/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.model.DuplicateRemoteVlinkId;
import cerent.cms.model.Feature;
import cerent.cms.model.FeatureUnsupported;
import cerent.cms.model.IIpAddr;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IVirtualLinkModel;
import cerent.cms.model.IVirtualLinksManager;
import cerent.cms.model.NoSuchVirtualLink;
import cerent.cms.model.VirtualLinksDirector;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.Network;
import cerent.util.InetUtil;
import cerent.util.SDebug;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class PPCRepairOperator {
    private static final SDebug db = new SDebug("PPCRepairOperator");
    private VirtualLinksDirector vld = VirtualLinksDirector.instance();
    private Network net = Network.instance();

    private PPCRepairOperator() {
    }

    public static final PPCRepairOperator newInstance() {
        return new PPCRepairOperator();
    }

    public List<IpChange> discoverIpChanges() {
        Object object;
        Object object22;
        Object object3;
        if (db.on()) {
            db.println("discoverIpChanges called");
        }
        Set<IVirtualLinkModel> set = this.vld.getVirtualLinks();
        LinkedList<IVirtualLinkModel> linkedList = new LinkedList<IVirtualLinkModel>();
        if (db.on()) {
            db.println("Step1: building candidate list");
        }
        for (IVirtualLinkModel object42 : set) {
            object3 = InetUtil.makeDottedString(object42.getTermNode());
            object22 = this.net.findNetElemByIp((String)object3);
            if (object22 == null || !object22.getConnectionState()) {
                linkedList.add(object42);
                if (!db.on()) continue;
                db.println("Added candidate remoteId=" + (String)object3);
                continue;
            }
            if (!db.on()) continue;
            db.println("Not a candidate remoteId=" + (String)object3 + ": valid NE found (" + object22.getName() + ")");
        }
        LinkedList linkedList2 = new LinkedList();
        Collection collection = this.net.getAllElements();
        if (db.on()) {
            db.println("Step2: evaluating candidate list (" + linkedList.size() + " elements)");
        }
        for (Object object22 : linkedList) {
            object = InetUtil.makeDottedString(object22.getOrigNode());
            String string = InetUtil.makeDottedString(object22.getTermNode());
            short s = object22.getOrigVLID();
            if (db.on()) {
                db.println("Checking candidate remoteId/oldId=" + string + ", localIP=" + (String)object + " localID= " + s);
            }
            for (INetElement iNetElement : collection) {
                if (db.on()) {
                    db.println("Checking NE " + iNetElement.getName());
                }
                try {
                    IVirtualLinkModel[] exception = this.vld.getVirtualLinks(iNetElement.getNodeModel());
                    if (exception == null) continue;
                    for (IVirtualLinkModel iVirtualLinkModel : exception) {
                        String string2 = InetUtil.makeDottedString(iVirtualLinkModel.getTermNode());
                        short s2 = iVirtualLinkModel.getTermVLID();
                        if (db.on()) {
                            db.println("Checking against remoteIP=" + string2 + ", remoteID= " + s2);
                        }
                        if (!string2.equals(object) || s2 != s) continue;
                        String string3 = InetUtil.makeDottedString(iVirtualLinkModel.getOrigNode());
                        IpChange ipChange = new IpChange(string3, string);
                        if (!linkedList2.contains(ipChange)) {
                            linkedList2.add(ipChange);
                            continue;
                        }
                        if (!db.on()) continue;
                        db.println("Discarded " + ipChange + ": already in list");
                    }
                }
                catch (Exception exception) {
                    db.warning("Error occurred while evaluating NE " + iNetElement.getName() + ": " + exception.getMessage());
                    if (!db.on()) continue;
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
        }
        if (db.on()) {
            object3 = new StringBuilder("discoverIpChanges returning ");
            ((StringBuilder)object3).append(linkedList2.size()).append(" IP changes");
            object22 = linkedList2.iterator();
            while (object22.hasNext()) {
                object = (IpChange)object22.next();
                ((StringBuilder)object3).append("\n").append(object);
            }
        }
        return linkedList2;
    }

    public List<IVirtualLinkModel> findTermToBeFixed(IpChange ipChange) {
        LinkedList<IVirtualLinkModel> linkedList = new LinkedList<IVirtualLinkModel>();
        String string = ipChange.getCurrIp();
        String string2 = ipChange.getOldIp();
        INetElement iNetElement = this.net.findNetElemByIp(string);
        if (iNetElement == null) {
            return linkedList;
        }
        if (db.on()) {
            db.println("findTermToBeFixed called for " + ipChange + ". NE is " + iNetElement.getName());
        }
        IVirtualLinkModel[] iVirtualLinkModelArray = this.vld.getVirtualLinks(iNetElement.getNodeModel());
        for (IVirtualLinkModel iVirtualLinkModel : iVirtualLinkModelArray) {
            try {
                String string3 = InetUtil.makeDottedString(iVirtualLinkModel.getTermNode());
                short s = iVirtualLinkModel.getOrigVLID();
                short s2 = iVirtualLinkModel.getTermVLID();
                List<IVirtualLinkModel> list = this.findMatchingTerms(string3, string2, s2, s);
                linkedList.addAll(list);
            }
            catch (Exception exception) {
                db.warning("Error occurred while evaluating vl " + iVirtualLinkModel + ": " + exception.getMessage());
                if (!db.on()) continue;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        if (db.on()) {
            StringBuilder stringBuilder = new StringBuilder("findTermToBeFixed returning ");
            stringBuilder.append(linkedList.size()).append(" PPC terms");
            for (IVirtualLinkModel iVirtualLinkModel : linkedList) {
                stringBuilder.append("\n").append(iVirtualLinkModel);
            }
        }
        return linkedList;
    }

    private List<IVirtualLinkModel> findMatchingTerms(String string, String string2, int n, int n2) {
        IVirtualLinkModel[] iVirtualLinkModelArray;
        if (db.on()) {
            db.println("findMatchingTerms called for localIP=" + string + ", oldIP=" + string2 + ", localID=" + n2 + ", remoteID=" + n);
        }
        LinkedList<IVirtualLinkModel> linkedList = new LinkedList<IVirtualLinkModel>();
        INetElement iNetElement = this.net.findNetElemByIp(string);
        if (iNetElement == null) {
            return linkedList;
        }
        if (db.on()) {
            db.println("NE is " + iNetElement.getName());
        }
        if ((iVirtualLinkModelArray = this.vld.getVirtualLinks(iNetElement.getNodeModel())) != null) {
            for (IVirtualLinkModel iVirtualLinkModel : iVirtualLinkModelArray) {
                String string3 = InetUtil.makeDottedString(iVirtualLinkModel.getTermNode());
                short s = iVirtualLinkModel.getTermVLID();
                if (db.on()) {
                    db.println("Checking againste remoteIP " + string3 + ", remote ID = " + s);
                }
                if (!string3.equals(string2) || s != n2) continue;
                linkedList.add(iVirtualLinkModel);
            }
        }
        return linkedList;
    }

    public boolean fixTerminations(IpChange ipChange, List<IVirtualLinkModel> list, List<String> list2) {
        boolean bl = true;
        INetElement iNetElement = this.net.findNetElemByIp(ipChange.getCurrIp());
        if (iNetElement == null) {
            if (db.on()) {
                db.println("No NE found for current IP " + ipChange.getCurrIp());
            }
            list2.add("Cannot find any node for current IP " + ipChange.getCurrIp());
            return false;
        }
        IIpAddr iIpAddr = iNetElement.getNodeModel().getIpConfig().getIpAddress();
        for (IVirtualLinkModel iVirtualLinkModel : list) {
            String string = InetUtil.makeDottedString(iVirtualLinkModel.getOrigNode());
            INetElement iNetElement2 = this.net.findNetElemByIp(string);
            if (iNetElement2 == null) {
                list2.add("Cannot find any node for local IP " + string);
                continue;
            }
            INodeModel iNodeModel = iNetElement2.getNodeModel();
            if (iNodeModel != null) {
                if (!iNodeModel.provides(Feature.PPC_REPAIR)) {
                    bl = false;
                    list2.add("Node " + iNodeModel.getName() + " does not support PPC Repair.");
                    continue;
                }
                IVirtualLinksManager iVirtualLinksManager = iNodeModel.getVirtualLinksManager();
                try {
                    iVirtualLinksManager.changeRemoteVlinkEnd(iVirtualLinkModel.getTermNode(), iVirtualLinkModel.getTermVLID(), iIpAddr, iVirtualLinkModel.getTermVLID());
                    if (!db.on()) continue;
                    db.println("Repaired PPC " + iVirtualLinkModel);
                }
                catch (FeatureUnsupported featureUnsupported) {
                    bl = false;
                    list2.add(this.toString(iVirtualLinkModel) + ":\nFeature not supported.");
                    if (!db.on()) continue;
                    SDebug.printStackTrace((Throwable)featureUnsupported);
                }
                catch (NoSuchVirtualLink noSuchVirtualLink) {
                    bl = false;
                    list2.add(this.toString(iVirtualLinkModel) + ":\nNo such PPC termination.");
                    if (!db.on()) continue;
                    SDebug.printStackTrace((Throwable)noSuchVirtualLink);
                }
                catch (DuplicateRemoteVlinkId duplicateRemoteVlinkId) {
                    bl = false;
                    list2.add(this.toString(iVirtualLinkModel) + ":\nDuplicate remote ID.");
                    if (!db.on()) continue;
                    SDebug.printStackTrace((Throwable)duplicateRemoteVlinkId);
                }
                catch (Exception exception) {
                    bl = false;
                    list2.add(this.toString(iVirtualLinkModel) + ":\nUnexpected error.");
                    SDebug.printStackTrace((Throwable)exception);
                }
                continue;
            }
            bl = false;
            list2.add("Node model not found for NE " + iNetElement2.getName());
        }
        return bl;
    }

    private String toString(IVirtualLinkModel iVirtualLinkModel) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[Node: ").append(InetUtil.makeDottedString(iVirtualLinkModel.getOrigNode())).append(", origination ID: ").append(iVirtualLinkModel.getOrigVLID()).append(", termination ID: ").append(iVirtualLinkModel.getTermVLID());
        return stringBuilder.toString();
    }

    public static class IpChange {
        private String currIp;
        private String oldIp;

        public IpChange(String string, String string2) {
            this.currIp = string;
            this.oldIp = string2;
        }

        public String getCurrIp() {
            return this.currIp;
        }

        public String getOldIp() {
            return this.oldIp;
        }

        public String toString() {
            return this.oldIp + " -> " + this.currIp;
        }

        public boolean equals(Object object) {
            if (object instanceof IpChange) {
                IpChange ipChange = (IpChange)object;
                return ipChange.currIp.equals(this.currIp) && ipChange.oldIp.equals(this.oldIp);
            }
            return false;
        }
    }
}

