/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.model.Feature;
import cerent.cms.model.IIpAddr;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IServerTrailEnd;
import cerent.cms.model.IServerTrailLinkId;
import cerent.cms.model.IServerTrailsManager;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.ServerTrailModel;
import cerent.cms.model.ServerTrailsDirector;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.Network;
import cerent.util.InetUtil;
import cerent.util.SDebug;
import cerent.util.proxy.CtcProxyFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class ServerTrailRepairOperator {
    private static final SDebug db = new SDebug("ServerTrailRepairOperator");
    private ServerTrailsDirector sld = ServerTrailsDirector.instance();
    private Network net = Network.instance();

    private ServerTrailRepairOperator() {
    }

    public static final ServerTrailRepairOperator newInstance() {
        return new ServerTrailRepairOperator();
    }

    public List<IpChange> discoverIpChanges() {
        IpChange ipChange;
        String string;
        INodeModel iNodeModel;
        IServerTrailLinkId iServerTrailLinkId;
        String string2;
        IServerTrailEnd[] iServerTrailEndArray;
        INetElement iNetElement;
        Iterator iterator;
        IServerTrailLinkId iServerTrailLinkId2;
        String string3;
        INetElement iNetElement2;
        Object object;
        Object object2;
        Object object322;
        if (db.on()) {
            db.println("discoverIpChanges called");
        }
        Set set = this.sld.getServerTrails();
        LinkedList<Object> linkedList = new LinkedList<Object>();
        LinkedList<Object> linkedList2 = new LinkedList<Object>();
        if (db.on()) {
            db.println("Step1: building candidate list");
        }
        for (Object object322 : set) {
            object2 = ((ServerTrailModel)object322).getSrcServerTrailEnd();
            for (int i = 0; i < 2; ++i) {
                if (object2 != null) {
                    object = object2.getPeerIpAddr();
                    iNetElement2 = this.net.findNetElemByIp((String)object);
                    if (iNetElement2 == null || !iNetElement2.getConnectionState()) {
                        if (i == 0) {
                            linkedList.add(object322);
                        } else {
                            linkedList2.add(object322);
                        }
                        if (db.on()) {
                            db.println("Added candidate remoteId=" + (String)object);
                        }
                    } else if (db.on()) {
                        db.println("Not a candidate remoteId=" + (String)object + ": valid NE found (" + iNetElement2.getName() + ")");
                    }
                }
                object2 = ((ServerTrailModel)object322).getDstServerTrailEnd();
            }
        }
        LinkedList linkedList3 = new LinkedList();
        object322 = this.net.getAllElements();
        if (db.on()) {
            db.println("Step2: evaluating candidate list (" + linkedList.size() + " elements)");
        }
        for (ServerTrailModel serverTrailModel : linkedList) {
            object = "";
            iNetElement2 = serverTrailModel.getDstServerTrailEnd();
            if (iNetElement2 != null) {
                object = iNetElement2.getPeerIpAddr();
            } else {
                iNetElement2 = serverTrailModel.getSrcServerTrailEnd();
                string3 = Network.instance().getNodeModel(iNetElement2.getNodeModel().getNodeId());
                object = CtcProxyFactory.isIPv6Network() ? InetUtil.makeDottedString(string3.getIpConfig().getIpv6Address()) : (string3.isSecureMode() ? InetUtil.makeDottedString(string3.getSecureIpConfig().getIpAddress()) : InetUtil.makeDottedString(string3.getIpConfig().getIpAddress()));
            }
            string3 = serverTrailModel.getSrcServerTrailEnd().getPeerIpAddr();
            iServerTrailLinkId2 = serverTrailModel.getServerTrailLinkId();
            if (db.on()) {
                db.println("Checking candidate remoteId/oldId=" + string3 + ", localIP=" + (String)object + " localID= " + iServerTrailLinkId2);
            }
            iterator = object322.iterator();
            while (iterator.hasNext()) {
                iNetElement = (INetElement)iterator.next();
                if (db.on()) {
                    db.println("Checking NE " + iNetElement.getName());
                }
                try {
                    iServerTrailEndArray = this.sld.getServerTrails(iNetElement.getNodeModel());
                    if (iServerTrailEndArray == null) continue;
                    for (IServerTrailEnd iServerTrailEnd : iServerTrailEndArray) {
                        string2 = iServerTrailEnd.getPeerIpAddr();
                        iServerTrailLinkId = iServerTrailEnd.getServerTrailLinkId();
                        if (db.on()) {
                            db.println("Checking against remoteIP=" + string2 + ", remoteID= " + iServerTrailLinkId);
                        }
                        if (!string2.equals(object) || !iServerTrailLinkId.equals(iServerTrailLinkId2)) continue;
                        iNodeModel = iNetElement.getNodeModel();
                        string = null;
                        string = CtcProxyFactory.isIPv6Network() ? InetUtil.makeDottedString(iNodeModel.getIpConfig().getIpv6Address()) : (iNodeModel.isSecureMode() ? InetUtil.makeDottedString(iNodeModel.getSecureIpConfig().getIpAddress()) : InetUtil.makeDottedString(iNodeModel.getIpConfig().getIpAddress()));
                        ipChange = new IpChange(string, string3);
                        if (this.validIpChange(ipChange) && !linkedList3.contains(ipChange)) {
                            linkedList3.add(ipChange);
                            continue;
                        }
                        if (!db.on()) continue;
                        db.println("Discarded " + ipChange + ": already in list or invalid change");
                    }
                }
                catch (Exception exception) {
                    db.warning("Error occurred while evaluating NE " + iNetElement.getName() + ": " + exception.getMessage());
                    if (!db.on()) continue;
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
        }
        if (db.on()) {
            db.println("Step3: evaluating second candidate list (" + linkedList.size() + " elements)");
        }
        for (ServerTrailModel serverTrailModel : linkedList2) {
            object = "";
            iNetElement2 = serverTrailModel.getSrcServerTrailEnd();
            if (iNetElement2 != null) {
                object = iNetElement2.getPeerIpAddr();
            } else {
                iNetElement2 = serverTrailModel.getDstServerTrailEnd();
                string3 = Network.instance().getNodeModel(iNetElement2.getNodeModel().getNodeId());
                object = CtcProxyFactory.isIPv6Network() ? InetUtil.makeDottedString(string3.getIpConfig().getIpv6Address()) : (string3.isSecureMode() ? InetUtil.makeDottedString(string3.getSecureIpConfig().getIpAddress()) : InetUtil.makeDottedString(string3.getIpConfig().getIpAddress()));
            }
            string3 = serverTrailModel.getDstServerTrailEnd().getPeerIpAddr();
            iServerTrailLinkId2 = serverTrailModel.getServerTrailLinkId();
            if (db.on()) {
                db.println("Checking candidate remoteId/oldId=" + string3 + ", localIP=" + (String)object + " localID= " + iServerTrailLinkId2);
            }
            iterator = object322.iterator();
            while (iterator.hasNext()) {
                iNetElement = (INetElement)iterator.next();
                if (db.on()) {
                    db.println("Checking NE " + iNetElement.getName());
                }
                try {
                    iServerTrailEndArray = this.sld.getServerTrails(iNetElement.getNodeModel());
                    if (iServerTrailEndArray == null) continue;
                    for (IServerTrailEnd iServerTrailEnd : iServerTrailEndArray) {
                        string2 = iServerTrailEnd.getPeerIpAddr();
                        iServerTrailLinkId = iServerTrailEnd.getServerTrailLinkId();
                        if (db.on()) {
                            db.println("Checking against remoteIP=" + string2 + ", remoteID= " + iServerTrailLinkId);
                        }
                        if (!string2.equals(object) || !iServerTrailLinkId.equals(iServerTrailLinkId2)) continue;
                        iNodeModel = iNetElement.getNodeModel();
                        string = null;
                        string = CtcProxyFactory.isIPv6Network() ? InetUtil.makeDottedString(iNodeModel.getIpConfig().getIpv6Address()) : (iNodeModel.isSecureMode() ? InetUtil.makeDottedString(iNodeModel.getSecureIpConfig().getIpAddress()) : InetUtil.makeDottedString(iNodeModel.getIpConfig().getIpAddress()));
                        ipChange = new IpChange(string, string3);
                        if (this.validIpChange(ipChange) && !linkedList3.contains(ipChange)) {
                            linkedList3.add(ipChange);
                            continue;
                        }
                        if (!db.on()) continue;
                        db.println("Discarded " + ipChange + ": already in list or invalid change");
                    }
                }
                catch (Exception exception) {
                    db.warning("Error occurred while evaluating NE " + iNetElement.getName() + ": " + exception.getMessage());
                    if (!db.on()) continue;
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
        }
        if (db.on()) {
            object2 = new StringBuilder("discoverIpChanges returning ");
            ((StringBuilder)object2).append(linkedList3.size()).append(" IP changes");
            Iterator iterator2 = linkedList3.iterator();
            while (iterator2.hasNext()) {
                object = (IpChange)iterator2.next();
                ((StringBuilder)object2).append("\n").append(object);
            }
        }
        return linkedList3;
    }

    private boolean validIpChange(IpChange ipChange) {
        String string;
        String string2 = ipChange.getCurrIp();
        if (string2.equals(string = ipChange.getOldIp())) {
            if (db.on()) {
                db.println("Discarded " + ipChange + ": newIp and oldIp same");
            }
            return false;
        }
        try {
            InetAddress inetAddress = InetAddress.getByName(string2);
            InetAddress inetAddress2 = InetAddress.getByName(string);
            if (inetAddress.getAddress().length > 4 && inetAddress2.getAddress().length <= 4 || inetAddress2.getAddress().length > 4 && inetAddress.getAddress().length <= 4) {
                if (db.on()) {
                    db.println("Discarded " + ipChange + ": newIp and oldIp is a mix of IPv6 and IPv4 address");
                }
                return false;
            }
        }
        catch (UnknownHostException unknownHostException) {
            if (db.on()) {
                db.println("validIpChange: caught UnknownHostException " + unknownHostException.getMessage());
                SDebug.printStackTrace((Throwable)unknownHostException);
            }
            return false;
        }
        return true;
    }

    public List<ServerTrailModel> findTermToBeFixed(IpChange ipChange) {
        LinkedList<ServerTrailModel> linkedList = new LinkedList<ServerTrailModel>();
        String string = ipChange.getCurrIp();
        String string2 = ipChange.getOldIp();
        INetElement iNetElement = this.net.findNetElemByIp(string);
        if (iNetElement == null) {
            return linkedList;
        }
        if (db.on()) {
            db.println("findTermToBeFixed called for " + ipChange + ". NE is " + iNetElement.getName());
        }
        IServerTrailEnd[] iServerTrailEndArray = this.sld.getServerTrails(iNetElement.getNodeModel());
        for (IServerTrailEnd iServerTrailEnd : iServerTrailEndArray) {
            try {
                String string3 = iServerTrailEnd.getPeerIpAddr();
                IServerTrailLinkId iServerTrailLinkId = iServerTrailEnd.getServerTrailLinkId();
                List<ServerTrailModel> list = this.findMatchingTerms(string3, string2, iServerTrailLinkId);
                linkedList.addAll(list);
            }
            catch (Exception exception) {
                db.warning("Error occurred while evaluating servertrailend " + iServerTrailEnd + ": " + exception.getMessage());
                if (!db.on()) continue;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        if (db.on()) {
            StringBuilder stringBuilder = new StringBuilder("findTermToBeFixed returning ");
            stringBuilder.append(linkedList.size()).append(" servertrails");
            for (ServerTrailModel serverTrailModel : linkedList) {
                stringBuilder.append("\n").append(serverTrailModel);
            }
        }
        return linkedList;
    }

    private List<ServerTrailModel> findMatchingTerms(String string, String string2, IServerTrailLinkId iServerTrailLinkId) {
        IServerTrailEnd[] iServerTrailEndArray;
        if (db.on()) {
            db.println("findMatchingTerms called for localIP=" + string + ", oldIP=" + string2 + ", servertrailid=" + iServerTrailLinkId);
        }
        LinkedList<ServerTrailModel> linkedList = new LinkedList<ServerTrailModel>();
        INetElement iNetElement = this.net.findNetElemByIp(string);
        if (iNetElement == null) {
            return linkedList;
        }
        if (db.on()) {
            db.println("NE is " + iNetElement.getName());
        }
        if ((iServerTrailEndArray = this.sld.getServerTrails(iNetElement.getNodeModel())) != null) {
            for (IServerTrailEnd iServerTrailEnd : iServerTrailEndArray) {
                String string3 = iServerTrailEnd.getPeerIpAddr();
                IServerTrailLinkId iServerTrailLinkId2 = iServerTrailEnd.getServerTrailLinkId();
                if (db.on()) {
                    db.println("Checking against remoteIP " + string3 + ", remote ID = " + iServerTrailLinkId2);
                }
                if (!string3.equals(string2) || !iServerTrailLinkId2.equals(iServerTrailLinkId)) continue;
                linkedList.add(this.sld.getTrailModelById(iServerTrailLinkId));
            }
        }
        return linkedList;
    }

    public boolean fixTerminations(IpChange ipChange, List<ServerTrailModel> list, List<String> list2) {
        boolean bl = true;
        INetElement iNetElement = this.net.findNetElemByIp(ipChange.getCurrIp());
        if (iNetElement == null) {
            if (db.on()) {
                db.println("No NE found for current IP " + ipChange.getCurrIp());
            }
            list2.add("Cannot find any node for current IP " + ipChange.getCurrIp());
            return false;
        }
        INodeModel iNodeModel = iNetElement.getNodeModel();
        if (iNodeModel == null) {
            if (db.on()) {
                db.println("No NodeModel found for current IP " + ipChange.getCurrIp());
            }
            list2.add("Cannot find any node for current IP " + ipChange.getCurrIp());
            return false;
        }
        IIpAddr iIpAddr = null;
        iIpAddr = CtcProxyFactory.isIPv6Network() ? iNodeModel.getIpConfig().getIpv6Address() : (iNodeModel.isSecureMode() ? iNodeModel.getSecureIpConfig().getIpAddress() : iNodeModel.getIpConfig().getIpAddress());
        for (ServerTrailModel serverTrailModel : list) {
            INetElement iNetElement2;
            String string = serverTrailModel.getDstServerTrailEnd().getPeerIpAddr();
            boolean bl2 = false;
            if (string.equals(ipChange.getOldIp())) {
                bl2 = true;
                string = serverTrailModel.getSrcServerTrailEnd().getPeerIpAddr();
            }
            if ((iNetElement2 = this.net.findNetElemByIp(string)) == null) {
                list2.add("Cannot find any node for local IP " + string);
                continue;
            }
            INodeModel iNodeModel2 = iNetElement2.getNodeModel();
            if (iNodeModel2 != null) {
                if (!iNodeModel2.provides(Feature.SERVER_TRAIL_REPAIR)) {
                    bl = false;
                    list2.add("Node " + iNodeModel2.getName() + " does not support Servertrail Repair.");
                    continue;
                }
                IServerTrailsManager iServerTrailsManager = iNodeModel2.getServerTrailsManager();
                try {
                    if (bl2) {
                        iServerTrailsManager.changePeerIpAddress(serverTrailModel.getDstServerTrailEnd().getPeerIpAddr(), InetUtil.makeDottedString(iIpAddr), serverTrailModel.getServerTrailLinkId());
                    } else {
                        iServerTrailsManager.changePeerIpAddress(serverTrailModel.getSrcServerTrailEnd().getPeerIpAddr(), InetUtil.makeDottedString(iIpAddr), serverTrailModel.getServerTrailLinkId());
                    }
                    if (!db.on()) continue;
                    db.println("Repaired ServerTrails " + serverTrailModel);
                }
                catch (ProvisionError provisionError) {
                    bl = false;
                    list2.add(this.toString(serverTrailModel) + ":\n" + provisionError.getEIDMsg());
                    if (!db.on()) continue;
                    SDebug.printStackTrace((Throwable)provisionError);
                }
                catch (Exception exception) {
                    bl = false;
                    list2.add(this.toString(serverTrailModel) + ":\nUnexpected error.");
                    if (!db.on()) continue;
                    SDebug.printStackTrace((Throwable)exception);
                }
                continue;
            }
            bl = false;
            list2.add("Node model not found for NE " + iNetElement2.getName());
        }
        return bl;
    }

    private String toString(ServerTrailModel serverTrailModel) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Server Trail ID: ").append(serverTrailModel.getServerTrailLinkId().getNodeId()).append(":").append(serverTrailModel.getServerTrailLinkId().getUniqueId()).append(" [Node: ");
        if (serverTrailModel.getSrcNode() != null) {
            stringBuilder.append(serverTrailModel.getSrcNode().getHostName());
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static class IpChange {
        private String currIp;
        private String oldIp;

        public IpChange(String string, String string2) {
            this.currIp = string;
            this.oldIp = string2;
        }

        public String getCurrIp() {
            return this.currIp;
        }

        public String getOldIp() {
            return this.oldIp;
        }

        public String toString() {
            return this.oldIp + " -> " + this.currIp;
        }

        public boolean equals(Object object) {
            if (object instanceof IpChange) {
                IpChange ipChange = (IpChange)object;
                return ipChange.currIp.equals(this.currIp) && ipChange.oldIp.equals(this.oldIp);
            }
            return false;
        }
    }
}

