/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ocm;

import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.Feature;
import cerent.cms.model.ICircuitId;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IEntityTableModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IOhCircuitEnd;
import cerent.cms.model.IOhCircuitInfo;
import cerent.cms.model.IOhCircuitModel;
import cerent.cms.model.IOhConnectionModel;
import cerent.cms.model.IpTunnelCircuitInfo;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.OhChannelType;
import cerent.cms.model.OhCircuitEnd;
import cerent.cms.model.OhCircuitInfo;
import cerent.cms.model.OhCircuitType;
import cerent.cms.model.SdccCircuitInfo;
import cerent.cms.ncp.CircuitProvError;
import cerent.cms.ncp.DeletionError;
import cerent.cms.ncp.IncorrectCircuitState;
import cerent.cms.ncp.SanityCheckFailed;
import cerent.cms.ocm.DccTunnel;
import cerent.cms.ocm.IpEncapsulatedTunnel;
import cerent.cms.ocm.OhCircuit;
import cerent.cms.ocm.OhCircuitWatchDog;
import cerent.cms.ocm.OhConnectionModelComparator;
import cerent.cms.ocm.OhNetCircuitEnd;
import cerent.cms.ocm.OwCircuit;
import cerent.cms.ocm.OwLoopFoundException;
import cerent.cms.ocm.OwLoopPrevention;
import cerent.cms.ocm.UdcF1Circuit;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.INetwork;
import cerent.cms.topo.NetLinkComparator;
import cerent.cms.topo.Network;
import cerent.util.AnnotatedException;
import cerent.util.IAsyncObserver;
import cerent.util.IDebugDiag;
import cerent.util.SDebug;
import cerent.util.job.IJobGroupListener;
import cerent.util.job.JobController;
import cerent.util.job.JobControllerFactory;
import cerent.util.job.JobGroup;
import cerent.util.job.JobStatus;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class OhCircuitManager
extends CmsObservable
implements IJobGroupListener {
    private static final SDebug db = new SDebug("OhCircuitManager");
    private static final SDebug pkgDb = new SDebug("OcmPackage");
    public DumpDebug dumpDb;
    private static OhCircuitManager manager;
    private final int MAX_CIRCUITS = 1024;
    private Map cktMap;
    private Object cktMapSearchLock;
    private INodeModel hostNode;
    private Network net;
    private OhCircuitWatchDog watchDog;
    private HashMap circuitNameMap;
    private OwLoopPrevention lowLoopPrevention;
    private OwLoopPrevention eowLoopPrevention;
    private JobGroup deleteJobGroup;
    private JobController deleteJobController;
    private JobController createJobController;
    static final int AIC_2_AIC = 0;
    static final int AIC_2_OPTICAL = 1;
    static final int OPTICAL_2_OPTICAL = 2;
    static final int OPTICAL_2_AIC = 3;

    public static synchronized OhCircuitManager instance() {
        if (manager == null) {
            Network network = Network.instance();
            if (network == null) {
                if (OhCircuitManager.dbgOn()) {
                    db.warning("Unable to instantiate Circuit Manager- null network");
                }
                return null;
            }
            if (OhCircuitManager.dbgOn()) {
                db.finer("Obtained ref. to network. creating circuit manager");
            }
            manager = new OhCircuitManager(network);
            if (OhCircuitManager.dbgOn()) {
                db.finer("Network Circuit Manager created ");
            }
        }
        return manager;
    }

    public void init() {
        this.dumpDb = new DumpDebug("OhCircuits");
    }

    public void dispose() {
        this.dumpDb.dispose();
        Iterator iterator = this.getCircuits().iterator();
        while (iterator.hasNext()) {
            OhCircuit ohCircuit = (OhCircuit)iterator.next();
            ohCircuit.dispose();
            iterator.remove();
        }
    }

    private OhCircuitManager(Network network) {
        this.init();
        this.net = network;
        this.deleteJobGroup = null;
        this.deleteJobController = null;
        this.createJobController = null;
        this.cktMap = Collections.synchronizedMap(new TreeMap());
        this.cktMapSearchLock = new Object();
        if (OhCircuitManager.dbgOn()) {
            db.finer("Circuit Manager- Creating WatchDog object");
        }
        this.watchDog = OhCircuitWatchDog.instance();
        this.circuitNameMap = new HashMap();
        this.lowLoopPrevention = new OwLoopPrevention(this, 2);
        this.eowLoopPrevention = new OwLoopPrevention(this, 3);
    }

    public int[] deleteCheck(OhCircuit[] ohCircuitArray) {
        int[] nArray = null;
        int[] nArray2 = new int[ohCircuitArray.length];
        int n = 0;
        int n2 = 0;
        if (OhCircuitManager.dbgOn()) {
            db.finer("DEL: deleteCheck entered......");
        }
        for (n2 = 0; n2 < ohCircuitArray.length; ++n2) {
            try {
                ohCircuitArray[n2].circuitDeleteCheck();
                continue;
            }
            catch (IncorrectCircuitState incorrectCircuitState) {
                if (OhCircuitManager.dbgOn()) {
                    db.warning("DEL: invalid index " + n2);
                }
                nArray2[n++] = n2;
            }
        }
        if (n > 0) {
            nArray = new int[n];
            if (OhCircuitManager.dbgOn()) {
                db.warning("DEL: invalid count is " + n);
            }
            for (n2 = 0; n2 < n; ++n2) {
                nArray[n2] = nArray2[n2];
                if (!OhCircuitManager.dbgOn()) continue;
                db.warning("DEL: invalid index " + nArray[n2]);
            }
        }
        return nArray;
    }

    public void deleteSelectedCircuits(OhCircuit[] ohCircuitArray, IAsyncObserver iAsyncObserver) throws DeletionError {
        LinkedList<OhCircuit> linkedList = new LinkedList<OhCircuit>();
        String string = null;
        String string2 = null;
        int n = ohCircuitArray.length;
        OhCircuit[] ohCircuitArray2 = new OhCircuit[]{};
        if (n < 1) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            boolean bl = false;
            if (ohCircuitArray[i].getState() == 2) continue;
            if (OhCircuitManager.dbgOn()) {
                db.finer("DEL: sanity check......");
            }
            try {
                ohCircuitArray[i].setState(2);
                ohCircuitArray[i].destroy(true);
            }
            catch (IncorrectCircuitState incorrectCircuitState) {
                SDebug.printStackTrace((Throwable)incorrectCircuitState);
                bl = true;
                string2 = incorrectCircuitState.toString();
            }
            catch (SanityCheckFailed sanityCheckFailed) {
                SDebug.printStackTrace((Throwable)sanityCheckFailed);
                bl = true;
                string2 = sanityCheckFailed.toString();
            }
            catch (DeletionError deletionError) {
                SDebug.printStackTrace((Throwable)deletionError);
                bl = true;
                string2 = deletionError.toString();
            }
            if (bl) {
                if (string == null) {
                    string = "The following circuits could not be scheduled for deletion:\n";
                }
                string = string + "An error occurred while deleting the circuit " + ohCircuitArray[i].getCircuitName() + ".\n";
                string = string + string2 + "\n";
                if (!OhCircuitManager.dbgOn()) continue;
                db.warning("deleteSelectedCircuits: " + string);
                continue;
            }
            linkedList.add(ohCircuitArray[i]);
        }
        if (string != null) {
            throw new DeletionError(string);
        }
    }

    protected JobController getCreateJc() {
        if (this.createJobController == null) {
            this.createJobController = JobControllerFactory.createJC((int)5);
        }
        return this.createJobController;
    }

    protected void insertCircuit(OhCircuit ohCircuit, boolean bl) {
        if (ohCircuit.isCircuitRefValid()) {
            this.cktMap.put(ohCircuit.getCircuitId(), ohCircuit);
            if (bl) {
                this.ocmChanged();
            }
        }
    }

    protected void removeCircuit(OhCircuit ohCircuit) {
        if (OhCircuitManager.dbgOn()) {
            db.fine("removeCircuit - " + ohCircuit.getCircuitName());
        }
        if (ohCircuit.getCircuitId() != null) {
            this.cktMap.remove(ohCircuit.getCircuitId());
        }
    }

    public Set getAffectedNodes(int n) {
        HashSet hashSet = new HashSet();
        if (OhCircuitManager.dbgOn()) {
            db.fine("getAffectedNodes: oldNodeId = " + n);
            db.fine("Examining each Circuit ... ");
        }
        for (OhCircuit ohCircuit : this.getCircuits()) {
            hashSet.addAll(ohCircuit.getAffectedNodes(n));
        }
        return hashSet;
    }

    public int repairCircuits(int n, int n2) throws CircuitProvError {
        int n3 = 0;
        if (OhCircuitManager.dbgOn()) {
            db.fine("repairCircuits: oldNodeId = " + n + " newNodeId = " + n2);
            db.finer("Examining each Circuit ... ");
        }
        Iterator iterator = this.getCircuits().iterator();
        while (iterator.hasNext()) {
            if (!((OhCircuit)iterator.next()).repairCircuit(n, n2)) continue;
            ++n3;
        }
        return n3;
    }

    public int repairIpTunnels(INodeModel iNodeModel, String string, String string2) throws CircuitProvError {
        int n = 0;
        if (OhCircuitManager.dbgOn()) {
            db.fine("repairCircuits: oldNodeIp = " + string + " newNodeIp = " + string2);
            db.finer("Examining each Circuit ... ");
        }
        for (OhCircuit ohCircuit : this.getCircuits()) {
            if (!ohCircuit.getCircuitTypeObj().isIpTunnelType() || !((IpEncapsulatedTunnel)ohCircuit).repairTunnel(iNodeModel, string, string2)) continue;
            ++n;
        }
        return n;
    }

    public void newNetLink(INetLink iNetLink) {
        for (OhCircuit ohCircuit : this.getCircuits()) {
            if (!ohCircuit.isCircuitRefValid()) continue;
            ohCircuit.foundNewNetLink(iNetLink);
        }
    }

    public Set getAvailSourcePorts(INodeModel iNodeModel, IOhCircuitInfo iOhCircuitInfo) throws AbstractCmsNoSuchEntityException, NoSuchInterface {
        return this.getAvailPortEntities(iNodeModel, iOhCircuitInfo);
    }

    public Set getAvailPortEntities(INodeModel iNodeModel, IOhCircuitInfo iOhCircuitInfo) throws AbstractCmsNoSuchEntityException, NoSuchInterface {
        int n = iOhCircuitInfo.getCircuitType();
        OhCircuitType ohCircuitType = OhCircuitType.getOhCktTypeObj((int)n);
        Set set = null;
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                set = iNodeModel.getOhConnectionModels().getAvailAicPorts(ohCircuitType);
            }
            case 4: 
            case 5: 
            case 6: {
                Set set2 = iNodeModel.getOhConnectionModels().getAvailOpticalPorts(ohCircuitType);
                if (set == null) {
                    set = set2;
                    break;
                }
                set.addAll(set2);
                break;
            }
            default: {
                throw new IllegalArgumentException("The circuit type is unknown.");
            }
        }
        return set;
    }

    public Set getAvailDestPorts(INodeModel iNodeModel, IOhCircuitInfo iOhCircuitInfo, IOhCircuitEnd iOhCircuitEnd) throws AbstractCmsNoSuchEntityException, NoSuchInterface {
        Set set = this.getAvailPortEntities(iNodeModel, iOhCircuitInfo);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            IEntityModel iEntityModel = (IEntityModel)iterator.next();
            if (iOhCircuitEnd == null || iOhCircuitEnd.getPort() != iEntityModel.getIndex()) continue;
            iterator.remove();
            break;
        }
        return set;
    }

    public OhCircuit newCircuit(IOhCircuitInfo iOhCircuitInfo) throws AnnotatedException {
        OhCircuit ohCircuit;
        switch (iOhCircuitInfo.getCircuitType()) {
            case 2: 
            case 3: {
                if (this.getOwLoopPrevention(iOhCircuitInfo.getCircuitType()).formingLoop(iOhCircuitInfo)) {
                    OwLoopFoundException owLoopFoundException = new OwLoopFoundException("An orderwire loop will be formed by adding this circuit.");
                    throw new AnnotatedException("The required orderwire circuit could not be created.", (Exception)owLoopFoundException);
                }
                ohCircuit = new OwCircuit(iOhCircuitInfo);
                break;
            }
            case 4: 
            case 5: {
                if (db.on()) {
                    db.println("Creating DCC Tunnel circuits");
                }
                ohCircuit = new DccTunnel(iOhCircuitInfo);
                break;
            }
            case 6: {
                if (db.on()) {
                    db.println("Creating IP Tunnel circuits");
                }
                ohCircuit = new IpEncapsulatedTunnel(iOhCircuitInfo);
                break;
            }
            case 0: {
                if (db.on()) {
                    db.println("Creating UDC_F1 circuits");
                }
                ohCircuit = new UdcF1Circuit(iOhCircuitInfo);
                break;
            }
            default: {
                ohCircuit = new OhCircuit(iOhCircuitInfo);
            }
        }
        this.insertCircuit(ohCircuit, true);
        return ohCircuit;
    }

    public OhCircuit newCircuitFromConn(IOhConnectionModel iOhConnectionModel) {
        int n = iOhConnectionModel.getCircuitType();
        OhCircuit ohCircuit = n == 2 || n == 3 ? new OwCircuit(iOhConnectionModel) : (n == 4 || n == 5 ? new DccTunnel(iOhConnectionModel) : (n == 6 ? new IpEncapsulatedTunnel(iOhConnectionModel) : (n == 0 ? new UdcF1Circuit(iOhConnectionModel) : new OhCircuit(iOhConnectionModel))));
        this.insertCircuit(ohCircuit, true);
        return ohCircuit;
    }

    public OhCircuit newCircuitFromCircuitInfo(IOhCircuitModel iOhCircuitModel) {
        int n = iOhCircuitModel.getCircuitType();
        OhCircuit ohCircuit = n == 2 || n == 3 ? new OwCircuit(iOhCircuitModel) : (n == 4 || n == 5 ? new DccTunnel(iOhCircuitModel) : (n == 6 ? new IpEncapsulatedTunnel(iOhCircuitModel) : (n == 0 ? new UdcF1Circuit(iOhCircuitModel) : new OhCircuit(iOhCircuitModel))));
        this.insertCircuit(ohCircuit, true);
        return ohCircuit;
    }

    protected Object getCktMapSearchLock() {
        return this.cktMapSearchLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getCircuits() {
        Map map = this.cktMap;
        synchronized (map) {
            return new LinkedList(this.cktMap.values());
        }
    }

    public OhCircuit getCircuitFromCircuitEnd(IOhCircuitEnd iOhCircuitEnd) {
        for (OhCircuit ohCircuit : this.getCircuits()) {
            if ((ohCircuit.getSource() == null || !ohCircuit.getSource().equals(iOhCircuitEnd)) && !ohCircuit.getDestinations().contains(iOhCircuitEnd)) continue;
            return ohCircuit;
        }
        return null;
    }

    public List getCircuits(INodeModel iNodeModel) {
        List list = new LinkedList();
        INetElement iNetElement = null;
        if (iNodeModel != null) {
            iNetElement = this.net.findNetElem(iNodeModel);
        }
        if (iNetElement != null) {
            list = this.getCircuits();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                if (((OhCircuit)iterator.next()).doesCircuitUseNetElem(iNetElement)) continue;
                iterator.remove();
            }
        }
        return list;
    }

    public List getCircuits(List list) {
        ArrayList<OhCircuit> arrayList = new ArrayList<OhCircuit>();
        TreeSet treeSet = new TreeSet(new OhConnectionModelComparator());
        treeSet.addAll(list);
        for (OhCircuit ohCircuit : this.getCircuits()) {
            TreeSet treeSet2 = new TreeSet(new OhConnectionModelComparator());
            treeSet2.addAll(ohCircuit.getConnections());
            treeSet2.retainAll(treeSet);
            if (treeSet2.isEmpty()) continue;
            arrayList.add(ohCircuit);
        }
        return arrayList;
    }

    public INetwork getNetwork() {
        return this.net;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OhCircuit getCircuitFromId(ICircuitId iCircuitId) {
        if (iCircuitId.getNodeId() == 0 && iCircuitId.getUniquePart().getUniqueId() == 0) {
            return null;
        }
        Object object = this.cktMapSearchLock;
        synchronized (object) {
            return (OhCircuit)this.cktMap.get(iCircuitId);
        }
    }

    public Set getUsedLinks(OhCircuitType ohCircuitType) {
        TreeSet treeSet = new TreeSet(new NetLinkComparator());
        if (ohCircuitType.equals((Object)OhCircuitType.SDCC_TUNNEL_CIRCUIT_OBJ)) {
            return treeSet;
        }
        OhChannelType ohChannelType = ohCircuitType.getCorrespondingChannelType();
        OhChannelType[] ohChannelTypeArray = ohChannelType.getMutualExclusiveChannelTypes();
        for (int i = 0; i < ohChannelTypeArray.length; ++i) {
            treeSet.addAll(this.getUsedLinks(ohChannelTypeArray[i]));
        }
        return treeSet;
    }

    public Set getUsedLinks(OhChannelType ohChannelType) {
        TreeSet treeSet = new TreeSet(new NetLinkComparator());
        Iterator iterator = this.getCircuits().iterator();
        while (iterator.hasNext()) {
            Set set = ((OhCircuit)iterator.next()).getUsedLinks(ohChannelType);
            if (set == null) continue;
            treeSet.addAll(set);
        }
        return treeSet;
    }

    public void ocmChanged() {
        this.setChanged();
        this.notifyObservers(ModelUpdateType.ADDED);
    }

    public OwLoopPrevention getOwLoopPrevention(int n) {
        switch (n) {
            case 2: {
                return this.lowLoopPrevention;
            }
            case 3: {
                return this.eowLoopPrevention;
            }
        }
        throw new IllegalArgumentException("The circuit type is unsupported.");
    }

    protected List[] getDividedCircuitLists(int n) {
        List[] listArray = new List[]{new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList()};
        for (OhCircuit ohCircuit : this.getCircuits()) {
            if (ohCircuit.getCircuitType() != n || !ohCircuit.isComplete()) continue;
            OhNetCircuitEnd ohNetCircuitEnd = ohCircuit.getSource();
            OhNetCircuitEnd ohNetCircuitEnd2 = ohCircuit.getFirstDestination();
            if (!ohNetCircuitEnd.isPortOptical() && !ohNetCircuitEnd2.isPortOptical()) {
                listArray[0].add(ohCircuit);
                continue;
            }
            if (!ohNetCircuitEnd.isPortOptical() && ohNetCircuitEnd2.isPortOptical()) {
                listArray[1].add(ohCircuit);
                continue;
            }
            if (ohNetCircuitEnd.isPortOptical() && ohNetCircuitEnd2.isPortOptical()) {
                listArray[2].add(ohCircuit);
                continue;
            }
            listArray[3].add(ohCircuit);
        }
        return listArray;
    }

    protected List getCircuitPathList(List[] listArray, boolean bl) {
        ArrayList<List> arrayList = new ArrayList<List>();
        ArrayList arrayList2 = new ArrayList(listArray[1]);
        if (!bl) {
            arrayList2.addAll(listArray[3]);
        }
        ArrayList arrayList3 = new ArrayList(listArray[1]);
        arrayList3.addAll(listArray[3]);
        arrayList3.addAll(listArray[2]);
        if (OhCircuitManager.dbgOn()) {
            db.finer("startingCkts: " + arrayList2);
            db.finer("candidateCkts: " + arrayList3);
        }
        for (OhCircuit ohCircuit : arrayList2) {
            arrayList3.remove(ohCircuit);
            List list = this.getCircuitPath(ohCircuit, arrayList3);
            if (list == null) continue;
            arrayList.add(list);
        }
        return arrayList;
    }

    private List getCircuitPath(OhCircuit ohCircuit, List list) {
        if (OhCircuitManager.dbgOn()) {
            db.finer("firstCkt = " + ohCircuit + ", Candidate circuits: " + list);
        }
        ArrayList<OhCircuit> arrayList = new ArrayList<OhCircuit>();
        arrayList.add(ohCircuit);
        OhCircuit ohCircuit2 = ohCircuit;
        OhNetCircuitEnd ohNetCircuitEnd = null;
        INetLink iNetLink = null;
        do {
            INetLink[] iNetLinkArray;
            if ((iNetLink = (ohNetCircuitEnd = ohNetCircuitEnd == null ? (ohCircuit2.getSource().isPortOptical() ? ohCircuit2.getSource() : ohCircuit2.getFirstDestination()) : (ohCircuit2.getSource().associateWithLink(iNetLink) ? ohCircuit2.getFirstDestination() : ohCircuit2.getSource())).getAssociatedLink()) == null && (iNetLinkArray = ohNetCircuitEnd.getAssociatedVirtualLinksForCkt(ohCircuit2)) != null && iNetLinkArray.length > 0) {
                iNetLink = iNetLinkArray[0];
            }
            if (iNetLink == null) {
                if (OhCircuitManager.dbgOn()) {
                    db.finer("Can't find the link for " + ohNetCircuitEnd);
                }
                return null;
            }
            ohCircuit2 = this.findNextCircuit(iNetLink, list);
            if (ohCircuit2 == null) {
                return null;
            }
            arrayList.add(ohCircuit2);
        } while (ohCircuit2.getSource().isPortOptical() && ohCircuit2.getFirstDestination().isPortOptical());
        if (OhCircuitManager.dbgOn()) {
            db.finer("Found path for circuit " + ohCircuit + ": " + arrayList);
        }
        return arrayList;
    }

    private OhCircuit findNextCircuit(INetLink iNetLink, List list) {
        OhCircuit ohCircuit;
        INetLink iNetLink2 = this.net.findReverseLink(iNetLink);
        if (OhCircuitManager.dbgOn()) {
            db.finer("findNextCircuit: link - " + iNetLink.prettyString() + ", revLink - " + iNetLink2.prettyString());
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ohCircuit = (OhCircuit)iterator.next();
            if (!ohCircuit.getSource().associateWithLink(iNetLink) && !ohCircuit.getFirstDestination().associateWithLink(iNetLink)) continue;
            iterator.remove();
            if (OhCircuitManager.dbgOn()) {
                db.finer("Found next circuit " + ohCircuit + " for link" + iNetLink);
            }
            return ohCircuit;
        }
        iterator = list.iterator();
        while (iterator.hasNext()) {
            ohCircuit = (OhCircuit)iterator.next();
            if (!ohCircuit.getSource().isPortAssociatedWithVirtualLink(ohCircuit, iNetLink) && !ohCircuit.getFirstDestination().isPortAssociatedWithVirtualLink(ohCircuit, iNetLink)) continue;
            iterator.remove();
            if (OhCircuitManager.dbgOn()) {
                db.finer("Found next circuit " + ohCircuit + " for link" + iNetLink);
            }
            return ohCircuit;
        }
        if (OhCircuitManager.dbgOn()) {
            db.finer("Found no next circuit");
        }
        return null;
    }

    protected List getCircuitPath(OhCircuit ohCircuit) {
        List[] listArray = this.getDividedCircuitLists(ohCircuit.getCircuitType());
        ArrayList arrayList = new ArrayList(listArray[2]);
        arrayList.addAll(listArray[3]);
        arrayList.addAll(listArray[1]);
        arrayList.remove(ohCircuit);
        return this.getCircuitPath(ohCircuit, arrayList);
    }

    public boolean mergeCircuit(OhCircuit ohCircuit) throws IncorrectCircuitState, SanityCheckFailed, DeletionError {
        List list = this.getCircuitPath(ohCircuit);
        if (list == null) {
            return false;
        }
        this.mergeCircuits(list);
        return true;
    }

    public void mergeCircuits(List list) throws IncorrectCircuitState, SanityCheckFailed, DeletionError {
        int n;
        OhCircuit ohCircuit = (OhCircuit)list.get(0);
        OhCircuit ohCircuit2 = (OhCircuit)list.get(list.size() - 1);
        ohCircuit.setState(4);
        for (n = 1; n < list.size(); ++n) {
            OhCircuit ohCircuit3 = (OhCircuit)list.get(n);
            for (IOhConnectionModel iOhConnectionModel : ohCircuit3.getConnections()) {
                ohCircuit3.removeConnection(iOhConnectionModel);
                iOhConnectionModel.setCircuitId(ohCircuit.getCircuitId());
                ohCircuit.addConnection(iOhConnectionModel);
            }
        }
        ohCircuit.circuitModel().addDestination((IOhCircuitEnd)(ohCircuit2.getSource().isPortOptical() ? ohCircuit2.getFirstDestination() : ohCircuit2.getSource()));
        ohCircuit.circuitModel().delDestination((IOhCircuitEnd)ohCircuit.getFirstDestination());
        for (n = 1; n < list.size(); ++n) {
            ((OhCircuit)list.get(n)).destroy(true);
        }
        ohCircuit.completeCheck();
    }

    public int mergeAllCircuits() throws AnnotatedException {
        int n = 0;
        int n2 = 0;
        Exception exception = null;
        OhCircuitType[] ohCircuitTypeArray = OhCircuitType.NON_DCC_TUNNEL_CIRCUIT_TYPES;
        for (int i = 0; i < ohCircuitTypeArray.length; ++i) {
            List list = this.getCircuitPathList(this.getDividedCircuitLists(ohCircuitTypeArray[i].getIndex()), true);
            n += list.size();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                try {
                    this.mergeCircuits((List)iterator.next());
                    ++n2;
                }
                catch (Exception exception2) {
                    if (exception != null) continue;
                    exception = exception2;
                }
            }
        }
        if (exception != null) {
            throw new AnnotatedException("In total (" + n2 + " of " + n + ") circuits were successfully merged.\n" + "Please manually fix those circuits that failed to merge.", exception);
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateCircuitNameMap(ICircuitId iCircuitId, String string) {
        String string2;
        HashMap hashMap = this.circuitNameMap;
        synchronized (hashMap) {
            string2 = string == null ? (String)this.circuitNameMap.remove(new Long(iCircuitId.longValue())) : this.circuitNameMap.put(new Long(iCircuitId.longValue()), string);
        }
        if (string2 == null || string2 != null && !string2.equals(string)) {
            this.watchDog.queueCircuitNameMapUpdate();
        }
    }

    public OhCircuit upgradeTunnelCircuit(OhCircuit ohCircuit, int n) throws DeletionError, AnnotatedException {
        OhCircuitInfo ohCircuitInfo;
        block10: {
            boolean bl = ohCircuit.getCircuitType() == 4;
            ohCircuitInfo = this.createTunnelInfo(ohCircuit, n, false);
            this.deleteCircuit(ohCircuit);
            if (db.on()) {
                db.println("updateTunnelCircuit - Circuit deleted");
            }
            if (!bl) {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    if (!db.on()) break block10;
                    db.println(" Thread interrupted");
                }
            }
        }
        if (db.on()) {
            db.println("updateTunnelInfo: Start Circuit creation");
        }
        OhCircuit ohCircuit2 = this.createCircuit(ohCircuitInfo);
        if (db.on()) {
            db.println("updateTunnelInfo: Circuit created");
        }
        return ohCircuit2;
    }

    protected int getSlotNum(INodeModel iNodeModel, int n) {
        int n2;
        block2: {
            IEntityTableModel iEntityTableModel = iNodeModel.getEntityTable();
            n2 = 0;
            try {
                IEntityModel iEntityModel = iEntityTableModel.getEntityModelByIndex(n);
                n2 = iEntityModel.getSlot();
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (!db.on()) break block2;
                db.println(" Entity Not found");
            }
        }
        return n2;
    }

    protected int getShelfNum(INodeModel iNodeModel, int n) {
        int n2;
        block3: {
            IEntityTableModel iEntityTableModel = iNodeModel.getEntityTable();
            n2 = 1;
            try {
                if (Feature.provides((INodeModel)iNodeModel, (Feature)Feature.MULTISHELF)) {
                    IEntityModel iEntityModel = iEntityTableModel.getEntityModelByIndex(n);
                    n2 = iEntityModel.getShelfId();
                }
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (!db.on()) break block3;
                db.println(" Entity Not found");
            }
        }
        return n2;
    }

    private void setTypeAndChannel(IOhCircuitInfo iOhCircuitInfo, boolean bl) {
        OhChannelType ohChannelType = null;
        if (bl) {
            iOhCircuitInfo.setCircuitType(6);
            ohChannelType = OhChannelType.getOhChannelTypeObj((int)9);
            ((IpTunnelCircuitInfo)iOhCircuitInfo).setSrcChannelType(ohChannelType);
            ((IpTunnelCircuitInfo)iOhCircuitInfo).setDstChannelType(ohChannelType);
        } else {
            iOhCircuitInfo.setCircuitType(4);
            ohChannelType = OhChannelType.getOhChannelTypeObj((int)0);
            ((SdccCircuitInfo)iOhCircuitInfo).setSrcChannelType(ohChannelType);
            ((SdccCircuitInfo)iOhCircuitInfo).setDstChannelType(ohChannelType);
        }
    }

    public OhCircuit rollBack(IOhCircuitInfo iOhCircuitInfo, int n) throws AnnotatedException {
        boolean bl = true;
        OhCircuit ohCircuit = this.createCircuit(iOhCircuitInfo);
        return ohCircuit;
    }

    private void deleteCircuit(OhCircuit ohCircuit) throws DeletionError {
        boolean bl = false;
        String string = null;
        if (ohCircuit.getState() != 2) {
            if (OhCircuitManager.dbgOn()) {
                db.finer("DEL: sanity check......");
            }
            try {
                ohCircuit.setState(2);
                ohCircuit.destroy(true);
            }
            catch (IncorrectCircuitState incorrectCircuitState) {
                SDebug.printStackTrace((Throwable)incorrectCircuitState);
                bl = true;
                string = incorrectCircuitState.toString();
            }
            catch (SanityCheckFailed sanityCheckFailed) {
                SDebug.printStackTrace((Throwable)sanityCheckFailed);
                bl = true;
                string = sanityCheckFailed.toString();
            }
            catch (DeletionError deletionError) {
                SDebug.printStackTrace((Throwable)deletionError);
                bl = true;
                string = deletionError.toString();
            }
            String string2 = "";
            if (bl) {
                string2 = string2 + "An error occurred while deleting the circuit " + ohCircuit.getCircuitName() + ".\n" + string;
                throw new DeletionError(string2);
            }
        }
    }

    OhCircuit createCircuit(IOhCircuitInfo iOhCircuitInfo) throws AnnotatedException {
        return this.newCircuit(iOhCircuitInfo);
    }

    public OhCircuitInfo createTunnelInfo(OhCircuit ohCircuit, int n, boolean bl) {
        SdccCircuitInfo sdccCircuitInfo;
        boolean bl2 = false;
        OhCircuitInfo ohCircuitInfo = new OhCircuitInfo();
        if (bl) {
            bl2 = ohCircuit.getCircuitType() == 6;
        } else {
            boolean bl3 = bl2 = ohCircuit.getCircuitType() == 4;
        }
        if (bl2) {
            sdccCircuitInfo = new IpTunnelCircuitInfo(ohCircuitInfo);
            ((IpTunnelCircuitInfo)sdccCircuitInfo).setMaxBwPercent(n);
        } else {
            sdccCircuitInfo = new SdccCircuitInfo(ohCircuitInfo);
        }
        sdccCircuitInfo.setCircuitName(ohCircuit.getCircuitName());
        this.setTypeAndChannel(sdccCircuitInfo, bl2);
        OhNetCircuitEnd ohNetCircuitEnd = ohCircuit.getSource();
        OhNetCircuitEnd ohNetCircuitEnd2 = ohCircuit.getFirstDestination();
        int n2 = ohNetCircuitEnd.getPort();
        int n3 = ohNetCircuitEnd2.getPort();
        INodeModel iNodeModel = Network.instance().getNodeModel(ohNetCircuitEnd.getNodeId());
        INodeModel iNodeModel2 = Network.instance().getNodeModel(ohNetCircuitEnd2.getNodeId());
        int n4 = this.getShelfNum(iNodeModel, n2);
        int n5 = this.getShelfNum(iNodeModel2, n3);
        int n6 = this.getSlotNum(iNodeModel, n2);
        int n7 = this.getSlotNum(iNodeModel2, n3);
        OhCircuitEnd ohCircuitEnd = new OhCircuitEnd(ohNetCircuitEnd.getNodeId(), n4, n6, n2);
        OhCircuitEnd ohCircuitEnd2 = new OhCircuitEnd(ohNetCircuitEnd2.getNodeId(), n5, n7, n3);
        sdccCircuitInfo.setSrcPoint(ohCircuitEnd);
        sdccCircuitInfo.setDestPoints(new IOhCircuitEnd[]{ohCircuitEnd2});
        return sdccCircuitInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean setNodeCircuitNameMap(INodeModel iNodeModel) {
        if (!Feature.provides((INodeModel)iNodeModel, (Feature)Feature.AICI)) {
            return true;
        }
        try {
            HashMap hashMap = this.circuitNameMap;
            synchronized (hashMap) {
                iNodeModel.getOhConnectionModels().setCircuitNameMap(this.circuitNameMap);
            }
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            db.warning("IO Exception in setNodeCircuitNameMap " + (Object)((Object)abstractCmsIOException));
            SDebug.printStackTrace((Throwable)abstractCmsIOException);
            return false;
        }
        return true;
    }

    public boolean isLinkAvailable(INetLink iNetLink, int n) {
        boolean bl = n == 4 ? DccTunnel.linkValidForSdccTunnel(iNetLink) : OhCircuit.linkValid(iNetLink, n);
        return bl;
    }

    public void jobGroupFinished(JobGroup jobGroup) {
        if (jobGroup == this.deleteJobGroup) {
            if (OhCircuitManager.dbgOn()) {
                db.finer("DEL: delete JobGroup finished");
            }
            String string = "Circuit Deletion Completed\n";
            JobStatus[] jobStatusArray = jobGroup.getJobStatusList();
            for (int i = 0; i < jobStatusArray.length; ++i) {
                if (jobStatusArray[i].value() != 2) continue;
                string = "Circuit Deletion Failed\n";
                DeletionError deletionError = (DeletionError)jobStatusArray[i].getResult();
                if (deletionError == null) continue;
                string = string + deletionError.toString();
            }
            JobStatus jobStatus = new JobStatus(4);
            jobStatus.setResult((Object)string);
            IAsyncObserver iAsyncObserver = (IAsyncObserver)jobGroup.getUserObject();
            if (iAsyncObserver != null) {
                iAsyncObserver.asyncUpdate(null, jobStatus);
            }
            this.deleteJobGroup = null;
        }
    }

    protected static boolean pkgDbgOn() {
        return pkgDb.on();
    }

    protected static boolean dbgOn() {
        return db.on() || OhCircuitManager.pkgDbgOn();
    }

    public class DumpDebug
    extends SDebug
    implements IDebugDiag {
        public DumpDebug(String string) {
            super(string);
        }

        public final void dump() {
            if (manager != null) {
                Iterator iterator = OhCircuitManager.this.getCircuits().iterator();
                if (!this.on()) {
                    this.set();
                }
                while (iterator.hasNext()) {
                    OhCircuit ohCircuit = (OhCircuit)iterator.next();
                    ohCircuit.prettyPrint(this);
                    this.println("==========================================================");
                }
            }
        }

        public void dumpDiag() {
            this.dump();
        }
    }
}

