/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.route;

import cerent.cms.route.DriNodePair;
import cerent.cms.route.NoRoute;
import cerent.cms.route.TsiRingConstraint;
import cerent.cms.topo.INetElement;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class DriNodes {
    private int type;
    private List driNodePairs;
    private boolean isSecPca;
    private LinkedList tsiRingConstraints;
    private LinkedList possibleBlsrRings;
    private LinkedList requiredRings;

    public DriNodes(int n, boolean bl) {
        this.type = n;
        this.isSecPca = bl;
        this.driNodePairs = new LinkedList();
        this.tsiRingConstraints = new LinkedList();
        this.possibleBlsrRings = new LinkedList();
        this.requiredRings = new LinkedList();
    }

    public boolean isSecPca() {
        return this.isSecPca;
    }

    public void addNodePair(DriNodePair driNodePair) {
        this.driNodePairs.add(driNodePair);
    }

    public void addRequiredRings(String string, String string2) {
        this.requiredRings.clear();
        this.requiredRings.add(string);
        this.requiredRings.add(string2);
    }

    public String getDriRing(INetElement iNetElement) {
        switch (this.findDriNodeType(iNetElement)) {
            case 2: 
            case 4: 
            case 6: 
            case 7: {
                return (String)this.requiredRings.get(0);
            }
            case 3: 
            case 5: {
                return (String)this.requiredRings.get(1);
            }
        }
        return null;
    }

    public String getOtherDriRing(INetElement iNetElement) {
        switch (this.findDriNodeType(iNetElement)) {
            case 2: 
            case 4: 
            case 6: 
            case 7: {
                return (String)this.requiredRings.get(1);
            }
            case 3: 
            case 5: {
                return (String)this.requiredRings.get(0);
            }
        }
        return null;
    }

    public String getFirstDriRing() {
        return (String)this.requiredRings.get(0);
    }

    public String getSecondDriRing() {
        return (String)this.requiredRings.get(1);
    }

    public void sanityCheck() throws NoRoute {
        if (this.getFirstDriRing().equals("") && this.getSecondDriRing().equals("")) {
            throw new NoRoute("Both rings cannot be UPSR in DRI -" + this.prettyString());
        }
        if (this.getFirstDriRing().equals(this.getSecondDriRing())) {
            throw new NoRoute("Rings are same in DRI -" + this.prettyString());
        }
    }

    public int findDriNodeType(INetElement iNetElement) {
        Iterator iterator = this.driNodePairs.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            DriNodePair driNodePair = (DriNodePair)iterator.next();
            boolean bl2 = iNetElement.equals(driNodePair.getPrimary());
            boolean bl3 = iNetElement.equals(driNodePair.getSecondary());
            if (this.type == 1) {
                if (bl2) {
                    if (bl) {
                        return 2;
                    }
                    return 3;
                }
                if (bl3) {
                    if (bl) {
                        return 4;
                    }
                    return 5;
                }
            } else if (this.type == 2) {
                if (bl2) {
                    return 6;
                }
                if (bl3) {
                    return 7;
                }
            }
            bl = false;
        }
        return 1;
    }

    public INetElement getPrimary() {
        if (this.driNodePairs.size() == 0) {
            return null;
        }
        DriNodePair driNodePair = (DriNodePair)this.driNodePairs.iterator().next();
        return driNodePair.getPrimary();
    }

    public List getNodePairs() {
        return this.driNodePairs;
    }

    public boolean isNodeInDriNodes(INetElement iNetElement) {
        for (DriNodePair driNodePair : this.driNodePairs) {
            if (!driNodePair.isNodePrimaryOrSecondary(iNetElement)) continue;
            return true;
        }
        return false;
    }

    public INetElement getPeerNode(INetElement iNetElement) {
        INetElement iNetElement2 = null;
        Iterator iterator = this.driNodePairs.iterator();
        if (iterator.hasNext()) {
            DriNodePair driNodePair = (DriNodePair)iterator.next();
            if (driNodePair.getPrimary().equals(iNetElement)) {
                return driNodePair.getSecondary();
            }
            return driNodePair.getPrimary();
        }
        return iNetElement2;
    }

    public int getDriType() {
        return this.type;
    }

    public LinkedList getTsiRingConstraints() {
        return this.tsiRingConstraints;
    }

    public void clearTsiRingConstraints() {
        if (this.tsiRingConstraints != null) {
            this.tsiRingConstraints.clear();
        }
    }

    public void setTsiRingConstraints(LinkedList linkedList) {
        this.tsiRingConstraints = linkedList;
    }

    public TsiRingConstraint getTsiRingConstraint(String string) {
        if (this.tsiRingConstraints.size() == 0) {
            return null;
        }
        for (TsiRingConstraint tsiRingConstraint : this.tsiRingConstraints) {
            if (!tsiRingConstraint.getRingName().equals(string)) continue;
            return tsiRingConstraint;
        }
        return null;
    }

    public void addTsiRingConstraint(Object object) {
        TsiRingConstraint tsiRingConstraint;
        if (object instanceof TsiRingConstraint && !this.tsiRingConstraints.contains(tsiRingConstraint = (TsiRingConstraint)object)) {
            this.tsiRingConstraints.add(tsiRingConstraint);
        }
    }

    public LinkedList findBlsrDriRings() {
        this.possibleBlsrRings.clear();
        if (!this.getFirstDriRing().equals("")) {
            this.possibleBlsrRings.add(this.getFirstDriRing());
        }
        if (!this.getSecondDriRing().equals("")) {
            this.possibleBlsrRings.add(this.getSecondDriRing());
        }
        return this.possibleBlsrRings;
    }

    public LinkedList getPreferredBlsrRings() {
        return this.possibleBlsrRings;
    }

    public String prettyString() {
        DriNodePair driNodePair = null;
        DriNodePair driNodePair2 = null;
        String string = " TsiConstraint: ";
        if (this.tsiRingConstraints.size() != 0) {
            for (TsiRingConstraint tsiRingConstraint : this.tsiRingConstraints) {
                string = string + tsiRingConstraint.prettyString();
            }
        } else {
            string = string + " Empty";
        }
        String string2 = " Ring1= " + (String)this.requiredRings.get(0) + " Ring2= " + (String)this.requiredRings.get(1);
        driNodePair = (DriNodePair)this.driNodePairs.get(0);
        if (this.type == 1) {
            driNodePair2 = (DriNodePair)this.driNodePairs.get(1);
            return "Type = " + this.type + ". P1:" + driNodePair.getPrimary().prettyString() + ". S1: " + driNodePair.getSecondary().prettyString() + ". P2: " + driNodePair2.getPrimary().prettyString() + ". S2: " + driNodePair2.getSecondary().prettyString() + ". isSecPca: " + this.isSecPca() + string + (String)string2;
        }
        return "Type = " + this.type + ". P: " + driNodePair.getPrimary().prettyString() + ". S: " + driNodePair.getSecondary().prettyString() + ". isSecPca: " + this.isSecPca() + string + (String)string2;
    }
}

