/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.route;

import cerent.cms.ocm.OhCircuitManager;
import cerent.cms.route.NullGranularityFilter;
import cerent.cms.route.RoutePrefs;
import cerent.cms.route.SptLink;
import cerent.cms.route.VcatFilter;
import cerent.cms.route.xLinkNotUsable;
import cerent.cms.topo.CompositeNetLink;
import cerent.cms.topo.DwdmNetLink;
import cerent.cms.topo.INetLink;

public class OhGranularityFilter
extends NullGranularityFilter {
    public OhGranularityFilter(RoutePrefs routePrefs, VcatFilter vcatFilter) {
        super(routePrefs, vcatFilter);
        routePrefs.getLog().getDebugLog().info("OhGranularityFilter: Created");
    }

    @Override
    public boolean isUsable(SptLink sptLink) throws xLinkNotUsable {
        this.prefs.getLog().getDebugLog().info("OhGranularityFilter: isUsable");
        INetLink iNetLink = sptLink.getLink();
        if (iNetLink.isLOTunnel() || iNetLink.isLAP()) {
            throw new xLinkNotUsable("Link is a tunnel");
        }
        if (iNetLink instanceof CompositeNetLink) {
            throw new xLinkNotUsable("Link is a composite link");
        }
        if (iNetLink instanceof DwdmNetLink) {
            throw new xLinkNotUsable("Link is a DWDM link");
        }
        if (!OhCircuitManager.instance().isLinkAvailable(iNetLink, this.prefs.getCircuitType())) {
            throw new xLinkNotUsable("Link is unavailable");
        }
        if (iNetLink.isServerTrail()) {
            throw new xLinkNotUsable("Link is ServerTrail (non-DCC)");
        }
        return super.isUsable(sptLink);
    }
}

