/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.topo;

import cerent.cms.fv.net.IFvLinkModel;
import cerent.cms.fv.net.IFvNetElement;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AbstractCmsObjectNotExistException;
import cerent.cms.model.CircuitType;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.Feature;
import cerent.cms.model.FramingType;
import cerent.cms.model.HoPathDefModel;
import cerent.cms.model.ICircuitSize;
import cerent.cms.model.ICircuitType;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IEntityTableModel;
import cerent.cms.model.IFramingType;
import cerent.cms.model.ILinkModel;
import cerent.cms.model.ILinkPhysicalType;
import cerent.cms.model.ILinkType;
import cerent.cms.model.ILoAditModel;
import cerent.cms.model.ILoPathInfo;
import cerent.cms.model.INetLinkType;
import cerent.cms.model.INetProtectionType;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPathInfo;
import cerent.cms.model.IPoolModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.IServerTrailLinkId;
import cerent.cms.model.LinkModel;
import cerent.cms.model.LinkPhysicalType;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NetLinkType;
import cerent.cms.model.NetProtectionType;
import cerent.cms.ncp.SanityCheckFailed;
import cerent.cms.route.HoLabelSet;
import cerent.cms.route.HoLoSrg;
import cerent.cms.route.ILabelSet;
import cerent.cms.route.INetLinkSpan;
import cerent.cms.route.ISrg;
import cerent.cms.route.LoLabelSet;
import cerent.cms.route.NetLinkSpan;
import cerent.cms.route.NodeSrg;
import cerent.cms.route.PortSrg;
import cerent.cms.route.RoutePrefs;
import cerent.cms.route.SlotSrg;
import cerent.cms.route.SptCompositeNetLink;
import cerent.cms.route.SrgList;
import cerent.cms.route.xLinkNotUsable;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.Network;
import cerent.cms.topo.ServerTrailLink;
import cerent.cms.topo.Topology;
import cerent.cms.ui.helper.PortHelper;
import cerent.util.ComparisonUtil;
import cerent.util.EnumStrings;
import cerent.util.HoLoComparator;
import cerent.util.HoLoFactory;
import cerent.util.IHoLoNum;
import cerent.util.IHoNum;
import cerent.util.ILabel;
import cerent.util.ILoNum;
import cerent.util.IObservable;
import cerent.util.IObserver;
import cerent.util.SDebug;
import java.lang.reflect.Array;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.Set;
import java.util.TreeSet;

public abstract class AbstractNetLink
extends CmsObservable
implements INetLink,
IObserver {
    static final short NOT_BLSR = -1;
    static final short ANY_BLSR = -1;
    static final short NO_SLOT = -1;
    protected static final HoLoComparator holoComp = HoLoComparator.instance();
    protected static final ILoAditModel[] ILoAditModelArrayTemplate = new ILoAditModel[0];
    protected Network net;
    protected ILinkModel linkModel;
    protected INetElement src;
    protected INetElement dst;
    protected ArrayList nodesList;
    protected ArrayList linksList;
    protected boolean srcExtendable;
    protected boolean dstExtendable;
    protected boolean deleted;
    protected int srcShelf = 1;
    protected int srcSlot = 0;
    protected int[] srcPort = new int[0];
    protected int dstShelf = 1;
    protected int dstSlot = 0;
    protected int[] dstPort = new int[0];
    protected boolean sdccLink;
    protected int topoId;
    protected Topology topology;
    protected Integer sla;
    protected SDebug db;
    protected static SDebug dbg = new SDebug("NetLink");
    private long timestamp;

    protected AbstractNetLink(Network network, ILinkModel iLinkModel, INetElement iNetElement, INetElement iNetElement2, boolean bl, Topology topology, int n) {
        this.net = network;
        this.linkModel = iLinkModel;
        this.src = iNetElement;
        this.dst = iNetElement2;
        this.linksList = new ArrayList();
        this.linksList.add(this);
        this.nodesList = new ArrayList();
        this.srcExtendable = true;
        this.dstExtendable = true;
        this.sdccLink = bl;
        this.topology = topology;
        this.topoId = n;
        this.sla = null;
        this.nodesList.add(iNetElement);
        this.nodesList.add(iNetElement2);
        this.deleted = false;
        this.timestamp = System.currentTimeMillis();
        this.initializeDebug();
        if (dbg.on()) {
            this.db.set(true);
        }
        this.acquireSrcSlotAndPort();
        this.acquireDstSlotAndPort();
    }

    protected AbstractNetLink(Network network, ILinkModel iLinkModel, INetElement iNetElement, INetElement iNetElement2, boolean bl) {
        this(network, iLinkModel, iNetElement, iNetElement2, bl, network.getDefaultTopo(), 0);
    }

    protected AbstractNetLink(INetElement iNetElement, INetElement iNetElement2) {
        this(Network.instance(), null, iNetElement, iNetElement2, false, Network.instance().getDefaultTopo(), 0);
    }

    protected AbstractNetLink(Network network, ILinkModel iLinkModel, INetElement iNetElement, INetElement iNetElement2, Topology topology, int n, boolean bl, LinkedList linkedList, LinkedList linkedList2) {
        this.net = network;
        this.linkModel = iLinkModel;
        this.src = iNetElement;
        this.dst = iNetElement2;
        this.sdccLink = bl;
        this.linksList = new ArrayList();
        this.nodesList = new ArrayList();
        this.topology = topology;
        this.topoId = n;
        linkedList.add(iNetElement);
        linkedList.add(iNetElement2);
        this.srcExtendable = true;
        this.dstExtendable = true;
        this.deleted = false;
        this.initializeDebug();
        if (dbg.on()) {
            this.db.set(true);
        }
        this.acquireSrcSlotAndPort();
        this.acquireDstSlotAndPort();
        for (Object object : linkedList) {
            if (this.nodesList.contains(object)) continue;
            this.nodesList.add(object);
        }
        for (INetLink iNetLink : linkedList2) {
            if (this.linksList.contains(iNetLink)) continue;
            this.linksList.add(iNetLink);
        }
        this.timestamp = System.currentTimeMillis();
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    public abstract void newState(int var1);

    protected abstract void setChecking(boolean var1);

    protected abstract boolean inChecking();

    protected String protectionTypeToString() {
        switch (this.getProtectionType()) {
            case 0: {
                return "2F-BLSR";
            }
            case 1: {
                return "1+1";
            }
            case 2: {
                return "LOT";
            }
            case 3: {
                return "Unprotected";
            }
            case 4: {
                return "4F-BLSR";
            }
            case 5: {
                return "2F-PCA";
            }
            case 6: {
                return "4F-PCA";
            }
            case 7: {
                return "Y-Cable";
            }
            case 8: {
                return "Splitter";
            }
            case 11: {
                return "Protected";
            }
            case 12: {
                return "BLSR";
            }
            case 13: {
                return "UPSR";
            }
            case 14: {
                return "PCA";
            }
            case 15: {
                return "Lost";
            }
            case 16: {
                return "Unknown";
            }
            case 17: {
                return "None";
            }
            case 18: {
                return "DRI";
            }
        }
        return "?????";
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(!this.isPca() ? "[NL_" : "[NLp_");
        stringBuffer.append(this.src.getName() + "/");
        stringBuffer.append("s" + this.getSrcSlotNumber() + "/");
        stringBuffer.append("p" + PortHelper.getConcatenatedString((int[])this.getSrcPortNumber()) + " -> ");
        stringBuffer.append(this.dst.getName() + "/");
        stringBuffer.append("s" + this.getDstSlotNumber() + "/");
        stringBuffer.append("p" + PortHelper.getConcatenatedString((int[])this.getDstPortNumber()) + (this.getProtectionRole() == 0 ? " {P}" : " {W}") + " (" + this.timestamp + ")]");
        return stringBuffer.toString();
    }

    public String getString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.src.getName() + "/");
        stringBuffer.append("s" + this.getSrcSlotNumber() + "/");
        stringBuffer.append("p" + PortHelper.getConcatenatedString((int[])this.getSrcPortNumber()) + " -> ");
        stringBuffer.append(this.dst.getName() + "/");
        stringBuffer.append("s" + this.getDstSlotNumber() + "/");
        stringBuffer.append("p" + PortHelper.getConcatenatedString((int[])this.getDstPortNumber()));
        stringBuffer.append(this.getProtectionRole() == 0 ? " {P}" : " {W}");
        return stringBuffer.toString();
    }

    @Override
    public String prettyString() {
        return this.src.prettyString() + "(" + Integer.toHexString(this.linkModel.srcEntityIndex()) + (this.linkModel.srcHo() == null ? "" : ":" + this.linkModel.srcHo()) + ")" + "->" + this.dst.prettyString() + "(" + Integer.toHexString(this.linkModel.dstEntityIndex()) + (this.linkModel.dstHo() == null ? "" : ":" + this.linkModel.dstHo()) + "). " + "(" + EnumStrings.getString(INetLinkType.class, (int)this.getLinkType()) + ", " + EnumStrings.getString(ILinkType.class, (int)this.getPhysicalLinkType()) + (this.getSla() != null ? "SLA " + this.getSla().shortValue() + ", " : " ") + this.protectionTypeToString() + ", " + "State=" + (this.state() == 1 ? "Up)." : "Down).");
    }

    @Override
    public String prettyStringDetail() {
        return this.prettyString();
    }

    @Override
    public ILinkModel getLinkModel() {
        return this.linkModel;
    }

    public INodeModel topoHost() {
        return this.linkModel.topoHost();
    }

    @Override
    public int getDstEntityIndex() {
        return this.linkModel.dstEntityIndex();
    }

    @Override
    public int getSrcEntityIndex() {
        return this.linkModel.srcEntityIndex();
    }

    @Override
    public int[] getDstPortNumber() {
        return this.dstPort;
    }

    @Override
    public int getDstShelfNumber() {
        return this.dstShelf;
    }

    @Override
    public int getDstSlotNumber() {
        return this.dstSlot;
    }

    @Override
    public int[] getSrcPortNumber() {
        return this.srcPort;
    }

    @Override
    public int getSrcShelfNumber() {
        return this.srcShelf;
    }

    @Override
    public int getSrcSlotNumber() {
        return this.srcSlot;
    }

    @Override
    public IHoNum getSrcHo() {
        return this.linkModel.srcHo();
    }

    @Override
    public IHoNum getDstHo() {
        return this.linkModel.dstHo();
    }

    @Override
    public abstract int state();

    @Override
    public int getCost() {
        return this.linkModel.cost();
    }

    @Override
    public void addSrlg(ISrg iSrg) throws SanityCheckFailed {
        throw new SanityCheckFailed("SRLG not supported for link :" + this.prettyString());
    }

    @Override
    public void removeSrlg(ISrg iSrg) throws SanityCheckFailed {
        throw new SanityCheckFailed("SRLG not supported for link :" + this.prettyString());
    }

    @Override
    public void clearSrlg() throws SanityCheckFailed {
        throw new SanityCheckFailed("SRLG not supported for link :" + this.prettyString());
    }

    @Override
    public LinkedList getSrlgList() throws SanityCheckFailed {
        throw new SanityCheckFailed("SRLG not supported for link :" + this.prettyString());
    }

    @Override
    public int getProtectionRole() {
        return this.linkModel.protectionRole();
    }

    @Override
    public int getPhysicalType() {
        return this.linkModel.physicalType();
    }

    @Override
    public ILinkPhysicalType getPhysicalTypeObj() {
        return LinkPhysicalType.getLinkPhysicalType((int)this.linkModel.physicalType());
    }

    public int getPhysicalLinkType() {
        return this.linkModel.physicalLinkType();
    }

    @Override
    public INetElement getDst() {
        return this.dst;
    }

    @Override
    public int getPhysicalSize() {
        ILinkPhysicalType iLinkPhysicalType = LinkPhysicalType.getLinkPhysicalType((int)this.getPhysicalType(), (boolean)true);
        return iLinkPhysicalType == null ? 0 : iLinkPhysicalType.getStsCapacity();
    }

    public ILinkPhysicalType getPhysicalSizeObj() {
        ILinkPhysicalType iLinkPhysicalType = LinkPhysicalType.getLinkPhysicalType((int)this.getPhysicalType(), (boolean)true);
        return iLinkPhysicalType;
    }

    @Override
    public boolean isSdccLink() {
        return this.sdccLink;
    }

    @Override
    public int getProtectionGroup() {
        return this.linkModel.protectionGroup();
    }

    @Override
    public INetElement getSrc() {
        return this.src;
    }

    @Override
    public ArrayList getLinksList() {
        return this.linksList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArrayList getNodesList() {
        ArrayList arrayList = null;
        ArrayList arrayList2 = this.nodesList;
        synchronized (arrayList2) {
            arrayList = new ArrayList(this.nodesList);
        }
        return arrayList;
    }

    @Override
    public int getLinkType() {
        return this.linkModel.linkType();
    }

    public INetLinkType getLinkTypeObj() {
        return NetLinkType.getNetLinkType(this.getLinkType());
    }

    @Override
    public int getProtectionType() {
        return this.linkModel.protectionType();
    }

    @Override
    public int getSrcLinkId() {
        return -1;
    }

    @Override
    public int getDstLinkId() {
        return -1;
    }

    public int getLinkDir() {
        return 0;
    }

    public INetProtectionType getProtectionTypeObj() {
        return NetProtectionType.getNetProtectionType(this.getProtectionType());
    }

    @Override
    public boolean isDeleted() {
        return this.deleted;
    }

    protected void setDeleted(boolean bl) {
        if (this.db.on()) {
            this.db.println("setDeleted: deleted state = " + bl);
        }
        this.deleted = bl;
    }

    @Override
    public void setCost(int n) {
        if (this.linkModel.cost() != n) {
            if (this.db.on()) {
                this.db.println("setCost: " + this.linkModel.cost() + " --> " + n);
            }
            this.linkModel.setCost(n);
            this.setChanged();
            this.notifyObservers(ModelUpdateType.CHANGED);
        }
    }

    @Override
    public void setPhysicalType(int n) {
        if (this.linkModel.physicalType() != n) {
            if (this.db.on()) {
                this.db.println("setPhysicalType: " + this.linkModel.physicalType() + " --> " + n);
            }
            this.linkModel.setPhysicalType(n);
            this.setChanged();
            this.notifyObservers(ModelUpdateType.CHANGED);
        }
    }

    public void setProtectionGroup(int n) {
        if (this.linkModel.protectionGroup() != n) {
            if (this.db.on()) {
                this.db.println("setProtectionGroup: " + this.linkModel.protectionGroup() + " --> " + n);
            }
            this.linkModel.setProtectionGroup(n);
            this.setChanged();
        }
    }

    public void setLinkType(int n) {
        if (this.linkModel.linkType() != n) {
            if (this.db.on()) {
                this.db.println("setLinkType: " + this.linkModel.linkType() + " --> " + n);
            }
            this.linkModel.setLinkType(n);
            this.setChanged();
        }
    }

    @Override
    public void setProtectionType(int n) {
        if (this.linkModel.protectionType() != n) {
            if (this.db.on()) {
                this.db.println("setProtectionType: " + this.linkModel.protectionType() + " --> " + n);
            }
            this.linkModel.setProtectionType(n);
            this.setChanged();
            this.notifyObservers(ModelUpdateType.CHANGED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setTopology(Topology topology, int n) {
        if (this.db.on()) {
            this.db.println("setTopology: topo = " + topology + ", topo id = " + n);
        }
        AbstractNetLink abstractNetLink = this;
        synchronized (abstractNetLink) {
            this.topology = topology;
            this.topoId = n;
        }
    }

    @Override
    public Topology getTopology() {
        return this.topology;
    }

    @Override
    public int getTopoId() {
        return this.topoId;
    }

    protected abstract void setOspfAreaId(long var1);

    @Override
    public abstract long getOspfAreaId();

    protected void refresh(int n, String string, byte by, int n2, int n3, int n4, int n5) {
    }

    @Override
    public void setSla(short s) {
        this.sla = new Integer(s);
    }

    @Override
    public Integer getSla() {
        return this.sla;
    }

    @Override
    public void containsSrg(Collection collection) throws xLinkNotUsable {
        if (SrgList.contains(collection, new NodeSrg(this.getSrc(), 2))) {
            throw new xLinkNotUsable(" Src node is excluded");
        }
        if (SrgList.contains(collection, new NodeSrg(this.getDst(), 1))) {
            throw new xLinkNotUsable(" Dst node is excluded");
        }
        for (ISrg iSrg : collection) {
            Object object;
            ISrg iSrg2;
            if (iSrg instanceof SlotSrg) {
                iSrg2 = (SlotSrg)iSrg;
                if (this.getSrc().equals(((SlotSrg)iSrg2).getNe()) && this.getSrcShelfNumber() == ((SlotSrg)iSrg2).getShelf() && this.getSrcSlotNumber() == ((SlotSrg)iSrg2).getSlot() && ((SlotSrg)iSrg2).getDirection() || this.getDst().equals(((SlotSrg)iSrg2).getNe()) && this.getDstShelfNumber() == ((SlotSrg)iSrg2).getShelf() && this.getDstSlotNumber() == ((SlotSrg)iSrg2).getSlot() && !((SlotSrg)iSrg2).getDirection()) {
                    throw new xLinkNotUsable(" Link contains SRG: " + iSrg.prettyString());
                }
            }
            if (iSrg instanceof PortSrg) {
                iSrg2 = (PortSrg)iSrg;
                if (this.getSrc().equals(((PortSrg)iSrg2).getNe()) && this.getSrcShelfNumber() == ((PortSrg)iSrg2).getShelf() && this.getSrcSlotNumber() == ((PortSrg)iSrg2).getSlot() && ComparisonUtil.compare((int[])this.getSrcPortNumber(), (int[])((PortSrg)iSrg2).getPort()) == 0 || this.getDst().equals(((PortSrg)iSrg2).getNe()) && this.getDstSlotNumber() == ((PortSrg)iSrg2).getSlot() && this.getDstShelfNumber() == ((PortSrg)iSrg2).getShelf() && ComparisonUtil.compare((int[])this.getDstPortNumber(), (int[])((PortSrg)iSrg2).getPort()) == 0) {
                    throw new xLinkNotUsable(" Link contains SRG: " + iSrg.prettyString());
                }
            }
            if (!(iSrg instanceof HoLoSrg) || this.getLinkType() != 9) continue;
            iSrg2 = (HoLoSrg)iSrg;
            ServerTrailLink serverTrailLink = (ServerTrailLink)this;
            ILabel iLabel = serverTrailLink.getPrefs().getSrcPoolStart();
            IHoLoNum iHoLoNum = null;
            IHoLoNum iHoLoNum2 = null;
            if (iLabel instanceof IHoNum) {
                object = (IHoNum)iLabel;
                iHoLoNum = HoLoFactory.createHoLoNum((IHoNum)object, null);
                IHoNum iHoNum = serverTrailLink.getDstHo((IHoNum)object);
                iHoLoNum2 = HoLoFactory.createHoLoNum(iHoNum, null);
            } else {
                iHoLoNum = (IHoLoNum)iLabel;
                iHoLoNum2 = serverTrailLink.getDstHoLo(iHoLoNum.getHoNum(), iHoLoNum.getLoNum());
            }
            object = HoLoComparator.instance();
            if ((!this.getSrc().equals(((HoLoSrg)iSrg2).getNe()) || this.getSrcShelfNumber() != ((HoLoSrg)iSrg2).getShelf() || this.getSrcSlotNumber() != ((HoLoSrg)iSrg2).getSlot() || ComparisonUtil.compare((int[])this.getSrcPortNumber(), (int[])((HoLoSrg)iSrg2).getPort()) != 0 || ((HoLoComparator)object).compare(iHoLoNum, ((HoLoSrg)iSrg2).getHoLoNum()) != 0) && (!this.getDst().equals(((HoLoSrg)iSrg2).getNe()) || this.getDstSlotNumber() != ((HoLoSrg)iSrg2).getSlot() || this.getDstShelfNumber() != ((HoLoSrg)iSrg2).getShelf() || ComparisonUtil.compare((int[])this.getDstPortNumber(), (int[])((HoLoSrg)iSrg2).getPort()) != 0 || ((HoLoComparator)object).compare(iHoLoNum2, ((HoLoSrg)iSrg2).getHoLoNum()) != 0)) continue;
            throw new xLinkNotUsable(" Link contains SRG: " + iSrg.prettyString());
        }
    }

    @Override
    public boolean isUsable(RoutePrefs routePrefs, INetLink iNetLink) throws xLinkNotUsable {
        return true;
    }

    @Override
    public abstract boolean isRoutable();

    protected abstract void initializeDebug();

    @Override
    public boolean equals(Object object) {
        if (object instanceof AbstractNetLink) {
            AbstractNetLink abstractNetLink = (AbstractNetLink)object;
            if (!this.physicalLinkEquals(abstractNetLink)) {
                return false;
            }
            if (!AbstractNetLink.areHosEqual(abstractNetLink.getSrcHo(), this.getSrcHo())) {
                return false;
            }
            if (!AbstractNetLink.areHosEqual(abstractNetLink.getDstHo(), this.getDstHo())) {
                return false;
            }
            return abstractNetLink.isSdccLink() == this.isSdccLink();
        }
        return false;
    }

    public int hashCode() {
        int n = 17;
        n = 37 * n + this.src.hashCode();
        n = 37 * n + this.getSrcEntityIndex();
        n = 37 * n + (this.getSrcHo() == null ? 0 : this.getSrcHo().hashCode());
        n = 37 * n + this.dst.hashCode();
        n = 37 * n + this.getDstEntityIndex();
        n = 37 * n + (this.getDstHo() == null ? 0 : this.getDstHo().hashCode());
        n = 37 * n + (this.isSdccLink() ? 1 : 0);
        return n;
    }

    @Override
    public boolean physicalLinkEquals(INetLink iNetLink) {
        if (!iNetLink.getSrc().equals(this.src)) {
            return false;
        }
        if (iNetLink.getSrcEntityIndex() != this.getSrcEntityIndex()) {
            return false;
        }
        if (!iNetLink.getDst().equals(this.dst)) {
            return false;
        }
        return iNetLink.getDstEntityIndex() == this.getDstEntityIndex();
    }

    @Override
    public boolean isPhysical() {
        return this.getLinkType() == 1;
    }

    @Override
    public boolean isPhantom() {
        return this.getLinkType() == 3;
    }

    @Override
    public boolean isServerTrail() {
        return this.getLinkType() == 9;
    }

    @Override
    public IServerTrailLinkId getServerTrailId() {
        return null;
    }

    @Override
    public String getServerTrailIdString() {
        return "";
    }

    @Override
    public String getServerTrailCktSizeString() {
        return "";
    }

    protected boolean isXcCapable() {
        return this.linkModel.isXcCapable();
    }

    protected boolean isNbrXcCapable() {
        return this.linkModel.isNbrXcCapable();
    }

    @Override
    public boolean inWorkingBLSR() {
        return false;
    }

    @Override
    public short blsrRingId() {
        return 0;
    }

    @Override
    public boolean isPca() {
        return this.getProtectionTypeObj().isPca();
    }

    @Override
    public boolean inBLSR() {
        return false;
    }

    @Override
    public String blsrRingName() {
        return "";
    }

    @Override
    public String blsrRingName(INetElement iNetElement) {
        return "";
    }

    @Override
    public boolean isPca(INetElement iNetElement) {
        INetLink iNetLink = null;
        if (!this.isLOTunnel() && !this.isLAP()) {
            return this.isPca();
        }
        if (iNetElement == this.getSrc()) {
            iNetLink = this.net.findNetLinkFromSource(false, iNetElement, this.getSrcEntityIndex(), this.getSrcHo());
        } else if (iNetElement == this.getDst()) {
            iNetLink = this.net.findNetLinkFromDestination(false, iNetElement, this.getDstEntityIndex(), this.getDstHo());
        }
        return iNetLink != null && iNetLink.isPca();
    }

    @Override
    public abstract boolean isBlsrCapable();

    @Override
    public boolean isLOCapable() {
        if (this.getLinkType() == 7) {
            return true;
        }
        return this.getSrc().loXCon() && this.getDst().loXCon();
    }

    @Override
    public boolean isProtected() {
        if (this.isServerTrail()) {
            return this.getProtectionType() == 11;
        }
        return this.getProtectionType() == 0 || this.getProtectionType() == 4 || this.getProtectionType() == 1 || this.getProtectionType() == 2;
    }

    @Override
    public boolean isFullyUnprotected() {
        for (INetLink iNetLink : this.getLinksList()) {
            if (!iNetLink.isProtected() && !iNetLink.isPca()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isFullyProtected() {
        for (INetLink iNetLink : this.getLinksList()) {
            if (iNetLink.isProtected()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isFullyLineProtected() {
        for (INetLink iNetLink : this.getLinksList()) {
            if (iNetLink.isProtected()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isLOTunnel() {
        return this.getLinkType() == 2;
    }

    @Override
    public boolean isLAP() {
        return this.getLinkType() == 7;
    }

    @Override
    public boolean isOchTrailTunnel() {
        return this.getLinkType() == 8;
    }

    @Override
    public INetLinkSpan getAvailSpan(int n, int n2) {
        INetLinkSpan[] iNetLinkSpanArray = this.getNAvailSpans(n, n2, 1);
        if (iNetLinkSpanArray.length == 0) {
            return null;
        }
        return iNetLinkSpanArray[0];
    }

    @Override
    public INetLinkSpan[] getAllAvailSpans(int n, int n2) {
        return this.getNAvailSpans(n, n2, 100000);
    }

    public INetLinkSpan[] getNAvailSpans(int n, int n2, int n3) {
        if (this.db.on()) {
            this.db.println("getNAvailSpans: N = " + n3);
        }
        int n4 = 0;
        INetLink iNetLink = this.getReverseLink();
        if (iNetLink == null) {
            if (this.db.on()) {
                this.db.println("getNAvailSpans: ReverseLink is Null. Error");
            }
            return new INetLinkSpan[0];
        }
        ILabelSet iLabelSet = this.getSrcLabelSet(n, n2);
        ILabelSet iLabelSet2 = this.getDstLabelSet(n, n2);
        if (this.getLinkType() == 7) {
            if (this.isDstExtendable()) {
                iLabelSet = iLabelSet2;
            }
        } else {
            iLabelSet.intersectSelf(iLabelSet2);
        }
        INetLinkSpan[] iNetLinkSpanArray = new INetLinkSpan[iLabelSet.size()];
        Iterator iterator = iLabelSet.getLabelSet().iterator();
        while (iterator.hasNext() && n4 < n3) {
            ILabel iLabel = (ILabel)iterator.next();
            iNetLinkSpanArray[n4++] = new NetLinkSpan(this, iNetLink, iLabel, iLabel);
        }
        if (dbg.on()) {
            this.db.println("getNAvailSpans: Number of Spans: " + iNetLinkSpanArray.length);
        }
        return iNetLinkSpanArray;
    }

    @Override
    public boolean isValidSrcHoNumber(IHoNum iHoNum) {
        if (this.isLOTunnel() || this.isLAP()) {
            return holoComp.isEqual(this.getSrcHo(), iHoNum);
        }
        return this.isValidHoNumber(iHoNum);
    }

    @Override
    public boolean isValidDstHoNumber(IHoNum iHoNum) {
        if (this.isLOTunnel() || this.isLAP()) {
            return holoComp.isEqual(this.getDstHo(), iHoNum);
        }
        return this.isValidHoNumber(iHoNum);
    }

    public boolean isValidHoNumber(IHoNum iHoNum) {
        if (iHoNum == null) {
            return false;
        }
        int n = iHoNum.getFramingType();
        return holoComp.compare(this.getFirstValidSrcHo(n), iHoNum) <= 0 && holoComp.compare(iHoNum, this.getLastValidSrcHo(n)) <= 0;
    }

    public IHoNum get2fBlsrStartingPcaHo(int n) {
        int n2 = this.getPhysicalSize() / 2 + 1;
        return HoLoFactory.idlSts2HoNum(n, n2);
    }

    protected IPoolModel getPool(INetElement iNetElement, int n) {
        INodeModel iNodeModel = iNetElement.getNodeModel();
        if (this.isPca(iNetElement) && !this.isServerTrail()) {
            return iNodeModel.getPoolModels().getProtectPoolModel(n);
        }
        return iNodeModel.getPoolModels().getPoolModel(n);
    }

    @Override
    public IPoolModel getSrcPool() {
        return this.getPool(this.getSrc(), this.getSrcEntityIndex());
    }

    @Override
    public IPoolModel getDstPool() {
        return this.getPool(this.getDst(), this.getDstEntityIndex());
    }

    @Override
    public INetLink getReverseLink() {
        return this.net.findReverseLink(this);
    }

    @Override
    public INetLink getCounterpartLink() {
        if (this.db.on()) {
            this.db.println("getCounterpartLink: link: " + this.prettyString());
        }
        Collection collection = this.getSrc().getAdjacencyList();
        for (INetLink iNetLink : collection) {
            if (this.db.on()) {
                this.db.println("getCounterpartLink: adjLink: " + iNetLink.prettyString());
            }
            if (this.isLOTunnel()) {
                if (!iNetLink.isLOTunnel()) continue;
                if (!(iNetLink != this && iNetLink.getDst() == this.getDst() && iNetLink.originatingRingName().equals(this.originatingRingName()) && this.terminatingRingName().equals(this.originatingRingName()) && iNetLink.terminatingRingName().equals(this.terminatingRingName()) && iNetLink.getLinksList().size() == this.getLinksList().size())) {
                    if (!this.db.on()) continue;
                    this.db.println("getCounterpartLink: adjLink is not counterPart ");
                    continue;
                }
                boolean bl = true;
                for (INetLink iNetLink2 : this.getLinksList()) {
                    INetLink iNetLink3 = iNetLink2.getCounterpartLink();
                    if (iNetLink3 == null) {
                        if (this.db.on()) {
                            this.db.println("getCounterpartLink: adjLink is not counterPart. There is no counterPart  for " + iNetLink2.prettyString());
                        }
                        bl = false;
                        break;
                    }
                    if (iNetLink.getLinksList().contains(iNetLink3)) continue;
                    if (iNetLink3.getReverseLink() != null) {
                        if (this.db.on()) {
                            this.db.println("getCounterpartLink: revLink not found");
                        }
                        bl = false;
                        break;
                    }
                    if (!iNetLink.getLinksList().contains(iNetLink3.getReverseLink())) continue;
                }
                if (!bl) continue;
                if (this.db.on()) {
                    this.db.println("getCounterpartLink: link is Counterpart");
                }
                return iNetLink;
            }
            if (iNetLink == this || iNetLink.getSrcEntityIndex() != this.getSrcEntityIndex()) continue;
            return iNetLink;
        }
        return null;
    }

    @Override
    public String originatingRingName() {
        return "";
    }

    @Override
    public String terminatingRingName() {
        return "";
    }

    @Override
    public boolean originatingInRing() {
        return false;
    }

    @Override
    public boolean terminatingInRing() {
        return false;
    }

    @Override
    public boolean shouldSrcDstLabelsMatch() {
        if (!this.inBLSR()) {
            return this.isPhysical() || this.isOchTrailTunnel() || this.isPhantom();
        }
        if (this.isLAP()) {
            return false;
        }
        if (this.originatingRingName().equals("") || this.terminatingRingName().equals("")) {
            return false;
        }
        if (this.originatingRingName().equals(this.terminatingRingName())) {
            return !this.isLOTunnel() || this.isFullyProtected();
        }
        return false;
    }

    @Override
    public boolean canSupportCircuitSize(int n, int n2) {
        return this.src.canSupportCircuitSize(n, n2) && this.dst.canSupportCircuitSize(n, n2);
    }

    @Override
    public boolean canSupportCircuitDirection(int n) {
        return true;
    }

    @Override
    public boolean availBW(RoutePrefs routePrefs) {
        return false;
    }

    @Override
    public abstract List getAvailableHoNumbers(int var1, int var2);

    @Override
    public ILabelSet getSrcLabelSet(int n, int n2) {
        boolean bl;
        ICircuitType iCircuitType = CircuitType.getCircuitType((int)n2);
        boolean bl2 = bl = iCircuitType.isLoCircuitType() || iCircuitType.isLoVcatCircuitType();
        if (bl) {
            return new LoLabelSet();
        }
        return new HoLabelSet();
    }

    @Override
    public ILabelSet getDstLabelSet(int n, int n2) {
        boolean bl;
        ICircuitType iCircuitType = CircuitType.getCircuitType((int)n2);
        boolean bl2 = bl = iCircuitType.isLoCircuitType() || iCircuitType.isLoVcatCircuitType();
        if (bl) {
            return new LoLabelSet();
        }
        return new HoLabelSet();
    }

    @Override
    public abstract List getAvailableLoNumbers(IHoNum var1, int var2);

    protected void acquireSrcSlotAndPort() {
        boolean bl;
        INodeModel iNodeModel;
        block16: {
            iNodeModel = this.getSrc().getNodeModel();
            bl = false;
            if (iNodeModel.isInited()) {
                try {
                    IEntityTableModel iEntityTableModel = iNodeModel.getEntityTable();
                    if (iEntityTableModel != null) {
                        IEntityModel iEntityModel = iEntityTableModel.getEntityModelByIndex(this.getSrcEntityIndex());
                        if (iEntityModel != null) {
                            if (iNodeModel.provides(Feature.MULTISHELF)) {
                                this.srcShelf = iEntityModel.getShelfId();
                            }
                            this.srcSlot = iEntityModel.getSlot();
                            this.srcPort = AbstractNetLink.getPortNum(iEntityModel);
                            if (this.db.on()) {
                                this.db.println("acquireSrcSlotAndPort: slot => " + this.srcSlot + ", port => " + PortHelper.getConcatenatedString((int[])this.srcPort));
                            }
                            if (this.srcSlot != 0 && this.srcPort.length > 0) {
                                if (iNodeModel.getConnectionNotifier() != null) {
                                    if (this.db.on()) {
                                        this.db.println("acquireSrcSlotAndPort: deleting SRC NM ConnNotifier observer.");
                                    }
                                    iNodeModel.getConnectionNotifier().deleteObserver((IObserver)this);
                                }
                                this.setChanged();
                            }
                        } else {
                            bl = true;
                        }
                        break block16;
                    }
                    bl = true;
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    bl = true;
                    if (this.db.on()) {
                        this.db.println("acquireSrcSlotAndPort: entity index invalid");
                    }
                    break block16;
                }
            }
            bl = true;
        }
        if (bl) {
            if (iNodeModel.getConnectionNotifier() != null) {
                iNodeModel.getConnectionNotifier().addObserver((IObserver)this);
                if (this.db.on()) {
                    this.db.println("acquireSrcSlotAndPort: observing NM conn notifier");
                }
            } else {
                this.db.println("acquireSrcSlotAndPort: WARNING NM ConnNotifier is null");
            }
        }
    }

    protected void acquireDstSlotAndPort() {
        boolean bl;
        INodeModel iNodeModel;
        block17: {
            iNodeModel = this.getDst().getNodeModel();
            bl = false;
            if (iNodeModel.isInited()) {
                try {
                    IEntityTableModel iEntityTableModel = iNodeModel.getEntityTable();
                    if (iEntityTableModel != null) {
                        IEntityModel iEntityModel = iEntityTableModel.getEntityModelByIndex(this.getDstEntityIndex());
                        if (iEntityModel != null) {
                            if (iNodeModel.provides(Feature.MULTISHELF)) {
                                this.dstShelf = iEntityModel.getShelfId();
                            }
                            this.dstSlot = iEntityModel.getSlot();
                            this.dstPort = AbstractNetLink.getPortNum(iEntityModel);
                            if (this.db.on()) {
                                this.db.println("acquireDstSlotAndPort: slot => " + this.dstSlot + ", port => " + PortHelper.getConcatenatedString((int[])this.dstPort));
                            }
                            if (this.dstSlot != 0 && this.dstPort.length > 0) {
                                if (iNodeModel.getConnectionNotifier() != null) {
                                    if (this.db.on()) {
                                        this.db.println("acquireDstSlotAndPort: deleting DST NM ConnNotifier observer.");
                                    }
                                    iNodeModel.getConnectionNotifier().deleteObserver((IObserver)this);
                                }
                                this.setChanged();
                            }
                        } else {
                            bl = true;
                        }
                        break block17;
                    }
                    bl = true;
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    bl = true;
                    if (this.db.on()) {
                        this.db.println("acquireDstSlotAndPort: entity index invalid");
                    }
                    break block17;
                }
            }
            if (this.db.on()) {
                this.db.println("acquireDstSlotAndPort: DST NE not inited");
            }
            bl = true;
        }
        if (bl) {
            if (iNodeModel.getConnectionNotifier() != null) {
                iNodeModel.getConnectionNotifier().addObserver((IObserver)this);
                if (this.db.on()) {
                    this.db.println("acquireDstSlotAndPort: observing NM conn notifier");
                }
            } else {
                this.db.println("acquireDstSlotAndPort: WARNING NM ConnNotifier is null");
            }
        }
    }

    public final void update(IObservable iObservable, Object object) {
        this._update(iObservable, object);
    }

    public final void update(Observable observable, Object object) {
        this._update(observable, object);
    }

    protected void _update(Object object, Object object2) {
        if (object instanceof INodeModel.AbstractConnectionNotifier) {
            if (object2 == ModelUpdateType.CHANGED) {
                if (this.db.on()) {
                    this.db.println("update: received CHANGED update event");
                }
                this.acquireSrcSlotAndPort();
                this.acquireDstSlotAndPort();
                this.notifyObservers(ModelUpdateType.CHANGED);
            } else if (object2 == ModelUpdateType.DELETED) {
                if (this.db.on()) {
                    this.db.println("update: received DELETED update event");
                }
                ((INodeModel.AbstractConnectionNotifier)object).deleteObserver((IObserver)this);
                this.notifyObservers(ModelUpdateType.DELETED);
            }
        }
    }

    @Override
    public void dispose() {
        if (this.db.on()) {
            this.db.println("dispose: disposing link");
        }
        this.deleted = true;
        this.setChanged();
        this.notifyObservers(ModelUpdateType.DELETED);
        super.destroy();
        this.linksList.clear();
        this.nodesList.clear();
        if (this.linkModel != null) {
            this.linkModel.destroy();
        }
        INodeModel iNodeModel = this.getSrc().getNodeModel();
        INodeModel iNodeModel2 = this.getDst().getNodeModel();
        if (iNodeModel.getConnectionNotifier() != null) {
            if (this.db != null && this.db.on()) {
                this.db.println("dispose: deleting SRC NM ConnNotifier observer.");
            }
            iNodeModel.getConnectionNotifier().deleteObserver((IObserver)this);
        }
        if (iNodeModel2.getConnectionNotifier() != null) {
            if (this.db != null && this.db.on()) {
                this.db.println("dispose: deleting DST NM ConnNotifier observer.");
            }
            iNodeModel2.getConnectionNotifier().deleteObserver((IObserver)this);
        }
        this.db.dispose();
    }

    public void disposed() {
        this.dispose();
    }

    public static String getDebugName(String string) {
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByName(string);
            if (inetAddress != null) {
                byte[] byArray = inetAddress.getAddress();
                return "" + (byArray[3] & 0xFF) + "-" + (byArray[2] & 0xFF) + "-" + (byArray[1] & 0xFF) + "-" + (byArray[0] & 0xFF);
            }
            return string;
        }
        catch (UnknownHostException unknownHostException) {
            return string;
        }
    }

    protected int getPhysicalMaxStsBandwidth() {
        if (this.isLOTunnel() || this.isLAP()) {
            return 0;
        }
        return this.getPhysicalTypeObj().getStsCapacity();
    }

    public IHoNum getFirstValidSrcHo(int n) {
        return this.getValidHo(n, true, true);
    }

    public IHoNum getLastValidSrcHo(int n) {
        return this.getValidHo(n, false, true);
    }

    public IHoNum getFirstValidDstHo(int n) {
        return this.getValidHo(n, true, false);
    }

    public IHoNum getLastValidDstHo(int n) {
        return this.getValidHo(n, false, false);
    }

    private IHoNum getValidHo(int n, boolean bl, boolean bl2) {
        int n2;
        if (this.isLOTunnel() || this.isLAP()) {
            return bl2 ? this.getSrcHo() : this.getDstHo();
        }
        IFramingType iFramingType = FramingType.getFramingType((int)n);
        IHoNum iHoNum = HoLoFactory.createFirstHoNum(n);
        IHoNum iHoNum2 = bl ? iHoNum : ((n2 = iFramingType.getFramingTypeHoPathWidth(this.getPhysicalMaxStsBandwidth())) == 0 ? iHoNum : HoLoFactory.addOffset(iHoNum, n2 - 1));
        if (bl && this.getProtectionType() == 5) {
            iHoNum2 = this.get2fBlsrStartingPcaHo(n);
        }
        if (!bl && this.getProtectionType() == 0) {
            iHoNum2 = HoLoFactory.addOffset(this.get2fBlsrStartingPcaHo(n), -1);
        }
        return iHoNum2;
    }

    protected static boolean areHosEqual(IHoNum iHoNum, IHoNum iHoNum2) {
        return holoComp.isEqual(iHoNum, iHoNum2);
    }

    protected static boolean areLosEqual(ILoNum iLoNum, ILoNum iLoNum2) {
        return holoComp.isEqual(iLoNum, iLoNum2);
    }

    protected static List _aditsWithCapacity(ILoAditModel[] iLoAditModelArray, ICircuitSize iCircuitSize) {
        short s = iCircuitSize.size2widthOfLoCircuit();
        int n = iLoAditModelArray == null ? 0 : iLoAditModelArray.length;
        ArrayList<ILoAditModel> arrayList = new ArrayList<ILoAditModel>();
        for (int i = 0; i < n; ++i) {
            try {
                ILoAditModel iLoAditModel = iLoAditModelArray[i];
                ILoPathInfo[] iLoPathInfoArray = iLoAditModel.getAvailableLos((int)s);
                if (iLoPathInfoArray == null || iLoPathInfoArray.length <= 0) continue;
                arrayList.add(iLoAditModel);
                continue;
            }
            catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
                abstractCmsObjectNotExistException.printStackTrace();
            }
        }
        return arrayList;
    }

    protected static ILoAditModel[] aditsWithCapacity(ILoAditModel[] iLoAditModelArray, ICircuitSize iCircuitSize) {
        ILoAditModel[] iLoAditModelArray2;
        if (iCircuitSize == null) {
            iLoAditModelArray2 = iLoAditModelArray;
        } else {
            List list = AbstractNetLink._aditsWithCapacity(iLoAditModelArray, iCircuitSize);
            iLoAditModelArray2 = list.toArray(ILoAditModelArrayTemplate);
        }
        return iLoAditModelArray2;
    }

    protected static IHoNum getBaseHo(IPoolModel iPoolModel, int n) {
        if (Feature.provides((INodeModel)iPoolModel.getNodeModel(), (Feature)Feature.SDH_AU3)) {
            return iPoolModel.includedPath().getStartingHo(n);
        }
        return iPoolModel.includedPath().getStartingHo();
    }

    protected static IHoNum physicalHo(ILoAditModel iLoAditModel) {
        return HoPathDefModel.physicalHo(iLoAditModel.getHo());
    }

    protected static IHoNum physicalHo(INodeModel iNodeModel, IHoNum iHoNum, IPathInfo iPathInfo) {
        IHoNum iHoNum2 = iNodeModel.provides(Feature.SDH_AU3) ? iPathInfo.getStartingHo(iHoNum.getFramingType()) : iPathInfo.getStartingHo();
        return HoLoFactory.addOffset(iHoNum, iHoNum2);
    }

    protected static Set getCommonHoNums(ILoAditModel[] iLoAditModelArray, ILoAditModel[] iLoAditModelArray2) {
        Set set = AbstractNetLink.getAllHoNums(iLoAditModelArray);
        set.retainAll(AbstractNetLink.getAllHoNums(iLoAditModelArray2));
        return set;
    }

    protected static Set getCommonLoNums(ILoPathInfo[] iLoPathInfoArray, ILoPathInfo[] iLoPathInfoArray2) {
        Set set = AbstractNetLink.getAllLoNums(iLoPathInfoArray);
        set.retainAll(AbstractNetLink.getAllLoNums(iLoPathInfoArray2));
        return set;
    }

    protected static ILoNum getFirstCommonLoNum(ILoPathInfo[] iLoPathInfoArray, ILoPathInfo[] iLoPathInfoArray2) {
        Set set = AbstractNetLink.getCommonLoNums(iLoPathInfoArray, iLoPathInfoArray2);
        ILoNum iLoNum = null;
        if (set.size() > 0) {
            iLoNum = (ILoNum)set.iterator().next();
        }
        return iLoNum;
    }

    protected static Set getAllHoNums(INodeModel iNodeModel, IPathInfo[] iPathInfoArray, IHoNum iHoNum) {
        TreeSet<IHoNum> treeSet = new TreeSet<IHoNum>();
        for (int i = 0; i < iPathInfoArray.length; ++i) {
            treeSet.add(AbstractNetLink.physicalHo(iNodeModel, iHoNum, iPathInfoArray[i]));
        }
        return treeSet;
    }

    protected static Set getAllHoNums(ILoAditModel[] iLoAditModelArray) {
        TreeSet<IHoNum> treeSet = new TreeSet<IHoNum>();
        for (int i = 0; i < iLoAditModelArray.length; ++i) {
            treeSet.add(AbstractNetLink.physicalHo(iLoAditModelArray[i]));
        }
        return treeSet;
    }

    protected static Set getAllLoNums(ILoPathInfo[] iLoPathInfoArray) {
        TreeSet treeSet = AbstractNetLink.createLoSet();
        for (int i = 0; i < iLoPathInfoArray.length; ++i) {
            treeSet.add(iLoPathInfoArray[i].getLoNum());
        }
        return treeSet;
    }

    protected static Object linearSearch(Object object, Object object2, Comparator comparator) {
        int n = Array.getLength(object);
        Object object3 = null;
        for (int i = 0; i < n; ++i) {
            Object object4 = Array.get(object, i);
            if (comparator.compare(object4, object2) != 0) continue;
            object3 = object4;
            break;
        }
        return object3;
    }

    protected static TreeSet createLoSet() {
        HoLoComparator hoLoComparator = HoLoComparator.instance();
        TreeSet treeSet = new TreeSet(hoLoComparator);
        return treeSet;
    }

    protected static int getLoTunnelSize(int n) {
        int n2 = FramingType.getFramingType((int)n).getLoTunnelSize();
        return n2;
    }

    public boolean isSonetCapable() {
        return this.getSrc().getTdmProtocolTypeObj().isSonet();
    }

    @Override
    public int getEndProtectionSwitchState(boolean bl) {
        return -1;
    }

    protected static int[] getPortNum(IEntityModel iEntityModel) {
        if (iEntityModel instanceof IPortModel) {
            if (iEntityModel.getNodeModel().provides(Feature.EXP_PORT_NUM)) {
                return ((IPortModel)iEntityModel).getPortNum();
            }
            return new int[]{iEntityModel.getPort()};
        }
        return new int[0];
    }

    @Override
    public boolean isSrcExtendable() {
        return this.srcExtendable;
    }

    public boolean isDstExtendable() {
        return this.dstExtendable;
    }

    @Override
    public boolean isVirtual() {
        return false;
    }

    @Override
    public boolean isTemporarySptLink() {
        return false;
    }

    @Override
    public boolean needsSptCompositeLink(RoutePrefs routePrefs) {
        return false;
    }

    @Override
    public SptCompositeNetLink getSptCompositeLink(RoutePrefs routePrefs) {
        return null;
    }

    @Override
    public IHoNum get2fBlsrStartingPcaHo(boolean bl) {
        int n = this.src.getTdmProtocolType();
        int n2 = n == 0 ? 0 : 1;
        int n3 = this.getPhysicalSize() / 2 + 1;
        return HoLoFactory.idlSts2HoNum(n2, n3);
    }

    public IFvLinkModel getTheLinkModel() {
        return (LinkModel)this.linkModel;
    }

    public IFvNetElement getDestination() {
        return this.getDst();
    }

    public IFvNetElement getSource() {
        return this.getSrc();
    }

    public class AbstractNetLinkDebug
    extends SDebug {
        public AbstractNetLinkDebug(String string) {
            super(string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void dump() {
            AbstractNetLink.this.db.println("NetLink state:");
            AbstractNetLink.this.db.println("Src = " + AbstractNetLink.this.src.getHostName());
            AbstractNetLink.this.db.println("Dst = " + AbstractNetLink.this.dst.getHostName());
            AbstractNetLink.this.db.println("Deleted = " + AbstractNetLink.this.deleted);
            AbstractNetLink.this.db.println("Topology ID = " + AbstractNetLink.this.topoId);
            AbstractNetLink.this.db.println("NetLink Type = " + AbstractNetLink.this.getLinkTypeObj());
            AbstractNetLink.this.db.println("Protection Type = " + AbstractNetLink.this.getProtectionTypeObj());
            AbstractNetLink.this.db.println("Physical Type = " + AbstractNetLink.this.getPhysicalTypeObj().getDisplayString(AbstractNetLink.this.isSonetCapable()));
            AbstractNetLink.this.db.println("Physical Link Type = " + EnumStrings.getString(ILinkType.class, (int)AbstractNetLink.this.getPhysicalLinkType()));
            AbstractNetLink.this.db.println("Src XC Capable = " + AbstractNetLink.this.isXcCapable());
            AbstractNetLink.this.db.println("Dst XC Capable = " + AbstractNetLink.this.isNbrXcCapable());
            AbstractNetLink.this.db.println("Src Slot = " + AbstractNetLink.this.srcSlot);
            AbstractNetLink.this.db.println("Src Port = " + PortHelper.getConcatenatedString((int[])AbstractNetLink.this.srcPort));
            AbstractNetLink.this.db.println("Dst Slot = " + AbstractNetLink.this.dstSlot);
            AbstractNetLink.this.db.println("Dst Port = " + PortHelper.getConcatenatedString((int[])AbstractNetLink.this.dstPort));
            AbstractNetLink.this.db.println("  Nodes List: ");
            ArrayList arrayList = AbstractNetLink.this.nodesList;
            synchronized (arrayList) {
                for (Object object : AbstractNetLink.this.nodesList) {
                    AbstractNetLink.this.db.println("    " + object.getHostName());
                }
            }
            AbstractNetLink.this.db.println("  Links List:");
            arrayList = AbstractNetLink.this.linksList;
            synchronized (arrayList) {
                for (Object object : AbstractNetLink.this.linksList) {
                    AbstractNetLink.this.db.println("    " + object.prettyString());
                }
            }
        }

        public final void setLinkCost(int n) {
            AbstractNetLink.this.setCost(n);
        }

        public final void dumpObservers() {
            AbstractNetLink.this.db.println("NL observers:");
            AbstractNetLink.this.printObservers();
        }
    }
}

