/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.topo;

import cerent.cms.model.AbstractCmsNoSuchElementException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.CannotPerform;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.Feature;
import cerent.cms.model.FeatureUnsupported;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IEntityTableModel;
import cerent.cms.model.ILinkModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.LinkModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NoSuchEquipment;
import cerent.cms.topo.AbstractNetLink;
import cerent.cms.topo.CompositeNetLink;
import cerent.cms.topo.DwdmNetLink;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.LmpNetLinkManager;
import cerent.cms.topo.NetLinkFactory;
import cerent.cms.topo.NetServerTrailManager;
import cerent.cms.topo.Network;
import cerent.cms.topo.NonRoutableNetLink;
import cerent.cms.topo.OscNetLink;
import cerent.cms.topo.Topology;
import cerent.cms.topo.UnknownNetLink;
import cerent.cms.ui.helper.PortHelper;
import cerent.util.ComparisonUtil;
import cerent.util.SDebug;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;

public class NetLinkManager
implements Observer {
    private static NetLinkManager nlMgr;
    private Network net;
    private List sourceTerminatedLinkList;
    private List unprocessedLinkList;
    private List unknownLinkList;
    private List oscLinkList;
    private SDebug db = new NetLinkManagerDebug("NetLinkManager");

    private NetLinkManager() {
        this.net = Network.instance();
        this.sourceTerminatedLinkList = Collections.synchronizedList(new LinkedList());
        this.unprocessedLinkList = Collections.synchronizedList(new LinkedList());
        this.unknownLinkList = Collections.synchronizedList(new LinkedList());
        this.oscLinkList = Collections.synchronizedList(new LinkedList());
        if (this.net.db.on()) {
            this.db.set(true);
        }
        if (this.db.on()) {
            this.db.println("Creating new NetLinkManager");
        }
        Thread thread = new Thread("NetLinkManager"){

            @Override
            public void run() {
                while (true) {
                    try {
                        1.sleep(5000L);
                        NetServerTrailManager.instance().discoverServerTrails();
                    }
                    catch (Exception exception) {
                        NetLinkManager.this.db.println("NetLinkManager hit an exception");
                        NetLinkManager.this.db;
                        SDebug.printStackTrace((Throwable)exception);
                    }
                    try {
                        1.sleep(5000L);
                        LmpNetLinkManager.instance().discoverLMPLinks();
                        continue;
                    }
                    catch (Exception exception) {
                        NetLinkManager.this.db.println("NetLinkManager hit an exception");
                        NetLinkManager.this.db;
                        SDebug.printStackTrace((Throwable)exception);
                        continue;
                    }
                    break;
                }
            }
        };
        thread.setName("CTC NetLinkManager Thread");
        thread.start();
    }

    public static synchronized NetLinkManager instance() {
        if (nlMgr == null) {
            nlMgr = new NetLinkManager();
        }
        return nlMgr;
    }

    protected synchronized void newNetLink(INetLink iNetLink) {
        iNetLink.addObserver(this);
        if (iNetLink instanceof UnknownNetLink) {
            if (!((UnknownNetLink)iNetLink).isValid()) {
                if (this.db.on()) {
                    this.db.println("newNetLink: NL " + iNetLink.toString() + " not yet ready");
                }
                return;
            }
            if (!this.unknownLinkList.contains(iNetLink)) {
                if (this.db.on()) {
                    this.db.println("newNetLink: adding unknown NL " + iNetLink.toString());
                }
                this.unknownLinkList.add(iNetLink);
                if (iNetLink.isDeleted()) {
                    this.deleteNetLink(iNetLink);
                } else {
                    this.net.queueNetworkUpdateEvent();
                }
            }
        } else if (iNetLink instanceof OscNetLink) {
            if (!((OscNetLink)iNetLink).isValid()) {
                if (this.db.on()) {
                    this.db.println("newNetLink: NL " + iNetLink.toString() + " not valid");
                }
                return;
            }
            if (!this.oscLinkList.contains(iNetLink)) {
                if (this.db.on()) {
                    this.db.println("newNetLink: adding OSC NL " + iNetLink.toString());
                }
                this.oscLinkList.add(iNetLink);
                if (iNetLink.isDeleted()) {
                    this.deleteNetLink(iNetLink);
                } else {
                    this.net.queueNetworkUpdateEvent();
                }
            } else if (this.db.on()) {
                this.db.println("newNetLink: already in list " + iNetLink.toString());
            }
        } else if (iNetLink instanceof NonRoutableNetLink) {
            if (!((NonRoutableNetLink)iNetLink).isValid() || ((NonRoutableNetLink)iNetLink).isSpliced()) {
                if (this.db.on()) {
                    this.db.println("newNetLink: NL " + iNetLink.toString() + " not valid");
                }
                return;
            }
            switch (iNetLink.getLinkModel().physicalLinkType()) {
                case 1: 
                case 2: {
                    if (iNetLink.getLinkModel().isXcCapable() && !iNetLink.getLinkModel().isNbrXcCapable()) {
                        if (!this.sourceTerminatedLinkList.contains(iNetLink)) {
                            if (this.db.on()) {
                                this.db.println("newNetLink: adding non-routable NL " + iNetLink.toString());
                            }
                            this.sourceTerminatedLinkList.add(iNetLink);
                        }
                    } else if (!this.unprocessedLinkList.contains(iNetLink)) {
                        if (this.db.on()) {
                            this.db.println("newNetLink: adding non-routable NL " + iNetLink.toString());
                        }
                        this.unprocessedLinkList.add(iNetLink);
                    }
                    if (iNetLink.isDeleted()) {
                        this.deleteNetLink(iNetLink);
                        break;
                    }
                    this.net.queueNetworkUpdateEvent();
                    break;
                }
                case 3: 
                case 6: {
                    if (this.unprocessedLinkList.contains(iNetLink)) break;
                    if (this.db.on()) {
                        this.db.println("newNetLink: adding non-routable NL " + iNetLink.toString());
                    }
                    this.unprocessedLinkList.add(iNetLink);
                    if (iNetLink.isDeleted()) {
                        this.deleteNetLink(iNetLink);
                        break;
                    }
                    this.net.queueNetworkUpdateEvent();
                    break;
                }
            }
        }
    }

    private void deleteNetLink(INetLink iNetLink) {
        this.sourceTerminatedLinkList.remove(iNetLink);
        this.unprocessedLinkList.remove(iNetLink);
        this.unknownLinkList.remove(iNetLink);
        this.oscLinkList.remove(iNetLink);
        iNetLink.deleteObserver(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection getSourceTerminatedLinks() {
        LinkedList linkedList;
        List list = this.sourceTerminatedLinkList;
        synchronized (list) {
            linkedList = new LinkedList(this.sourceTerminatedLinkList);
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection getUnprocessedLinks() {
        LinkedList linkedList;
        List list = this.unprocessedLinkList;
        synchronized (list) {
            linkedList = new LinkedList(this.unprocessedLinkList);
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection getOscLinks() {
        LinkedList linkedList;
        List list = this.oscLinkList;
        synchronized (list) {
            linkedList = new LinkedList(this.oscLinkList);
        }
        return linkedList;
    }

    private synchronized void spliceLinks() {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        LinkedList linkedList2 = (LinkedList)this.getSourceTerminatedLinks();
        while (linkedList2.size() > 0) {
            NonRoutableNetLink nonRoutableNetLink = (NonRoutableNetLink)linkedList2.removeFirst();
            if (this.db.on()) {
                this.db.println("spliceLinks: processing SRC term. NL " + nonRoutableNetLink.toString());
            }
            LinkedList<Object> linkedList3 = new LinkedList<Object>();
            LinkedList linkedList4 = (LinkedList)this.getUnprocessedLinks();
            boolean bl = false;
            linkedList3.add(nonRoutableNetLink);
            linkedList4.remove(nonRoutableNetLink);
            Object object = nonRoutableNetLink;
            while (object != null) {
                Object object2 = this.findMatchingLink(((AbstractNetLink)object).getDst(), ((NonRoutableNetLink)object).getDstSlot(), ((NonRoutableNetLink)object).getDstPort(), ((NonRoutableNetLink)object).isDstDwdmPort(), linkedList4);
                if (object2 == null && ((AbstractNetLink)object).getProtectionType() == 7) {
                    if (this.db.on()) {
                        this.db.println("spliceLinks: match not found using YCable working port, trying protect port");
                    }
                    int n = this.getProtectSlot((NonRoutableNetLink)object, false);
                    int[] nArray = this.getProtectPort((NonRoutableNetLink)object, false);
                    object2 = this.findMatchingLink(((AbstractNetLink)object).getDst(), n, nArray, ((NonRoutableNetLink)object).isDstDwdmPort(), linkedList4);
                }
                if (object2 != null) {
                    if (((AbstractNetLink)object2).getLinkModel().isNbrXcCapable()) {
                        if (nonRoutableNetLink.getPhysicalSize() == ((AbstractNetLink)object2).getPhysicalSize()) {
                            if (linkedList3.size() > 1) {
                                if (ComparisonUtil.compare((int[])nonRoutableNetLink.getDstPort(), (int[])((NonRoutableNetLink)object2).getSrcPort()) == 0) {
                                    if (this.db.on()) {
                                        this.db.println("spliceLinks: Link successfully spliced");
                                    }
                                    linkedList3.add(object2);
                                    bl = true;
                                    break;
                                }
                                if (this.db.on()) {
                                    this.db.println("spliceLinks: excluding matching Link");
                                }
                                linkedList4.remove(object2);
                                continue;
                            }
                            if (this.db.on()) {
                                this.db.println("spliceLinks: Link successfully spliced");
                            }
                            linkedList3.add(object2);
                            bl = true;
                            break;
                        }
                        if (this.db.on()) {
                            this.db.println("spliceLinks: Link successfully spliced");
                        }
                        linkedList3.add(object2);
                        bl = true;
                        if (nonRoutableNetLink.getPhysicalSize() > ((AbstractNetLink)object2).getPhysicalSize()) {
                            linkedList.add(nonRoutableNetLink);
                            break;
                        }
                        linkedList.add(object2);
                        break;
                    }
                    linkedList3.add(object2);
                    linkedList4.remove(object2);
                    object = object2;
                    if (!this.db.on()) continue;
                    this.db.println("spliceLinks: found match, setting new seed");
                    continue;
                }
                object = object2;
            }
            if (bl) {
                this.createCompositeLink(linkedList3, linkedList);
            }
            for (NonRoutableNetLink nonRoutableNetLink2 : linkedList) {
                if (!nonRoutableNetLink2.isXcCapable()) continue;
                if (this.db.on()) {
                    this.db.println("spliceLinks: adding required link " + nonRoutableNetLink2.toString() + " to SRC term links");
                }
                linkedList2.add(nonRoutableNetLink2);
            }
            linkedList.clear();
        }
    }

    private int getProtectSlot(NonRoutableNetLink nonRoutableNetLink, boolean bl) {
        block4: {
            int n = nonRoutableNetLink.getLinkModel().getYCableProtectPortEntityIndex();
            INodeModel iNodeModel = bl ? nonRoutableNetLink.getSrc().getNodeModel() : nonRoutableNetLink.getDst().getNodeModel();
            try {
                IEntityModel iEntityModel;
                IEntityTableModel iEntityTableModel = iNodeModel.getEntityTable();
                if (iEntityTableModel != null && (iEntityModel = iEntityTableModel.getEntityModelByIndex(n)) != null) {
                    int n2 = iEntityModel.getSlot();
                    if (this.db.on()) {
                        this.db.println("getProtectSlot: NE " + iNodeModel.getHostName() + ", YCable prot slot " + n2);
                    }
                    return n2;
                }
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (!this.db.on()) break block4;
                this.db.println("getProtectSlot: entity index invalid");
            }
        }
        return 0;
    }

    private int[] getProtectPort(NonRoutableNetLink nonRoutableNetLink, boolean bl) {
        block4: {
            int n = nonRoutableNetLink.getLinkModel().getYCableProtectPortEntityIndex();
            INodeModel iNodeModel = bl ? nonRoutableNetLink.getSrc().getNodeModel() : nonRoutableNetLink.getDst().getNodeModel();
            try {
                IEntityModel iEntityModel;
                IEntityTableModel iEntityTableModel = iNodeModel.getEntityTable();
                if (iEntityTableModel != null && (iEntityModel = iEntityTableModel.getEntityModelByIndex(n)) != null) {
                    int[] nArray = AbstractNetLink.getPortNum(iEntityModel);
                    if (this.db.on()) {
                        this.db.println("getProtectPort: NE " + iNodeModel.getHostName() + ", YCable prot port " + PortHelper.getConcatenatedString((int[])nArray));
                    }
                    return nArray;
                }
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (!this.db.on()) break block4;
                this.db.println("getProtectPort: entity index invalid");
            }
        }
        return new int[0];
    }

    private NonRoutableNetLink findMatchingLink(INetElement iNetElement, int n, int[] nArray, boolean bl, Collection collection) {
        NonRoutableNetLink nonRoutableNetLink = null;
        if (this.db.on()) {
            this.db.println("findMatchingLink: for NE " + iNetElement.getHostName() + ", slot => " + n + ", port => " + PortHelper.getConcatenatedString((int[])nArray) + ", trunk => " + bl);
            for (NonRoutableNetLink nonRoutableNetLink2 : collection) {
                this.db.println("candidate NL => " + nonRoutableNetLink2.toString());
            }
        }
        for (NonRoutableNetLink nonRoutableNetLink2 : collection) {
            if (this.db.on()) {
                this.db.println("findMatchingLink: trying NL " + nonRoutableNetLink2.toString());
                this.db.println("findMatchingLink: src slot => " + nonRoutableNetLink2.getSrcSlot() + ", src port => " + PortHelper.getConcatenatedString((int[])nonRoutableNetLink2.getSrcPort()) + ", src DWDM => " + nonRoutableNetLink2.isSrcDwdmPort());
            }
            if (!nonRoutableNetLink2.isValid()) {
                if (!this.db.on()) continue;
                this.db.println("findMatchingLink: ignoring invalid NL");
                continue;
            }
            if (this.doEndpointsMatch(iNetElement, n, nArray, bl, nonRoutableNetLink2.getSrc(), nonRoutableNetLink2.getSrcSlot(), nonRoutableNetLink2.getSrcPort(), nonRoutableNetLink2.isSrcDwdmPort())) {
                if (this.db.on()) {
                    this.db.println("findMatchingLink: found matching NL " + nonRoutableNetLink2.toString());
                }
                nonRoutableNetLink = nonRoutableNetLink2;
                break;
            }
            if (nonRoutableNetLink2.getProtectionType() != 7) continue;
            if (this.db.on()) {
                this.db.println("findMatchingLink: match not found using YCable working port, trying protect port");
            }
            int n2 = this.getProtectSlot(nonRoutableNetLink2, true);
            int[] nArray2 = this.getProtectPort(nonRoutableNetLink2, true);
            if (!this.doEndpointsMatch(iNetElement, n, nArray, bl, nonRoutableNetLink2.getSrc(), n2, nArray2, nonRoutableNetLink2.isSrcDwdmPort())) continue;
            if (this.db.on()) {
                this.db.println("findMatchingLink: found matching NL " + nonRoutableNetLink2.toString());
            }
            nonRoutableNetLink = nonRoutableNetLink2;
            break;
        }
        return nonRoutableNetLink;
    }

    private boolean doEndpointsMatch(INetElement iNetElement, int n, int[] nArray, boolean bl, INetElement iNetElement2, int n2, int[] nArray2, boolean bl2) {
        return iNetElement == iNetElement2 && n == n2 && bl != bl2 && ComparisonUtil.compare((int[])nArray, (int[])nArray2) != 0;
    }

    private void createCompositeLink(Collection collection, Collection collection2) {
        CmsObservable cmsObservable2;
        if (this.db.on()) {
            this.db.println("createCompositeLink: Composite Link components:");
        }
        AbstractNetLink abstractNetLink = null;
        AbstractNetLink abstractNetLink2 = null;
        LinkedList<NonRoutableNetLink> linkedList = new LinkedList<NonRoutableNetLink>();
        int n = 0;
        for (CmsObservable cmsObservable2 : collection) {
            if (this.db.on()) {
                this.db.println("createCompositeLink:     " + cmsObservable2.toString());
            }
            cmsObservable2.setIsSpliced(true);
            n += cmsObservable2.getCost();
            if (cmsObservable2.getLinkModel().isXcCapable()) {
                abstractNetLink = cmsObservable2;
                if (collection2.contains((Object)cmsObservable2)) continue;
                this.sourceTerminatedLinkList.remove((Object)cmsObservable2);
                cmsObservable2.deleteObserver(this);
                continue;
            }
            if (cmsObservable2.getLinkModel().isNbrXcCapable()) {
                abstractNetLink2 = cmsObservable2;
                if (collection2.contains((Object)cmsObservable2)) continue;
                this.unprocessedLinkList.remove((Object)cmsObservable2);
                cmsObservable2.deleteObserver(this);
                continue;
            }
            linkedList.add((NonRoutableNetLink)cmsObservable2);
        }
        cmsObservable2 = new LinkModel(abstractNetLink.getSrc().getNodeModel(), abstractNetLink.getSrcEntityIndex(), null, abstractNetLink2.getDst().getNodeModel(), abstractNetLink2.getDstEntityIndex(), null, abstractNetLink.getLinkModel().linkType(), abstractNetLink.getLinkModel().physicalType(), abstractNetLink.getLinkModel().physicalLinkType(), true, true, -1, -1, 3, "", 0, abstractNetLink.getLinkModel().protectionGroup(), abstractNetLink.getLinkModel().protectionRole(), n, 0, 0);
        CompositeNetLink compositeNetLink = new CompositeNetLink(this.net, (ILinkModel)cmsObservable2, (NonRoutableNetLink)abstractNetLink, (NonRoutableNetLink)abstractNetLink2, linkedList);
        this.net.addCompositeNetLink(compositeNetLink);
    }

    private void createDwdmLink(OscNetLink oscNetLink) throws NoSuchEquipment, FeatureUnsupported, CannotPerform, AbstractCmsNoSuchElementException {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (this.db.on()) {
            this.db.println("createDwdmLink: getOtsSrcPort From:" + oscNetLink.getSrc().getHostName() + " To:" + oscNetLink.getDst().getHostName());
        }
        n = oscNetLink.getOtsSrcPort();
        if (this.db.on()) {
            this.db.println("createDwdmLink: srcEntityIdx " + Integer.toHexString(n));
        }
        if (this.db.on()) {
            this.db.println("createDwdmLink: getOtsDstPort From:" + oscNetLink.getDst().getHostName() + " To:" + oscNetLink.getSrc().getHostName());
        }
        n3 = oscNetLink.getOtsDstPort();
        if (this.db.on()) {
            this.db.println("createDwdmLink: dstEntityIdx " + Integer.toHexString(n3));
        }
        this.createDwdmLink(oscNetLink, n, n3, 1);
        n4 = oscNetLink.getOtsProtDstPort();
        if (n4 != 0) {
            n2 = oscNetLink.getOtsProtSrcPort();
            if (this.db.on()) {
                this.db.println("createDwdmLink: Protected link from protSrcEntityIdx " + Integer.toHexString(n2) + " to protDstEntityIdx " + Integer.toHexString(n4));
            }
            this.createDwdmLink(oscNetLink, n2, n4, 0);
        }
    }

    private void createDwdmLink(OscNetLink oscNetLink, int n, int n2, int n3) throws NoSuchEquipment, FeatureUnsupported, CannotPerform, AbstractCmsNoSuchElementException {
        INetElement iNetElement = oscNetLink.getSrc();
        INodeModel iNodeModel = iNetElement.getNodeModel();
        INetElement iNetElement2 = oscNetLink.getDst();
        INodeModel iNodeModel2 = iNetElement2.getNodeModel();
        Topology topology = oscNetLink.getTopology();
        LinkModel linkModel = new LinkModel(iNodeModel, n, null, iNodeModel2, n2, null, 1, 5, 5, true, true, -1, -1, 3, "", 0, 0, n3, 1024, 0, 0);
        INetLink iNetLink = Network.instance().findNetLink(iNetElement, n, null, iNetElement2, n2, null, false, 1);
        if (iNetLink == null) {
            INetLink iNetLink2;
            INetLink iNetLink3 = Network.instance().findRedundantNetLinkFromSource(linkModel.linkType(), iNetElement, linkModel.srcEntityIndex(), linkModel.srcHo(), linkModel.isPca(), linkModel.getSrcLinkId());
            if (iNetLink3 != null) {
                if (this.db.on()) {
                    this.db.println("createDwdmLink: found OTS SRC redundant link, let's dispose it: " + iNetLink3.prettyString());
                }
                Network.instance().deleteNetLink(iNetLink3);
                iNetLink2 = Network.instance().findReverseLink(iNetLink3);
                if (iNetLink2 != null) {
                    if (this.db.on()) {
                        this.db.println("createDwdmLink: found OTS SRC redundant reverse link, let's dispose it: " + iNetLink2.prettyString());
                    }
                    Network.instance().deleteNetLink(iNetLink2);
                }
            }
            if ((iNetLink2 = Network.instance().findRedundantNetLinkFromDestination(linkModel.linkType(), iNetElement2, linkModel.dstEntityIndex(), linkModel.dstHo(), linkModel.isPca(), linkModel.getDstLinkId())) != null) {
                if (this.db.on()) {
                    this.db.println("createDwdmLink: found OTS DST redundant link, let's dispose it: " + iNetLink2.prettyString());
                }
                Network.instance().deleteNetLink(iNetLink2);
                INetLink iNetLink4 = Network.instance().findReverseLink(iNetLink2);
                if (iNetLink4 != null) {
                    if (this.db.on()) {
                        this.db.println("createDwdmLink: found OTS DST redundant reverse link, let's dispose it: " + iNetLink4.prettyString());
                    }
                    Network.instance().deleteNetLink(iNetLink4);
                }
            }
            iNetLink = NetLinkFactory.createNetLink(this.net, (ILinkModel)linkModel, iNetElement, iNetElement2, topology, false, false);
            if (this.db.on()) {
                this.db.println("createDwdmLink: link is new, add it to network");
            }
            this.net.addDwdmNetLink(iNetLink);
        } else if (this.db.on()) {
            this.db.println("createDwdmLink: link is already in the network");
        }
        if (!iNodeModel.provides(Feature.OPTICAL_SIDE)) {
            ((DwdmNetLink)iNetLink).setOptAttribs(oscNetLink.getOptRingName(), oscNetLink.getOptLinkDir());
        }
        ((DwdmNetLink)iNetLink).startObserving(oscNetLink);
    }

    private UnknownNetLink getNextUnknownLink() {
        UnknownNetLink unknownNetLink;
        block3: {
            unknownNetLink = null;
            try {
                if (!this.unknownLinkList.isEmpty()) {
                    unknownNetLink = (UnknownNetLink)this.unknownLinkList.remove(0);
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                if (!this.db.on()) break block3;
                this.db.println("getNextUnknownLink: no Unknown links to process");
            }
        }
        return unknownNetLink;
    }

    private void processUnknownLinks() {
        UnknownNetLink unknownNetLink = this.getNextUnknownLink();
        while (unknownNetLink != null) {
            if (this.db.on()) {
                this.db.println("processUnknownLinks: processing NL " + unknownNetLink.toString());
            }
            LinkModel linkModel = (LinkModel)unknownNetLink.getLinkModel();
            LinkModel linkModel2 = new LinkModel(unknownNetLink.getSrc().getNodeModel(), unknownNetLink.getSrcEntityIndex(), null, unknownNetLink.getDst().getNodeModel(), unknownNetLink.getDstEntityIndex(), null, 1, unknownNetLink.getPhysicalType(), unknownNetLink.getPhysicalLinkType(), unknownNetLink.isXcCapable(), unknownNetLink.isNbrXcCapable(), -1, -1, unknownNetLink.getProtectionType(), linkModel.blsrRingName(), linkModel.blsrNodeId(), linkModel.protectionGroup(), linkModel.protectionRole(), linkModel.cost(), linkModel.pcaRevertMode(), linkModel.getLinkDir());
            INetLink iNetLink = NetLinkFactory.createNetLink(this.net, (ILinkModel)linkModel2, unknownNetLink.getSrc(), unknownNetLink.getDst(), unknownNetLink.getTopology(), unknownNetLink.isSdccLink(), true);
            this.net.replaceUnknownLink(unknownNetLink, iNetLink);
            unknownNetLink = this.getNextUnknownLink();
        }
    }

    private void processOscLinks() {
        if (this.db.on()) {
            this.db.println("processOscLinks: entry processing NL");
        }
        for (OscNetLink oscNetLink : this.getOscLinks()) {
            if (this.db.on()) {
                this.db.println("processOscLinks: processing NL " + oscNetLink.toString());
            }
            try {
                this.createDwdmLink(oscNetLink);
                this.deleteNetLink(oscNetLink);
            }
            catch (NoSuchEquipment noSuchEquipment) {
                if (!this.db.on()) continue;
                this.db.println("NoSuchEquipment: processing NL " + oscNetLink.toString());
            }
            catch (FeatureUnsupported featureUnsupported) {
                if (!this.db.on()) continue;
                this.db.println("FeatureUnsupported: processing NL " + oscNetLink.toString());
            }
            catch (CannotPerform cannotPerform) {
                if (!this.db.on()) continue;
                this.db.println("CannotPerform: processing NL " + oscNetLink.toString());
            }
            catch (AbstractCmsNoSuchElementException abstractCmsNoSuchElementException) {
                if (!this.db.on()) continue;
                this.db.println("AbstractCmsNoSuchElementException: processing NL " + oscNetLink.toString());
            }
        }
    }

    protected void doAction() {
        this.processUnknownLinks();
        this.processOscLinks();
        this.spliceLinks();
    }

    @Override
    public void update(Observable observable, Object object) {
        if (observable instanceof INetLink) {
            INetLink iNetLink = (INetLink)((Object)observable);
            if (object == ModelUpdateType.CHANGED) {
                if (this.db.on()) {
                    this.db.println("update: received CHANGED event from " + iNetLink.toString());
                }
                this.newNetLink(iNetLink);
            } else if (object == ModelUpdateType.DELETED) {
                if (this.db.on()) {
                    this.db.println("update: received DELETED event from " + iNetLink.toString());
                }
                this.deleteNetLink(iNetLink);
            }
        }
    }

    public class NetLinkManagerDebug
    extends SDebug {
        public NetLinkManagerDebug(String string) {
            super(string);
        }

        public final void dump() {
            this.dumpSrcTermLinks();
            this.dumpUnprocessedLinks();
            this.dumpUnknownLinks();
            this.dumpOscLinks();
        }

        public final void doAction() {
            NetLinkManager.this.doAction();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void dumpSrcTermLinks() {
            NetLinkManager.this.db.println("======================================");
            NetLinkManager.this.db.println("SRC term. Links:");
            List list = NetLinkManager.this.sourceTerminatedLinkList;
            synchronized (list) {
                for (INetLink iNetLink : NetLinkManager.this.sourceTerminatedLinkList) {
                    NetLinkManager.this.db.println(iNetLink.toString());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void dumpOscLinks() {
            NetLinkManager.this.db.println("======================================");
            NetLinkManager.this.db.println("OSC Links:");
            List list = NetLinkManager.this.oscLinkList;
            synchronized (list) {
                for (INetLink iNetLink : NetLinkManager.this.oscLinkList) {
                    NetLinkManager.this.db.println(iNetLink.toString());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void dumpUnprocessedLinks() {
            NetLinkManager.this.db.println("======================================");
            NetLinkManager.this.db.println("Unprocessed Links:");
            List list = NetLinkManager.this.unprocessedLinkList;
            synchronized (list) {
                for (NonRoutableNetLink nonRoutableNetLink : NetLinkManager.this.unprocessedLinkList) {
                    NetLinkManager.this.db.println(nonRoutableNetLink.toString());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void dumpUnknownLinks() {
            NetLinkManager.this.db.println("=======================================");
            NetLinkManager.this.db.println("Unknown Links:");
            List list = NetLinkManager.this.unknownLinkList;
            synchronized (list) {
                for (UnknownNetLink unknownNetLink : NetLinkManager.this.unknownLinkList) {
                    NetLinkManager.this.db.println(unknownNetLink.toString());
                }
            }
        }

        public final void dumpObservers() {
        }
    }
}

