/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.topo;

import cerent.cms.fv.net.IFvNetElement;
import cerent.cms.fv.net.IFvNetLink;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsNoSuchElementException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.Feature;
import cerent.cms.model.FramingType;
import cerent.cms.model.IConnectionModel;
import cerent.cms.model.IConnectionModels;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IEntityTableModel;
import cerent.cms.model.IFramingType;
import cerent.cms.model.IHoConnectionModel;
import cerent.cms.model.IHoPathDefModel;
import cerent.cms.model.ILinkModel;
import cerent.cms.model.ILmpCtrlChannelModel;
import cerent.cms.model.ILoConnectionModel;
import cerent.cms.model.ILoDefModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IOnePlusOneModel;
import cerent.cms.model.IOspfAdv;
import cerent.cms.model.IOspfLSA;
import cerent.cms.model.IPortModel;
import cerent.cms.model.IServerTrailEnd;
import cerent.cms.model.IServerTrailLinkId;
import cerent.cms.model.IServerTrailsManager;
import cerent.cms.model.ITdmPortModel;
import cerent.cms.model.ITdmProtocolType;
import cerent.cms.model.IVirtualLinkModel;
import cerent.cms.model.LinkModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NetworkModel;
import cerent.cms.model.NodeModel;
import cerent.cms.model.ObjDuplicate;
import cerent.cms.model.OchPortsHelper;
import cerent.cms.model.ServerTrailLinkId;
import cerent.cms.model.TdmProtocolType;
import cerent.cms.model.User;
import cerent.cms.ncp.DNode;
import cerent.cms.ncp.NetCircuitSplicer;
import cerent.cms.ncp.NetCircuitWatchDog;
import cerent.cms.ncp.RollManager;
import cerent.cms.ncp.SanityCheckFailed;
import cerent.cms.ocm.OhCircuitWatchDog;
import cerent.cms.route.AutoRouteRequestor;
import cerent.cms.route.GenericSrg;
import cerent.cms.route.PathSegment;
import cerent.cms.route.RoutePrefs;
import cerent.cms.topo.AbstractNetLink;
import cerent.cms.topo.AbstractNodeIpPartitioner;
import cerent.cms.topo.CompositeNetLink;
import cerent.cms.topo.DwdmNetLink;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.INetServerTrailManager;
import cerent.cms.topo.INetwork;
import cerent.cms.topo.IPartitioner;
import cerent.cms.topo.ITopology;
import cerent.cms.topo.InvalidTopoOperation;
import cerent.cms.topo.LinkComparator;
import cerent.cms.topo.LmpDataLinkNetLink;
import cerent.cms.topo.LmpNetLinkManager;
import cerent.cms.topo.NetElement;
import cerent.cms.topo.NetElementDeletionException;
import cerent.cms.topo.NetLink;
import cerent.cms.topo.NetLinkComparatorKey;
import cerent.cms.topo.NetLinkFactory;
import cerent.cms.topo.NetLinkManager;
import cerent.cms.topo.NetServerTrailManager;
import cerent.cms.topo.OchTrailTunnelNetLink;
import cerent.cms.topo.PhantomLinkException;
import cerent.cms.topo.ServerTrailLink;
import cerent.cms.topo.Topology;
import cerent.cms.topo.TopologyAgent;
import cerent.cms.topo.UnknownNetLink;
import cerent.cms.topo.VirtualNetLink;
import cerent.cms.vlan.VlanSetManager;
import cerent.util.HoLoComparator;
import cerent.util.IDebugDiag;
import cerent.util.IHoNum;
import cerent.util.IIPAddressTranslator;
import cerent.util.ILoNum;
import cerent.util.IObservable;
import cerent.util.IObserver;
import cerent.util.IPAddressTranslator;
import cerent.util.Preferences;
import cerent.util.SDebug;
import cerent.util.SonetLoNum;
import cerent.util.UObservable;
import cerent.util.proxy.CtcProxyFactory;
import cerent.util.proxy.IInetAddressTranslator;
import cerent.util.threadpool.IActionClient;
import cerent.util.threadpool.IThreadWorker;
import cerent.util.threadpool.ThreadPool;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.AbstractSequentialList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.TreeMap;

public class Network
extends CmsObservable
implements INetwork,
IObserver,
IInetAddressTranslator,
IPartitioner {
    private static final HoLoComparator holoComp = HoLoComparator.instance();
    private Map allNetLinks;
    private Map netElems;
    private Map netElemsByIp;
    private Map waitQ;
    private Map svTrailLinks;
    private Object masterTrailLock;
    private int nextId;
    protected static Network network;
    private Map topologies;
    private List topoNEs;
    private List redundantLinks;
    private List limitedNodes = null;
    private int nextTopoId = 1;
    protected static String errString;
    private NetElementCreationNotifier netElementCreationNotifier;
    private NetLinkCreationNotifier netLinkCreationNotifier;
    private TopologyCreationNotifier topologyCreationNotifier;
    private boolean active = false;
    private List topologyUpdateQueue;
    private NetworkActionClient networkActionClient = null;
    private static final IIPAddressTranslator trans;
    private boolean enableCircuitDiscovery = false;
    private boolean excludeDynamicNodes = false;
    private static boolean addNetEleCompleted;
    private INetServerTrailManager netSvMgr = null;
    private IPartitioner partitioner;
    private List linkList = new LinkedList();
    private Map neMap = Collections.synchronizedMap(new TreeMap());
    protected NetworkDebug db = new NetworkDebug();

    public static synchronized Network instance() {
        if (network == null) {
            network = new Network();
            AbstractNodeIpPartitioner.initBuiltInPartitionerIfConfigured(network);
        }
        return network;
    }

    private Network() {
        this.allNetLinks = Collections.synchronizedMap(new TreeMap(new LinkComparator()));
        this.netElems = Collections.synchronizedMap(new TreeMap());
        this.netElemsByIp = Collections.synchronizedMap(new TreeMap(String.CASE_INSENSITIVE_ORDER));
        this.topologies = Collections.synchronizedMap(new HashMap());
        this.topoNEs = Collections.synchronizedList(new LinkedList());
        this.waitQ = Collections.synchronizedMap(new HashMap());
        this.svTrailLinks = Collections.synchronizedMap(new TreeMap(new TrailIdComparator()));
        this.masterTrailLock = new Object();
        this.redundantLinks = Collections.synchronizedList(new LinkedList());
        this.topologyUpdateQueue = Collections.synchronizedList(new LinkedList());
        this.netElementCreationNotifier = new NetElementCreationNotifier();
        this.netLinkCreationNotifier = new NetLinkCreationNotifier();
        this.topologyCreationNotifier = new TopologyCreationNotifier();
        this.networkActionClient = new NetworkActionClient();
        Topology topology = new Topology(this, 0, false);
        this.topologies.put(new Integer(0), topology);
        this.getTopologyCreationNotifier().changed(topology);
        this.netElementCreationNotifier.addObserver(NetCircuitWatchDog.instance());
        this.netLinkCreationNotifier.addObserver(NetCircuitSplicer.instance());
        this.netLinkCreationNotifier.addObserver(VlanSetManager.instance());
        this.netElementCreationNotifier.addObserver(VlanSetManager.instance());
        this.netElementCreationNotifier.addObserver(OhCircuitWatchDog.instance());
        this.netLinkCreationNotifier.addObserver(OhCircuitWatchDog.instance());
        this.netElementCreationNotifier.addObserver(RollManager.instance());
        this.active = true;
        CtcProxyFactory.registerAddressTranslator((IInetAddressTranslator)this);
        this.netSvMgr = NetServerTrailManager.instance();
    }

    protected void queueTopologyUpdateEvent(Topology topology) {
        if (this.db.on()) {
            this.db.println("queueTopologyUpdateEvent: for Topo " + topology.getTopoId());
        }
        this.topologyUpdateQueue.add(topology);
        ThreadPool.instance().enqueueClient((IActionClient)this.networkActionClient);
    }

    protected void queueNetworkUpdateEvent() {
        ThreadPool.instance().enqueueClient((IActionClient)this.networkActionClient);
    }

    private void cleanupOrphanedLinks() {
        for (INetLink iNetLink : this.getNetLinks()) {
            if (iNetLink.getLinkModel().linkType() == 7 || iNetLink.getLinkModel().linkType() == 2 || iNetLink.getLinkModel().linkType() == 3 || iNetLink.getLinkModel().linkType() == 9 || iNetLink.getLinkModel().linkType() == 8 || this.topologies.containsKey(new Integer(iNetLink.getTopoId()))) continue;
            this.db.println("cleanupOrphanedLinks: removing orphaned NL " + iNetLink.prettyStringDetail());
            iNetLink.dispose();
        }
    }

    public void addNetElementCreationObserver(IObserver iObserver) {
        this.netElementCreationNotifier.addObserver(iObserver);
    }

    @Override
    public void setExcludeDyn(boolean bl) {
        if (bl) {
            this.excludeDynamicNodes = true;
            this.limitedNodes = Collections.synchronizedList(new LinkedList());
        } else {
            this.excludeDynamicNodes = false;
            this.limitedNodes = null;
        }
        if (this.db.on()) {
            this.db.println("Exclude dynamically discovered nodes=" + bl);
        }
    }

    @Override
    public void setEnableCircuitDiscovery(boolean bl) {
        if (!this.enableCircuitDiscovery) {
            if (this.db.on()) {
                this.db.println("Enabling Circuit Discovery from " + this.enableCircuitDiscovery + " -> " + bl);
            }
            this.enableCircuitDiscovery = bl;
        }
    }

    @Override
    public boolean getEnableCircuitDiscovery() {
        return this.enableCircuitDiscovery;
    }

    private void handleCTPChange(IServerTrailsManager iServerTrailsManager) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean putSvLink(INetLink iNetLink) {
        INetLink iNetLink2 = null;
        Object object = this.masterTrailLock;
        synchronized (object) {
            IServerTrailLinkId iServerTrailLinkId = ((ServerTrailLink)iNetLink).getPrefs().getTrailId();
            iNetLink2 = this.findSvLink(iServerTrailLinkId);
            if (iNetLink2 == null) {
                ServerTrailLinkId serverTrailLinkId = new ServerTrailLinkId(iServerTrailLinkId.getNodeId(), iServerTrailLinkId.getUniqueId());
                this.svTrailLinks.put(serverTrailLinkId, iNetLink);
                return true;
            }
        }
        return false;
    }

    @Override
    public INetElement findNetElemByIp(String string) {
        INetElement iNetElement;
        block7: {
            iNetElement = null;
            try {
                InetAddress inetAddress;
                InetAddress inetAddress2 = InetAddress.getByName(string);
                IIPAddressTranslator iIPAddressTranslator = IPAddressTranslator.instance();
                InetAddress inetAddress3 = iIPAddressTranslator.isVirtual(inetAddress2) ? inetAddress2 : iIPAddressTranslator.findVirtualAddress(inetAddress2);
                String string2 = inetAddress3 == null ? string : inetAddress3.getHostAddress();
                iNetElement = (INetElement)this.netElemsByIp.get(string2);
                if (iNetElement == null && (inetAddress = InetAddress.getByName(string2)).getAddress().length > 4) {
                    InetAddress inetAddress4 = iIPAddressTranslator.findVirtualAddressForIPv6(inetAddress);
                    int n = IPAddressTranslator.instance().getActualNodeId(inetAddress4);
                    iNetElement = this.findNetElem(n);
                    if (iNetElement != null) {
                        if (this.db.on()) {
                            this.db.println("findNetElemByIp: found NE" + iNetElement.getHostName() + "for virtual ip" + string2);
                        }
                    } else if (this.db.on()) {
                        this.db.println("findNetElemByIp: couldnt find NE for => " + string2);
                        this.db.println("virtualAddress in map => " + inetAddress4 + "nodeId =>" + n);
                    }
                }
            }
            catch (UnknownHostException unknownHostException) {
                if (!this.db.on()) break block7;
                this.db.println("findNetElemByIp: caught UnknownHostException " + unknownHostException.getMessage());
                NetworkDebug.printStackTrace((Throwable)unknownHostException);
            }
        }
        return iNetElement;
    }

    protected void updateIPAddress(NetElement netElement, String string) {
        if (!this.netElemsByIp.containsKey(netElement.getHostName())) {
            if (this.db.on()) {
                this.db.println("updateIPAddress: IP address of NE has changed from " + this.getActualIpAddress(string) + " to " + netElement.getActualAddressDisplay());
            }
            this.netElemsByIp.remove(string);
            this.addNetElementToIPMap(netElement.getHostName(), netElement);
        }
    }

    protected void updateSecureIPAddress(NetElement netElement, String string) {
        String string2;
        block6: {
            NetElement netElement2;
            string2 = netElement.getSecureIPAddress();
            if (this.netElemsByIp.containsKey(string2) && (netElement2 = (NetElement)this.netElemsByIp.get(string2)) != netElement && netElement2 != null) {
                if (this.db.on()) {
                    this.db.println("WARNING !! another NE found with secure ip of a secure mode noderemoving the same");
                    this.db.println("updateSecureIpAddress: Duplicate NEs detected => ");
                    this.db.println("updateSecureIpAddress:    Existing NE => ");
                    this.db.println("updateSecureIpAddress:        Public IP => " + netElement2.getActualAddressDisplay());
                    this.db.println("updateSecureIpAddress:        Secure IP => " + this.getActualIpAddress(netElement2.getSecureIPAddress()));
                    this.db.println("updateSecureIpAddress:    New NE => ");
                    this.db.println("updateSecureIpAddress:        Public IP => " + netElement.getActualAddressDisplay());
                    this.db.println("updateSecureIpAddress:        Secure IP => " + this.getActualIpAddress(netElement.getSecureIPAddress()));
                }
                try {
                    this.deleteNetElement(netElement2);
                }
                catch (NetElementDeletionException netElementDeletionException) {
                    if (!this.db.on()) break block6;
                    this.db.println("Error !! could not delete existing ne in updateSecureIPAddress");
                }
            }
        }
        if (this.db.on()) {
            this.db.println("updateSecureIPAddress: IP address of NE has changed from " + this.getActualIpAddress(string) + " to " + this.getActualIpAddress(string2));
        }
        this.addNetElementToIPMap(string2, netElement);
        if (!string2.equals(string)) {
            this.netElemsByIp.remove(string);
        }
    }

    protected void updateNodeId(NetElement netElement) {
        if (this.db.on()) {
            this.db.println("updateNodeId: Node ID of NE has changed from " + Integer.toHexString(netElement.getOldNodeId()) + " to " + Integer.toHexString(netElement.getNodeId()));
        }
        if (netElement == null) {
            if (this.db.on()) {
                this.db.println("NE is null in updateNodeId .. returning");
            }
            return;
        }
        if (this.netElems.remove(new Integer(netElement.getOldNodeId())) != null) {
            this.netElems.put(new Integer(netElement.getNodeId()), netElement);
        } else if (this.db.on) {
            this.db.println("ERROR !! In updateNodeId , netElement host " + netElement.getActualAddressDisplay() + " nodeId " + Integer.toHexString(netElement.getNodeId()) + " is not in the network !!!");
        }
    }

    @Override
    public synchronized INetElement addNetElement(String string, String string2, String string3) throws UnknownHostException, AbstractCmsIOException {
        return this.addNetElement(string, string2, string3, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized INetElement addNetElement(String string, String string2, String string3, INetElement iNetElement) throws UnknownHostException, AbstractCmsIOException {
        if (this.db.on()) {
            this.db.println("addNetElement: adding NE " + this.getActualIpAddress(string) + " to network");
        }
        INetElement iNetElement2 = null;
        addNetEleCompleted = false;
        try {
            InetAddress inetAddress = null;
            InetAddress inetAddress2 = InetAddress.getByName(string);
            inetAddress = IPAddressTranslator.instance().findVirtualAddress(inetAddress2);
            if (inetAddress == null) {
                inetAddress = IPAddressTranslator.instance().getVirtualAddress(string, 0);
            }
            String string4 = inetAddress.getHostAddress();
            if (this.limitedNodes != null) {
                this.limitedNodes.add(string4);
                if (this.db.on()) {
                    this.db.println("addNetElement: added NE " + this.getActualIpAddress(string4) + " to limited Nodes list");
                }
            }
            if ((iNetElement2 = this.findNetElemByIp(string4)) != null) {
                if (this.db.on()) {
                    this.db.println("addNetElement: found existing NE using IP");
                }
                INodeModel iNodeModel = iNetElement2.getNodeModel();
                ((NodeModel)iNodeModel).setUserName(string2);
                ((NodeModel)iNodeModel).setUserPassword(string3);
                INetElement iNetElement3 = iNetElement2;
                return iNetElement3;
            }
            if (this.db.on()) {
                this.db.println("addNetElement: NE is unique based on IP");
            }
            NodeModel nodeModel = new NodeModel(string4, 0, string2, string3, this.getDefaultName());
            if (iNetElement != null) {
                nodeModel.setPeerNe(iNetElement.getNodeModel());
            }
            Topology topology = iNetElement == null ? this.getDefaultTopo() : iNetElement.getTopology();
            iNetElement2 = new NetElement(nodeModel, topology, topology.getTopoId());
            iNetElement2 = this.addNetElement(iNetElement2);
            this.getNetElementCreationNotifier().changed((NetElement)iNetElement2);
            if (this.isNodeModelEnabledByDefault()) {
                nodeModel.setEnabled(true);
            }
        }
        finally {
            addNetEleCompleted = true;
        }
        return iNetElement2;
    }

    public boolean isAddingNetEleCompleted() {
        return addNetEleCompleted;
    }

    @Override
    public void deleteNetElement(INetElement iNetElement) throws NetElementDeletionException {
        if (!this.canDeleteNetElement(iNetElement)) {
            throw new NetElementDeletionException("The network element " + iNetElement.getName() + " cannot " + "be deleted.");
        }
        if (this.limitedNodes != null) {
            String string = iNetElement.getNodeModel().getHostName();
            if (string != null) {
                this.limitedNodes.remove(string);
            }
            if (this.db.on()) {
                this.db.println("deleteNetElement: removed NE " + this.getActualIpAddress(string) + " from limited Nodes list");
            }
        }
        if (this.db.on) {
            this.db.println("Calling ne.destroy from deleteNetElement");
        }
        iNetElement.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canDeleteNetElement(INetElement iNetElement) {
        if (this.db.on) {
            this.db.println("Entering canDeleteNetElement");
        }
        Network network = this;
        synchronized (network) {
            if (iNetElement == null) {
                if (this.db.on()) {
                    this.db.println("deleteNetElement: ne = null");
                }
                return false;
            }
            if (this.getNetElem(iNetElement) == null) {
                if (this.db.on()) {
                    this.db.println("deleteNetElement: NE " + iNetElement.getName() + " is unknown");
                }
                return false;
            }
            if (this.findAllNetLinksWithNetElem(iNetElement).size() != 0) {
                if (this.db.on) {
                    this.db.println("Cannot delete NetElement because there are links " + this.findAllNetLinksWithNetElem(iNetElement).size());
                }
                return false;
            }
        }
        if (this.db.on) {
            this.db.println("Returning true from canDeleteNetElement");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteNetElementAndBlock(INetElement iNetElement) throws NetElementDeletionException, AbstractCmsIOException {
        NetElemObserver netElemObserver;
        block17: {
            if (iNetElement == null) {
                if (this.db.on()) {
                    this.db.println("blockedDeleteNetElement: ne = null");
                }
                return;
            }
            if (this.getNetElem(iNetElement) == null) {
                if (this.db.on()) {
                    this.db.println("blockedDeleteNetElement: NE " + iNetElement.getName() + " is unknown");
                }
                return;
            }
            if (this.db.on()) {
                this.db.println("blockedDeleteNetElement: deleting NE " + iNetElement.getName());
            }
            if (this.findAllNetLinksWithNetElem(iNetElement).size() == 0) {
                netElemObserver = new NetElemObserver();
                ((NetElement)iNetElement).addObserver(netElemObserver);
                try {
                    iNetElement.destroy();
                }
                catch (AbstractCmsIOException abstractCmsIOException) {
                    ((NetElement)iNetElement).deleteObserver(netElemObserver);
                    netElemObserver = null;
                    this.db.println("deleteNetElementAndBlock: unable to delete NE due to exception => " + (Object)((Object)abstractCmsIOException));
                    throw abstractCmsIOException;
                }
                while (true) {
                    try {
                        NetElemObserver netElemObserver2 = netElemObserver;
                        synchronized (netElemObserver2) {
                            if (!netElemObserver.isDeleted()) {
                                if (this.db.on()) {
                                    this.db.println("deleteNetElementAndBlock: waiting for deleted event");
                                }
                                netElemObserver.wait();
                                if (this.db.on()) {
                                    this.db.println("deleteNetElementAndBlock: finished waiting");
                                }
                            }
                            break block17;
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        if (!this.db.on()) continue;
                        this.db.println("deleteNetElementAndBlock: caught " + interruptedException);
                        continue;
                    }
                    break;
                }
            }
            throw new NetElementDeletionException("The network element " + iNetElement.getName() + " cannot " + "be deleted because it is " + "connected to one or more " + "network elements.");
        }
        ((NetElement)iNetElement).deleteObserver(netElemObserver);
        netElemObserver = null;
    }

    @Override
    public void deleteNetElementAndConnectedNetLinks(INetElement iNetElement) {
        Iterator iterator = this.findAllNetLinksWithNetElem(iNetElement).iterator();
        if (this.db.on()) {
            this.db.println("deleteNetElementAndConnectedNetLinks: deleting NE " + iNetElement.getActualAddressDisplay());
        }
        iNetElement.destroy();
        while (iterator.hasNext()) {
            INetLink iNetLink = (INetLink)iterator.next();
            if (this.db.on()) {
                this.db.println("deleteNetElementAndConnectedNetLinks: deleting NL " + iNetLink.prettyString());
            }
            iNetLink.dispose();
            INetLink iNetLink2 = this.findReverseLink(iNetLink);
            if (iNetLink2 == null) continue;
            iNetLink2.dispose();
            if (!this.db.on()) continue;
            this.db.println("deleteNetElementAndConnectedNetLinks: deleting NL " + iNetLink2.prettyString());
        }
    }

    @Override
    public synchronized ITopology createTopology(INetElement iNetElement) {
        NetElement netElement = null;
        Topology topology = null;
        if (iNetElement == null) {
            if (this.db.on()) {
                this.db.println("createTopology: ne is null");
            }
            return null;
        }
        if (this.db.on()) {
            this.db.println("createTopology: called for NE " + iNetElement.getActualAddressDisplay());
        }
        if ((netElement = (NetElement)this.findNetElem(iNetElement)) != null) {
            if (this.db.on()) {
                this.db.println("createTopology: found NE " + netElement.getActualAddressDisplay() + " in inited list");
            }
            if (netElement.getTopoId() != 0) {
                if (this.db.on()) {
                    this.db.println("createTopology: NE already assigned to topo " + netElement.getTopoId() + ", returning existing" + " topo");
                }
                return netElement.getTopology();
            }
            topology = this.createNewTopology(netElement, false);
            if (topology != null) {
                this.getTopologyCreationNotifier().changed(topology);
            }
            return topology;
        }
        netElement = (NetElement)this.getNetElem(iNetElement.getHostName());
        if (netElement != null) {
            if (this.db.on()) {
                this.db.println("createTopology: found NE " + netElement.getActualAddressDisplay() + " in waitQ");
            }
            if (netElement.getTopoId() != 0) {
                if (this.db.on()) {
                    this.db.println("createTopology: NE already assigned to topo " + netElement.getTopoId() + ", returning existing topo");
                }
                return netElement.getTopology();
            }
            topology = this.createNewTopology(null, false);
            this.getTopologyCreationNotifier().changed(topology);
            netElement.setTopology(topology, topology.getTopoId());
            this.topoNEs.add(netElement);
            return topology;
        }
        if (this.db.on()) {
            this.db.println("createTopology: NE " + iNetElement.getActualAddressDisplay() + " is unknown, returning null Topology");
        }
        return null;
    }

    public void createTopology(LinkedList linkedList) {
        while (!linkedList.isEmpty()) {
            ITopology iTopology;
            block6: {
                INetElement iNetElement = (INetElement)linkedList.removeFirst();
                iTopology = null;
                if (iNetElement instanceof NetElement) {
                    if (this.db.on()) {
                        this.db.println("createTopology: trying NE " + iNetElement.getActualAddressDisplay());
                    }
                    iTopology = this.createTopology(iNetElement);
                    if (this.db.on()) {
                        this.db.println("createTopology: sleeping for 30 sec");
                    }
                    try {
                        Thread.sleep(30000L);
                    }
                    catch (InterruptedException interruptedException) {
                        if (!this.db.on()) break block6;
                        this.db.println("createTopology: caught interruptedException");
                    }
                }
            }
            if (iTopology == null) continue;
            linkedList.removeAll(iTopology.getTopoElems());
        }
    }

    protected Topology createNewTopology(NetElement netElement, boolean bl) {
        Topology topology = null;
        if (netElement != null) {
            try {
                topology = new Topology(this, netElement, this.nextTopoId);
            }
            catch (InvalidTopoOperation invalidTopoOperation) {
                this.db.println("createNewTopology: caught unexpected exception => " + invalidTopoOperation.getMessage());
                NetworkDebug.printStackTrace((Throwable)((Object)invalidTopoOperation));
                return topology;
            }
        } else {
            topology = new Topology(this, this.nextTopoId, bl);
        }
        if (this.db.on()) {
            this.db.println("createNewTopology: created new Topology " + this.nextTopoId);
        }
        this.topologies.put(new Integer(this.nextTopoId), topology);
        ++this.nextTopoId;
        return topology;
    }

    @Override
    public void deleteTopology(INetElement iNetElement) {
        Topology topology = iNetElement.getTopology();
        topology.destroy(true);
    }

    @Override
    public void deleteTopology(ITopology iTopology) {
        ((Topology)iTopology).destroy(true);
    }

    private INetElement addNetElement(INetElement iNetElement) {
        int n = iNetElement.getNodeId();
        String string = iNetElement.getHostName();
        if (n == -1 || n == 0) {
            NetElement netElement = null;
            netElement = (NetElement)this.waitQ.get(string);
            if (netElement == null) {
                this.waitQ.put(string, iNetElement);
                if (!this.netElemsByIp.containsKey(string)) {
                    this.addNetElementToIPMap(string, iNetElement);
                    if (this.db.on()) {
                        this.db.println("addNetElement: added NE with IP " + iNetElement.getActualAddressDisplay() + " to netElemsByIp map");
                    }
                }
                if (iNetElement.hasSecureIPAddress() && !this.netElemsByIp.containsKey(iNetElement.getSecureIPAddress())) {
                    this.addNetElementToIPMap(iNetElement.getSecureIPAddress(), iNetElement);
                    if (this.db.on()) {
                        this.db.println("addNetElement: added NE with secure IP" + this.getActualIpAddress(iNetElement.getSecureIPAddress()) + " to netElemsByIp map");
                    }
                }
                ((NetElement)iNetElement).addObserver(this);
                if (iNetElement.getNodeId() != -1 && iNetElement.getNodeId() != 0) {
                    if (this.db.on()) {
                        this.db.println("addNetElement: NE " + this.getActualIpAddress(string) + " now has valid Node ID, adding to inited map");
                    }
                    this.waitQ.remove(string);
                    ((NetElement)iNetElement).deleteObserver(this);
                    return this.putNetElement(iNetElement);
                }
                if (this.db.on()) {
                    this.db.println("addNetElement: " + this.getActualIpAddress(string) + " added to waitQ");
                }
                return iNetElement;
            }
            if (this.db.on()) {
                this.db.println("addNetElement: " + this.getActualIpAddress(string) + " found in waitQ");
            }
            return netElement;
        }
        if (this.db.on()) {
            this.db.println("addNetElement: for " + Integer.toHexString(iNetElement.getNodeId()) + "/" + this.getActualIpAddress(string));
        }
        return this.putNetElement(iNetElement);
    }

    protected synchronized INetElement addNetElement(String string, int n, Topology topology, boolean bl, int n2) throws AbstractCmsIOException {
        Object object;
        Object object2;
        InetAddress inetAddress;
        boolean bl2 = false;
        try {
            inetAddress = IPAddressTranslator.instance().findVirtualAddress(n);
            if (inetAddress == null) {
                inetAddress = IPAddressTranslator.instance().getVirtualAddress(string, n);
            } else {
                object2 = InetAddress.getByName(string);
                object = IPAddressTranslator.instance().getSecureAddress(inetAddress);
                InetAddress inetAddress2 = IPAddressTranslator.instance().getPublicAddress(inetAddress);
                if (object == null || inetAddress2 == null) {
                    return null;
                }
                if (((InetAddress)object).equals(inetAddress2)) {
                    bl2 |= IPAddressTranslator.instance().updateSecureIpAddress(inetAddress.getHostAddress(), string);
                }
                bl2 |= IPAddressTranslator.instance().updatePublicIpAddress(inetAddress.getHostAddress(), string);
            }
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
        String string2 = inetAddress.getHostAddress();
        if (this.db.on()) {
            this.db.println("addNetElement: Topo " + topology.getTopoId() + " is " + "attempting to add NE " + this.getActualIpAddress(string2));
        }
        if (!bl && this.filterNode(string2)) {
            if (this.db.on()) {
                this.db.println("addNetElement: dynamically discovered NE ignored");
            }
            return null;
        }
        INetElement iNetElement = (NetElement)this.findNetElem(n);
        if (iNetElement != null) {
            if (!iNetElement.getHostName().equals(string2)) {
                block29: {
                    object2 = iNetElement.getHostName();
                    try {
                        ((NetElement)iNetElement).setHostName(string2);
                    }
                    catch (UnknownHostException unknownHostException) {
                        if (!this.db.on()) break block29;
                        this.db.println("addNetElement: caught unexpected exception, e = " + unknownHostException);
                    }
                }
                if (this.db.on()) {
                    this.db.println("addNetElement: oldIP = " + this.getActualIpAddress((String)object2) + ", ne.getHostName() = " + iNetElement.getActualAddressDisplay() + ", ne.hasSecureIPAddress() = " + iNetElement.hasSecureIPAddress() + ", ne.getSecureIPAddress() = " + this.getActualIpAddress(iNetElement.getSecureIPAddress()));
                }
                object = iNetElement.getNodeModel();
                if (iNetElement.hasSecureIPAddress() && iNetElement.getSecureIPAddress().equals(object2) && object != null && object.isSecureMode()) {
                    if (this.db.on()) {
                        this.db.println("addNetElement: changing IP address from secure to public");
                    }
                    this.addNetElementToIPMap(iNetElement.getHostName(), iNetElement);
                } else {
                    if (this.db.on()) {
                        this.db.println("addNetElement: IP address has changed");
                    }
                    this.updateIPAddress((NetElement)iNetElement, (String)object2);
                }
            }
            if (this.db.on()) {
                this.db.println("addNetElement: returning NE in inited list");
            }
            if (bl2) {
                this.reinitializeNe(iNetElement);
            }
            LmpNetLinkManager.instance().addNewNE(iNetElement);
            return iNetElement;
        }
        iNetElement = (INetElement)this.waitQ.remove(string2);
        if (iNetElement != null) {
            iNetElement.setNodeId(n);
            iNetElement.deleteObserver(this);
            if (this.topoNEs.remove(iNetElement)) {
                if (this.db.on()) {
                    this.db.println("addNetElement: NE " + iNetElement.getActualAddressDisplay() + " is a topo host, initing topo " + iNetElement.getTopoId());
                }
                object2 = iNetElement.getTopology();
                ((Topology)object2).initialize((NetElement)iNetElement);
            }
            this.addNetElement(iNetElement);
            if (this.db.on()) {
                this.db.println("addNetElement: returning NE found in waitQ");
            }
            if (bl2) {
                this.reinitializeNe(iNetElement);
            }
            return iNetElement;
        }
        iNetElement = this.findNetElemByIp(string2);
        if (iNetElement != null) {
            if (this.db.on()) {
                this.db.println("addNetElement: WARNING returning NE found in netElemsByIP map");
            }
            if (bl2) {
                this.reinitializeNe(iNetElement);
            }
            return iNetElement;
        }
        if (this.db.on()) {
            this.db.println("addNetElement: NE " + this.getActualIpAddress(string2) + " is unique");
        }
        object = NetworkModel.instance().getUser();
        NodeModel nodeModel = new NodeModel(string2, n, ((User)object).getName(), ((User)object).getPassword(), this.getDefaultName());
        iNetElement = new NetElement(nodeModel, topology, topology.getTopoId());
        iNetElement = this.addNetElement(iNetElement);
        this.getNetElementCreationNotifier().changed(iNetElement);
        return iNetElement;
    }

    protected boolean isNodeModelEnabledByDefault() {
        return Preferences.instance().getBoolean("ctc", "node.enabled", true);
    }

    public boolean filterNode(String string) {
        return this.limitedNodes != null && !this.limitedNodes.contains(string);
    }

    public synchronized void update(IObservable iObservable, Object object) {
        if (iObservable instanceof NetElement) {
            NetElement netElement;
            block18: {
                netElement = (NetElement)iObservable;
                if (object == ModelUpdateType.DELETED) {
                    if (this.db.on()) {
                        this.db.println("update: received DELETED event for NE " + netElement.getActualAddressDisplay());
                    }
                    this.delete(netElement);
                    netElement.deleteObserver(this);
                    return;
                }
                if (this.db.on()) {
                    this.db.println("update: event for NE " + netElement.getActualAddressDisplay());
                }
                if (this.db.on()) {
                    this.db.dumpWaitQ();
                }
                if (netElement.getNodeId() == 0 || netElement.getNodeId() == -1) {
                    if (this.db.on()) {
                        this.db.println("update: NE still has invalid Node ID, ignoring update event");
                    }
                    return;
                }
                if (this.waitQ.remove(netElement.getHostName()) != null) {
                    if (this.db.on()) {
                        this.db.println("update: NE found in waitQ");
                    }
                    int n = netElement.getNodeId();
                    if (this.db.on()) {
                        this.db.println("update: NE nodeId = " + n);
                    }
                    netElement.deleteObserver(this);
                    if (this.db.on()) {
                        this.db.println("update: removed Network from NE " + netElement.getActualAddressDisplay() + " observer list");
                    }
                    this.addNetElement(netElement);
                    if (netElement.getTopoId() == 0) {
                        try {
                            Topology topology = (Topology)this.topologies.get(new Integer(0));
                            if (topology != null) {
                                topology.addNetElement(netElement);
                            }
                            break block18;
                        }
                        catch (InvalidTopoOperation invalidTopoOperation) {
                            if (this.db.on()) {
                                this.db.println("update: " + (Object)((Object)invalidTopoOperation));
                            }
                            break block18;
                        }
                    }
                    if (this.topoNEs.remove(netElement)) {
                        if (this.db.on()) {
                            this.db.println("update: NE " + netElement.getName() + " is a topo host, init topo");
                        }
                        Topology topology = netElement.getTopology();
                        topology.initialize(netElement);
                    }
                }
            }
            netElement.deleteObserver(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prettyPrint(SDebug sDebug) {
        int n = 0;
        sDebug.println("Active => " + this.active);
        Object object2 = this.netElems;
        synchronized (object2) {
            Iterator<Object> iterator = this.netElems.values().iterator();
            sDebug.println("Network Element(s) :");
            while (iterator.hasNext()) {
                INetElement iNetElement = (INetElement)iterator.next();
                sDebug.println("  NE #" + ++n + " : " + iNetElement.prettyString() + " => " + iNetElement.getActualAddressDisplay());
            }
        }
        sDebug.println("Network Link(s) :");
        n = 0;
        object2 = this.allNetLinks;
        synchronized (object2) {
            for (INetLink iNetLink : this.allNetLinks.values()) {
                sDebug.print("  Link #" + ++n + " : ");
                sDebug.println(iNetLink.prettyStringDetail());
            }
        }
        sDebug.println("");
        sDebug.println("Next Topo ID = " + this.nextTopoId);
        sDebug.println("");
        sDebug.println("Printing Topology Aggregation:");
        for (Object object2 : this.getTopologies()) {
            if (((Topology)object2).getTopoId() == 0) {
                sDebug.println("  Topology Id = " + ((Topology)object2).getTopoId() + "    TopoAgent(s) : None ");
            } else {
                sDebug.println("  Topology Id = " + ((Topology)object2).getTopoId());
                sDebug.println("    TopoAgent(s): ");
                for (NetElement netElement : ((Topology)object2).getCurrentTopoHosts()) {
                    sDebug.println("      " + netElement.prettyString());
                }
            }
            sDebug.println("    Network Element(s) :");
            n = 0;
            for (INetElement iNetElement : ((Topology)object2).getTopoElems()) {
                sDebug.println("      NE #" + ++n + " : " + iNetElement.prettyString());
            }
            sDebug.println("    Network Link(s) :");
            n = 0;
            for (INetLink iNetLink : ((Topology)object2).getTopoLinks()) {
                sDebug.print("      Link #" + ++n + " : ");
                sDebug.println(iNetLink.prettyString());
            }
            sDebug.println("");
        }
        sDebug.println("Network partitioner: " + (this.partitioner == null ? "off" : this.partitioner.toString()));
        sDebug.println("");
    }

    public static void prettyPrint(SDebug sDebug, List list) {
        if (!sDebug.on) {
            return;
        }
        Iterator iterator = list.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            PathSegment pathSegment = (PathSegment)iterator.next();
            Iterator iterator2 = pathSegment.getPrimary().iterator();
            sDebug.println("Path Segment #" + ++n + (pathSegment.isProtected() ? "(" : "(un") + "protected)");
            INetLink iNetLink = null;
            sDebug.println("Printing the Primary Path:");
            while (iterator2.hasNext()) {
                iNetLink = (INetLink)iterator2.next();
                sDebug.println(iNetLink.prettyString());
            }
            if (pathSegment.getAlternate().size() == 0) continue;
            iterator2 = pathSegment.getAlternate().iterator();
            iNetLink = null;
            sDebug.println("Printing the Alternate Path:");
            while (iterator2.hasNext()) {
                iNetLink = (INetLink)iterator2.next();
                sDebug.println(iNetLink.prettyString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private INetElement putNetElement(INetElement iNetElement) {
        INetElement iNetElement2 = null;
        Map map = this.netElems;
        synchronized (map) {
            iNetElement2 = this.findNetElem(iNetElement);
            if (iNetElement2 == null) {
                this.netElems.put(new Integer(iNetElement.getNodeId()), iNetElement);
                if (!this.netElemsByIp.containsKey(iNetElement.getHostName())) {
                    this.addNetElementToIPMap(iNetElement.getHostName(), iNetElement);
                    if (this.db.on()) {
                        this.db.println("putNetElement: added NE with IP " + iNetElement.getActualAddressDisplay() + " to netElemsByIp map");
                    }
                }
                if (iNetElement.hasSecureIPAddress() && !this.netElemsByIp.containsKey(iNetElement.getSecureIPAddress())) {
                    this.addNetElementToIPMap(iNetElement.getSecureIPAddress(), iNetElement);
                    if (this.db.on()) {
                        this.db.println("putNetElement: added NE with secure IP " + this.getActualIpAddress(iNetElement.getSecureIPAddress()) + " to netElemsByIp map");
                    }
                }
                if (this.db.on()) {
                    this.db.println("putNetElement: NE " + iNetElement.getActualAddressDisplay() + " added to NE list, list size = " + this.netElemsByIp.size());
                }
            }
        }
        if (iNetElement2 == null) {
            NetServerTrailManager.instance().updateServerTrails(iNetElement);
            LmpNetLinkManager.instance().addNewNE(iNetElement);
            return iNetElement;
        }
        if (iNetElement2 != iNetElement) {
            if (this.db.on()) {
                this.db.println("putNetElement: Duplicate NEs detected => ");
                this.db.println("putNetElement:    Existing NE => ");
                this.db.println("putNetElement:        Public IP => " + iNetElement2.getActualAddressDisplay());
                this.db.println("putNetElement:        Secure IP => " + this.getActualIpAddress(iNetElement2.getSecureIPAddress()));
                this.db.println("putNetElement:    New NE => ");
                this.db.println("putNetElement:        Public IP => " + iNetElement.getActualAddressDisplay());
                this.db.println("putNetElement:        Secure IP => " + this.getActualIpAddress(iNetElement.getSecureIPAddress()));
            }
            boolean bl = false;
            try {
                bl = IPAddressTranslator.instance().updateActualAddress(iNetElement2.getHostName(), iNetElement.getHostName());
            }
            catch (UnknownHostException unknownHostException) {
                this.db.println("putNetElement: caught UnknownHostException " + unknownHostException.getMessage());
            }
            iNetElement.destroy();
            if (bl) {
                this.reinitializeNe(iNetElement2);
            }
            return iNetElement2;
        }
        if (this.db.on()) {
            this.db.println("putNetElement: NE " + iNetElement.getActualAddressDisplay() + " already " + "in list, returning existing NE, list size = " + this.netElems.size());
        }
        return iNetElement2;
    }

    private void addNetElementToIPMap(String string, INetElement iNetElement) {
        if (!string.equals("unknown")) {
            this.netElemsByIp.put(string, iNetElement);
            if (this.db.on()) {
                this.db.println("addNetElementToIPMap: added NE with IP " + this.getActualIpAddress(string) + " to netElemsByIp map," + " size => " + this.netElemsByIp.size());
            }
        }
    }

    private void reinitializeNe(INetElement iNetElement) {
        if (this.db.on()) {
            this.db.println("reinitializeNe: actual ip address changed - reinitializing node " + iNetElement.getActualAddressDisplay());
        }
        INodeModel iNodeModel = iNetElement.getNodeModel();
        ((NodeModel)iNodeModel).reinitNM(this.isNodeModelEnabledByDefault());
    }

    @Override
    public INetElement getNetElem(int n) {
        return this.findNetElem(n);
    }

    public INetElement getNetElem(INetElement iNetElement) {
        return this.getNetElem(iNetElement, iNetElement.getHostName());
    }

    private INetElement getNetElem(String string) {
        if (string != null) {
            INetElement iNetElement;
            if (this.db.on()) {
                this.db.println("getNetElem: looking for NE with IP " + this.getActualIpAddress(string));
            }
            if ((iNetElement = (INetElement)this.waitQ.get(string)) != null) {
                if (this.db.on()) {
                    this.db.println("getNetElem: NE found in waitQ");
                }
                return iNetElement;
            }
        }
        if (this.db.on()) {
            this.db.println("getNetElem: NE not found in waitQ");
        }
        return null;
    }

    public INetElement getNetElem(INetElement iNetElement, String string) {
        INetElement iNetElement2 = null;
        if (iNetElement != null && iNetElement.getNodeModel() != null) {
            if (this.db.on()) {
                this.db.println("getNetElem: looking for NE " + iNetElement.getActualAddressDisplay());
            }
            if ((iNetElement2 = this.findNetElem(iNetElement.getNodeId())) != null) {
                if (this.db.on()) {
                    this.db.println("getNetElem: NE found in initialized list");
                }
                return iNetElement2;
            }
            iNetElement2 = this.getNetElem(iNetElement.getHostName());
            if (iNetElement2 != null) {
                if (this.db.on()) {
                    this.db.println("getNetElem: NE found in waitQ");
                }
                return iNetElement2;
            }
            iNetElement2 = this.getNetElem(string);
            if (iNetElement2 != null) {
                if (this.db.on()) {
                    this.db.println("getNetElem: NE with IP " + this.getActualIpAddress(string) + " found in waitQ");
                }
                return iNetElement2;
            }
        } else {
            return this.getNetElem(string);
        }
        if (this.db.on()) {
            this.db.println("getNetElem: returning NULL NE");
        }
        return null;
    }

    public List getNetElemsWithTdmProtocolType(int n) {
        ArrayList<INetElement> arrayList = new ArrayList<INetElement>();
        for (INetElement iNetElement : this.getElements()) {
            INodeModel iNodeModel = iNetElement.getNodeModel();
            try {
                if (!iNodeModel.isInited() || iNodeModel.getTdmProtocolType() != n) continue;
                arrayList.add(iNetElement);
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                if (!this.db.on()) continue;
                this.db.println("failed to get protocol type for node: " + iNodeModel.getNodeId() + " " + abstractCmsIOException.getMessage());
            }
        }
        return arrayList;
    }

    public TdmProtocolType[] getSupportedTdmProtocolTypes() {
        HashSet<ITdmProtocolType> hashSet = new HashSet<ITdmProtocolType>();
        for (INetElement iNetElement : this.getElements()) {
            INodeModel iNodeModel = iNetElement.getNodeModel();
            hashSet.add(iNodeModel.getTdmProtocolTypeObj());
        }
        return hashSet.toArray(new TdmProtocolType[0]);
    }

    public FramingType[] getSupportedFramingTypes() {
        HashSet<IFramingType> hashSet = new HashSet<IFramingType>();
        Iterator iterator = this.getElements().iterator();
        while (iterator.hasNext()) {
            INodeModel iNodeModel = ((INetElement)iterator.next()).getNodeModel();
            if (!iNodeModel.isInited()) continue;
            int[] nArray = iNodeModel.getSupportedFramingTypes();
            for (int i = 0; i < nArray.length; ++i) {
                hashSet.add(FramingType.getFramingType((int)nArray[i]));
            }
        }
        return hashSet.toArray(new FramingType[0]);
    }

    protected void delete(INetElement iNetElement) {
        if (iNetElement == null) {
            if (this.db.on()) {
                this.db.println("delete: NE is null");
            }
            return;
        }
        if (this.db.on()) {
            this.db.println("delete: disposing of NE " + iNetElement.getActualAddressDisplay());
        }
        int n = IPAddressTranslator.instance().getActualNodeId(iNetElement.getHostName());
        if (this.findNetElemByIp(iNetElement.getHostName()) == iNetElement || this.findNetElem(iNetElement.getNodeId()) == iNetElement) {
            this.netElems.remove(new Integer(n));
            this.netElemsByIp.remove(iNetElement.getHostName());
            this.netElemsByIp.remove(iNetElement.getSecureIPAddress());
            this.waitQ.remove(iNetElement.getHostName());
        } else if (this.db.on()) {
            this.db.println("delete: duplicate NE destroyed, NE not removed from list");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized void createPhantomLink(INetElement iNetElement, INetElement iNetElement2, int n, int n2, int n3, int n4, int n5) throws PhantomLinkException {
        int n6;
        NodeModel nodeModel;
        block27: {
            IEntityModel iEntityModel;
            IEntityModel iEntityModel2;
            block23: {
                ITdmPortModel iTdmPortModel;
                ITdmPortModel iTdmPortModel2;
                block24: {
                    if (this.findNetLinkFromEnt(iNetElement, n) != null || this.findNetLinkFromEnt(iNetElement2, n2) != null) {
                        if (this.db.on()) {
                            this.db.println("createPhantomLink: Phantom link cannot be created as link already exists");
                        }
                        throw new PhantomLinkException("The following phantom link cannot be created because another link with the same source or destination exists. \nsource => " + iNetElement.getHostName() + ", entity index => " + n + "\ndestination => " + iNetElement2.getHostName() + ", entity index => " + n2);
                    }
                    if (!iNetElement.getConnectionState() || !iNetElement2.getConnectionState()) {
                        if (this.db.on()) {
                            this.db.println("createPhantomLink: Src or Dst is not connected");
                        }
                        throw new PhantomLinkException("The phantom link cannot be created because its source or destination network element is not connected.");
                    }
                    nodeModel = (NodeModel)iNetElement.getNodeModel();
                    NodeModel nodeModel2 = (NodeModel)iNetElement2.getNodeModel();
                    iEntityModel2 = null;
                    iEntityModel = null;
                    try {
                        iEntityModel2 = nodeModel.getEntityTable().getEntityModelByIndex(n);
                        iEntityModel = nodeModel2.getEntityTable().getEntityModelByIndex(n2);
                    }
                    catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                        if (this.db.on()) {
                            this.db.println("createPhantomLink: Src or Dst entity index invalid");
                        }
                        throw new PhantomLinkException("The phantom link cannot be created because its source or destination\nentity index is invalid.");
                    }
                    if (!(iEntityModel2 instanceof IPortModel) || !(iEntityModel instanceof IPortModel)) break block23;
                    iTdmPortModel2 = (ITdmPortModel)iEntityModel2;
                    iTdmPortModel = (ITdmPortModel)iEntityModel;
                    if (!iTdmPortModel2.isOptical() || !iTdmPortModel.isOptical()) {
                        if (this.db.on()) {
                            this.db.println("createPhantomLink: src/dst not optical");
                        }
                        throw new PhantomLinkException("The phantom link cannot be created because its source or destination\ncard is not an optical interface.");
                    }
                    if (iTdmPortModel2.getEqType() != iTdmPortModel.getEqType()) {
                        if (this.db.on()) {
                            this.db.println("createPhantomLink: SRC and DST eq. type diff");
                        }
                        throw new PhantomLinkException("The phantom link cannot be created because its source and destination\ninterfaces are not of the same type.");
                    }
                    n6 = iTdmPortModel2.getEqType();
                    if (!iTdmPortModel2.hasOpticalProtection() || !iTdmPortModel.hasOpticalProtection()) break block24;
                    try {
                        block26: {
                            block25: {
                                if (iTdmPortModel2.getElementModel().getType() != 1 || iTdmPortModel.getElementModel().getType() != 1) break block25;
                                IOnePlusOneModel iOnePlusOneModel = (IOnePlusOneModel)iTdmPortModel2.getElementModel();
                                IOnePlusOneModel iOnePlusOneModel2 = (IOnePlusOneModel)iTdmPortModel.getElementModel();
                                if (iOnePlusOneModel.getWorkingEntityIndex() == n && iOnePlusOneModel2.getWorkingEntityIndex() == n2) {
                                    if (this.db.on()) {
                                        this.db.println("createPhantomLink: 1+1 Working port");
                                    }
                                    break block26;
                                } else {
                                    if (this.db.on()) {
                                        this.db.println("createPhantomLink: 1+1 Protect port");
                                    }
                                    throw new PhantomLinkException("The phantom link cannot be created because its source or destination port is a 1+1 protect port.");
                                }
                            }
                            if (this.db.on()) {
                                this.db.println("createPhantomLink: Port(s) has unknown protection type");
                            }
                            throw new PhantomLinkException("The phantom link cannot be created because its source or destination port must be\neither unprotected or the working port of a 1+1 protection group.");
                        }
                        n4 = 1;
                    }
                    catch (AbstractCmsNoSuchElementException abstractCmsNoSuchElementException) {
                        this.db.println("createPhantomLink: caught Exception => ");
                        NetworkDebug.printStackTrace((Throwable)abstractCmsNoSuchElementException);
                        throw new PhantomLinkException("The phantom link cannot be created because of an unexpected exception.");
                    }
                }
                if (iTdmPortModel2.hasOpticalProtection() && !iTdmPortModel.hasOpticalProtection() || !iTdmPortModel2.hasOpticalProtection() && iTdmPortModel.hasOpticalProtection()) {
                    if (this.db.on()) {
                        this.db.println("createPhantomLink: Inconsistent SRC/DST 1+1 configuration");
                    }
                    throw new PhantomLinkException("The 1+1 port provisioning is inconsistent.  The source and destination\nports must both belong to a protection group or bothnot belong to a protection group.");
                }
                break block27;
            }
            if (this.db.on()) {
                this.db.println("createPhantomLink: Invalid src/dst entity index, src model = " + iEntityModel2.getClass().getName() + ", dst model = " + iEntityModel.getClass().getName());
            }
            throw new PhantomLinkException("The phantom link cannot be created because the source or destinationentity index refers to a slot rather than a port.");
        }
        if (this.db.on()) {
            this.db.println("createPhantomLink: creating fwd and rev link models");
        }
        int n7 = nodeModel.getTdmProtocolTypeObj().isSonet() ? 1 : 2;
        LinkModel linkModel = new LinkModel(iNetElement.getNodeModel(), n, null, iNetElement2.getNodeModel(), n2, null, 3, NetLink.getLinkPhysicalType(n6), n7, true, true, -1, -1, n4, "", 0, 0, 1, n5, 0, 0);
        LinkModel linkModel2 = new LinkModel(iNetElement2.getNodeModel(), n2, null, iNetElement.getNodeModel(), n, null, 3, NetLink.getLinkPhysicalType(n6), n7, true, true, -1, -1, n4, "", 0, 0, 1, n5, 0, 0);
        if (this.db.on()) {
            this.db.println("createPhantomLink: creating fwd and rev NL's");
        }
        INetLink iNetLink = this.addNetLink(linkModel, (NetElement)iNetElement, (NetElement)iNetElement2, false, false, ((NetElement)iNetElement).getTopology(), this.redundantLinks);
        INetLink iNetLink2 = this.addNetLink(linkModel2, (NetElement)iNetElement2, (NetElement)iNetElement, false, false, ((NetElement)iNetElement2).getTopology(), this.redundantLinks);
        this.getNetLinkCreationNotifier().changed(iNetLink);
        this.getNetLinkCreationNotifier().changed(iNetLink2);
    }

    @Override
    public synchronized void deletePhantomLink(INetLink iNetLink) throws PhantomLinkException {
        if (iNetLink == null) {
            if (this.db.on()) {
                this.db.println("deletePhantomLink: cannot delete null link");
            }
            return;
        }
        if (iNetLink.getLinkType() != 3) {
            if (this.db.on()) {
                this.db.println("deletePhantomLink: cannot delete non-phantom link " + iNetLink.prettyString());
            }
            throw new PhantomLinkException("The link " + iNetLink.prettyString() + " cannot be deleted because it " + "is not a phantom link.");
        }
        if (iNetLink.isDeleted()) {
            if (this.db.on()) {
                this.db.println("deletePhantomLink: link is already deleted");
            }
            return;
        }
        if (this.db.on()) {
            this.db.println("deletePhantomLink: attempting to delete phantom link " + iNetLink.prettyString());
        }
        INetLink iNetLink2 = this.findReverseLink(iNetLink);
        int n = iNetLink.getTopoId();
        INetElement iNetElement = iNetLink.getSrc();
        INetElement iNetElement2 = iNetLink.getDst();
        iNetLink.dispose();
        if (iNetLink2 != null) {
            iNetLink2.dispose();
        }
    }

    protected void delete(INetLink iNetLink) {
        NetLinkComparatorKey netLinkComparatorKey;
        if (iNetLink == null) {
            if (this.db.on()) {
                this.db.println("delete: cannot delete NULL link");
            }
            return;
        }
        if (this.db.on()) {
            this.db.println("delete: attempting to delete NL " + iNetLink.prettyString());
        }
        if (this.allNetLinks.remove(netLinkComparatorKey = new NetLinkComparatorKey(iNetLink.getLinkModel().linkType(), iNetLink.getSrc(), iNetLink.getDst(), iNetLink.isVirtual() ? 0 : iNetLink.getSrcEntityIndex(), iNetLink.isVirtual() ? 0 : iNetLink.getDstEntityIndex(), iNetLink.getSrcHo(), iNetLink.getDstHo(), iNetLink.isVirtual() ? iNetLink.getSrcLinkId() : -1, iNetLink.isVirtual() ? iNetLink.getDstLinkId() : -1, iNetLink.isSdccLink(), iNetLink.isServerTrail() ? ((ServerTrailLink)iNetLink).getServerTrailId() : null)) == null) {
            if (this.db.on()) {
                this.db.println("delete: NL not found in network, returning");
            }
            return;
        }
        if (this.db.on()) {
            this.db.println("delete: removed NL from links list, list size = " + this.allNetLinks.size());
        }
        iNetLink.getSrc().removeAdjacentLink(iNetLink);
    }

    private void delete(Topology topology) {
        if (topology == null) {
            if (this.db.on()) {
                this.db.println("delete: cannot delete null Topo");
            }
            return;
        }
        if (this.db.on()) {
            this.db.println("delete: deleting Topo " + topology.getTopoId());
        }
        this.topologies.remove(new Integer(topology.getTopoId()));
        topology.destroy(true);
    }

    private void initErrorString(INetElement iNetElement, INetElement iNetElement2, int n, INetLink[] iNetLinkArray) {
        errString = "Unable to find a " + (n == 0 ? "protected " : " ") + "path from " + iNetElement.getName() + " to " + iNetElement2.getName() + "\n";
        if (iNetLinkArray.length != 0) {
            errString = errString + "Following Links are blocked:\n";
        }
        for (int i = 0; i < iNetLinkArray.length; ++i) {
            INetLink iNetLink = iNetLinkArray[i];
            errString = errString + iNetLink.prettyString() + "\n";
        }
    }

    protected void removeTopology(Topology topology) {
        if (this.active) {
            if (this.db.on()) {
                this.db.println("removeTopology: removing Topo " + topology.getTopoId());
            }
            this.topologies.remove(new Integer(topology.getTopoId()));
        } else if (this.db.on()) {
            this.db.println("removeTopology: ignored, as Network is being destroyed");
        }
    }

    public INetElement[] getAvailDropNodes(RoutePrefs routePrefs) {
        if (this.db.on()) {
            this.db.println("getAvailDropNodes: Source: " + routePrefs.getSrc().prettyString() + " Circuit Size: " + routePrefs.getCircuitSize());
        }
        if (this.findNetElem(routePrefs.getSrc()) == null) {
            if (this.db.on()) {
                this.db.println("getAvailDropNodes: Source Not Found");
            }
            return new INetElement[0];
        }
        AutoRouteRequestor autoRouteRequestor = new AutoRouteRequestor(routePrefs);
        return autoRouteRequestor.computeReachableNodes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection getElements() {
        LinkedList<INetElement> linkedList = new LinkedList<INetElement>();
        Map map = this.netElems;
        synchronized (map) {
            for (INetElement iNetElement : this.netElems.values()) {
                linkedList.add(iNetElement);
            }
        }
        map = this.waitQ;
        synchronized (map) {
            linkedList.addAll(this.waitQ.values());
        }
        return linkedList;
    }

    @Override
    public Collection getAllElements() {
        LinkedList linkedList = new LinkedList(this.netElems.values());
        linkedList.addAll(this.waitQ.values());
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getTopologies() {
        LinkedList linkedList = null;
        Map map = this.topologies;
        synchronized (map) {
            linkedList = new LinkedList(this.topologies.values());
        }
        return linkedList;
    }

    public synchronized Map getTopologyMap() {
        return this.topologies;
    }

    @Override
    public void refresh() {
        Object object2;
        for (Object object2 : this.getTopologies()) {
            int n = ((Topology)object2).getTopoId();
            if (((Topology)object2).getTopoId() == 0) continue;
            ((Topology)object2).destroy(false);
            if (!this.db.on()) continue;
            this.db.println("refresh: topo " + n + " destroyed");
        }
        object2 = (LinkedList)this.getElements();
        LinkedList linkedList = (LinkedList)this.getNetLinks();
        Iterator iterator = ((AbstractSequentialList)object2).iterator();
        while (iterator.hasNext()) {
            INetElement iNetElement = (INetElement)iterator.next();
            if (!(iNetElement instanceof NetElement)) continue;
            iNetElement.setTopology(this.getDefaultTopo(), 0);
        }
        this.createTopology((LinkedList)object2);
        for (AbstractNetLink abstractNetLink : linkedList) {
            if (abstractNetLink.getLinkType() != 4) {
                abstractNetLink.setTopology(abstractNetLink.getSrc().getTopology(), abstractNetLink.getSrc().getTopoId());
            }
            this.addNewNetLink(abstractNetLink);
        }
    }

    public boolean isActive() {
        return this.active;
    }

    @Override
    public synchronized void destroy() {
        if (this.db.on()) {
            this.db.println("destroy: destroying network");
        }
        this.active = false;
        for (Topology topology : this.getTopologies()) {
            int n = topology.getTopoId();
            topology.destroy(true);
            if (!this.db.on()) continue;
            this.db.println("destroy: topo " + n + " destroyed");
        }
        super.destroy();
        network = null;
        this.db.dispose();
    }

    public INetElement findNetElem(int n) {
        return (INetElement)this.netElems.get(new Integer(n));
    }

    public IFvNetElement findIFvNetElem(int n) {
        return (IFvNetElement)this.netElems.get(new Integer(n));
    }

    public INetElement findNetElem(INodeModel iNodeModel) {
        INetElement iNetElement = null;
        iNetElement = (INetElement)this.netElems.get(new Integer(iNodeModel.getNodeId()));
        if (iNetElement == null) {
            if (this.db.on()) {
                this.db.println("Could not find node with Id: " + Integer.toHexString(iNodeModel.getNodeId()) + ", will search using ip: " + this.getActualIpAddress(iNodeModel.getHostName()));
            }
            iNetElement = (INetElement)this.netElemsByIp.get(iNodeModel.getHostName());
        }
        return iNetElement;
    }

    public INetElement findNetElem(INetElement iNetElement) {
        return this.findNetElem(iNetElement.getNodeId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected INetElement findNetElem(InetAddress inetAddress, List list) {
        if (inetAddress == null) {
            return null;
        }
        Map map = this.allNetLinks;
        synchronized (map) {
            for (INetLink iNetLink : this.allNetLinks.values()) {
                INetElement iNetElement = iNetLink.getSrc();
                InetAddress inetAddress2 = null;
                INetElement iNetElement2 = iNetLink.getDst();
                InetAddress inetAddress3 = null;
                inetAddress2 = IPAddressTranslator.instance().getPublicAddress(iNetElement.getHostName());
                inetAddress3 = IPAddressTranslator.instance().getPublicAddress(iNetElement2.getHostName());
                if (inetAddress.equals(inetAddress2) && list.contains(iNetElement2)) {
                    return iNetElement;
                }
                if (!inetAddress.equals(inetAddress3) || !list.contains(iNetElement)) continue;
                return iNetElement2;
            }
        }
        return null;
    }

    private String formatLink(INetLink iNetLink) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Integer.toHexString(iNetLink.getSrc().getNodeId()));
        stringBuffer.append("/");
        stringBuffer.append(Integer.toHexString(iNetLink.getSrcEntityIndex()));
        stringBuffer.append("/");
        stringBuffer.append(iNetLink.getSrcHo());
        stringBuffer.append("->");
        stringBuffer.append(Integer.toHexString(iNetLink.getDst().getNodeId()));
        stringBuffer.append("/");
        stringBuffer.append(Integer.toHexString(iNetLink.getDstEntityIndex()));
        stringBuffer.append("/");
        stringBuffer.append(iNetLink.getDstHo());
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showLinks(INetLink iNetLink) {
        StringBuffer stringBuffer = new StringBuffer();
        Map map = this.allNetLinks;
        synchronized (map) {
            Iterator iterator = this.allNetLinks.values().iterator();
            stringBuffer.append("links+");
            stringBuffer.append(this.formatLink(iNetLink));
            stringBuffer.append("={");
            while (iterator.hasNext()) {
                INetLink iNetLink2 = (INetLink)iterator.next();
                stringBuffer.append(" ");
                stringBuffer.append(this.formatLink(iNetLink2));
            }
            stringBuffer.append(" }");
        }
        this.db.println(stringBuffer.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addNewNetLink(INetLink iNetLink) {
        if (iNetLink == null) {
            if (this.db.on()) {
                this.db.println("addNewNetLink: cannot add NULL link");
            }
            return;
        }
        if (this.db.on()) {
            this.db.println("addNewNetLink: attempting to add NL " + iNetLink.prettyString());
        }
        iNetLink.getSrc().addAdjacentLink(iNetLink);
        NetLinkComparatorKey netLinkComparatorKey = new NetLinkComparatorKey(iNetLink.getLinkModel().linkType(), iNetLink.getSrc(), iNetLink.getDst(), iNetLink.isVirtual() ? 0 : iNetLink.getSrcEntityIndex(), iNetLink.isVirtual() ? 0 : iNetLink.getDstEntityIndex(), iNetLink.getSrcHo(), iNetLink.getDstHo(), iNetLink.isVirtual() ? iNetLink.getSrcLinkId() : -1, iNetLink.isVirtual() ? iNetLink.getDstLinkId() : -1, iNetLink.isSdccLink(), iNetLink.isServerTrail() ? ((ServerTrailLink)iNetLink).getServerTrailId() : null);
        boolean bl = false;
        Map map = this.allNetLinks;
        synchronized (map) {
            if (!this.allNetLinks.containsKey(netLinkComparatorKey)) {
                this.allNetLinks.put(netLinkComparatorKey, iNetLink);
                bl = true;
                if (this.db.on()) {
                    this.db.println("addNewNetLink: link is new, added to NL list, list size = " + this.allNetLinks.size());
                }
            }
        }
        if (bl) {
            this.getNetLinkCreationNotifier().changed(iNetLink);
        }
    }

    public void addNetLink(INetLink iNetLink) throws ObjDuplicate {
        if (iNetLink == null) {
            if (this.db.on()) {
                this.db.println("addNetLink- link is null");
            }
            return;
        }
        if (this.db.on()) {
            this.db.println("addNetLink: adding link between " + iNetLink.getSrc() + " and " + iNetLink.getDst());
        }
        if (this.db.on()) {
            this.db.println("Adding a link to the network");
        }
        if (this.db.on()) {
            this.db.println(iNetLink.prettyString());
        }
        if (iNetLink instanceof NetLink && this.db.on()) {
            this.db.println(" Old state = " + (((NetLink)iNetLink).oldState() == 1 ? "Up" : "Down"));
        }
        iNetLink.getSrc().addAdjacentLink(iNetLink);
        NetLinkComparatorKey netLinkComparatorKey = new NetLinkComparatorKey(iNetLink.getLinkModel().linkType(), iNetLink.getSrc(), iNetLink.getDst(), iNetLink.isVirtual() ? 0 : iNetLink.getSrcEntityIndex(), iNetLink.isVirtual() ? 0 : iNetLink.getDstEntityIndex(), iNetLink.isOchTrailTunnel() ? null : iNetLink.getSrcHo(), iNetLink.isOchTrailTunnel() ? null : iNetLink.getDstHo(), iNetLink.isVirtual() ? iNetLink.getSrcLinkId() : -1, iNetLink.isVirtual() ? iNetLink.getDstLinkId() : -1, iNetLink.isSdccLink(), iNetLink.isServerTrail() ? ((ServerTrailLink)iNetLink).getServerTrailId() : null);
        if (this.allNetLinks.containsKey(netLinkComparatorKey)) {
            if (this.db.on()) {
                this.db.println("Duplicate link");
            }
            throw new ObjDuplicate("A duplicate link was found.");
        }
        if (this.getNetElem(iNetLink.getSrc()) == null) {
            if (this.db.on()) {
                this.db.println("Source NE of link doesn't exist, adding it");
            }
            this.addNetElement(iNetLink.getSrc());
        }
        if (this.getNetElem(iNetLink.getDst()) == null) {
            if (this.db.on()) {
                this.db.println("Destination NE of link doesn't exist, adding it");
            }
            this.addNetElement(iNetLink.getDst());
        }
        this.allNetLinks.put(netLinkComparatorKey, iNetLink);
        if (this.db.on()) {
            this.showLinks(iNetLink);
        }
        if (this.db.on()) {
            this.db.println("addNetLink: notify observer of a new netlink");
        }
        this.getNetLinkCreationNotifier().changed(iNetLink);
    }

    protected INetLink addNetLink(ILinkModel iLinkModel, INetElement iNetElement, INetElement iNetElement2, boolean bl, boolean bl2, Topology topology, List list) {
        INetLink iNetLink;
        if (iLinkModel == null) {
            if (this.db.on()) {
                this.db.println("addNetLink: link model is null, returning null");
            }
            return null;
        }
        if (this.db.on()) {
            this.db.println("addNetLink: attempting to add NL between NE's " + iNetElement.getActualAddressDisplay() + " and " + iNetElement2.getActualAddressDisplay());
        }
        INetLink iNetLink2 = null;
        NetLinkComparatorKey netLinkComparatorKey = new NetLinkComparatorKey(iLinkModel.linkType(), iNetElement, iNetElement2, iLinkModel.isVirtual() ? 0 : iLinkModel.srcEntityIndex(), iLinkModel.isVirtual() ? 0 : iLinkModel.dstEntityIndex(), iLinkModel.srcHo(), iLinkModel.dstHo(), iLinkModel.linkType() == 6 ? iLinkModel.getSrcLinkId() : -1, iLinkModel.linkType() == 6 ? iLinkModel.getDstLinkId() : -1, bl2, null);
        if (this.allNetLinks.containsKey(netLinkComparatorKey)) {
            if (this.db.on()) {
                this.db.println("addNetLink: link already exists, returning existing NL, list size= " + this.allNetLinks.size());
            }
            if ((iNetLink2 = (INetLink)this.allNetLinks.get(netLinkComparatorKey)).getLinkType() == 9) {
                if (this.db.on()) {
                    this.db.println("addNetLink: DENY A ServerTrail already exists between given entities.");
                }
                return null;
            }
            if (iNetLink2.getLinkType() == 3) {
                if (this.db.on()) {
                    this.db.println("addNetLink: existing link is a phantom link, must be removed");
                }
                INetLink iNetLink3 = this.findReverseLink(iNetLink2);
                ((NetLink)iNetLink2).dispose();
                if (iNetLink3 != null) {
                    ((NetLink)iNetLink3).dispose();
                }
                iNetLink2 = NetLinkFactory.createNetLink(this, iLinkModel, iNetElement, iNetElement2, topology, bl2, bl);
            }
            this.addNewNetLink(iNetLink2);
            return iNetLink2;
        }
        INetLink iNetLink4 = null;
        INetLink iNetLink5 = null;
        if (iNetElement instanceof NetElement) {
            iNetLink4 = this.findRedundantNetLinkFromSource(iLinkModel.linkType(), iNetElement, iLinkModel.srcEntityIndex(), iLinkModel.srcHo(), iLinkModel.isPca(), iLinkModel.getSrcLinkId());
        }
        if (iNetElement2 instanceof NetElement) {
            iNetLink5 = this.findRedundantNetLinkFromDestination(iLinkModel.linkType(), iNetElement2, iLinkModel.dstEntityIndex(), iLinkModel.dstHo(), iLinkModel.isPca(), iLinkModel.getDstLinkId());
        }
        iNetLink2 = NetLinkFactory.createNetLink(this, iLinkModel, iNetElement, iNetElement2, topology, bl2, bl);
        this.addNewNetLink(iNetLink2);
        if (iNetLink4 != null && !list.contains(iNetLink4)) {
            if (this.db.on()) {
                this.db.println("addNetLink: adding SRC redundant NL " + iNetLink4.prettyString() + " to list");
            }
            list.add(iNetLink4);
            iNetLink = this.findReverseLink(iNetLink4);
            if (iNetLink != null) {
                if (this.db.on()) {
                    this.db.println("addNetLink: adding SRC redundant NL " + iNetLink.prettyString() + " to list");
                }
                list.add(iNetLink);
            }
        }
        if (iNetLink5 != null && !list.contains(iNetLink5)) {
            if (this.db.on()) {
                this.db.println("addNetLink: adding DST redundant NL " + iNetLink5.prettyString() + " to list");
            }
            list.add(iNetLink5);
            iNetLink = this.findReverseLink(iNetLink5);
            if (iNetLink != null) {
                if (this.db.on()) {
                    this.db.println("addNetLink: adding DST redundant NL " + iNetLink.prettyString() + " to list");
                }
                list.add(iNetLink);
            }
        }
        return iNetLink2;
    }

    protected void addDwdmNetLink(INetLink iNetLink) {
        if (iNetLink == null) {
            if (this.db.on()) {
                this.db.println("addDwdmNetLink: link is null, returning");
            }
            return;
        }
        if (this.db.on()) {
            this.db.println("addDwdmNetLink: attempting to add NL between NE's" + iNetLink.getSrc().getActualAddressDisplay() + " and " + iNetLink.getDst().getActualAddressDisplay());
        }
        this.addNewNetLink(iNetLink);
    }

    protected void addCompositeNetLink(CompositeNetLink compositeNetLink) {
        if (compositeNetLink == null) {
            if (this.db.on()) {
                this.db.println("addCompositeNetLink: link is null, returning");
            }
            return;
        }
        if (this.db.on()) {
            this.db.println("addCompositeNetLink: attempting to add NL between NE's" + compositeNetLink.getSrc().getActualAddressDisplay() + " and " + compositeNetLink.getDst().getActualAddressDisplay());
        }
        this.addNewNetLink(compositeNetLink);
    }

    protected synchronized void replaceUnknownLink(UnknownNetLink unknownNetLink, INetLink iNetLink) {
        Topology topology = unknownNetLink.getTopology();
        if (this.db.on()) {
            this.db.println("replaceUnknownLink: replacing NL " + unknownNetLink.prettyString() + " with " + iNetLink.prettyString());
        }
        if (topology != null && !topology.isDestroyed()) {
            topology.replaceUnknownLink(unknownNetLink, iNetLink);
        }
        unknownNetLink.dispose();
        this.addNewNetLink(iNetLink);
    }

    public void deleteNetLink(INetLink iNetLink) {
        if (iNetLink == null) {
            if (this.db.on()) {
                this.db.println("deleteNetLink- link is null");
            }
            return;
        }
        if (this.db.on()) {
            this.db.println("deleteNetLink: deleting NL " + iNetLink.prettyString());
        }
        iNetLink.dispose();
    }

    @Override
    public INetLink findNetLink(INetElement iNetElement, int n, IHoNum iHoNum, INetElement iNetElement2, int n2, IHoNum iHoNum2, boolean bl, int n3) {
        if (iNetElement == null || iNetElement2 == null) {
            if (this.db.on()) {
                this.db.println("findNetLink- null NE reference");
            }
            return null;
        }
        INodeModel iNodeModel = iNetElement.getNodeModel();
        INodeModel iNodeModel2 = iNetElement2.getNodeModel();
        if (iNodeModel == null || iNodeModel2 == null) {
            return null;
        }
        NetLinkComparatorKey netLinkComparatorKey = new NetLinkComparatorKey(n3, iNetElement, iNetElement2, n, n2, iHoNum, iHoNum2, -1, -1, bl, null);
        INetLink iNetLink = (INetLink)this.allNetLinks.get(netLinkComparatorKey);
        if (iNetLink == null && this.db.on()) {
            this.db.println("Unable to find netlink in the network");
        }
        return iNetLink;
    }

    @Override
    public INetLink findReverseLink(INetLink iNetLink) {
        NetLinkComparatorKey netLinkComparatorKey;
        INetLink iNetLink2 = null;
        if (iNetLink == null) {
            return null;
        }
        if (this.db.on()) {
            this.db.println("findReverseLink: link = " + iNetLink.prettyString());
        }
        if ((iNetLink2 = (INetLink)this.allNetLinks.get(netLinkComparatorKey = new NetLinkComparatorKey(iNetLink.getLinkType(), iNetLink.getDst(), iNetLink.getSrc(), iNetLink.isVirtual() ? 0 : iNetLink.getDstEntityIndex(), iNetLink.isVirtual() ? 0 : iNetLink.getSrcEntityIndex(), iNetLink.getDstHo(), iNetLink.getSrcHo(), iNetLink.isVirtual() ? iNetLink.getDstLinkId() : -1, iNetLink.isVirtual() ? iNetLink.getSrcLinkId() : -1, iNetLink.isSdccLink(), iNetLink.isServerTrail() ? ((ServerTrailLink)iNetLink).getServerTrailId() : null))) == null) {
            if (this.db.on()) {
                this.db.println("findReverseLink: Unable to find reverse link in the network");
            }
        } else if (this.db.on()) {
            this.db.println("findReverseLink: returning reverse link from network");
        }
        return iNetLink2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection findVirtualLinks(INetElement iNetElement, INetElement iNetElement2) {
        LinkedList<INetLink> linkedList = new LinkedList<INetLink>();
        Map map = this.allNetLinks;
        synchronized (map) {
            for (INetLink iNetLink : this.allNetLinks.values()) {
                if (!(iNetLink instanceof VirtualNetLink) || (!iNetLink.getSrc().equals(iNetElement) || !iNetLink.getDst().equals(iNetElement2)) && (!iNetLink.getSrc().equals(iNetElement2) || !iNetLink.getDst().equals(iNetElement))) continue;
                linkedList.add(iNetLink);
            }
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public INetLink findNetLinkFromLinkModel(ILinkModel iLinkModel) {
        INetLink iNetLink = null;
        Map map = this.allNetLinks;
        synchronized (map) {
            Iterator iterator = this.allNetLinks.values().iterator();
            while (iNetLink == null && iterator.hasNext()) {
                INetLink iNetLink2 = (INetLink)iterator.next();
                if (iNetLink2.getLinkModel() != iLinkModel) continue;
                iNetLink = iNetLink2;
            }
        }
        return iNetLink;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public INetLink findNetLinkFromEnt(INetElement iNetElement, int n, boolean bl) {
        INetLink iNetLink = null;
        Map map = this.allNetLinks;
        synchronized (map) {
            for (INetLink iNetLink2 : this.allNetLinks.values()) {
                if (iNetLink2.getSrc() != iNetElement || iNetLink2.getSrcEntityIndex() != n || iNetLink2.isSdccLink() != bl) continue;
                if (iNetLink == null) {
                    iNetLink = iNetLink2;
                    continue;
                }
                if (iNetLink.getTimestamp() >= iNetLink2.getTimestamp()) continue;
                iNetLink = iNetLink2;
            }
        }
        return iNetLink;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public INetLink findNetLinkFromEnt(INetElement iNetElement, int n) {
        INetLink iNetLink = null;
        Map map = this.allNetLinks;
        synchronized (map) {
            for (INetLink iNetLink2 : this.allNetLinks.values()) {
                if (iNetLink2.getSrc() != iNetElement || iNetLink2.getSrcEntityIndex() != n) continue;
                if (iNetLink == null) {
                    iNetLink = iNetLink2;
                    continue;
                }
                if (iNetLink.getTimestamp() >= iNetLink2.getTimestamp()) continue;
                iNetLink = iNetLink2;
            }
        }
        return iNetLink;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public INetLink findPcaNetLinkFromEnt(INetElement iNetElement, int n) {
        Map map = this.allNetLinks;
        synchronized (map) {
            for (INetLink iNetLink : this.allNetLinks.values()) {
                if (iNetLink.isLOTunnel() || iNetLink.isLAP() || !iNetLink.isPca() || iNetLink.getSrc() != iNetElement || iNetLink.getSrcEntityIndex() != n) continue;
                return iNetLink;
            }
        }
        return null;
    }

    public INetLink findRedundantNetLinkFromSource(int n, INetElement iNetElement, int n2, IHoNum iHoNum, boolean bl, int n3) {
        for (INetLink iNetLink : this.getNetLinks()) {
            if (iNetLink instanceof CompositeNetLink || iNetLink.getLinkType() != n || iNetLink.getSrc() != iNetElement || iNetLink.getSrcEntityIndex() != n2 || !holoComp.isEqual(iNetLink.getSrcHo(), iHoNum) || iNetLink.isPca() != bl || iNetLink.getSrcLinkId() != n3) continue;
            return iNetLink;
        }
        return null;
    }

    public INetLink findRedundantNetLinkFromDestination(int n, INetElement iNetElement, int n2, IHoNum iHoNum, boolean bl, int n3) {
        for (INetLink iNetLink : this.getNetLinks()) {
            if (iNetLink instanceof CompositeNetLink || iNetLink.getLinkType() != n || iNetLink.getDst() != iNetElement || iNetLink.getDstEntityIndex() != n2 || !holoComp.isEqual(iNetLink.getDstHo(), iHoNum) || iNetLink.isPca() != bl || iNetLink.getDstLinkId() != n3) continue;
            return iNetLink;
        }
        return null;
    }

    public INetLink findNetLinkFromSourceCktEnd(boolean bl, INetElement iNetElement, int n, IHoNum iHoNum, ILoNum iLoNum) {
        Iterator iterator = this.getNetLinks().iterator();
        if (this.db.on()) {
            this.db.println("findNetLinkFromSourceCktEnd: on ne " + iNetElement.getName());
        }
        if (bl) {
            while (iterator.hasNext()) {
                INetLink iNetLink = (INetLink)iterator.next();
                if (!iNetLink.isLOTunnel() && !iNetLink.isLAP() || iNetLink.getSrc() != iNetElement || iNetLink.getSrcEntityIndex() != n || !holoComp.isEqual(iNetLink.getSrcHo(), iHoNum)) continue;
                return iNetLink;
            }
        }
        for (INetLink iNetLink : this.getNetLinks()) {
            if (!iNetLink.isRoutable() || iNetLink.getSrc() != iNetElement || iNetLink.getSrcEntityIndex() != n || !iNetLink.isValidSrcHoNumber(iHoNum) || iNetLink.isServerTrail() && iLoNum != null && !((ServerTrailLink)iNetLink).isValidHoLoNum(iHoNum, iLoNum, true)) continue;
            return iNetLink;
        }
        return null;
    }

    public INetLink findNetLinkFromDestinationCktEnd(boolean bl, INetElement iNetElement, int n, IHoNum iHoNum, ILoNum iLoNum) {
        Iterator iterator = this.getNetLinks().iterator();
        if (this.db.on()) {
            this.db.println("findNetLinkFromDestinationCktEnd: on ne " + iNetElement.getName());
        }
        if (bl) {
            while (iterator.hasNext()) {
                INetLink iNetLink = (INetLink)iterator.next();
                if (!iNetLink.isLOTunnel() && !iNetLink.isLAP() || iNetLink.getDst() != iNetElement || iNetLink.getDstEntityIndex() != n || !holoComp.isEqual(iNetLink.getDstHo(), iHoNum)) continue;
                return iNetLink;
            }
        }
        for (INetLink iNetLink : this.getNetLinks()) {
            if (!iNetLink.isRoutable() || iNetLink.getDst() != iNetElement || iNetLink.getDstEntityIndex() != n || !iNetLink.isValidDstHoNumber(iHoNum) || iNetLink.isServerTrail() && iLoNum != null && !((ServerTrailLink)iNetLink).isValidHoLoNum(iHoNum, iLoNum, false)) continue;
            return iNetLink;
        }
        return null;
    }

    @Override
    public INetLink findNetLinkFromSource(boolean bl, INetElement iNetElement, int n, IHoNum iHoNum) {
        return this.findNetLinkFromSource(bl, iNetElement, n, iHoNum, null);
    }

    @Override
    public INetLink findNetLinkFromDestination(boolean bl, INetElement iNetElement, int n, IHoNum iHoNum) {
        return this.findNetLinkFromDestination(bl, iNetElement, n, iHoNum, null);
    }

    @Override
    public INetLink findNetLinkFromSource(boolean bl, INetElement iNetElement, int n, IHoNum iHoNum, ILoNum iLoNum) {
        for (INetLink iNetLink : this.getNetLinks()) {
            INodeModel iNodeModel;
            if (!bl && (iNetLink.isLOTunnel() || iNetLink.isLAP() || iNetLink.isOchTrailTunnel()) || bl && !iNetLink.isLOTunnel() && !iNetLink.isLAP() && !iNetLink.isOchTrailTunnel() || !iNetLink.isRoutable() || iNetLink.getSrc() != iNetElement || iNetLink.getSrcEntityIndex() != n || !iNetLink.isValidSrcHoNumber(iHoNum) || iNetLink.isVirtual() && !((VirtualNetLink)iNetLink).isDstPortRX() || iNetLink.getLinkType() == 11 && (iNodeModel = ((LmpDataLinkNetLink)iNetLink).getSrc().getNodeModel()) != null && iNodeModel.getNeType() != null && iNodeModel.getNeType().indexOf("crs") > -1 && !((LmpDataLinkNetLink)iNetLink).isDstPortRX() || iNetLink.isServerTrail() && iLoNum != null && !((ServerTrailLink)iNetLink).isValidHoLoNum(iHoNum, iLoNum, true)) continue;
            return iNetLink;
        }
        return null;
    }

    public List<INetLink> findAllNetLinksWithNetElemAndSide(INetElement iNetElement, int n) {
        List list = this.findAllNetLinksWithNetElem(iNetElement);
        int n2 = iNetElement.getNodeId();
        IEntityTableModel iEntityTableModel = iNetElement.getNodeModel().getEntityTable();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            INetLink iNetLink = (INetLink)iterator.next();
            try {
                int n3 = iNetLink.getSrc().getNodeId() == n2 ? iNetLink.getSrcEntityIndex() : iNetLink.getDstEntityIndex();
                IEntityModel iEntityModel = iEntityTableModel.getEntityModelByIndex(n3);
                int n4 = OchPortsHelper.getSide(iEntityModel);
                if (n4 == n) continue;
                iterator.remove();
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                iterator.remove();
                if (!this.db.on()) continue;
                this.db.println("Cannot get port on " + iNetElement.getName() + " for link " + iNetLink);
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
        }
        return list;
    }

    @Override
    public INetLink findNetLinkFromDestination(boolean bl, INetElement iNetElement, int n, IHoNum iHoNum, ILoNum iLoNum) {
        for (INetLink iNetLink : this.getNetLinks()) {
            INodeModel iNodeModel;
            if (!bl && (iNetLink.isLOTunnel() || iNetLink.isLAP() || iNetLink.isOchTrailTunnel()) || bl && !iNetLink.isLOTunnel() && !iNetLink.isLAP() && !iNetLink.isOchTrailTunnel() || !iNetLink.isRoutable() || iNetLink.getDst() != iNetElement || iNetLink.getDstEntityIndex() != n || !iNetLink.isValidDstHoNumber(iHoNum) || iNetLink.isVirtual() && !((VirtualNetLink)iNetLink).isSrcPortTX() || iNetLink.getLinkType() == 11 && (iNodeModel = ((LmpDataLinkNetLink)iNetLink).getDst().getNodeModel()) != null && iNodeModel.getNeType() != null && iNodeModel.getNeType().indexOf("crs") > -1 && !((LmpDataLinkNetLink)iNetLink).isSrcPortTX() || iNetLink.isServerTrail() && iLoNum != null && !((ServerTrailLink)iNetLink).isValidHoLoNum(iHoNum, iLoNum, false)) continue;
            return iNetLink;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List findAllNetLinksWithSource(INetElement iNetElement) {
        LinkedList<INetLink> linkedList = new LinkedList<INetLink>();
        Map map = this.allNetLinks;
        synchronized (map) {
            for (INetLink iNetLink : this.allNetLinks.values()) {
                if (iNetLink.getSrc() != iNetElement) continue;
                linkedList.add(iNetLink);
            }
        }
        return linkedList;
    }

    public INetLink findDwdmNetLinkReverse(INetLink iNetLink) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        List list = this.findAllNetLinksWithSource(iNetLink.getDst());
        for (INetLink iNetLink2 : list) {
            if (!(iNetLink2 instanceof DwdmNetLink)) continue;
            try {
                n = this.getShelfId(iNetLink.getSrc(), iNetLink.getSrcEntityIndex());
                n2 = this.getShelfId(iNetLink.getDst(), iNetLink.getDstEntityIndex());
                n3 = this.getShelfId(iNetLink2.getSrc(), iNetLink2.getSrcEntityIndex());
                n4 = this.getShelfId(iNetLink2.getDst(), iNetLink2.getDstEntityIndex());
            }
            catch (Exception exception) {
                this.db.warning("Cannot get shelf ID: " + exception.getMessage());
                continue;
            }
            if (iNetLink2.getSrc().getNodeId() != iNetLink.getDst().getNodeId() || iNetLink2.getDst().getNodeId() != iNetLink.getSrc().getNodeId() || n != n4 || n2 != n3 || iNetLink2.getSrcSlotNumber() != iNetLink.getDstSlotNumber() || iNetLink2.getDstSlotNumber() != iNetLink.getSrcSlotNumber() || iNetLink2.getProtectionRole() != iNetLink.getProtectionRole()) continue;
            return iNetLink2;
        }
        return null;
    }

    private int getShelfId(INetElement iNetElement, int n) throws Exception {
        int n2 = 0;
        INodeModel iNodeModel = iNetElement.getNodeModel();
        if (iNodeModel.provides(Feature.MULTISHELF) && iNodeModel.isMultishelf()) {
            IEntityModel iEntityModel = this.getEntityModel(iNetElement, n);
            n2 = iEntityModel.getShelfId();
        }
        if (this.db.isFinestEnabled()) {
            this.db.finest("getShelfId(" + iNetElement.getName() + ", " + Integer.toHexString(n) + ") = " + n2);
        }
        return n2;
    }

    private IEntityModel getEntityModel(INetElement iNetElement, int n) throws Exception {
        IEntityModel iEntityModel = null;
        iEntityModel = iNetElement.getNodeModel().getEntityTable().getEntityModelByIndex(n);
        return iEntityModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List findAllNetLinksWithNetElem(INetElement iNetElement) {
        if (this.db.on()) {
            this.db.println("findAllNetLinksWithNetElem: looking for NE " + iNetElement.getActualAddressDisplay());
        }
        LinkedList<INetLink> linkedList = new LinkedList<INetLink>();
        Map map = this.allNetLinks;
        synchronized (map) {
            for (INetLink iNetLink : this.allNetLinks.values()) {
                if (iNetLink.getDst() != iNetElement && iNetLink.getSrc() != iNetElement) continue;
                if (this.db.on()) {
                    this.db.println("findAllNetLinksWithNetElem: link = " + iNetLink.prettyString());
                }
                linkedList.add(iNetLink);
            }
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List findAllNetLinksWithBlsrRingName(String string) {
        if (this.db.on()) {
            this.db.println("findAllNetLinksWithBlsrRingName: looking for ring " + string);
        }
        LinkedList<INetLink> linkedList = new LinkedList<INetLink>();
        Map map = this.allNetLinks;
        synchronized (map) {
            for (INetLink iNetLink : this.allNetLinks.values()) {
                if (!iNetLink.inBLSR() || !iNetLink.blsrRingName().equals(string)) continue;
                if (this.db.on()) {
                    this.db.println("findAllNetLinksWithBlsrRingName: link = " + iNetLink.prettyString());
                }
                linkedList.add(iNetLink);
            }
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List findAllLoTunnelNetLinks(INetElement iNetElement, INetElement iNetElement2, boolean bl) {
        LinkedList<INetLink> linkedList = new LinkedList<INetLink>();
        Map map = this.allNetLinks;
        synchronized (map) {
            for (INetLink iNetLink : this.allNetLinks.values()) {
                if (bl && iNetLink.isLOTunnel() && iNetLink.getSrc() == iNetElement && iNetLink.getDst() == iNetElement2) {
                    linkedList.add(iNetLink);
                    continue;
                }
                if (bl || !iNetLink.isLAP() || iNetLink.getSrc() != iNetElement || iNetLink.getDst() != iNetElement2) continue;
                linkedList.add(iNetLink);
            }
        }
        return linkedList;
    }

    protected INetLink findLoTunnelNetLink(INetElement iNetElement, INetElement iNetElement2, int n, IHoNum iHoNum) {
        LinkedList linkedList = new LinkedList();
        LinkedList linkedList2 = new LinkedList();
        linkedList.addAll(this.findAllLoTunnelNetLinks(iNetElement, iNetElement2, true));
        linkedList2.addAll(this.findAllLoTunnelNetLinks(iNetElement, iNetElement2, false));
        Iterator iterator = linkedList.iterator();
        for (int i = 0; i < 2; ++i) {
            while (iterator.hasNext()) {
                NetLink netLink = (NetLink)iterator.next();
                if (netLink.getSrcEntityIndex() != n || !holoComp.isEqual(netLink.getSrcHo(), iHoNum)) continue;
                return netLink;
            }
            iterator = linkedList2.iterator();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection getNetLinks() {
        LinkedList linkedList = null;
        Map map = this.allNetLinks;
        synchronized (map) {
            linkedList = new LinkedList(this.allNetLinks.values());
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public INetLink findOchTrailTunnelNetLinkFromSrc(INetElement iNetElement, int n) {
        Map map = this.allNetLinks;
        synchronized (map) {
            for (INetLink iNetLink : this.allNetLinks.values()) {
                if (!(iNetLink instanceof OchTrailTunnelNetLink) || iNetLink.getSrc() != iNetElement || iNetLink.getSrcEntityIndex() != n) continue;
                return iNetLink;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public INetLink findOchTrailTunnelNetLinkFromDst(INetElement iNetElement, int n) {
        Map map = this.allNetLinks;
        synchronized (map) {
            for (INetLink iNetLink : this.allNetLinks.values()) {
                if (!(iNetLink instanceof OchTrailTunnelNetLink) || iNetLink.getDst() != iNetElement || iNetLink.getDstEntityIndex() != n) continue;
                return iNetLink;
            }
        }
        return null;
    }

    public INodeModel getNodeModel(int n) {
        INetElement iNetElement = this.findNetElem(n);
        return iNetElement == null ? null : iNetElement.getNodeModel();
    }

    public Topology getNonDefaultTopoOfSmallestId() {
        Topology topology = null;
        int n = 0;
        for (Topology topology2 : this.topologies.values()) {
            if (topology2.getTopoId() == 0) continue;
            if (topology == null) {
                topology = topology2;
                n = topology2.getTopoId();
                continue;
            }
            if (topology2.getTopoId() >= n) continue;
            topology = topology2;
            n = topology2.getTopoId();
        }
        return topology;
    }

    protected Topology getDefaultTopo() {
        return (Topology)this.topologies.get(new Integer(0));
    }

    public INetElement getTopoHost(int n) {
        INetElement iNetElement = null;
        Topology topology = (Topology)this.getTopologyMap().get(new Integer(n));
        for (INetElement iNetElement2 : topology.getTopoElems()) {
            if (!iNetElement2.isTopoHost() || iNetElement2.getTopoId() != n) continue;
            iNetElement = iNetElement2;
            break;
        }
        return iNetElement;
    }

    @Override
    public boolean areNodesInSameTopo(InetAddress inetAddress, InetAddress inetAddress2) {
        if (inetAddress == null || inetAddress2 == null) {
            return false;
        }
        if (inetAddress.equals(inetAddress2)) {
            return true;
        }
        if (this.partitioner != null && this.partitioner.areNodesInSameTopo(inetAddress, inetAddress2)) {
            return true;
        }
        String string = inetAddress.getHostAddress();
        String string2 = inetAddress2.getHostAddress();
        INetElement iNetElement = this.findNetElemByIp(string);
        INetElement iNetElement2 = this.findNetElemByIp(string2);
        return iNetElement != null && iNetElement2 != null && iNetElement.getTopoId() == iNetElement2.getTopoId();
    }

    public NetElementCreationNotifier getNetElementCreationNotifier() {
        return this.netElementCreationNotifier;
    }

    public NetLinkCreationNotifier getNetLinkCreationNotifier() {
        return this.netLinkCreationNotifier;
    }

    public TopologyCreationNotifier getTopologyCreationNotifier() {
        return this.topologyCreationNotifier;
    }

    public List getLinkSet() {
        return this.linkList;
    }

    public Map getNodeMap() {
        return this.neMap;
    }

    private String getDefaultName() {
        return "Unknown" + ++this.nextId;
    }

    protected boolean isExcludeDynamicNodes() {
        return this.excludeDynamicNodes;
    }

    protected void removeSvTrailLinksById(IServerTrailLinkId iServerTrailLinkId) {
        if (iServerTrailLinkId != null) {
            this.svTrailLinks.remove(iServerTrailLinkId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getSvTrailLinks() {
        LinkedList linkedList = null;
        Object object = this.masterTrailLock;
        synchronized (object) {
            linkedList = new LinkedList(this.svTrailLinks.values());
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeSvTrailLinksOnNe(INetElement iNetElement) {
        Object object = this.masterTrailLock;
        synchronized (object) {
            Iterator iterator = this.svTrailLinks.values().iterator();
            while (iterator.hasNext()) {
                ServerTrailLink serverTrailLink = (ServerTrailLink)iterator.next();
                if (!serverTrailLink.getSrc().equals(iNetElement) && !serverTrailLink.getDst().equals(iNetElement)) continue;
                ServerTrailLinkId serverTrailLinkId = new ServerTrailLinkId(serverTrailLink.getServerTrailId().getNodeId(), serverTrailLink.getServerTrailId().getUniqueId());
                iterator.remove();
                NetServerTrailManager.instance().removePrimPeerCtpsById(serverTrailLinkId);
            }
        }
    }

    @Override
    public INetLink findSvLink(IServerTrailLinkId iServerTrailLinkId) {
        return (INetLink)this.svTrailLinks.get(new ServerTrailLinkId(iServerTrailLinkId.getNodeId(), iServerTrailLinkId.getUniqueId()));
    }

    protected boolean isNetLinkKey(NetLinkComparatorKey netLinkComparatorKey) {
        return this.allNetLinks.containsKey(netLinkComparatorKey);
    }

    protected INetLink getNetLink(NetLinkComparatorKey netLinkComparatorKey) {
        return (INetLink)this.allNetLinks.get(netLinkComparatorKey);
    }

    protected int getAllNetLinkSize() {
        return this.allNetLinks.size();
    }

    private String getActualIpAddress(String string) {
        return trans.getActualAddressDisplay(string);
    }

    public IFvNetLink findTheReverseLink(IFvNetLink iFvNetLink) {
        return this.findReverseLink((INetLink)iFvNetLink);
    }

    public boolean isNetElementCreationNotifier(Observable observable) {
        return observable instanceof NetElementCreationNotifier;
    }

    public boolean isNetLinkCreationNotifier(Observable observable) {
        return observable instanceof NetLinkCreationNotifier;
    }

    public boolean isTopologyCreationNotifier(Observable observable) {
        return observable instanceof TopologyCreationNotifier;
    }

    public IPartitioner getPartitioner() {
        return this.partitioner;
    }

    public void setPartitioner(IPartitioner iPartitioner) {
        this.partitioner = iPartitioner != this ? iPartitioner : null;
    }

    @Override
    public boolean isEnabled() {
        return this.partitioner == null ? false : this.partitioner.isEnabled();
    }

    public boolean isPartitionerEnabled() {
        return this.isEnabled();
    }

    @Override
    public boolean isMember(IOspfLSA iOspfLSA, IOspfAdv iOspfAdv, long l, TopologyAgent topologyAgent) {
        return this.partitioner == null ? true : this.partitioner.isMember(iOspfLSA, iOspfAdv, l, topologyAgent);
    }

    @Override
    public boolean isMember(IServerTrailEnd iServerTrailEnd, INodeModel iNodeModel) {
        return this.partitioner == null ? true : this.partitioner.isMember(iServerTrailEnd, iNodeModel);
    }

    @Override
    public boolean isMember(ILmpCtrlChannelModel iLmpCtrlChannelModel, INodeModel iNodeModel) {
        return this.partitioner == null ? true : this.partitioner.isMember(iLmpCtrlChannelModel, iNodeModel);
    }

    @Override
    public boolean isMember(IVirtualLinkModel iVirtualLinkModel, INodeModel iNodeModel) {
        return this.partitioner == null ? true : this.partitioner.isMember(iVirtualLinkModel, iNodeModel);
    }

    @Override
    public void lastMember(long l, TopologyAgent topologyAgent) {
        if (this.partitioner != null) {
            this.partitioner.lastMember(l, topologyAgent);
        }
    }

    @Override
    public void lastMember(INodeModel iNodeModel, IPartitioner.AdjacencyType adjacencyType) {
        if (this.partitioner != null) {
            this.partitioner.lastMember(iNodeModel, adjacencyType);
        }
    }

    static {
        trans = IPAddressTranslator.instance();
        addNetEleCompleted = true;
    }

    private class NetElemObserver
    implements IObserver {
        boolean deleted = false;

        private NetElemObserver() {
        }

        public synchronized void update(IObservable iObservable, Object object) {
            if (object == ModelUpdateType.DELETED) {
                if (Network.this.db.on()) {
                    Network.this.db.println("NetElemObserver.update: received DELETED event");
                }
                this.deleted = true;
                this.notifyAll();
                if (Network.this.db.on()) {
                    Network.this.db.println("NetElemObserver.update: called notifyAll");
                }
            }
        }

        protected boolean isDeleted() {
            return this.deleted;
        }
    }

    public class NetElementCreationNotifier
    extends UObservable {
        protected void changed(INetElement iNetElement) {
            if (Network.this.db.on()) {
                Network.this.db.println("changed: notifying observers about new NE " + iNetElement.getActualAddressDisplay());
            }
            this.setChanged();
            this.notifyObservers(iNetElement);
        }
    }

    public class NetLinkCreationNotifier
    extends UObservable {
        protected void changed(INetLink iNetLink) {
            if (Network.this.db.on()) {
                Network.this.db.println("changed: notifying observers about new link " + iNetLink.prettyString() + "\nchanged: NL = " + iNetLink);
            }
            this.setChanged();
            this.notifyObservers(iNetLink);
        }
    }

    private class NetworkActionClient
    implements IActionClient {
        private boolean disposed = false;

        public void doAction() {
            try {
                if (Network.this.db.on()) {
                    Network.this.db.println("doAction: processing update events");
                }
                while (!Network.this.topologyUpdateQueue.isEmpty()) {
                    Topology topology = (Topology)Network.this.topologyUpdateQueue.remove(0);
                    if (Network.this.db.on()) {
                        Network.this.db.println("doAction: processing event for Topo " + topology.getTopoId());
                    }
                    topology.processUpdateEvents();
                    if (!Network.this.db.on()) continue;
                    Network.this.db.println("doAction: processed event for Topo " + topology.getTopoId());
                }
                NetLinkManager.instance().doAction();
                Network.this.cleanupOrphanedLinks();
                if (Network.this.db.on()) {
                    Network.this.db.println("doAction: processed update event");
                }
            }
            catch (Exception exception) {
                Network.this.db.println("doAction: caught Exception => " + exception.getMessage());
                NetworkDebug cfr_ignored_0 = Network.this.db;
                NetworkDebug.printStackTrace((Throwable)exception);
            }
        }

        public void dispose() {
            if (Network.this.db.on()) {
                Network.this.db.println("dispose: networkActionClient disposed");
            }
            this.disposed = true;
        }

        public void failedAction(IThreadWorker iThreadWorker) {
        }
    }

    public class NetworkDebug
    extends SDebug
    implements IDebugDiag,
    IActionClient {
        private User user;
        private static final String defaultUserName = "CISCO15";
        private static final String defaultPassword = "otbu+1";
        private DNode dn;
        List nodeList;
        public static final String Hdump = "Dump all of the NetLinks in the network";
        public static final String HlistTopoNEs = "List the Topology Hosts";

        public NetworkDebug() {
            super("Network");
            this.user = null;
            this.dn = null;
            this.nodeList = new LinkedList();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void dump() {
            if (network != null) {
                this.println("Network type determining host: " + NetworkModel.instance().getCmsHostModel());
                Network network = Network.network;
                synchronized (network) {
                    Network.network.prettyPrint(this);
                }
            }
        }

        public final void traverse(String string, int n, int n2) {
            Object var6_4 = null;
            INetElement iNetElement = (INetElement)Network.this.netElemsByIp.get(string);
            Iterator iterator = null;
            Network.this.db.println("Traverse called on ne=" + iNetElement.getName() + " on slot " + n / 4096 + " on STS=" + n2);
            IConnectionModels iConnectionModels = iNetElement.getNodeModel().getConnectionModels();
            List<IHoConnectionModel> list = Arrays.asList(iConnectionModels.getHoConnectionModels());
            Network.this.db.println("Got " + list.size() + " HoConnModels");
            Iterator<IHoConnectionModel> iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                Object object;
                this.nodeList.clear();
                Network.this.neMap.clear();
                iterator = Network.instance().getNetLinks().iterator();
                Network.this.linkList.clear();
                while (iterator.hasNext()) {
                    object = (INetLink)iterator.next();
                    if (object.isLOTunnel() || Network.this.linkList.contains(object)) continue;
                    Network.this.linkList.add(object);
                }
                Network.this.db.println("Now LinkList for links has " + Network.this.linkList.size() + " links");
                IConnectionModel iConnectionModel = (IConnectionModel)iterator2.next();
                if (!this.selectConnForTrace(iConnectionModel, n2, 0, n)) continue;
                Network.this.db.println("Found one Sts Conn on the given slot and sts..");
                object = new DNode(iNetElement, iConnectionModel);
                this.nodeList.add(object);
                Network.this.neMap.put(new Integer(iNetElement.getNodeId()), object);
                ((DNode)object).populate();
                Network.this.db.println("Now Printing the TimeSLot trace for one connection..");
                ((DNode)object).toString();
                object = null;
            }
        }

        public final void traverseVt(String string, int n, int n2, int n3) {
            Object var7_5 = null;
            INetElement iNetElement = (INetElement)Network.this.netElemsByIp.get(string);
            Iterator iterator = null;
            Network.this.db.println("Traverse called on ne=" + iNetElement.getName() + " on slot " + n / 4096 + " on STS=" + n2 + " on VT=" + n3);
            IConnectionModels iConnectionModels = iNetElement.getNodeModel().getConnectionModels();
            List<ILoConnectionModel> list = Arrays.asList(iConnectionModels.getLoConnectionModels());
            Network.this.db.println("Got " + list.size() + " LoConnModels");
            Iterator<ILoConnectionModel> iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                Object object;
                this.nodeList.clear();
                Network.this.neMap.clear();
                iterator = Network.instance().getNetLinks().iterator();
                Network.this.linkList.clear();
                while (iterator.hasNext()) {
                    object = (INetLink)iterator.next();
                    if (object.isLOTunnel() || Network.this.linkList.contains(object)) continue;
                    Network.this.linkList.add(object);
                }
                Network.this.db.println("Now LinkList for links has " + Network.this.linkList.size() + " links");
                IConnectionModel iConnectionModel = (IConnectionModel)iterator2.next();
                if (!this.selectConnForTrace(iConnectionModel, n2, n3, n)) continue;
                Network.this.db.println("Found one Vt Conn on the given slot, sts and vt num..");
                object = new DNode(iNetElement, iConnectionModel);
                this.nodeList.add(object);
                Network.this.neMap.put(new Integer(iNetElement.getNodeId()), object);
                ((DNode)object).populate();
                Network.this.db.println("Now Printing the TimeSLot trace for one connection..");
                ((DNode)object).toString();
                object = null;
            }
        }

        private boolean selectConnForTrace(Object object, int n, int n2, int n3) {
            block3: {
                block2: {
                    if (!(object instanceof IHoConnectionModel) || n2 != 0) break block2;
                    IHoPathDefModel[] iHoPathDefModelArray = ((IHoConnectionModel)object).getPaths();
                    for (int i = 0; i < iHoPathDefModelArray.length; ++i) {
                        if (iHoPathDefModelArray[i].getStartingHo().getHoNum() != n || iHoPathDefModelArray[i].getPool().getEntityIndex() != n3) continue;
                        return true;
                    }
                    break block3;
                }
                if (!(object instanceof ILoConnectionModel) || n2 == 0) break block3;
                ILoDefModel[] iLoDefModelArray = ((ILoConnectionModel)object).getPaths();
                for (int i = 0; i < iLoDefModelArray.length; ++i) {
                    if (!(iLoDefModelArray[i].getLoNum() instanceof SonetLoNum) || ((SonetLoNum)iLoDefModelArray[i].getLoNum()).getVtNum() != n2 || iLoDefModelArray[i].getLoAdit().getHo().getStartingHo().getHoNum() != n || iLoDefModelArray[i].getPortIndex() != n3) continue;
                    return true;
                }
            }
            return false;
        }

        public final void setUser(String string, String string2) {
            this.user = new User(string, string2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void listTopoNEs() {
            this.println("Topology Hosts:");
            List list = Network.this.topoNEs;
            synchronized (list) {
                for (INetElement iNetElement : network.topoNEs) {
                    this.println("\t" + iNetElement.getName());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void dumpNEs() {
            this.println("Network Elements keyed by NodeId");
            this.println("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
            Map map = Network.this.netElems;
            synchronized (map) {
                for (Integer n : Network.this.netElems.keySet()) {
                    INetElement iNetElement = (INetElement)Network.this.netElems.get(n);
                    this.println(iNetElement.getName() + " nodeId " + Integer.toHexString(n) + " hostname " + iNetElement.getActualAddressDisplay() + " inited " + iNetElement.getNodeModel().isInited());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void dumpByIP() {
            this.println("Network Elements keyed by IP address");
            this.println("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
            Map map = Network.this.netElemsByIp;
            synchronized (map) {
                for (String string : Network.this.netElemsByIp.keySet()) {
                    INetElement iNetElement = (INetElement)Network.this.netElemsByIp.get(string);
                    this.println(iNetElement.getName() + " " + Network.this.getActualIpAddress(string));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void dumpNLs() {
            this.println("Network Links:");
            Map map = Network.this.allNetLinks;
            synchronized (map) {
                for (INetLink iNetLink : Network.this.allNetLinks.values()) {
                    this.println("\t" + iNetLink.prettyString());
                    this.println("\t\t" + iNetLink);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void dumpWaitQ() {
            Map map = Network.this.waitQ;
            synchronized (map) {
                Iterator iterator = Network.this.waitQ.values().iterator();
                if (Network.this.db.on()) {
                    Network.this.db.println("waitQ:");
                }
                while (iterator.hasNext()) {
                    NetElement netElement = (NetElement)iterator.next();
                    Network.this.db.println("    " + netElement.getName());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void dumpLimitedNodes() {
            if (Network.this.limitedNodes != null) {
                this.println("Network Elements:");
                List list = Network.this.limitedNodes;
                synchronized (list) {
                    for (String string : Network.this.limitedNodes) {
                        Network.this.db.println("    " + string);
                    }
                }
            } else {
                this.println("limitedNodes empty");
            }
        }

        public final void dumpTopologies() {
            this.println("Dumping Topologies:");
            for (Topology topology : Network.this.getTopologies()) {
                this.println("    Topology " + topology.getTopoId());
            }
        }

        public final void addNE(String string, String string2, String string3) {
            if (Network.this.db.on()) {
                Network.this.db.println("addNE: manually adding NE " + Network.this.getActualIpAddress(string) + ", user= " + string2 + ", password= " + string3);
            }
            try {
                NetworkModel.instance().addNetElementBlocking(string, string2, string3, false);
                NetworkModel.instance().setUser(string2, string3);
            }
            catch (UnknownHostException unknownHostException) {
                Network.this.db.println("addNE: caught UnknownHostException, e = " + unknownHostException);
            }
            Network.this.db.println("addNE: manually added topo host");
        }

        public final void addNE(String string) {
            if (Network.this.db.on()) {
                Network.this.db.println("addNE: manually adding NE " + Network.this.getActualIpAddress(string));
            }
            this.addNE(string, defaultUserName, defaultPassword);
            Network.this.db.println("addNE: manually added topo host");
        }

        public final void createTopo(String string) {
            Network.this.db.println("createTopo: creating Topo with topo host " + string);
            INetElement iNetElement = null;
            try {
                iNetElement = Network.this.addNetElement(string, defaultUserName, defaultPassword);
                NetworkModel.instance().setUser(defaultUserName, defaultPassword);
            }
            catch (UnknownHostException unknownHostException) {
                Network.this.db.println("createTopo: caught UnknownHostException, e = " + unknownHostException);
            }
            Network.this.createTopology(iNetElement);
        }

        public final void delTopo(String string) {
            Network.this.db.println("delTopo: deleting topo containing NE " + string);
            INetElement iNetElement = null;
            try {
                InetAddress inetAddress = InetAddress.getByName(string);
                iNetElement = Network.this.findNetElemByIp(inetAddress.getHostAddress());
            }
            catch (UnknownHostException unknownHostException) {
                Network.this.db.println("delTopo: caught exception, e = " + unknownHostException);
            }
            if (iNetElement != null) {
                Network.this.deleteTopology(iNetElement);
            }
        }

        public final void dumpObservers() {
            Network.this.db.println("Network observers:");
            Network.this.printObservers();
            Network.this.db.println("NetElementCreationNotifier observers:");
            Network.this.netElementCreationNotifier.printObservers();
            Network.this.db.println("NetLinkCreationNotifier observers:");
            Network.this.netLinkCreationNotifier.printObservers();
        }

        public final void deleteNE(String string) {
            INetElement iNetElement = null;
            try {
                InetAddress inetAddress = InetAddress.getByName(string);
                iNetElement = Network.this.findNetElemByIp(inetAddress.getHostAddress());
            }
            catch (UnknownHostException unknownHostException) {
                Network.this.db.println("deleteNE: caught exception, e = " + unknownHostException);
            }
            if (iNetElement != null) {
                if (Network.this.db.on()) {
                    Network.this.db.println("deleteNE: NE = " + iNetElement.getActualAddressDisplay());
                }
                try {
                    Network.this.deleteNetElement(iNetElement);
                }
                catch (NetElementDeletionException netElementDeletionException) {
                    Network.this.db.println("deleteNE: caught exception, e = " + (Object)((Object)netElementDeletionException));
                }
            } else {
                Network.this.db.println("deleteNE: NE = null");
            }
        }

        public final void blockedDeleteNE(String string) {
            INetElement iNetElement = null;
            try {
                InetAddress inetAddress = InetAddress.getByName(string);
                iNetElement = Network.this.findNetElemByIp(inetAddress.getHostAddress());
            }
            catch (UnknownHostException unknownHostException) {
                Network.this.db.println("deleteNE: caught exception, e = " + unknownHostException);
            }
            if (iNetElement != null) {
                if (Network.this.db.on()) {
                    Network.this.db.println("deleteNE: NE = " + iNetElement.getActualAddressDisplay());
                }
                try {
                    Network.this.deleteNetElementAndBlock(iNetElement);
                }
                catch (NetElementDeletionException netElementDeletionException) {
                    Network.this.db.println("deleteNE: caught exception, e = " + (Object)((Object)netElementDeletionException));
                }
            } else {
                Network.this.db.println("deleteNE: NE = null");
            }
        }

        public final void deleteNEAndConnectedNLs(String string) {
            INetElement iNetElement = null;
            try {
                InetAddress inetAddress = InetAddress.getByName(string);
                iNetElement = Network.this.findNetElemByIp(inetAddress.getHostAddress());
            }
            catch (UnknownHostException unknownHostException) {
                Network.this.db.println("deleteNEAndConnectedNLs: caught exception, e = " + unknownHostException);
            }
            if (iNetElement != null) {
                Network.this.deleteNetElementAndConnectedNetLinks(iNetElement);
            } else {
                Network.this.db.println("deleteNEAndConnectedNLs: NE = NULL");
            }
        }

        public final void createSrlg(String string, int n, String string2) {
            Object object;
            INetElement iNetElement = null;
            try {
                object = InetAddress.getByName(string);
                iNetElement = Network.this.findNetElemByIp(((InetAddress)object).getHostAddress());
            }
            catch (UnknownHostException unknownHostException) {
                Network.this.db.println("createSrlg: caught exception, e = " + unknownHostException.getMessage());
            }
            object = Network.this.findNetLinkFromEnt(iNetElement, n);
            if (object == null) {
                Network.this.db.println("createSrlg: No matching link found");
                return;
            }
            if (!(object instanceof NetLink)) {
                Network.this.db.println("createSrlg: Link not an instance of NetLink class");
                return;
            }
            NetLink netLink = (NetLink)object;
            if (string2.equals("X")) {
                try {
                    netLink.clearSrlg();
                    Network.this.db.println("createSrlg: Cleared SRLGs for:" + netLink.prettyStringDetail());
                    return;
                }
                catch (SanityCheckFailed sanityCheckFailed) {
                    Network.this.db.println("createSrlg: Exception in addSrlg , e = " + sanityCheckFailed.getMessage());
                }
            }
            try {
                GenericSrg genericSrg = new GenericSrg(string2);
                netLink.addSrlg(genericSrg);
                Network.this.db.println("createSrlg: Added SRLG " + string2 + " for: " + netLink.prettyStringDetail());
            }
            catch (SanityCheckFailed sanityCheckFailed) {
                Network.this.db.println("createSrlg: Exception in addSrlg , e = " + sanityCheckFailed.getMessage());
            }
        }

        public final void createPhantom(String string, int n, String string2, int n2) {
            block4: {
                INetElement iNetElement = null;
                INetElement iNetElement2 = null;
                try {
                    InetAddress inetAddress = InetAddress.getByName(string);
                    InetAddress inetAddress2 = InetAddress.getByName(string2);
                    iNetElement = Network.this.findNetElemByIp(inetAddress.getHostAddress());
                    iNetElement2 = Network.this.findNetElemByIp(inetAddress2.getHostAddress());
                }
                catch (UnknownHostException unknownHostException) {
                    Network.this.db.println("createPhantom: caught exception, e = " + unknownHostException.getMessage());
                }
                int n3 = 3;
                int n4 = 1;
                int n5 = 1000;
                try {
                    Network.this.createPhantomLink(iNetElement, iNetElement2, n, n2, n4, n3, n5);
                }
                catch (PhantomLinkException phantomLinkException) {
                    if (!Network.this.db.on()) break block4;
                    Network.this.db.println("createPhantom: caught exception, e = " + phantomLinkException.getMessage());
                }
            }
        }

        public final void deletePhantom(String string, int n, String string2, int n2) {
            block7: {
                Object object;
                Object object2;
                INetElement iNetElement = null;
                INetElement iNetElement2 = null;
                try {
                    object2 = InetAddress.getByName(string);
                    object = InetAddress.getByName(string2);
                    iNetElement = Network.this.findNetElemByIp(((InetAddress)object2).getHostAddress());
                    iNetElement2 = Network.this.findNetElemByIp(((InetAddress)object).getHostAddress());
                }
                catch (UnknownHostException unknownHostException) {
                    Network.this.db.println("deletePhantom: caught exception, e = " + unknownHostException);
                    return;
                }
                object2 = Network.this.findNetLink(iNetElement, n, null, iNetElement2, n2, null, false, 3);
                if (object2 == null) {
                    Network.this.db.println("deletePhantom: cannot find phantom link to destroy");
                } else {
                    try {
                        object = Network.this.findReverseLink((INetLink)object2);
                        Network.this.deletePhantomLink((INetLink)object2);
                        if (object != null) {
                            Network.this.deletePhantomLink((INetLink)object);
                        }
                    }
                    catch (PhantomLinkException phantomLinkException) {
                        if (!Network.this.db.on()) break block7;
                        Network.this.db.println("deletePhantom: caught exception, e = \n" + phantomLinkException.getMessage());
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void dumpServerTrails() {
            Network.this.db.println("ServerTrail Links:");
            Object object = Network.this.masterTrailLock;
            synchronized (object) {
                for (ServerTrailLink serverTrailLink : Network.this.svTrailLinks.values()) {
                    Network.this.db.println("    " + serverTrailLink.prettyStringDetail());
                }
            }
        }

        public final void refreshTopo() {
            ThreadPool.instance().enqueueClient((IActionClient)this);
        }

        public void dumpDiag() {
            this.dump();
        }

        public final void ciruitDiscovery(boolean bl) {
            Network.this.setEnableCircuitDiscovery(bl);
        }

        public void doAction() {
            Network.this.refresh();
        }

        public void failedAction(IThreadWorker iThreadWorker) {
        }
    }

    public class TopologyCreationNotifier
    extends UObservable {
        protected void changed(Topology topology) {
            if (Network.this.db.on()) {
                Network.this.db.println("changed: notifying observers about new topo " + topology.getTopoId());
            }
            this.setChanged();
            this.notifyObservers(topology);
        }
    }

    public class TrailIdComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            IServerTrailLinkId iServerTrailLinkId = (IServerTrailLinkId)object;
            IServerTrailLinkId iServerTrailLinkId2 = (IServerTrailLinkId)object2;
            return ((ServerTrailLinkId)iServerTrailLinkId).compareTo(iServerTrailLinkId2);
        }
    }
}

