/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.model.AddNode2OnePlusOneModel;
import cerent.cms.model.ElementModels;
import cerent.cms.model.Feature;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IOhTermModel;
import cerent.cms.model.IOnePlusOneModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.ITdmPortModel;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.Network;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.AddNode2OnePlusOneDialog;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NetCSHelpConst;
import cerent.cms.ui.WizardPane;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.IPAddressTranslator;
import cerent.util.NEMC;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.MultiLineLabelUI;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.plaf.LabelUI;

public class AndStepPane
extends WizardPane {
    static final int INFO_PAGE_1 = 100;
    static final int INFO_PAGE_2 = 101;
    static final int STEP_DISABLE_PROT = 2;
    static final int STEP_REFIBER_PROTECT = 3;
    static final int STEP_UPDATE_CIRCUIT = 4;
    static final int UNREACHABLE_NODE_LAST_PAGE = 9;
    static final int REACHABLE_NODE_LAST_PAGE = 8;
    private JLabel bigLabel;
    private String clickNext = ".\n \n \nWhen you are ready, click Next.";
    private int step;
    private AddNode2OnePlusOneDialog parent;
    private boolean circuitUpdated = false;

    public AndStepPane(String string, AddNode2OnePlusOneDialog addNode2OnePlusOneDialog, int n) {
        super(string, addNode2OnePlusOneDialog);
        this.parent = addNode2OnePlusOneDialog;
        this.step = n;
        if (n == 100) {
            this.setInfoPane1();
        } else if (n == 101) {
            this.setInfoPane2();
        } else {
            this.setNextPane();
        }
    }

    private JPanel getInfoPane1() {
        JPanel jPanel = new JPanel(new FlowLayout(0));
        String string = "You are about to add a node between " + this.parent.getSrcNodeName() + " and " + this.parent.getDstNodeName() + ". Do not begin until\nyou verify the following:\n" + "- The terminal network has no critical or major alarms.\n" + "- The node that you will add has no critical or major alarms.\n" + "- The node has compatible software version with that of the terminal nodes.\n" + "- The node has four unused optical ports matching the speed of the 1+1 protection\n" + "  and no communication channel or circuit has been provisioned on these four ports.\n" + "- Fiber is available to connect the added node to " + this.parent.getSrcNodeName() + " and " + this.parent.getDstNodeName() + ".\n \n" + "CAUTION: Traffic is not protected during this upgrade and any problem during the\n" + "upgrade can be service affecting.\n";
        JLabel jLabel = new JLabel(string);
        jLabel.setUI((LabelUI)new MultiLineLabelUI());
        jPanel.add(jLabel);
        return jPanel;
    }

    private JPanel getInfoPane2() {
        JPanel jPanel = new JPanel(new FlowLayout(0));
        String string = "To add a node that is not reachable from your computer, you must log into\nthe node on-site and do the following:\n- Create a 1+1 protection group for the optical cards that will connect to " + this.parent.getSrcNodeName() + "\n  and a 1+1 protection group that will connect to " + this.parent.getDstNodeName() + ".\n" + "- Provision the two protect ports to the " + this.parent.tdmTerm.getTermForAdminState(0) + " state and the two working\n  " + "ports to the " + this.parent.tdmTerm.getTermForAdminState(1) + " state for the two protection groups above.\n " + "- Create DCC terminations on the working ports that will connect to\n  " + this.parent.getSrcNodeName() + " and " + this.parent.getDstNodeName() + ".\n";
        JLabel jLabel = new JLabel(string);
        jLabel.setUI((LabelUI)new MultiLineLabelUI());
        jPanel.add(jLabel);
        return jPanel;
    }

    private JPanel getBottomPane1() {
        JPanel jPanel = new JPanel(new FlowLayout(0));
        String string = "If you wish to continue, click Next.";
        JLabel jLabel = new JLabel(string);
        jLabel.setUI((LabelUI)new MultiLineLabelUI());
        jPanel.add(jLabel);
        return jPanel;
    }

    private JPanel getBottomPane2() {
        JPanel jPanel = new JPanel(new FlowLayout(0));
        String string = "When all the above provisioning has been done on the node " + this.parent.newNodeName + ", click Next.";
        JLabel jLabel = new JLabel(string);
        jLabel.setUI((LabelUI)new MultiLineLabelUI());
        jPanel.add(jLabel);
        return jPanel;
    }

    private void setInfoPane1() {
        this.setLayout(new BoxLayout((Container)((Object)this), 1));
        this.add(this.getInfoPane1());
        this.add(this.getBottomPane1());
    }

    private void setInfoPane2() {
        this.setLayout(new BoxLayout((Container)((Object)this), 1));
        this.add(this.getInfoPane2());
        this.add(this.getBottomPane2());
    }

    private void setNextPane() {
        this.setLayout(new FlowLayout(0));
        this.add(this.getDescPane());
    }

    public JPanel getDescPane() {
        JPanel jPanel = new JPanel();
        this.bigLabel = new JLabel(this.getDesc());
        this.bigLabel.setUI((LabelUI)new MultiLineLabelUI());
        jPanel.add(this.bigLabel);
        return jPanel;
    }

    private String getDesc() {
        String string = "";
        String string2 = "The system is about to force the traffic from the working to the protect path\nfor the nodes " + this.parent.getSrcNodeName() + " and " + this.parent.getDstNodeName() + ".";
        String string3 = "The system is about to force the traffic from the protect to the working path\nfor the nodes " + this.parent.getSrcNodeName() + ", " + this.parent.getDstNodeName() + " and " + this.parent.newNodeName + ".";
        String string4 = "The system is now updating circuits on the node " + this.parent.newNodeName + ".";
        String string5 = "One or more circuits have been updated on the node " + this.parent.newNodeName + ".\n \n \nClick Next to continue.";
        String string6 = "You have finished upgrading from terminal to linear protection.\nBefore clicking Finish, ensure that " + this.parent.newNodeName + " is added to the working path\n" + "and there are no critical or major alarms on the nodes\n" + this.parent.getSrcNodeName() + ", " + this.parent.getDstNodeName() + " and " + this.parent.newNodeName + ".";
        switch (this.step) {
            case 2: {
                if (!this.parent.isNodeUnreachable()) break;
                string = "The system is about to disable the traffic protection temporarily in order to\ndiscover the node " + this.parent.newNodeName + this.clickNext;
                break;
            }
            case 3: {
                if (this.parent.isNodeUnreachable()) {
                    string = "Connect the fibers from the two protect ports of the node " + this.parent.newNodeName + " to slot" + this.parent.srcProtectSlot + ",\nport " + this.parent.srcProtectPort + " on the node " + this.parent.getSrcNodeName() + " and slot " + this.parent.dstProtectSlot + ", port " + this.parent.dstProtectPort + " on the node " + this.parent.getDstNodeName() + ". CTC will automatically\n" + "connect to the node " + this.parent.newNodeName + " and enable the Next button. This may take up\n" + "to 60 seconds after the re-fiber is done.\n \n \n" + "Click Next to continue.";
                    break;
                }
                string = "Connect the fibers from slot " + this.parent.srcProtectSlot + ", port " + this.parent.srcProtectPort + " on the node " + this.parent.getSrcNodeName() + " to slot " + this.parent.protectModel1.getSlot() + ", port " + this.parent.entityCellRenderer.getPortString(this.parent.protectModel1, false) + "\non the node " + this.parent.newNodeName + "; from slot " + this.parent.dstProtectSlot + ", port " + this.parent.dstProtectPort + " on the node " + this.parent.getDstNodeName() + " to slot " + this.parent.protectModel2.getSlot() + ", port " + this.parent.entityCellRenderer.getPortString(this.parent.protectModel2, false) + "\non the node " + this.parent.newNodeName + ".\n \n \n" + "When the fibers are properly connected, click Next.";
                break;
            }
            case 4: {
                if (!this.circuitUpdated) {
                    string = string4;
                    break;
                }
                string = string5;
                break;
            }
            case 5: {
                if (this.parent.isNodeUnreachable()) {
                    string = "The system is about to restore the traffic protection disabled in Step 2 on the node\n" + this.parent.newNodeName + this.clickNext;
                    break;
                }
                string = string2 + this.clickNext;
                break;
            }
            case 6: {
                if (this.parent.isNodeUnreachable()) {
                    string = string2 + this.clickNext;
                    break;
                }
                string = "After the DCC link shows that " + this.parent.newNodeName + " has been added to the protect path,\n" + "connect the fibers from slot " + this.parent.srcWorkSlot + ", port " + this.parent.srcWorkPort + " on the node " + this.parent.getSrcNodeName() + " to slot " + this.parent.workModel1.getSlot() + ", port " + this.parent.entityCellRenderer.getPortString(this.parent.workModel1, false) + "\non the  node " + this.parent.newNodeName + "; from slot " + this.parent.dstWorkSlot + ", port " + this.parent.dstWorkPort + " on the node " + this.parent.getDstNodeName() + " to slot " + this.parent.workModel2.getSlot() + ", port " + this.parent.entityCellRenderer.getPortString(this.parent.workModel2, false) + "\non the node " + this.parent.newNodeName + ". Traffic will again be unprotected until the re-fiber\n" + "is done.\n \n \n" + "When the fibers are properly connected, click Next.";
                break;
            }
            case 7: {
                if (this.parent.isNodeUnreachable()) {
                    string = "Connect the fibers from the two working ports of the node " + this.parent.newNodeName + " to slot" + this.parent.srcWorkSlot + ",\nport " + this.parent.srcWorkPort + " on the node " + this.parent.getSrcNodeName() + " and slot " + this.parent.dstWorkSlot + ", port " + this.parent.dstWorkPort + " on the node " + this.parent.getDstNodeName() + ". Traffic will again\n" + "be unprotected until the re-fiber is done.\n \n \n" + "When the fibers are properly connected, click Next.";
                    break;
                }
                string = string3 + this.clickNext;
                break;
            }
            case 8: {
                if (this.parent.isNodeUnreachable()) {
                    string = string3 + this.clickNext;
                    break;
                }
                string = string6;
                break;
            }
            case 9: {
                string = string6;
            }
        }
        return string;
    }

    private void restoreProtectionNDeleteDCC() throws Exception {
        Set set = null;
        boolean bl = false;
        if (!this.parent.protectionRestored) {
            int n;
            IOhTermModel iOhTermModel = this.parent.srcTermConnModel.getTermModel(this.parent.srcProtectModel.getIndex());
            IOhTermModel iOhTermModel2 = this.parent.dstTermConnModel.getTermModel(this.parent.dstProtectModel.getIndex());
            this.parent.srcTermConnModel.deleteTermination(iOhTermModel);
            this.parent.dstTermConnModel.deleteTermination(iOhTermModel2);
            this.waitThreeSecond();
            this.parent.srcNodeModel.getIElementModels().createOnePlusOne(this.parent.srcWorkIndex, this.parent.srcProtectIndex, this.parent.rbr, false, ElementModels.truncateString(this.parent.srcPrtName));
            this.parent.dstNodeModel.getIElementModels().createOnePlusOne(this.parent.dstWorkIndex, this.parent.dstProtectIndex, this.parent.rbr, false, ElementModels.truncateString(this.parent.dstPrtName));
            for (n = 0; n < 20; ++n) {
                set = this.parent.srcNodeModel.getIElementModels().getOnePlusOneElements();
                for (IOnePlusOneModel iOnePlusOneModel : set) {
                    if (iOnePlusOneModel.getWorkingEntityIndex() != this.parent.srcWorkIndex) continue;
                    this.parent.sopo = iOnePlusOneModel;
                    bl = true;
                    break;
                }
                if (bl) break;
                this.waitHalfSecond();
            }
            if (!bl) {
                throw new Exception("An error occurred while trying to restore the source's 1+1 protection.");
            }
            bl = false;
            for (n = 0; n < 20; ++n) {
                set = this.parent.dstNodeModel.getIElementModels().getOnePlusOneElements();
                for (IOnePlusOneModel iOnePlusOneModel : set) {
                    if (iOnePlusOneModel.getWorkingEntityIndex() != this.parent.dstWorkIndex) continue;
                    this.parent.dopo = iOnePlusOneModel;
                    bl = true;
                    break;
                }
                if (bl) break;
                this.waitHalfSecond();
            }
            if (!bl) {
                throw new Exception("An error occurred while trying to restore the destination's 1+1 protection.");
            }
            this.parent.protectionRestored = true;
        }
    }

    private void deleteProtectionNCreateDCC() throws Exception {
        this.parent.sopo.delete();
        this.parent.dopo.delete();
        Boolean bl = true;
        this.parent.srcTermConnModel.createTermination(this.parent.srcProtectModel, new Serializable[]{bl, Boolean.FALSE});
        this.parent.dstTermConnModel.createTermination(this.parent.dstProtectModel, new Serializable[]{bl, Boolean.FALSE});
        this.parent.protectionRestored = false;
    }

    private void waitHalfSecond() throws Exception {
        Thread.sleep(500L);
    }

    private void waitTwoSecond() throws Exception {
        Thread.sleep(2000L);
    }

    private void waitThreeSecond() throws Exception {
        Thread.sleep(3000L);
    }

    private void waitFiveSecond() throws Exception {
        Thread.sleep(5000L);
    }

    private void verifyLosNSf(IEntityModel iEntityModel, String string, IEntityModel iEntityModel2, String string2) throws Exception {
        String string3 = "";
        if (iEntityModel.conditionExist("LOS")) {
            string3 = "\n" + string + ", slot " + iEntityModel.getSlot() + ", port " + this.parent.entityCellRenderer.getPortString(iEntityModel, false);
        }
        if (iEntityModel2.conditionExist("LOS")) {
            string3 = string3 + "\n" + string2 + ", slot " + iEntityModel2.getSlot() + ", port " + this.parent.entityCellRenderer.getPortString(iEntityModel2, false);
        }
        if (string3.length() > 0) {
            throw new Exception("Please resolve the loss of signal on  " + string3 + "\nbefore switching traffic.");
        }
        String string4 = "";
        if (iEntityModel.conditionExist("SF-L")) {
            string4 = "\n" + string + ", slot " + iEntityModel.getSlot() + ", port " + this.parent.entityCellRenderer.getPortString(iEntityModel, false);
        }
        if (iEntityModel2.conditionExist("SF-L")) {
            string4 = string4 + "\n" + string2 + ", slot " + iEntityModel2.getSlot() + ", port " + this.parent.entityCellRenderer.getPortString(iEntityModel2, false);
        }
        if (string4.length() > 0) {
            throw new Exception("Please resolve the signal failure on  " + string4 + "\nbefore switching traffic.");
        }
    }

    private void verifySd(IEntityModel iEntityModel, String string, IEntityModel iEntityModel2, String string2) throws Exception {
        String string3 = "";
        if (iEntityModel.conditionExist("SD-L")) {
            string3 = "\n" + string + ", slot " + iEntityModel.getSlot() + ", port " + this.parent.entityCellRenderer.getPortString(iEntityModel, false);
        }
        if (iEntityModel2.conditionExist("SD-L")) {
            string3 = string3 + "\n" + string2 + ", slot " + iEntityModel2.getSlot() + ", port " + this.parent.entityCellRenderer.getPortString(iEntityModel2, false);
        }
        if (string3.length() > 0 && !CerentDialog.yesNoDialog((Component)((Object)this), (String)(string3 + "\nhas a signal degrade." + "\nThe recommendation is to press No and resolve the signal degrade." + "\nPressing Yes will cause traffic loss after the switch."), (String)"Signal Degrade")) {
            throw new Exception("Please resolve the signal degrade on " + string3 + "\nbefore switching traffic.");
        }
    }

    private void switchToWorking(IOnePlusOneModel iOnePlusOneModel) throws Exception {
        if (iOnePlusOneModel.getNodeModel().provides(Feature.SET_PROTECTION_1P1)) {
            iOnePlusOneModel.setProtection(5);
        } else {
            iOnePlusOneModel.setForceSwitchToWorking();
        }
    }

    private void switchAddNodeToWorking() throws Exception {
        this.switchToWorking(this.parent.addOpo1);
        this.waitFiveSecond();
        this.switchToWorking(this.parent.addOpo2);
        this.waitFiveSecond();
    }

    private void switchAddNodeToProtect() throws Exception {
        this.parent.addOpo1.setForceSwitchToProtect();
        this.waitFiveSecond();
        this.parent.addOpo2.setForceSwitchToProtect();
        this.waitFiveSecond();
    }

    private boolean clearAddNodeProtection() throws Exception {
        boolean bl = false;
        if (!this.parent.addOpo1.isClear()) {
            this.parent.addOpo1.setClear();
            bl = true;
        }
        if (!this.parent.addOpo2.isClear()) {
            this.parent.addOpo2.setClear();
            bl = true;
        }
        return bl;
    }

    private void switchToWorking() throws Exception {
        this.switchToWorking(this.parent.sopo);
        this.waitFiveSecond();
        this.switchToWorking(this.parent.dopo);
        this.waitFiveSecond();
    }

    private void switchToProtect() throws Exception {
        this.parent.sopo.setForceSwitchToProtect();
        this.waitFiveSecond();
        this.parent.dopo.setForceSwitchToProtect();
        this.waitFiveSecond();
    }

    private boolean clearProtection() throws Exception {
        boolean bl = false;
        if (!this.parent.sopo.isClear()) {
            this.parent.sopo.setClear();
            bl = true;
        }
        if (!this.parent.dopo.isClear()) {
            this.parent.dopo.setClear();
            bl = true;
        }
        return bl;
    }

    private void verifyRefiber(boolean bl) throws Exception {
        String string;
        Iterator iterator = Network.instance().getNetLinks().iterator();
        int n = 0;
        INetElement iNetElement = null;
        INetElement iNetElement2 = null;
        String string2 = string = bl ? " working " : " protect ";
        while (iterator.hasNext()) {
            INetLink iNetLink = (INetLink)iterator.next();
            if (!iNetLink.isPhysical()) continue;
            int n2 = iNetLink.getSrcEntityIndex();
            INodeModel iNodeModel = iNetLink.getSrc().getNodeModel();
            if (n2 == this.parent.srcWorkIndex && iNodeModel == this.parent.srcNodeModel) {
                if (iNetLink.state() == 2) {
                    throw new Exception("DCC link(s) have not been completely discovered yet. Please wait.");
                }
                iNetElement = iNetLink.getDst();
                if (iNetElement.getNodeModel() == this.parent.dstNodeModel) {
                    throw new Exception("No node has been added to the" + string + "path.");
                }
                ++n;
            }
            if (n2 == this.parent.dstWorkIndex && iNodeModel == this.parent.dstNodeModel) {
                if (iNetLink.state() == 2) {
                    throw new Exception("DCC link(s) have not been completely discovered yet. Please wait.");
                }
                iNetElement2 = iNetLink.getDst();
                if (iNetElement2.getNodeModel() == this.parent.srcNodeModel) {
                    throw new Exception("No node has been added to the" + string + "path.");
                }
                ++n;
            }
            if (n != 2) continue;
            String string3 = IPAddressTranslator.instance().getActualAddress(iNetElement.getHostName()).getHostAddress();
            String string4 = IPAddressTranslator.instance().getActualAddress(iNetElement2.getHostName()).getHostAddress();
            if (!this.parent.newHostName.equals(string3)) {
                throw new Exception(iNetElement.getName() + " is not the node previously specified (" + this.parent.newNodeName + ").");
            }
            if (this.parent.newHostName.equals(string4)) break;
            throw new Exception(iNetElement2.getName() + " is not the node previously specified (" + this.parent.newNodeName + ").");
        }
        if (n != 2) {
            throw new Exception(this.parent.newNodeName + " has not been completely added to the" + string + "path.");
        }
    }

    private void undoStep2() throws Exception {
        if (this.parent.isNodeUnreachable()) {
            this.restoreProtectionNDeleteDCC();
        } else {
            AddNode2OnePlusOneModel addNode2OnePlusOneModel = AddNode2OnePlusOneModel.instance();
            addNode2OnePlusOneModel.rollBackDccAndOnePlusOne(this.parent.newNetElement.getNodeModel(), this.parent.isLdccLink, this.parent.workModel1, this.parent.protectModel1, this.parent.workModel2, this.parent.protectModel2);
            this.parent.addOpo1 = null;
            this.parent.addOpo2 = null;
        }
        if (!((ITdmPortModel)this.parent.srcWorkModel).isPortActive() || !((ITdmPortModel)this.parent.dstWorkModel).isPortActive()) {
            this.clearProtection();
            this.waitTwoSecond();
            this.switchToWorking();
            this.clearProtection();
        }
    }

    private void performStep2() throws Exception {
        if (this.parent.isNodeUnreachable()) {
            this.deleteProtectionNCreateDCC();
            this.parent.setStatusText("-Traffic unprotected on working path\n");
        }
    }

    private void performStep3() throws Exception {
        this.parent.setStatusText("-Protect path re-fibered\n");
    }

    private void performStep4() throws Exception {
        this.parent.setStatusText("-Circuit(s) updated\n");
    }

    private void performStep5() throws Exception {
        if (this.parent.isNodeUnreachable()) {
            this.verifyLosNSf(this.parent.protectModel1, this.parent.newNodeName, this.parent.protectModel2, this.parent.newNodeName);
            this.verifySd(this.parent.protectModel1, this.parent.newNodeName, this.parent.protectModel2, this.parent.newNodeName);
            this.switchAddNodeToProtect();
            this.restoreProtectionNDeleteDCC();
            this.parent.setStatusText("-Traffic protection restored\n");
        } else {
            if (this.clearAddNodeProtection() | this.clearProtection()) {
                this.waitFiveSecond();
            }
            this.verifyLosNSf(this.parent.protectModel1, this.parent.newNodeName, this.parent.protectModel2, this.parent.newNodeName);
            this.verifyLosNSf(this.parent.srcProtectModel, this.parent.getSrcNodeName(), this.parent.dstProtectModel, this.parent.getDstNodeName());
            this.verifySd(this.parent.protectModel1, this.parent.newNodeName, this.parent.protectModel2, this.parent.newNodeName);
            this.verifySd(this.parent.srcProtectModel, this.parent.getSrcNodeName(), this.parent.dstProtectModel, this.parent.getDstNodeName());
            this.switchToProtect();
            this.switchAddNodeToProtect();
            this.parent.setStatusText("-Traffic forced to protect path\n");
        }
    }

    private void performStep6() throws Exception {
        if (this.parent.isNodeUnreachable()) {
            if (this.clearProtection()) {
                this.waitFiveSecond();
            }
            this.verifyLosNSf(this.parent.srcProtectModel, this.parent.getSrcNodeName(), this.parent.dstProtectModel, this.parent.getDstNodeName());
            this.verifySd(this.parent.srcProtectModel, this.parent.getSrcNodeName(), this.parent.dstProtectModel, this.parent.getDstNodeName());
            this.switchToProtect();
            this.parent.setStatusText("-Traffic forced to protect path\n");
        } else {
            this.verifyRefiber(false);
            this.parent.setStatusText("-Working path re-fibered\n");
        }
    }

    private void performStep7() throws Exception {
        if (this.parent.isNodeUnreachable()) {
            this.parent.setStatusText("-Working path re-fibered\n");
        } else {
            if (this.clearAddNodeProtection() | this.clearProtection()) {
                this.waitFiveSecond();
            }
            this.verifyLosNSf(this.parent.workModel1, this.parent.newNodeName, this.parent.workModel2, this.parent.newNodeName);
            this.verifyLosNSf(this.parent.srcWorkModel, this.parent.getSrcNodeName(), this.parent.dstProtectModel, this.parent.getDstNodeName());
            this.verifySd(this.parent.workModel1, this.parent.newNodeName, this.parent.workModel2, this.parent.newNodeName);
            this.verifySd(this.parent.srcWorkModel, this.parent.getSrcNodeName(), this.parent.dstWorkModel, this.parent.getDstNodeName());
            this.switchAddNodeToWorking();
            this.switchToWorking();
            this.waitTwoSecond();
            this.clearAddNodeProtection();
            this.clearProtection();
            this.parent.setStatusText("-Traffic forced to working path\n");
        }
    }

    private void performStep8() throws Exception {
        if (this.parent.isNodeUnreachable()) {
            if (this.clearAddNodeProtection() | this.clearProtection()) {
                this.waitFiveSecond();
            }
            this.verifyLosNSf(this.parent.workModel1, this.parent.newNodeName, this.parent.workModel2, this.parent.newNodeName);
            this.verifyLosNSf(this.parent.srcWorkModel, this.parent.getSrcNodeName(), this.parent.dstWorkModel, this.parent.getDstNodeName());
            this.verifySd(this.parent.workModel1, this.parent.newNodeName, this.parent.workModel2, this.parent.newNodeName);
            this.verifySd(this.parent.srcWorkModel, this.parent.getSrcNodeName(), this.parent.dstWorkModel, this.parent.getDstNodeName());
            this.switchAddNodeToWorking();
            this.switchToWorking();
            this.waitTwoSecond();
            this.clearAddNodeProtection();
            this.clearProtection();
            this.parent.setStatusText("-Traffic forced to working path\n");
        } else {
            this.verifyRefiber(true);
        }
    }

    private void performStep9() throws Exception {
        if (this.parent.isNodeUnreachable()) {
            this.verifyRefiber(true);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void validatePage() throws Exception {
        try {
            this.parent.setStatusText("");
            this.parent.setCursor(new Cursor(3));
            switch (this.step) {
                case 2: {
                    this.performStep2();
                    if (!this.parent.isNodeUnreachable()) return;
                    this.parent.addRefiberProtectPane();
                    return;
                }
                case 3: {
                    this.performStep3();
                    if (this.parent.isNodeUnreachable()) {
                        this.parent.addUnreachableNodePanes();
                        return;
                    }
                    this.parent.addReachableNodePanes();
                    return;
                }
                case 4: {
                    this.performStep4();
                    return;
                }
                case 5: {
                    this.performStep5();
                    return;
                }
                case 6: {
                    this.performStep6();
                    return;
                }
                case 7: {
                    this.performStep7();
                    return;
                }
                case 8: {
                    this.performStep8();
                    return;
                }
                case 9: {
                    this.performStep9();
                    return;
                }
                case 100: {
                    this.parent.sanityCheck();
                    return;
                }
                case 101: {
                    this.parent.addDisableProtectPane();
                    return;
                }
            }
            return;
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            throw exception;
        }
        finally {
            this.parent.setCursor(new Cursor(0));
        }
    }

    @Override
    public void refresh() {
        if (this.step == 101 || this.step < 4) {
            this.parent.setBackEnabled(true);
        } else {
            this.parent.setBackEnabled(false);
        }
        if (this.step >= 100 || this.step < 4) {
            this.parent.setCancelEnabled(true);
        } else {
            this.parent.setCancelEnabled(false);
        }
        if (!(this.parent.isNodeUnreachable() && this.step == 3 || this.step == 4)) {
            this.parent.setNextEnabled(true);
        }
        if (this.parent.isNodeUnreachable() && this.step == 9 || !this.parent.isNodeUnreachable() && this.step == 8) {
            this.parent.setFinishEnabled(true);
            this.parent.setNextEnabled(false);
        }
        if (this.bigLabel != null) {
            this.bigLabel.setText(this.getDesc());
        }
    }

    @Override
    public void enteringPage() throws Exception {
        if (this.parent.isNodeUnreachable() && this.step == 3) {
            NodeDiscover nodeDiscover = new NodeDiscover(this);
            nodeDiscover.start();
        } else if (this.step == 4) {
            this.circuitUpdated = false;
            CircuitUpdater circuitUpdater = new CircuitUpdater(this);
            circuitUpdater.start();
        }
    }

    @Override
    protected String getStatusText() {
        return this.parent.getStatusText();
    }

    @Override
    public void handleCancel() {
        try {
            switch (this.step) {
                case 5: 
                case 6: 
                case 7: {
                    CerentDialog.warningDialog((Component)((Object)this), (String)ErrorMsg.getString((EID)NEMC.WID_PROT_UPGRADE_CANCELLED));
                }
                case 3: 
                case 4: {
                    this.undoStep2();
                }
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            CerentDialog.errorDialog((Component)((Object)this), (Exception)exception, (String)(this.getName() + " Error"));
        }
    }

    @Override
    public CSHelpID getHelpID() {
        return NetCSHelpConst.AndStepPane;
    }

    public class CircuitUpdater
    extends Thread {
        private AndStepPane asp;

        public CircuitUpdater(AndStepPane andStepPane2) {
            this.asp = andStepPane2;
        }

        @Override
        public void run() {
            int n = 0;
            int n2 = 0;
            Network network = Network.instance();
            INetLink iNetLink = network.findNetLink(((AndStepPane)AndStepPane.this).parent.netLink.getSrc(), ((AndStepPane)AndStepPane.this).parent.srcWorkModel.getEntityIndex(), null, ((AndStepPane)AndStepPane.this).parent.netLink.getDst(), ((AndStepPane)AndStepPane.this).parent.dstWorkModel.getEntityIndex(), null, true, 1);
            INetLink iNetLink2 = network.findReverseLink(iNetLink);
            NetCircuitManager netCircuitManager = NetCircuitManager.instance();
            n = netCircuitManager.getCircuitsNotUsingLap(iNetLink).size();
            n += netCircuitManager.getCircuitsNotUsingLap(iNetLink2).size();
            this.asp.parent.setNextEnabled(false);
            do {
                try {
                    n2 += netCircuitManager.addNodeToOnePlusOne(((AndStepPane)AndStepPane.this).parent.newNetElement, ((AndStepPane)AndStepPane.this).parent.workModel1, ((AndStepPane)AndStepPane.this).parent.workModel2, ((AndStepPane)AndStepPane.this).parent.netLink.getSrc(), ((AndStepPane)AndStepPane.this).parent.srcWorkModel, ((AndStepPane)AndStepPane.this).parent.netLink.getDst(), ((AndStepPane)AndStepPane.this).parent.dstWorkModel);
                }
                catch (Exception exception) {
                    AbstractPane.db.println("addNodeToOnePlusOne failed: " + exception);
                    if (AbstractPane.db.on()) {
                        SDebug.printStackTrace((Throwable)exception);
                    }
                    CerentDialog.errorDialog((Component)this.asp.parent, (Exception)exception, (String)"Circuit(s) Update Error");
                }
            } while (n2 < n);
            this.asp.circuitUpdated = true;
            this.asp.refresh();
            if (n > 0) {
                try {
                    CircuitUpdater.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.asp.parent.setNextEnabled(true);
        }
    }

    public class NodeDiscover
    extends Thread {
        private AndStepPane asp;

        public NodeDiscover(AndStepPane andStepPane2) {
            this.asp = andStepPane2;
        }

        @Override
        public void run() {
            INetElement iNetElement = null;
            INetElement iNetElement2 = null;
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            boolean bl = true;
            this.asp.parent.setNextEnabled(false);
            while (true) {
                Network network = Network.instance();
                Collection collection = network.getNetLinks();
                Iterator iterator = collection.iterator();
                n3 = 0;
                bl = true;
                while (iterator.hasNext()) {
                    INetLink iNetLink = (INetLink)iterator.next();
                    int n4 = iNetLink.getSrcEntityIndex();
                    INodeModel iNodeModel = iNetLink.getSrc().getNodeModel();
                    if (n4 == ((AndStepPane)this.asp).parent.srcProtectIndex && iNodeModel == ((AndStepPane)this.asp).parent.srcNodeModel) {
                        iNetElement = iNetLink.getDst();
                        n = iNetLink.getDstEntityIndex();
                        ++n3;
                        if (iNetElement.getNodeModel() == ((AndStepPane)this.asp).parent.dstNodeModel) {
                            bl = false;
                        }
                    }
                    if (n4 == ((AndStepPane)this.asp).parent.dstProtectIndex && iNodeModel == ((AndStepPane)this.asp).parent.dstNodeModel) {
                        iNetElement2 = iNetLink.getDst();
                        n2 = iNetLink.getDstEntityIndex();
                        ++n3;
                        if (iNetElement2.getNodeModel() == ((AndStepPane)this.asp).parent.srcNodeModel) {
                            bl = false;
                        }
                    }
                    if (n3 != 2) continue;
                    if (iNetElement == iNetElement2) {
                        if (!iNetElement.getNodeModel().isInited()) break;
                        if (!iNetElement.getNodeModel().provides(Feature.ADDNODE2OPO)) {
                            ErrorMsg.displayError((Component)this.asp.parent, (EID)NEMC.WID_ADD_NODE_2_OPO_NOT_SUPPORTED_PARAM_1, (Object)((AndStepPane)this.asp).parent.newNodeName);
                            return;
                        }
                        Set set = iNetElement.getNodeModel().getIElementModels().getOnePlusOneElements();
                        Iterator iterator2 = set.iterator();
                        try {
                            while (iterator2.hasNext()) {
                                IOnePlusOneModel iOnePlusOneModel = (IOnePlusOneModel)iterator2.next();
                                if (iOnePlusOneModel.getWorkingEntityIndex() == n) {
                                    if (iOnePlusOneModel.isBidirectional()) {
                                        iOnePlusOneModel.setBidirectional(false);
                                    }
                                    ((AndStepPane)this.asp).parent.addOpo1 = iOnePlusOneModel;
                                    ((AndStepPane)this.asp).parent.workModel1 = iNetElement.getNodeModel().getEntityTable().getEntityModelByIndex(iOnePlusOneModel.getWorkingEntityIndex());
                                    ((AndStepPane)this.asp).parent.protectModel1 = iNetElement.getNodeModel().getEntityTable().getEntityModelByIndex(iOnePlusOneModel.getProtectEntityIndex());
                                    ((IPortModel)((AndStepPane)this.asp).parent.workModel1).setAdminState(0);
                                }
                                if (iOnePlusOneModel.getWorkingEntityIndex() != n2) continue;
                                if (iOnePlusOneModel.isBidirectional()) {
                                    iOnePlusOneModel.setBidirectional(false);
                                }
                                ((AndStepPane)this.asp).parent.addOpo2 = iOnePlusOneModel;
                                ((AndStepPane)this.asp).parent.workModel2 = iNetElement.getNodeModel().getEntityTable().getEntityModelByIndex(iOnePlusOneModel.getWorkingEntityIndex());
                                ((AndStepPane)this.asp).parent.protectModel2 = iNetElement.getNodeModel().getEntityTable().getEntityModelByIndex(iOnePlusOneModel.getProtectEntityIndex());
                                ((IPortModel)((AndStepPane)this.asp).parent.workModel2).setAdminState(0);
                            }
                            ((AndStepPane)this.asp).parent.newNetElement = iNetElement;
                            this.asp.parent.setNextEnabled(true);
                        }
                        catch (Exception exception) {
                            CerentDialog.errorDialog((Component)this.asp.parent, (Exception)exception, (String)"Discover Node Error");
                        }
                        return;
                    }
                    if (!bl) continue;
                    CerentDialog.errorDialog((Component)this.asp.parent, (String)"The re-fiber of the protect path was not properly done.");
                }
                try {
                    NodeDiscover.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }
}

