/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.loader.ElementFactoryFinder;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.INodeModel;
import cerent.cms.topo.Network;
import cerent.cms.ui.IEntityCellRenderer;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.NEMC;
import cerent.util.SDebug;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.TreeMap;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.ListCellRenderer;

class IosSlotSelDialog
implements ItemListener {
    private static final String QUESTION_ICON_STR = "/images/icons/question32.gif";
    private static final ImageIcon QUESTION_ICON = new ImageIcon(IosSlotSelDialog.class.getResource("/images/icons/question32.gif"));
    private Frame parent;
    private JComboBox nodeCB;
    private JComboBox slotCB;
    private IModuleModel moduleModel;
    private boolean ok = false;
    public static final SDebug db = new SDebug("IosSlotSelDialog");

    public IosSlotSelDialog(Frame frame, INodeModel iNodeModel) {
        this.parent = frame;
        Object[][] objectArray = this.getItemData();
        if (objectArray == null) {
            ErrorMsg.displayError((Component)frame, (EID)NEMC.EID_UNABLE_LOCATE_IOS_CARD_NODE);
            return;
        }
        this.nodeCB = new JComboBox((E[])objectArray);
        this.nodeCB.setRenderer(new NodeSlotRenderer());
        this.nodeCB.addItemListener(this);
        this.slotCB = new JComboBox();
        this.slotCB.setRenderer(new NodeSlotRenderer());
        if (iNodeModel != null) {
            this.setPreferredNode(iNodeModel);
        }
        this.itemStateChanged(new ItemEvent(this.nodeCB, 701, this.nodeCB.getSelectedItem(), 1));
        this.show();
    }

    private void setPreferredNode(INodeModel iNodeModel) {
        if (iNodeModel == null) {
            return;
        }
        for (int i = 0; i < this.nodeCB.getItemCount(); ++i) {
            Object[] objectArray = (Object[])this.nodeCB.getItemAt(i);
            if (objectArray == null || objectArray[1] != iNodeModel) continue;
            this.nodeCB.setSelectedIndex(i);
            break;
        }
    }

    private void show() {
        Object[] objectArray = new Object[]{new JLabel("Select Node for IOS Session"), this.nodeCB, new JLabel("Select Slot"), this.slotCB};
        JOptionPane jOptionPane = new JOptionPane(objectArray, 3, 2, QUESTION_ICON);
        JDialog jDialog = jOptionPane.createDialog(this.parent, "Select Node and Slot");
        jDialog.show();
        if (jOptionPane.getValue() != null && (Integer)jOptionPane.getValue() == 0) {
            Object[] objectArray2 = (Object[])this.slotCB.getSelectedItem();
            if (objectArray2 != null) {
                this.moduleModel = (IModuleModel)objectArray2[1];
            }
            this.ok = true;
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() != this.nodeCB) {
            return;
        }
        if (this.nodeCB.getSelectedIndex() >= 0) {
            Object[] objectArray = (Object[])this.nodeCB.getSelectedItem();
            this.populateSlotCB((INodeModel)objectArray[1]);
        }
    }

    public boolean isOk() {
        return this.ok;
    }

    public IModuleModel getModuleModel() {
        return this.moduleModel;
    }

    private void populateSlotCB(INodeModel iNodeModel) {
        if (this.slotCB == null || !iNodeModel.isInited()) {
            return;
        }
        if (this.slotCB.getItemCount() > 0) {
            this.slotCB.removeAllItems();
        }
        IModuleModel[] iModuleModelArray = iNodeModel.getIosModuleList();
        for (int i = 0; i < iModuleModelArray.length; ++i) {
            Object[] objectArray = new Object[2];
            IEntityCellRenderer iEntityCellRenderer = ElementFactoryFinder.getElementFactory(iNodeModel).createEntityCellRenderer(iModuleModelArray[i]);
            objectArray[0] = iEntityCellRenderer.getString((Object)iModuleModelArray[i], null);
            objectArray[1] = iModuleModelArray[i];
            this.slotCB.addItem(objectArray);
        }
    }

    private Object[][] getItemData() {
        Object[] objectArray;
        Object[][] objectArray22;
        TreeMap<String, INodeModel> treeMap = new TreeMap<String, INodeModel>();
        for (Object[][] objectArray22 : Network.instance().getElements()) {
            if (!objectArray22.getNodeModel().isInited() || (objectArray = objectArray22.getNodeModel().getIosModuleList()).length <= 0) continue;
            treeMap.put(objectArray22.getNodeModel().getName(), objectArray22.getNodeModel());
        }
        if (treeMap.size() == 0) {
            return null;
        }
        objectArray22 = new Object[treeMap.size()][2];
        objectArray = treeMap.keySet().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray22[i][0] = objectArray[i];
            objectArray22[i][1] = treeMap.get(objectArray[i]);
        }
        return objectArray22;
    }

    class NodeSlotRenderer
    extends JLabel
    implements ListCellRenderer {
        public NodeSlotRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Object[] objectArray = (Object[])object;
            try {
                this.setText(((String)objectArray[0]).toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setBackground(bl ? jList.getSelectionBackground() : Color.white);
            this.setForeground(bl ? Color.white : Color.black);
            return this;
        }
    }
}

