/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.model.IPmStat;
import java.awt.Color;
import java.awt.Component;
import java.lang.reflect.Method;
import java.text.NumberFormat;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class PmCellRenderer
extends JLabel
implements TableCellRenderer {
    protected static final int ALIGN = 4;
    private int _current;
    private String _text;

    public PmCellRenderer() {
        this.setOpaque(true);
        this.setHorizontalTextPosition(4);
        this.setHorizontalAlignment(4);
        this._current = 0;
        this._text = "_~^~_";
    }

    protected void setupValid(String string) {
        if (this._current != 1) {
            this.setBackground(Color.white);
            this.setToolTipText("White cells contain valid data");
            this._current = 1;
        }
        if (!this._text.equals(string)) {
            this.setText(string);
            this._text = string;
        }
    }

    protected void setupInvalid(String string) {
        if (this._current != 2) {
            this.setBackground(Color.yellow);
            this.setToolTipText("Yellow cells contain invalid data");
            this._current = 2;
        }
        if (!this._text.equals(string)) {
            this.setText(string);
            this._text = string;
        }
    }

    protected void setupNoData() {
        if (this._current != 3) {
            this.setBackground(Color.white);
            this.setToolTipText("No data available");
            this._current = 3;
        }
        if (!this._text.equals("")) {
            this.setText("");
            this._text = "";
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if (object != null) {
            if (object instanceof IPmStat) {
                String string;
                Method[] methodArray;
                IPmStat iPmStat = (IPmStat)object;
                boolean bl3 = false;
                for (Class<?> clazz = iPmStat.getClass(); clazz != null && clazz.getSuperclass() != null; clazz = clazz.getSuperclass()) {
                    methodArray = clazz.getDeclaredMethods();
                    for (int i = 0; i < methodArray.length; ++i) {
                        if (!methodArray[i].getName().equals("toString")) continue;
                        bl3 = true;
                        break;
                    }
                    if (bl3) break;
                }
                if (bl3) {
                    string = iPmStat.toString();
                } else {
                    methodArray = NumberFormat.getInstance();
                    string = methodArray.format(iPmStat.getCnt());
                }
                if (iPmStat.getCnt() == -1) {
                    this.setupNoData();
                } else if (!iPmStat.getValid()) {
                    this.setupInvalid(string);
                } else {
                    this.setupValid(string);
                }
            } else if (object instanceof Integer) {
                int n3 = (Integer)object;
                NumberFormat numberFormat = NumberFormat.getInstance();
                this.setupValid(numberFormat.format(n3));
            } else if (object instanceof String) {
                if (object.toString().equals("")) {
                    this.setupNoData();
                } else {
                    this.setupInvalid(object.toString());
                }
            } else {
                this.setupInvalid(object.getClass().getName());
            }
        } else {
            this.setupNoData();
        }
        return this;
    }
}

