/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.ui.AbstractViewController;
import cerent.cms.ui.HandlerUtils;
import cerent.cms.ui.IPrintRegion;
import cerent.util.SDebug;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;

public class PrintRegionDialog
extends JDialog
implements IPrintRegion {
    private static final String screenString = "Entire Frame";
    private static final String tableComponentString = "Tabbed View";
    private static final String tableContentString = "Table Contents";
    private static final String screenCommandString = "PRINT_WINDOW_FRAME";
    private static final String tableComponentCommandString = "PRINT_TABLE_COMPONENT";
    private static final String tableContentCommandString = "PRINT_TABLE_CONTENTS";
    private Image printScreenImage;
    private Image printTableComponentImage;
    private Image printTableContentImage;
    JLabel picture = null;
    int _buttonHit = -1;
    int _printRegionSelection = 0;
    protected JRadioButton screenButton = null;
    protected JRadioButton tableComponentButton = null;
    protected JRadioButton tableContentButton = null;
    private static final SDebug db = new SDebug("PrintRegionDialog");

    public PrintRegionDialog() {
        this((JFrame)null, "", false, (AbstractViewController)null);
    }

    public int getPrintRegionSelection() {
        return this._printRegionSelection;
    }

    public PrintRegionDialog(JFrame jFrame, String string, boolean bl, AbstractViewController abstractViewController) {
        super(jFrame, string, bl);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        this.printScreenImage = toolkit.getImage(this.getClass().getResource("/images/screen.gif"));
        this.printTableComponentImage = toolkit.getImage(this.getClass().getResource("/images/component.gif"));
        this.printTableContentImage = toolkit.getImage(this.getClass().getResource("/images/content.gif"));
        this._buttonHit = -1;
        this._printRegionSelection = 0;
        this.screenButton = new JRadioButton(screenString);
        this.screenButton.setMnemonic(70);
        this.screenButton.setActionCommand(screenCommandString);
        this.screenButton.setSelected(true);
        this.screenButton.setToolTipText("Print App Window.");
        this.tableComponentButton = new JRadioButton(tableComponentString);
        this.tableComponentButton.setMnemonic(86);
        this.tableComponentButton.setActionCommand(tableComponentCommandString);
        this.tableComponentButton.setToolTipText("Print Tabbed View");
        this.tableContentButton = new JRadioButton(tableContentString);
        this.tableContentButton.setMnemonic(84);
        this.tableContentButton.setActionCommand(tableContentCommandString);
        this.tableContentButton.setToolTipText("Print Table Contents");
        if (abstractViewController == null || HandlerUtils.getDisplayedTable(abstractViewController) == null && HandlerUtils.getDisplayedHtmlReport(abstractViewController) == null) {
            this.tableContentButton.setEnabled(false);
            db.fine("Disabling tableContentButton");
        }
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.screenButton);
        buttonGroup.add(this.tableComponentButton);
        buttonGroup.add(this.tableContentButton);
        RadioListener radioListener = new RadioListener();
        this.screenButton.addActionListener(radioListener);
        this.tableComponentButton.addActionListener(radioListener);
        this.tableContentButton.addActionListener(radioListener);
        this.picture = new JLabel(new ImageIcon(this.printScreenImage));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 1));
        jPanel.add(this.screenButton);
        jPanel.add(this.tableComponentButton);
        jPanel.add(this.tableContentButton);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(1, 4));
        JButton jButton = new JButton("OK");
        JButton jButton2 = new JButton("Cancel");
        jButton.setActionCommand("OK");
        jButton.addActionListener(new ButtonListener());
        jButton2.setActionCommand("Cancel");
        jButton2.addActionListener(new ButtonListener());
        JLabel jLabel = new JLabel("    ");
        jPanel2.add(jLabel);
        jPanel2.add(jLabel);
        jPanel2.add(jButton);
        jPanel2.add(jButton2);
        jPanel2.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.setBorder(new TitledBorder("Print Regions"));
        jPanel3.add((Component)jPanel, "East");
        jPanel3.add((Component)this.picture, "Center");
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout());
        jPanel4.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        jPanel4.add((Component)jPanel3, "Center");
        jPanel4.add((Component)jPanel2, "South");
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add(jPanel4);
    }

    public int showDialog() {
        this._buttonHit = -1;
        this.setModal(true);
        this.pack();
        super.show();
        return this._buttonHit;
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("PRINT");
        jFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        jFrame.setVisible(true);
        PrintRegionDialog printRegionDialog = new PrintRegionDialog(jFrame, "Print", true, null);
        boolean bl = false;
        while (!bl) {
            int n = printRegionDialog.showDialog();
            switch (n) {
                case 0: {
                    System.out.println("OK");
                    break;
                }
                case 2: {
                    System.out.println("Cancel");
                    break;
                }
                case -1: {
                    System.out.println("Closed");
                    bl = true;
                }
            }
            if (n != 0) continue;
            System.out.println(printRegionDialog.getPrintRegionSelection());
        }
    }

    class ButtonListener
    implements ActionListener {
        ButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PrintRegionDialog.this.setVisible(false);
            PrintRegionDialog.this._buttonHit = actionEvent.getActionCommand().equals("OK") ? 0 : 2;
        }
    }

    class RadioListener
    implements ActionListener {
        RadioListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getActionCommand().equals(PrintRegionDialog.screenCommandString)) {
                PrintRegionDialog.this._printRegionSelection = 0;
                PrintRegionDialog.this.picture.setIcon(new ImageIcon(PrintRegionDialog.this.printScreenImage));
            } else if (actionEvent.getActionCommand().equals(PrintRegionDialog.tableComponentCommandString)) {
                PrintRegionDialog.this._printRegionSelection = 1;
                PrintRegionDialog.this.picture.setIcon(new ImageIcon(PrintRegionDialog.this.printTableComponentImage));
            } else {
                PrintRegionDialog.this._printRegionSelection = 2;
                PrintRegionDialog.this.picture.setIcon(new ImageIcon(PrintRegionDialog.this.printTableContentImage));
            }
        }
    }
}

