/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.model.Feature;
import cerent.cms.model.ICircuitType;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.INodeModel;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ui.AbstractStEndpointPanel;
import cerent.cms.ui.StEndpointPane;
import cerent.cms.ui.circuits.CircuitEndCellRenderer;
import cerent.cms.ui.circuits.SortablePortString;
import cerent.util.AnnotatedException;
import cerent.util.HoLoComparator;
import cerent.util.IHoNum;
import cerent.util.ILoNum;
import cerent.util.gui.LoListCellRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;

public class SonetStEndpointPanel
extends AbstractStEndpointPanel {
    private JComboBox stsCB;
    private JComboBox vtCB;
    private SortedMap vtMap;
    protected JLabel stsLB;
    protected JLabel vtLB;
    protected boolean hasDs1Endpoints = false;

    public SonetStEndpointPanel(String string, StEndpointPane stEndpointPane) {
        super(string, stEndpointPane);
    }

    @Override
    protected void addComponents(GridBagConstraints gridBagConstraints) {
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.gridheight = 1;
        this.stsLB = new JLabel("STS:", 4);
        this.stsCB = this.addCB(this.stsLB, "stsCB", gridBagConstraints);
        this.vtLB = new JLabel("VT:", 4);
        this.vtCB = this.addCB(this.vtLB, "vtCB", gridBagConstraints);
        this.vtCB.setRenderer(new VtListCellRenderer());
        this.hoParts.add(this.stsCB);
        this.hoParts.add(this.stsLB);
        this.loParts.add(this.vtCB);
        this.loParts.add(this.vtLB);
    }

    @Override
    protected List getLoParts() {
        if (this.loParts.size() == 0) {
            this.loParts.add(this.vtLB);
            this.loParts.add(this.vtCB);
        }
        return this.loParts;
    }

    @Override
    protected JComboBox getHoCB() {
        return this.stsCB;
    }

    @Override
    protected void localRefresh(ICircuitType iCircuitType, int n) {
        if (!iCircuitType.isLoCircuitType()) {
            this.endpoint.setLoNum(null);
            this.loNum = null;
            this.vtLB.setVisible(false);
            this.vtCB.setVisible(false);
        } else {
            this.vtLB.setVisible(true);
            this.vtCB.setVisible(true);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        block29: {
            Object object;
            block32: {
                Object object2;
                block31: {
                    block30: {
                        object = actionEvent.getSource();
                        if (object != this.slotCB) break block30;
                        String string = (String)this.slotCB.getSelectedItem();
                        if (this.isNull(string, "newSlot")) {
                            return;
                        }
                        if (db.on()) {
                            db.println(this.title + " actionPerformed: slot " + this.slot + " -> " + string);
                        }
                        this.slot = string;
                        this.vtLB.setText("VT:");
                        this.portMap = (SortedMap)this.entityMap.get(this.slot);
                        if (this.portMap.size() == 0) {
                            if (db.on()) {
                                db.println(this.title + " portMap is empty");
                            }
                            return;
                        }
                        this.setCBList(this.portCB, this.portMap.keySet());
                        if (this.portMap.size() == 1) {
                            SortablePortString sortablePortString = (SortablePortString)this.portMap.firstKey();
                            if (!sortablePortString.isEmpty()) {
                                this.portCB.setSelectedItem(sortablePortString);
                            } else {
                                this.port = null;
                                try {
                                    this.setEntity((IEntityModel)this.portMap.get(sortablePortString));
                                }
                                catch (AnnotatedException annotatedException) {
                                    if (db.on()) {
                                        db.println(this.title + " actionPerformed(slotCB): exception in setEntity");
                                    }
                                    this.clearEntity(annotatedException, true);
                                }
                            }
                            this.portCB.setEnabled(false);
                            break block29;
                        } else {
                            this.setCBList(this.hoParts, null);
                            this.setCBList(this.loParts, null);
                        }
                        break block29;
                    }
                    if (object != this.portCB) break block31;
                    SortablePortString sortablePortString = (SortablePortString)this.portCB.getSelectedItem();
                    if (this.isNull(sortablePortString, "newPort")) {
                        return;
                    }
                    if (db.on()) {
                        db.println(this.title + " actionPerformed: port " + this.port + " -> " + sortablePortString);
                    }
                    this.port = sortablePortString;
                    this.vtLB.setText("VT:");
                    try {
                        this.setEntity((IEntityModel)this.portMap.get(this.port));
                    }
                    catch (AnnotatedException annotatedException) {
                        if (db.on()) {
                            db.println(this.title + " actionPerformed(portCB): exception in setEntity");
                        }
                        this.clearEntity(annotatedException, false);
                    }
                    break block29;
                }
                if (object != this.stsCB) break block32;
                IHoNum iHoNum = (IHoNum)this.stsCB.getSelectedItem();
                if (this.isNull(iHoNum, "newSts")) {
                    return;
                }
                if (db.on()) {
                    db.println(this.title + " actionPerformed: sts " + this.hoNum + " -> " + iHoNum);
                }
                this.hoNum = iHoNum;
                if (this.port != null) {
                    object2 = CircuitEndCellRenderer.convertFromExternalHoNumber((IEntityModel)this.portMap.get(this.port), this.hoNum);
                    this.endpoint.setHoNum((IHoNum)object2);
                } else {
                    this.endpoint.setHoNum(this.hoNum);
                }
                object2 = this.endpointMap.get(this.hoNum);
                if (this.isNull(object2, "endpointMap value for STS " + this.hoNum.toString())) {
                    return;
                }
                if (object2 instanceof INetCircuitEnd) {
                    this.setCBList(this.vtCB, null);
                    break block29;
                } else if (object2 instanceof SortedMap) {
                    this.vtMap = (SortedMap)object2;
                    this.setCBList(this.vtCB, this.vtMap.keySet());
                    break block29;
                } else {
                    if (db.on()) {
                        db.println(this.title + " actionPerformed: endpointMap value has wrong class: " + object2.getClass().toString());
                    }
                    return;
                }
            }
            if (object == this.vtCB) {
                ILoNum iLoNum = (ILoNum)this.vtCB.getSelectedItem();
                if (this.isNull(iLoNum, "newVt")) {
                    return;
                }
                if (db.on()) {
                    db.println(this.title + " actionPerformed: vt " + (this.loNum == null ? "null" : this.loNum.prettyString()) + " -> " + iLoNum.prettyString());
                }
                this.loNum = iLoNum;
                this.endpoint.setLoNum(iLoNum);
            }
        }
        super.actionPerformed(actionEvent);
    }

    @Override
    void setNode(INodeModel iNodeModel) {
        this.node = iNodeModel;
        if (this.endpoint.getNodeModel() != iNodeModel) {
            this.endpoint.setNodeModel(iNodeModel);
            if (Feature.provides((INodeModel)iNodeModel, (Feature)Feature.MULTISHELF) && iNodeModel.isMultishelf()) {
                this.isMultiShelf = true;
                this.shelfLB.setVisible(true);
                this.shelfCB.setVisible(true);
            } else {
                this.isMultiShelf = false;
                this.shelfLB.setVisible(false);
                this.shelfCB.setVisible(false);
            }
            this.refresh();
        }
    }

    @Override
    protected void setLoComponents(ILoNum iLoNum) {
        this.vtCB.setSelectedItem(iLoNum);
    }

    @Override
    protected SortedMap createNewLoMap() {
        return new TreeMap(HoLoComparator.instance());
    }

    @Override
    protected void putInLoMap(SortedMap sortedMap, INetCircuitEnd iNetCircuitEnd) {
        INetCircuitEnd iNetCircuitEnd2 = sortedMap.put(iNetCircuitEnd.getLoNum(), iNetCircuitEnd);
        if (iNetCircuitEnd2 != null && db.on()) {
            db.println(this.title + " getDropPoints: multiple endpoints with " + "STS = " + iNetCircuitEnd.getHoNum() + ", VT = " + iNetCircuitEnd.getLoNum());
        }
    }

    @Override
    protected boolean inLoMap(SortedMap sortedMap, ILoNum iLoNum) {
        if (sortedMap == null) {
            return false;
        }
        return sortedMap.containsKey(iLoNum);
    }

    @Override
    protected ILoNum getFirstLoFromLoMap(SortedMap sortedMap, int n) {
        return (ILoNum)sortedMap.firstKey();
    }

    @Override
    protected void debugEndpoint(String string) {
        if (db.on()) {
            db.println(string + "endpoint.node = " + this.endpoint.getNodeModel());
            db.println(string + "endpoint.entity = " + this.getEntityModel());
            db.println(string + "slot = " + this.slot);
            db.println(string + "port = " + this.port);
            db.println(string + "endpoint.hoNum = " + this.endpoint.getHoNum());
        }
    }

    private class VtListCellRenderer
    extends LoListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object != null && object instanceof ILoNum && SonetStEndpointPanel.this.hasDs1Endpoints) {
                StringBuffer stringBuffer = new StringBuffer();
                ILoNum iLoNum = (ILoNum)object;
                IEntityModel iEntityModel = SonetStEndpointPanel.this.getEntityModel();
                if (iEntityModel != null) {
                    stringBuffer.append(iLoNum.toString());
                    stringBuffer.append(CircuitEndCellRenderer.getDs1PortName(iEntityModel, iLoNum, null));
                    stringBuffer.append(" (VT");
                    stringBuffer.append(iLoNum.groupString());
                    stringBuffer.append(')');
                }
                this.setText(stringBuffer.toString());
                this.setBackground(bl ? jList.getSelectionBackground() : Color.white);
                this.setForeground(bl ? Color.white : Color.black);
                return this;
            }
            return super.getListCellRendererComponent(jList, object, n, bl, bl2);
        }
    }
}

