/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.apc;

import cerent.cms.model.Busy;
import cerent.cms.model.CannotPerform;
import cerent.cms.model.Feature;
import cerent.cms.model.IApcDomainItem;
import cerent.cms.model.IDwdmApcModel;
import cerent.cms.model.IDwdmApcModels;
import cerent.cms.model.INodeModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.WrongNodeSide;
import cerent.cms.model.event.IObjectMessageInfo;
import cerent.cms.ui.DwdmSide;
import cerent.cms.ui.apc.ApcDomainDomainNode;
import cerent.cms.ui.apc.ApcDomainNode;
import cerent.cms.ui.apc.ApcDomainRootNode;
import cerent.cms.ui.apc.ApcDomainSpan;
import cerent.util.KDebug;
import cerent.util.SDebug;
import cerent.util.gui.row.AbstractRowDataSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class ApcDataSource
extends AbstractRowDataSource
implements Observer {
    private static final SDebug db = new SDebug("ApcDataSource");
    private ArrayList<ApcDomainDomainNode> listDomain;
    private JTree jtree;
    private ApcRunEntries apcRunEntries = new ApcRunEntries();

    public ApcDataSource(JTree jTree) {
        this.jtree = jTree;
        this.listDomain = new ArrayList();
    }

    public void unloadDataSource() {
        this.removeObserver();
        this.listDomain.clear();
    }

    public void loadDataSource() {
        block4: {
            DefaultMutableTreeNode defaultMutableTreeNode;
            block3: {
                TreePath treePath = this.jtree.getSelectionPath();
                defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                if (!(defaultMutableTreeNode.getUserObject() instanceof ApcDomainDomainNode)) break block3;
                ApcDomainDomainNode apcDomainDomainNode = (ApcDomainDomainNode)defaultMutableTreeNode.getUserObject();
                this.listDomain.add(apcDomainDomainNode);
                for (int i = 0; i < apcDomainDomainNode.getApcModels().size(); ++i) {
                    this.addObserver((IDwdmApcModels)apcDomainDomainNode.getApcModels().get(i));
                }
                break block4;
            }
            if (!(defaultMutableTreeNode.getUserObject() instanceof ApcDomainRootNode)) break block4;
            for (int i = 0; i < this.jtree.getRowCount(); ++i) {
                defaultMutableTreeNode = (DefaultMutableTreeNode)this.jtree.getPathForRow(i).getLastPathComponent();
                if (!(defaultMutableTreeNode.getUserObject() instanceof ApcDomainDomainNode)) continue;
                ApcDomainDomainNode apcDomainDomainNode = (ApcDomainDomainNode)defaultMutableTreeNode.getUserObject();
                this.listDomain.add(apcDomainDomainNode);
                for (int j = 0; j < apcDomainDomainNode.getApcModels().size(); ++j) {
                    this.addObserver((IDwdmApcModels)apcDomainDomainNode.getApcModels().get(j));
                }
            }
        }
    }

    public void dispose() {
        if (db.on()) {
            db.println("ApcDataSource Dispose");
        }
        this.removeObserver();
        this.listDomain.clear();
    }

    @Override
    public void update(Observable observable, Object object) {
        int n = object instanceof IObjectMessageInfo ? ((IObjectMessageInfo)object).getUpdateType() : ((Integer)object).intValue();
        if (observable instanceof IDwdmApcModel && object.equals(ModelUpdateType.CHANGED)) {
            IDwdmApcModel iDwdmApcModel = (IDwdmApcModel)observable;
            INodeModel iNodeModel = iDwdmApcModel.getNodeModel();
            int n2 = iDwdmApcModel.getApcNodeSide();
            this.updateApcProgressStatus(iDwdmApcModel);
            if (db.on()) {
                db.println("update: received IDwdmApcModel event from " + iNodeModel.getName() + ", side " + DwdmSide.getSideFromOffset(n2));
            }
            for (int i = 0; i < this.listDomain.size(); ++i) {
                ApcDomainDomainNode apcDomainDomainNode = this.listDomain.get(i);
                if (!apcDomainDomainNode.containsNode(iNodeModel, n2)) continue;
                try {
                    if (apcDomainDomainNode.getAPCState() != iDwdmApcModel.getApcState()) {
                        apcDomainDomainNode.setAPCState(iDwdmApcModel.getApcState());
                        this.fireDataSourceChanged();
                    }
                    if (apcDomainDomainNode.getAPCAdminState() != iDwdmApcModel.getApcAdminState()) {
                        apcDomainDomainNode.setAPCAdminState(iDwdmApcModel.getApcAdminState());
                        this.fireDataSourceChanged();
                    }
                    if (apcDomainDomainNode.getAPCProgressState() == iDwdmApcModel.getApcProgressState()) continue;
                    apcDomainDomainNode.setAPCProgressState(iDwdmApcModel.getApcProgressState());
                    if (iNodeModel.provides(Feature.APC_ABORTED_NODE)) {
                        if (iDwdmApcModel.getApcProgressState() == 1) {
                            apcDomainDomainNode.setAPCFailingNodeId(iDwdmApcModel.getApcFailingNodeId());
                        } else {
                            apcDomainDomainNode.setAPCFailingNodeId(-1);
                        }
                    } else {
                        apcDomainDomainNode.setAPCFailingNodeId(-1);
                    }
                    this.fireDataSourceChanged();
                    continue;
                }
                catch (WrongNodeSide wrongNodeSide) {
                    KDebug.printStackTrace((Throwable)wrongNodeSide);
                }
            }
        }
    }

    protected ApcDomainDomainNode[] getApcDomainDomainNodeSelected(int[] nArray) {
        ArrayList<ApcDomainDomainNode> arrayList = new ArrayList<ApcDomainDomainNode>();
        for (int i = 0; i < nArray.length; ++i) {
            ApcDomainDomainNode apcDomainDomainNode = (ApcDomainDomainNode)this.getObjectAtRow(nArray[i]);
            arrayList.add(apcDomainDomainNode);
        }
        return arrayList.toArray(new ApcDomainDomainNode[0]);
    }

    public Object getObjectAtRow(int n) {
        return this.listDomain.get(n);
    }

    public int getRowCount() {
        return this.listDomain.size();
    }

    public Collection getAllObjects() {
        return this.listDomain;
    }

    private void addObserver(IDwdmApcModels iDwdmApcModels) {
        ((Observable)iDwdmApcModels).addObserver(this);
        IDwdmApcModel[] iDwdmApcModelArray = iDwdmApcModels.getAllDwdmApcModel();
        INodeModel iNodeModel = iDwdmApcModels.getNodeModel();
        if (iNodeModel.getConnectionState()) {
            for (IDwdmApcModel iDwdmApcModel : iDwdmApcModelArray) {
                ((Observable)iDwdmApcModel).addObserver(this);
            }
        }
    }

    private void removeObserver() {
        for (int i = 0; i < this.listDomain.size(); ++i) {
            ApcDomainDomainNode apcDomainDomainNode = this.listDomain.get(i);
            for (int j = 0; j < apcDomainDomainNode.getApcModels().size(); ++j) {
                IDwdmApcModel[] iDwdmApcModelArray;
                IDwdmApcModels iDwdmApcModels = (IDwdmApcModels)apcDomainDomainNode.getApcModels().get(j);
                ((Observable)iDwdmApcModels).deleteObserver(this);
                for (IDwdmApcModel iDwdmApcModel : iDwdmApcModelArray = iDwdmApcModels.getAllDwdmApcModel()) {
                    ((Observable)iDwdmApcModel).deleteObserver(this);
                }
            }
        }
    }

    private synchronized void updateApcProgressStatus(IDwdmApcModel iDwdmApcModel) {
        ApcDomainNodeRunEntry apcDomainNodeRunEntry = this.apcRunEntries.getNodeEntryFor(iDwdmApcModel);
        if (apcDomainNodeRunEntry == null) {
            return;
        }
        apcDomainNodeRunEntry.updateState(iDwdmApcModel);
    }

    protected synchronized void runApc(ApcDomainDomainNode[] apcDomainDomainNodeArray) {
        block4: for (ApcDomainDomainNode apcDomainDomainNode : apcDomainDomainNodeArray) {
            ApcDomainSpan[] apcDomainSpanArray;
            this.apcRunEntries.initDomainEntry(apcDomainDomainNode);
            for (ApcDomainSpan apcDomainSpan : apcDomainSpanArray = (ApcDomainSpan[])apcDomainDomainNode.getChildren(new ApcDomainSpan[0])) {
                int n;
                IApcDomainItem iApcDomainItem = null;
                IApcDomainItem iApcDomainItem2 = apcDomainSpan.getFrom();
                IApcDomainItem iApcDomainItem3 = apcDomainSpan.getTo();
                if (iApcDomainItem2 != null) {
                    iApcDomainItem = apcDomainSpan.getFrom();
                } else {
                    if (iApcDomainItem3 == null) continue;
                    iApcDomainItem = apcDomainSpan.getTo();
                }
                INodeModel iNodeModel = ApcDomainNode.getNodeModel(iApcDomainItem);
                if (iApcDomainItem.getSideIn() != 0) {
                    n = iApcDomainItem.getSideIn();
                } else {
                    if (iApcDomainItem.getSideOut() == 0) continue;
                    n = iApcDomainItem.getSideOut();
                }
                if (db.on()) {
                    db.println("Running APC for node " + iNodeModel.getName() + " side " + DwdmSide.getSideFromOffset(n));
                }
                if (iNodeModel == null || !iNodeModel.getConnectionState()) continue;
                IDwdmApcModels iDwdmApcModels = iNodeModel.getIDwdmApcModels();
                try {
                    iDwdmApcModels.runApc((short)n);
                    continue block4;
                }
                catch (Busy busy) {
                    KDebug.printStackTrace((Throwable)busy);
                }
                catch (CannotPerform cannotPerform) {
                    KDebug.printStackTrace((Throwable)cannotPerform);
                }
                catch (WrongNodeSide wrongNodeSide) {
                    KDebug.printStackTrace((Throwable)wrongNodeSide);
                }
            }
        }
    }

    private static class ApcDomainNodeRunEntry
    implements Comparable<ApcDomainNodeRunEntry> {
        private ApcDomainRunEntry parent;
        private INodeModel node;
        private int sideId;
        private int runningState;

        ApcDomainNodeRunEntry(ApcDomainRunEntry apcDomainRunEntry, INodeModel iNodeModel, int n) {
            this.parent = apcDomainRunEntry;
            this.node = iNodeModel;
            this.sideId = n;
            this.runningState = 2;
        }

        boolean isForNode(INodeModel iNodeModel, int n) {
            return this.node.getNodeId() == iNodeModel.getNodeId() && this.sideId == n;
        }

        void updateState(IDwdmApcModel iDwdmApcModel) {
            if (db.on()) {
                db.println("Update state for run entry for " + this.getEntryLabel() + " - Current state is " + this.progressStateToString(this.runningState));
            }
            try {
                this.runningState = iDwdmApcModel.getApcProgressState();
                if (db.on()) {
                    db.println("New state is " + this.progressStateToString(this.runningState));
                }
            }
            catch (WrongNodeSide wrongNodeSide) {
                KDebug.printStackTrace((Throwable)wrongNodeSide);
                return;
            }
            this.parent.updateState();
        }

        private String getEntryLabel() {
            return "node " + this.node.getName() + " side " + DwdmSide.getSideFromOffset(this.sideId);
        }

        public String toString() {
            return this.getEntryLabel();
        }

        boolean isCompleted() {
            return this.runningState == 0;
        }

        boolean isAborted() {
            return this.runningState == 1;
        }

        boolean isRunning() {
            return this.runningState == 2;
        }

        @Override
        public int compareTo(ApcDomainNodeRunEntry apcDomainNodeRunEntry) {
            if (this.node.getNodeId() == apcDomainNodeRunEntry.node.getNodeId()) {
                return this.sideId - apcDomainNodeRunEntry.sideId;
            }
            return this.node.getNodeId() - apcDomainNodeRunEntry.node.getNodeId();
        }

        private String progressStateToString(int n) {
            if (n == 1) {
                return "ABORTED";
            }
            if (n == 0) {
                return "ENDED";
            }
            if (n == 2) {
                return "RUNNING";
            }
            return "Unknown state " + n;
        }
    }

    private static class ApcDomainRunEntry {
        private ApcRunEntries parent;
        private ApcDomainDomainNode domain;
        private Set<ApcDomainNodeRunEntry> nodes = new TreeSet<ApcDomainNodeRunEntry>();

        ApcDomainRunEntry(ApcRunEntries apcRunEntries, ApcDomainDomainNode apcDomainDomainNode) {
            this.parent = apcRunEntries;
            this.domain = apcDomainDomainNode;
            this.init();
        }

        private void init() {
            this.nodes.clear();
            ApcDomainNode[] apcDomainNodeArray = this.domain.getChildren(new ApcDomainNode[0]);
            for (int i = 0; i < apcDomainNodeArray.length; ++i) {
                int n;
                INodeModel iNodeModel;
                ApcDomainSpan apcDomainSpan = (ApcDomainSpan)apcDomainNodeArray[i];
                IApcDomainItem iApcDomainItem = apcDomainSpan.getTo();
                if (iApcDomainItem != null) {
                    iNodeModel = ApcDomainNode.getNodeModel(iApcDomainItem);
                    n = iApcDomainItem.getSideIn();
                    if (n != 0) {
                        this.addNode(iNodeModel, n);
                    }
                    if (i != apcDomainNodeArray.length - 1 && (n = iApcDomainItem.getSideOut()) != 0) {
                        this.addNode(iNodeModel, n);
                    }
                }
                if ((iApcDomainItem = apcDomainSpan.getFrom()) == null) continue;
                iNodeModel = ApcDomainNode.getNodeModel(iApcDomainItem);
                if (i != 0 && (n = iApcDomainItem.getSideIn()) != 0) {
                    this.addNode(iNodeModel, n);
                }
                if ((n = iApcDomainItem.getSideOut()) == 0) continue;
                this.addNode(iNodeModel, n);
            }
            if (db.on()) {
                db.println(this.dump());
            }
        }

        private String dump() {
            StringBuilder stringBuilder = new StringBuilder("Run entry for domain " + this.domain.getName() + " dump:");
            for (ApcDomainNodeRunEntry apcDomainNodeRunEntry : this.nodes) {
                stringBuilder.append("\n").append(apcDomainNodeRunEntry).append(" - completed: ").append(apcDomainNodeRunEntry.isCompleted()).append(" - aborted: ").append(apcDomainNodeRunEntry.isAborted());
            }
            return stringBuilder.toString();
        }

        private void addNode(INodeModel iNodeModel, int n) {
            if (this.getNodeEntry(iNodeModel, n) == null) {
                ApcDomainNodeRunEntry apcDomainNodeRunEntry = new ApcDomainNodeRunEntry(this, iNodeModel, n);
                this.nodes.add(apcDomainNodeRunEntry);
            }
        }

        boolean isCompleted() {
            for (ApcDomainNodeRunEntry apcDomainNodeRunEntry : this.nodes) {
                if (apcDomainNodeRunEntry.isCompleted()) continue;
                return false;
            }
            return true;
        }

        boolean isAborted() {
            for (ApcDomainNodeRunEntry apcDomainNodeRunEntry : this.nodes) {
                if (!apcDomainNodeRunEntry.isAborted()) continue;
                return true;
            }
            return false;
        }

        boolean isRunning() {
            for (ApcDomainNodeRunEntry apcDomainNodeRunEntry : this.nodes) {
                if (!apcDomainNodeRunEntry.isRunning()) continue;
                return true;
            }
            return false;
        }

        ApcDomainNodeRunEntry getNodeEntry(INodeModel iNodeModel, int n) {
            for (ApcDomainNodeRunEntry apcDomainNodeRunEntry : this.nodes) {
                if (!apcDomainNodeRunEntry.isForNode(iNodeModel, n)) continue;
                return apcDomainNodeRunEntry;
            }
            return null;
        }

        public String toString() {
            return this.domain.getName();
        }

        void updateState() {
            if (this.isCompleted()) {
                this.domain.setAPCProgressState(0);
                this.parent.terminated(this);
            } else if (this.isAborted()) {
                this.domain.setAPCProgressState(1);
                this.parent.terminated(this);
            } else if (this.isRunning()) {
                this.domain.setAPCProgressState(2);
            }
        }
    }

    private static class ApcRunEntries {
        private Map<ApcDomainDomainNode, ApcDomainRunEntry> domains = new HashMap<ApcDomainDomainNode, ApcDomainRunEntry>();

        private ApcRunEntries() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ApcDomainRunEntry initDomainEntry(ApcDomainDomainNode apcDomainDomainNode) {
            ApcDomainRunEntry apcDomainRunEntry;
            Map<ApcDomainDomainNode, ApcDomainRunEntry> map = this.domains;
            synchronized (map) {
                if (this.domains.containsKey(apcDomainDomainNode)) {
                    apcDomainRunEntry = this.domains.get(apcDomainDomainNode);
                    apcDomainRunEntry.init();
                } else {
                    apcDomainRunEntry = new ApcDomainRunEntry(this, apcDomainDomainNode);
                    this.domains.put(apcDomainDomainNode, apcDomainRunEntry);
                }
            }
            return apcDomainRunEntry;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ApcDomainNodeRunEntry getNodeEntryFor(IDwdmApcModel iDwdmApcModel) {
            ApcDomainNodeRunEntry apcDomainNodeRunEntry = null;
            INodeModel iNodeModel = iDwdmApcModel.getNodeModel();
            int n = iDwdmApcModel.getApcNodeSide();
            Map<ApcDomainDomainNode, ApcDomainRunEntry> map = this.domains;
            synchronized (map) {
                ApcDomainRunEntry apcDomainRunEntry;
                Collection<ApcDomainRunEntry> collection = this.domains.values();
                Iterator<ApcDomainRunEntry> iterator = collection.iterator();
                while (iterator.hasNext() && (apcDomainNodeRunEntry = (apcDomainRunEntry = iterator.next()).getNodeEntry(iNodeModel, n)) == null) {
                }
            }
            if (db.on()) {
                db.println("getNodeEntryFor found entry: " + apcDomainNodeRunEntry);
            }
            return apcDomainNodeRunEntry;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void terminated(ApcDomainRunEntry apcDomainRunEntry) {
            Map<ApcDomainDomainNode, ApcDomainRunEntry> map = this.domains;
            synchronized (map) {
                ApcDomainDomainNode apcDomainDomainNode = null;
                Set<ApcDomainDomainNode> set = this.domains.keySet();
                for (ApcDomainDomainNode apcDomainDomainNode2 : set) {
                    if (this.domains.get(apcDomainDomainNode2) != apcDomainRunEntry) continue;
                    apcDomainDomainNode = apcDomainDomainNode2;
                }
                if (apcDomainDomainNode != null) {
                    this.domains.remove(apcDomainDomainNode);
                } else {
                    db.warning("Cannot remove run entry for domain " + apcDomainRunEntry);
                }
            }
        }
    }
}

