/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.apc;

import cerent.cms.model.IApcDomainItem;
import cerent.cms.model.IDwdmApcModels;
import cerent.cms.model.IModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.WrongNodeSide;
import cerent.cms.topo.Network;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.DwdmSide;
import cerent.cms.ui.NetworkViewController;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.ViewName;
import cerent.cms.ui.apc.ApcDataSource;
import cerent.cms.ui.apc.ApcDomainDomainNode;
import cerent.cms.ui.apc.ApcDomainNode;
import cerent.cms.ui.apc.ApcDomainSpan;
import cerent.cms.ui.apc.ApcDomainsTableModel;
import cerent.util.CEMC;
import cerent.util.ErrorMsg;
import cerent.util.KDebug;
import cerent.util.NEMC;
import cerent.util.SDebug;
import cerent.util.WID;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import com.cisco.ctc.CtcApplication;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;

public class ApcDomainsPanePlugin
extends AbstractPane
implements ActionListener,
ListSelectionListener,
MouseListener {
    private int[] sortCols = new int[]{0};
    private boolean[] sortDir = new boolean[]{false};
    private static final SDebug db = new SDebug("ApcDomainsPanePlugin");
    private ApcDataSource dataSource;
    private JTree domainsTree;
    protected static final int FORCEDISABLEIDX = 0;
    protected static final int NAIDX = 1;
    protected static final int NAOPIDX = 2;
    protected static final int SELECTEDROWSIDX = 3;
    protected static final int ENABLEIDX = 4;
    private static final String RUN_APC = "Run APC";
    private static final String ENABLE_APC = "Enable APC";
    private static final String DISABLE_APC = "Disable APC";
    private JButton runAPCButton;
    private JButton disableapcButton;
    private static final int APC_FORCE_DISABLE = 0;
    private static final int APC_FREE_TO_RUN = 1;
    private ApcDomainsTableModel dataModel;

    public ApcDomainsPanePlugin(String string, IModel iModel, JTree jTree) {
        super(string, iModel, null);
        this.domainsTree = jTree;
    }

    private void init() {
        if (db.on()) {
            db.println("init");
        }
        this.setDefaultPrivilegeLevel(SecurityLevel.MAINTENANCE);
        this.setLayout(new BorderLayout());
        this.dataSource = new ApcDataSource(this.domainsTree);
        this.dataModel = new ApcDomainsTableModel(this.dataSource, this.sortCols, this.sortDir);
        this.table = new UTable((TableModel)((Object)this.dataModel));
        this.table.addMouseListener(this);
        this.table.getSelectionModel().setSelectionMode(2);
        ((ApcDomainsTableModel)((Object)this.table.getModel())).initTable(this.table);
        this.table.getSelectionModel().addListSelectionListener(this);
        this.add((Component)new UScrollPane((Component)this.table), "Center");
        this.add(this.getButtonPanel(), "South");
        this.initButtons();
    }

    private JPanel getButtonPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(0));
        this.runAPCButton = this.makeButton(RUN_APC);
        this.runAPCButton.setEnabled(false);
        jPanel.add(this.runAPCButton);
        this.disableapcButton = this.makeButton(DISABLE_APC);
        this.disableapcButton.setEnabled(false);
        jPanel.add(this.disableapcButton);
        this.updateUI();
        return jPanel;
    }

    private JButton makeButton(String string) {
        JButton jButton = new JButton(string);
        jButton.setMargin(new Insets(5, 5, 5, 5));
        Font font = jButton.getFont();
        jButton.setFont(font.deriveFont((float)font.getSize() - 2.0f));
        jButton.addActionListener(this);
        return jButton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enteringPage() throws Exception {
        try {
            if (this.uiToolkit != null) {
                this.uiToolkit.setCursor(3);
            }
            if (this.dataSource == null) {
                this.init();
            }
            this.dataSource.loadDataSource();
            TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
        }
        finally {
            if (this.uiToolkit != null) {
                this.uiToolkit.setCursor(0);
            }
        }
    }

    @Override
    public void leavingPage() throws Exception {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        this.dataSource.unloadDataSource();
    }

    protected int[] getSelectedDomainsStatus() {
        int[] nArray = new int[5];
        for (int i = 0; i < 5; ++i) {
            nArray[i] = 0;
        }
        int[] nArray2 = this.table.getSelectedRows();
        nArray[3] = nArray2.length;
        for (int i = 0; i < nArray2.length; ++i) {
            ApcDomainDomainNode apcDomainDomainNode = (ApcDomainDomainNode)this.table.getValueAt(nArray2[i], 0);
            if (!apcDomainDomainNode.isAllowOperation()) {
                nArray[2] = nArray[2] + 1;
            } else {
                nArray[4] = nArray[4] + 1;
            }
            if (apcDomainDomainNode.getAPCAdminState() == 0) {
                nArray[0] = nArray[0] + 1;
            }
            if (apcDomainDomainNode.getAPCState() != 3) continue;
            nArray[1] = nArray[1] + 1;
        }
        return nArray;
    }

    @Override
    public void refresh() {
        this.table.getSelectionModel().clearSelection();
    }

    @Override
    public void destroy() {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.destroy();
        if (this.dataSource != null) {
            this.dataSource.dispose();
            this.dataSource = null;
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        int[] nArray = this.table.getSelectedRows();
        if (object == this.disableapcButton) {
            ApcDomainDomainNode[] apcDomainDomainNodeArray;
            List<ApcDomainDomainNode> list = this.dataModel.getValuesAt(nArray, ApcDomainDomainNode.class);
            block4: for (ApcDomainDomainNode apcDomainDomainNode : apcDomainDomainNodeArray = list.toArray(new ApcDomainDomainNode[0])) {
                ApcDomainSpan[] apcDomainSpanArray;
                for (ApcDomainSpan apcDomainSpan : apcDomainSpanArray = (ApcDomainSpan[])apcDomainDomainNode.getChildren(new ApcDomainSpan[0])) {
                    int n;
                    IApcDomainItem iApcDomainItem = null;
                    IApcDomainItem iApcDomainItem2 = apcDomainSpan.getFrom();
                    IApcDomainItem iApcDomainItem3 = apcDomainSpan.getTo();
                    if (iApcDomainItem2 != null) {
                        iApcDomainItem = apcDomainSpan.getFrom();
                    } else {
                        if (iApcDomainItem3 == null) continue;
                        iApcDomainItem = apcDomainSpan.getTo();
                    }
                    INodeModel iNodeModel = ApcDomainNode.getNodeModel(iApcDomainItem);
                    if (iApcDomainItem.getSideIn() != 0) {
                        n = iApcDomainItem.getSideIn();
                    } else {
                        if (iApcDomainItem.getSideOut() == 0) continue;
                        n = iApcDomainItem.getSideOut();
                    }
                    if (iNodeModel == null || !iNodeModel.getConnectionState()) continue;
                    IDwdmApcModels iDwdmApcModels = iNodeModel.getIDwdmApcModels();
                    if (iDwdmApcModels == null) {
                        if (db.on()) {
                            db.println("IDwdmApcModels is null, node: " + iNodeModel.getName());
                        }
                        return;
                    }
                    if (this.disableapcButton.getText().equals(ENABLE_APC)) {
                        if (db.on()) {
                            db.println("Enable: APC for node " + iNodeModel.getName() + " side " + DwdmSide.getSideFromOffset(n));
                        }
                        try {
                            iDwdmApcModels.setApcAdminState(1, (short)n);
                            continue block4;
                        }
                        catch (WrongNodeSide wrongNodeSide) {
                            KDebug.printStackTrace((Throwable)wrongNodeSide);
                            continue;
                        }
                    }
                    if (db.on()) {
                        db.println("Disable: APC for node " + iNodeModel.getName() + " side " + DwdmSide.getSideFromOffset(n));
                    }
                    try {
                        iDwdmApcModels.setApcAdminState(0, (short)n);
                        continue block4;
                    }
                    catch (WrongNodeSide wrongNodeSide) {
                        KDebug.printStackTrace((Throwable)wrongNodeSide);
                    }
                }
            }
            this.table.getSelectionModel().clearSelection();
        } else if (object == this.runAPCButton) {
            List<ApcDomainDomainNode> list = this.dataModel.getValuesAt(nArray, ApcDomainDomainNode.class);
            ApcDomainDomainNode[] apcDomainDomainNodeArray = list.toArray(new ApcDomainDomainNode[0]);
            this.dataSource.runApc(apcDomainDomainNodeArray);
            this.table.getSelectionModel().clearSelection();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.initButtons();
    }

    private void initButtons() {
        boolean bl = false;
        int[] nArray = this.getSelectedDomainsStatus();
        if (nArray[2] > 0) {
            this.disableapcButton.setText(DISABLE_APC);
            this.disableapcButton.setEnabled(false);
            return;
        }
        if (nArray[0] == 0 && nArray[3] > 0) {
            bl = true;
        }
        if (nArray[0] > 0 && nArray[0] == nArray[3]) {
            this.disableapcButton.setText(ENABLE_APC);
        } else {
            this.disableapcButton.setText(DISABLE_APC);
        }
        if (nArray[4] > 0 && nArray[1] == 0 && nArray[0] == 0 || nArray[0] > 0 && nArray[0] == nArray[3]) {
            this.enableComponent(this.disableapcButton, this.getUiModel(), SecurityLevel.MAINTENANCE);
        } else {
            this.disableapcButton.setEnabled(false);
        }
        if (bl) {
            this.enableComponent(this.runAPCButton, this.getUiModel(), SecurityLevel.MAINTENANCE);
        } else {
            this.runAPCButton.setEnabled(false);
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        NetworkViewController networkViewController;
        int[] nArray;
        ViewName viewName;
        INodeModel iNodeModel;
        ApcDomainDomainNode apcDomainDomainNode;
        int[] nArray2;
        if (mouseEvent.getClickCount() == 2 && (nArray2 = this.table.getSelectedRows()).length == 1 && (apcDomainDomainNode = (ApcDomainDomainNode)this.dataModel.getValueAt(nArray2[0], 0)).getAPCProgressState() == 1 && this.isNodeOperational(iNodeModel = Network.instance().findNetElem(apcDomainDomainNode.getAPCFailingNodeId()).getNodeModel()) && this.isNodeManageable(iNodeModel) && (viewName = new ViewName(nArray = new int[]{iNodeModel.getNodeId(), 0, 0, 0, 0, 0})) != null && (networkViewController = CtcApplication.instance().getMainPanel().getNetworkViewController()) != null && viewName != null) {
            networkViewController.tryJumpView(viewName);
        }
    }

    protected boolean isNodeOperational(INodeModel iNodeModel) {
        if (iNodeModel.isInited() && iNodeModel.getConnectionState()) {
            return true;
        }
        ErrorMsg.displayWarning((Component)((Object)this), (WID)NEMC.WID_NODE_NOT_INITIALIZED_PARAM_1, (Object)iNodeModel.getName());
        return false;
    }

    protected boolean isNodeManageable(INodeModel iNodeModel) {
        if (iNodeModel.isManageable()) {
            return true;
        }
        ErrorMsg.displayWarning((Component)((Object)this), (WID)CEMC.WID_NO_NODE_MANAGEMENT_PARAM_1, (Object)iNodeModel.getName());
        return false;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }
}

