/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.apc;

import cerent.cms.topo.INetElement;
import cerent.cms.topo.Network;
import cerent.cms.ui.ApcRenderer;
import cerent.cms.ui.apc.ApcDataSource;
import cerent.cms.ui.apc.ApcDomainDomainNode;
import cerent.util.gui.row.AbstractColumnRenderer;
import cerent.util.gui.row.ColumnRenderer;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;

public class ApcDomainsTableColumnRenderer
extends AbstractColumnRenderer {
    public static final int DOMAIN_INDEX = 0;
    public static final int STATE_INDEX = 1;
    public static final int ADMIN_STATE_INDEX = 2;
    public static final int PROGRESS_STATE_INDEX = 3;
    private static final int COLUMN_NO = 4;
    private JLabel label;
    private ApcDataSource dataSource;

    public ApcDomainsTableColumnRenderer(ApcDataSource apcDataSource, String string, int n, boolean bl, int n2) {
        super(string, n, bl, n2);
        this.dataSource = apcDataSource;
        this.label = new JLabel();
        this.label.setHorizontalAlignment(n2);
        this.label.setVerticalAlignment(1);
        this.label.setOpaque(true);
        this.label.setForeground(Color.black);
        this.label.setFont(this.label.getFont().deriveFont(0));
    }

    protected String getStringValue(ApcDomainDomainNode apcDomainDomainNode, int n) {
        String string = "???";
        if (apcDomainDomainNode != null) {
            switch (n) {
                case 0: {
                    string = apcDomainDomainNode.getName();
                    break;
                }
                case 1: {
                    string = ApcRenderer.getAPCStateAsString(apcDomainDomainNode.getAPCState());
                    break;
                }
                case 2: {
                    string = ApcRenderer.getAPCAdminStateAsString(apcDomainDomainNode.getAPCAdminState());
                    break;
                }
                case 3: {
                    INetElement iNetElement;
                    StringBuffer stringBuffer = new StringBuffer(ApcRenderer.getAPCProgressStateAsString(apcDomainDomainNode.getAPCProgressState()));
                    if (apcDomainDomainNode.getAPCProgressState() == 1 && (iNetElement = Network.instance().findNetElem(apcDomainDomainNode.getAPCFailingNodeId())) != null) {
                        stringBuffer.append(" on " + iNetElement.getName());
                    }
                    string = stringBuffer.toString();
                }
            }
        }
        return string;
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        ApcDomainDomainNode apcDomainDomainNode;
        JLabel jLabel = this.label;
        try {
            apcDomainDomainNode = (ApcDomainDomainNode)object;
        }
        catch (Exception exception) {
            this.label.setText("");
            return jLabel;
        }
        String string = this.getStringValue(apcDomainDomainNode, n2);
        Color color = bl ? jTable.getSelectionBackground() : jTable.getBackground();
        Color color2 = bl ? jTable.getSelectionForeground() : jTable.getForeground();
        this.label.setToolTipText("");
        this.label.setText(string);
        ((Component)jLabel).setForeground(color2);
        ((Component)jLabel).setBackground(color);
        return jLabel;
    }

    static ColumnRenderer[] createTableRenderers(ApcDataSource apcDataSource) {
        ColumnRenderer[] columnRendererArray = new ColumnRenderer[4];
        for (int i = 0; i < columnRendererArray.length; ++i) {
            columnRendererArray[i] = ApcDomainsTableColumnRenderer.createColumnRenderer(apcDataSource, i);
        }
        return columnRendererArray;
    }

    public static ColumnRenderer createColumnRenderer(ApcDataSource apcDataSource, int n) {
        int n2;
        boolean bl;
        int n3;
        String string;
        switch (n) {
            case 0: {
                string = "Domain";
                n3 = 350;
                bl = true;
                n2 = 2;
                break;
            }
            case 1: {
                string = "APC State";
                n3 = 125;
                bl = true;
                n2 = 2;
                break;
            }
            case 2: {
                string = "Admin State";
                n3 = 125;
                bl = true;
                n2 = 2;
                break;
            }
            case 3: {
                string = "Progress State";
                n3 = 125;
                bl = true;
                n2 = 2;
                break;
            }
            default: {
                string = "???";
                n3 = 20;
                bl = false;
                n2 = 2;
            }
        }
        return new ApcDomainsTableColumnRenderer(apcDataSource, string, n3, bl, n2);
    }

    @Override
    public int compareColumn(Object object, Object object2, int n) {
        String string = this.getStringValue((ApcDomainDomainNode)object, n);
        String string2 = this.getStringValue((ApcDomainDomainNode)object2, n);
        return string.compareTo(string2);
    }
}

