/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.blsr;

import cerent.cms.model.ITdmPortModel;
import cerent.cms.model.NodeModel;
import cerent.cms.model.blsr.BlsrNode;
import cerent.cms.model.blsr.BlsrRingModel;
import cerent.cms.model.blsr.BlsrSpan;
import cerent.cms.topo.INetLink;
import cerent.cms.ui.blsr.AbstractBlsrMap;
import cerent.cms.ui.blsr.BlsrMapFactory;
import cerent.cms.ui.blsr.BlsrMapLink;
import cerent.cms.ui.blsr.BlsrMapLinkCookie;
import cerent.cms.ui.blsr.BlsrMapNode;
import cerent.cms.ui.blsr.BlsrMapNodeCookie;
import cerent.cms.ui.blsr.RcdCreationPane;
import cerent.util.SDebug;
import com.cisco.ctc.util.map.MapLink;
import com.cisco.ctc.util.map.MapNode;
import java.util.Observable;

public class BlsrDesignMap
extends AbstractBlsrMap {
    private static final SDebug db = new SDebug("BlsrDesignMap");
    private RcdCreationPane rcdCreationPane;
    private BlsrSpan[] potentialWorkingSpans = null;

    BlsrDesignMap(RcdCreationPane rcdCreationPane) {
        super(db, 0, BlsrMapFactory.instance());
        this.rcdCreationPane = rcdCreationPane;
        this.reInitMap();
        this.doZoomIn();
        this.setLinkOffset(12);
    }

    @Override
    public void linkSelected(MapLink mapLink, boolean bl) {
        if (BlsrDesignMap.db.on) {
            db.println("linkSelected(link=" + mapLink + ", sel=" + bl);
        }
        if (this.rcdCreationPane != null) {
            this.rcdCreationPane.linkSelected(mapLink, bl);
        }
    }

    @Override
    public void nodeSelected(MapNode mapNode, boolean bl) {
        if (BlsrDesignMap.db.on) {
            db.println("nodeSelected(node=" + mapNode + ", sel=" + bl);
        }
        if (this.rcdCreationPane != null) {
            this.rcdCreationPane.nodeSelected(mapNode, bl);
        }
    }

    @Override
    public void doubleClicked(MapNode mapNode) {
        if (BlsrDesignMap.db.on) {
            db.println("nodeDoubleClicked(node=" + mapNode + ")");
        }
    }

    @Override
    public void update(Observable observable, Object object) {
    }

    @Override
    public BlsrRingModel getRingModel() {
        return null;
    }

    public void showBlsrObjects() {
        if (BlsrDesignMap.db.on) {
            db.println("In BlsrDesignMap showing Blsr Objects ...");
        }
        this.potentialWorkingSpans = this.rcdCreationPane.getPotentialWorkingSpans();
        if (this.potentialWorkingSpans.length == 0) {
            if (BlsrDesignMap.db.on) {
                db.println("NO POTENTIAL WORKING SPANS!!!");
            }
        } else {
            for (int i = 0; i < this.potentialWorkingSpans.length; ++i) {
                BlsrSpan blsrSpan = this.potentialWorkingSpans[i];
                if (BlsrDesignMap.db.on) {
                    db.println("potentialWorkingSpan is: " + this.potentialWorkingSpans[i]);
                }
                this.addBlsrSpan(blsrSpan);
            }
        }
    }

    private void addBlsrSpan(BlsrSpan blsrSpan) {
        INetLink iNetLink;
        if (BlsrDesignMap.db.on) {
            db.println("addBlsrSpan(span=" + blsrSpan + ")");
        }
        if ((iNetLink = this.getNetLink(blsrSpan)) != null) {
            Object object;
            Object object2;
            ITdmPortModel iTdmPortModel;
            ITdmPortModel iTdmPortModel2;
            BlsrMapNode blsrMapNode;
            BlsrMapNode blsrMapNode2;
            BlsrRingModel blsrRingModel;
            block30: {
                NodeModel nodeModel = (NodeModel)iNetLink.getSrc().getNodeModel();
                NodeModel nodeModel2 = (NodeModel)iNetLink.getDst().getNodeModel();
                if (BlsrDesignMap.db.on) {
                    if (null != nodeModel) {
                        db.println("srcNodeModel is: " + nodeModel + " and its class is: " + nodeModel.getClass());
                    } else {
                        db.println("srcNodeModel is NULL ");
                    }
                    if (null != nodeModel2) {
                        db.println("dstNodeModel is: " + nodeModel2 + " and its class is: " + nodeModel2.getClass());
                    } else {
                        db.println("dstNodeModel is NULL ");
                    }
                }
                blsrRingModel = this.rcdCreationPane.getBlsrRingModel();
                BlsrNode blsrNode = blsrRingModel.getBlsrNode(nodeModel);
                BlsrNode blsrNode2 = blsrRingModel.getBlsrNode(nodeModel2);
                if (BlsrDesignMap.db.on) {
                    if (null != blsrNode) {
                        db.println("srcBlsrNode is: " + blsrNode);
                    } else {
                        db.println("srcBlsrNode is NULL");
                    }
                    if (null != blsrNode2) {
                        db.println("dstBlsrNode is: " + blsrNode2);
                    } else {
                        db.println("dstBlsrNode is NULL");
                    }
                    db.println("... adding nodes to map now ...");
                }
                BlsrMapNodeCookie blsrMapNodeCookie = new BlsrMapNodeCookie(blsrNode);
                this.addNode(nodeModel, true, blsrMapNodeCookie);
                blsrMapNodeCookie = new BlsrMapNodeCookie(blsrNode2);
                this.addNode(nodeModel2, true, blsrMapNodeCookie);
                blsrMapNode2 = this.getBlsrMapNode(nodeModel);
                blsrMapNode = this.getBlsrMapNode(nodeModel2);
                if (BlsrDesignMap.db.on) {
                    db.println("BlsrMapNode srcBlsrMapNode gotten back is: " + blsrMapNode2);
                    db.println("BlsrMapNode dstBlsrMapNode gotten back is: " + blsrMapNode);
                }
                if ((null == blsrMapNode2 || null == blsrMapNode) && BlsrDesignMap.db.on) {
                    db.println("Either the srcBlsrMapNode or the dstBlsrMapNode is null!");
                    db.println("srcBlsrMapNode is: " + blsrMapNode2);
                    db.println("dstBlsrMapNode is: " + blsrMapNode);
                }
                iTdmPortModel2 = null;
                iTdmPortModel = null;
                try {
                    object2 = nodeModel.getEntityTableModel().getEntityModelByIndex(iNetLink.getSrcEntityIndex());
                    if (object2 instanceof ITdmPortModel) {
                        iTdmPortModel2 = (ITdmPortModel)object2;
                    }
                    if ((object = nodeModel2.getEntityTableModel().getEntityModelByIndex(iNetLink.getDstEntityIndex())) instanceof ITdmPortModel) {
                        iTdmPortModel = (ITdmPortModel)object;
                    }
                }
                catch (Exception exception) {
                    if (!BlsrDesignMap.db.on) break block30;
                    db.println("Exception caught in BlsrDesignMap.addBlsrSpan:" + exception);
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
            object2 = new BlsrMapLinkCookie(blsrSpan, iTdmPortModel2, iTdmPortModel);
            this.addLink(iNetLink, object2);
            if (BlsrDesignMap.db.on) {
                if (null != blsrMapNode2) {
                    db.println("srcBlsrMapNode is: " + blsrMapNode2 + " and its class is: " + blsrMapNode2.getClass());
                } else {
                    db.println("srcBlsrMapNode is: NULL");
                }
                if (null != blsrMapNode) {
                    db.println("dstBlsrMapNode is: " + blsrMapNode + " and its class is: " + blsrMapNode.getClass());
                } else {
                    db.println("dstBlsrMapNode is: NULL");
                }
            }
            if (null != iTdmPortModel2 && BlsrDesignMap.db.on) {
                db.println("srcPortModel is: " + iTdmPortModel2 + " and its class is: " + iTdmPortModel2.getClass());
            }
            if (null != iTdmPortModel && BlsrDesignMap.db.on) {
                db.println("dstPortModel is: " + iTdmPortModel + " and its class is: " + iTdmPortModel.getClass());
            }
            if (null != (object = this.getBlsrMapLink(iNetLink))) {
                ((BlsrMapLink)object).setIncluded(blsrRingModel.isProposedSpan(blsrSpan));
            } else if (BlsrDesignMap.db.on) {
                db.println("blsrMapLink is null!");
            }
        } else if (BlsrDesignMap.db.on) {
            db.println("Trying to add a BlsrSpan (" + blsrSpan + ") that has no associated INetLink!");
        }
        this.updateView();
    }

    @Override
    public void doubleClicked(MapLink mapLink) {
        if (BlsrDesignMap.db.on) {
            db.println("doubleClicked (mapLink=" + mapLink + ")");
        }
        if (this.rcdCreationPane != null) {
            this.rcdCreationPane.doubleClicked(mapLink);
        }
    }

    @Override
    public void dispose() {
        if (BlsrDesignMap.db.on) {
            db.println("dispose() called");
        }
        this.potentialWorkingSpans = null;
        super.dispose();
    }
}

