/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.cfm;

import cerent.cms.model.DomainProfileInfo;
import cerent.cms.model.IDomainProfileInfo;
import cerent.cms.ui.AbstractProvTableModel;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.NEMC;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.util.ArrayList;
import javax.swing.JOptionPane;

public class DomainProfileTableModel
extends AbstractProvTableModel {
    private ArrayList<IDomainProfileInfo> dProfileList = new ArrayList();
    private Frame frame;
    private boolean isDirty;
    private static final int MAX_LEVEL = 7;

    public DomainProfileTableModel(Container container, boolean bl, String string) {
        super(null, false, "");
        this.frame = JOptionPane.getFrameForComponent(container);
        this.columnNames = new String[]{"Domain Name", "Level"};
    }

    @Override
    public Class getColumnClass(int n) {
        switch (n) {
            case 0: {
                return String.class;
            }
            case 1: {
                return Short.class;
            }
        }
        return Boolean.class;
    }

    @Override
    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.dProfileList.size();
    }

    protected void addDomainProfileTableRow(int n) {
        for (int i = 0; i < n; ++i) {
            this.dProfileList.add(new DomainProfileInfo());
        }
        this.fireTableDataChanged();
    }

    protected void removeDomainProfileTableRow(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i] - i;
            IDomainProfileInfo iDomainProfileInfo = this.dProfileList.remove(n);
        }
        this.fireTableDataChanged();
    }

    protected ArrayList<IDomainProfileInfo> getDomainProfilesFromTable(int[] nArray) {
        ArrayList<IDomainProfileInfo> arrayList = new ArrayList<IDomainProfileInfo>();
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            IDomainProfileInfo iDomainProfileInfo = this.dProfileList.get(n);
            arrayList.add(iDomainProfileInfo);
        }
        return arrayList;
    }

    public void applyToModel() throws Exception {
    }

    @Override
    public Object getValueAt(int n, int n2) {
        IDomainProfileInfo iDomainProfileInfo = this.dProfileList.get(n);
        switch (n2) {
            case 0: {
                return new String(iDomainProfileInfo.getDomainName());
            }
            case 1: {
                if (iDomainProfileInfo.getDomainLevel() == -1) {
                    return null;
                }
                return new Short(iDomainProfileInfo.getDomainLevel());
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        IDomainProfileInfo iDomainProfileInfo = this.dProfileList.get(n);
        switch (n2) {
            case 1: {
                Short s = (Short)object;
                if (s != null && s >= 0 && s <= 7) {
                    iDomainProfileInfo.setDomainLevel(s.shortValue());
                    break;
                }
                ErrorMsg.displayError((Component)this.frame, (EID)NEMC.EID_CFM_DOMAIN_LEVEL_ERROR);
                break;
            }
            case 0: {
                if (object != null && ((String)object).length() > 0 && ((String)object).length() <= 43) {
                    if (this.isProfileNameExists((String)object)) {
                        ErrorMsg.displayError((Component)this.frame, (EID)NEMC.EID_CFM_DOMAIN_EXISTS_ERROR);
                        break;
                    }
                    iDomainProfileInfo.setDomainName((String)object);
                    break;
                }
                ErrorMsg.displayError((Component)this.frame, (EID)NEMC.EID_CFM_DOMAIN_LENGTH_ERROR);
            }
        }
    }

    private boolean isProfileNameExists(String string) {
        IDomainProfileInfo iDomainProfileInfo = null;
        for (int i = 0; i < this.dProfileList.size(); ++i) {
            iDomainProfileInfo = this.dProfileList.get(i);
            if (iDomainProfileInfo == null || !string.equals(iDomainProfileInfo.getDomainName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        switch (n2) {
            default: 
        }
        return true;
    }

    public ArrayList<IDomainProfileInfo> getDomainProfileCurrentList(boolean bl) {
        if (bl) {
            this.removeNotValidDomainProfile();
        }
        return this.dProfileList;
    }

    private void removeNotValidDomainProfile() {
        ArrayList<IDomainProfileInfo> arrayList = new ArrayList<IDomainProfileInfo>();
        IDomainProfileInfo iDomainProfileInfo = null;
        for (int i = 0; i < this.dProfileList.size(); ++i) {
            iDomainProfileInfo = this.dProfileList.get(i);
            if (!iDomainProfileInfo.isValid()) continue;
            arrayList.add(iDomainProfileInfo);
        }
        this.dProfileList = arrayList;
        this.fireTableDataChanged();
    }

    protected boolean checkForInvalidDomains() {
        boolean bl = false;
        IDomainProfileInfo iDomainProfileInfo = null;
        for (int i = 0; i < this.dProfileList.size(); ++i) {
            iDomainProfileInfo = this.dProfileList.get(i);
            if (iDomainProfileInfo.isValid()) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public void setDomainProfileCurrentList(ArrayList<IDomainProfileInfo> arrayList) {
        this.dProfileList = arrayList;
        for (int i = 0; i < arrayList.size(); ++i) {
            IDomainProfileInfo iDomainProfileInfo = arrayList.get(i);
        }
        this.fireTableDataChanged();
    }

    public void forceDirty() {
        this.isDirty = true;
    }

    @Override
    public boolean isDirty() {
        return this.isDirty;
    }

    public void resetDirty() {
        this.isDirty = false;
    }

    public void setEmptyTableModel() {
        this.setDomainProfileCurrentList(new ArrayList<IDomainProfileInfo>());
        this.isDirty = false;
    }
}

