/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.AbstractCmsNoSuchElementException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.Attribute;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IInterfaceModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.IYCableModel;
import cerent.cms.model.NoSuchEquipment;
import cerent.cms.topo.INetLink;
import cerent.cms.ui.NetworkDefaults;
import cerent.cms.ui.circuits.AbstractProtectedCircuitMapPort;
import cerent.cms.ui.circuits.CircuitMap;
import cerent.cms.ui.network.CircuitMapLine;
import cerent.cms.ui.network.CircuitMapNode;
import cerent.cms.ui.network.CircuitMapPort;
import cerent.cms.ui.network.NetMapLink;
import cerent.util.IObservable;
import cerent.util.IObserver;
import cerent.util.SDebug;
import com.cisco.ctc.util.map.DetailedMapNode;
import com.cisco.ctc.util.map.IMapLineEndpoint;
import com.cisco.ctc.util.map.MapGraphicsUtil;
import com.cisco.ctc.util.map.MapLine;
import com.cisco.ctc.util.map.MapPort;
import com.cisco.ctc.util.map.MapSelector;
import com.cisco.ctc.util.map.MapToolkit;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Observable;
import javax.swing.SwingUtilities;

public abstract class AbstractProtectedCircuitMapNode
extends CircuitMapNode {
    private static Attribute[] switchAttrs;
    private static final SDebug db;
    private MapToolkit mtk;

    public AbstractProtectedCircuitMapNode(MapToolkit mapToolkit) {
        super(mapToolkit);
        this.mtk = mapToolkit;
        if (switchAttrs == null) {
            try {
                switchAttrs = NetworkDefaults.getAttributeMap().getAttributeArray("protectionOp");
            }
            catch (Exception exception) {
                db.println("Cannot obtain switchAttrs.");
                return;
            }
        }
    }

    static Attribute getAttributeForVal(int n) {
        if (switchAttrs != null) {
            for (int i = 0; i < switchAttrs.length; ++i) {
                if (switchAttrs[i].getIntValue() != n) continue;
                return switchAttrs[i];
            }
        }
        return null;
    }

    @Override
    protected void deleteObservers() {
        MapSelector[] mapSelectorArray = this.getSelectors();
        for (int i = 0; i < mapSelectorArray.length; ++i) {
            ProtectedMapSelector protectedMapSelector = (ProtectedMapSelector)mapSelectorArray[i];
            protectedMapSelector.deleteObserver();
        }
        super.deleteObservers();
    }

    @Override
    protected MapSelector createMapSelector(DetailedMapNode detailedMapNode) {
        ProtectedMapSelector protectedMapSelector = new ProtectedMapSelector(detailedMapNode);
        protectedMapSelector.init(new Integer(0), null);
        return protectedMapSelector;
    }

    public void addSelector(INodeModel iNodeModel, int n) {
        IEntityModel[] iEntityModelArray;
        String string = "addSelector():";
        ProtectedMapSelector protectedMapSelector = (ProtectedMapSelector)this.addSelector();
        try {
            iEntityModelArray = this.getPgPorts(iNodeModel, n);
        }
        catch (Exception exception) {
            db.println("Cannot get PG ports for node " + iNodeModel + "unprot port " + Integer.toHexString(n));
            return;
        }
        if (db.on()) {
            db.println(string + " found " + iEntityModelArray.length + " PG ports.");
        }
        MapPort[] mapPortArray = this.getPorts(true);
        for (int i = 0; i < iEntityModelArray.length; ++i) {
            boolean bl;
            IEntityModel iEntityModel = iEntityModelArray[i];
            int n2 = iEntityModel.getEntityIndex();
            AbstractProtectedCircuitMapPort abstractProtectedCircuitMapPort = null;
            for (bl = false; abstractProtectedCircuitMapPort == null && bl < mapPortArray.length; bl += 1) {
                MapPort mapPort = mapPortArray[bl];
                if (this.getEntityIndex(mapPort) != n2) continue;
                abstractProtectedCircuitMapPort = (AbstractProtectedCircuitMapPort)mapPort;
            }
            if (abstractProtectedCircuitMapPort != null) {
                bl = abstractProtectedCircuitMapPort.isWorkingPort();
                boolean bl2 = abstractProtectedCircuitMapPort.isActivePort();
                protectedMapSelector.addPort(abstractProtectedCircuitMapPort, iEntityModel, bl2);
                if (db.on()) {
                    db.println("Found map port " + abstractProtectedCircuitMapPort + " for PG port " + iEntityModel + " (is working?  " + bl + ")");
                }
                protectedMapSelector.setSuffixString(abstractProtectedCircuitMapPort, bl2, bl);
                Color color = bl2 ? NetMapLink.LINK_ACTIVE_COLOR : NetMapLink.LINK_STANDBY_COLOR;
                int n3 = bl2 ? 4 : 5;
                protectedMapSelector.addPort(abstractProtectedCircuitMapPort);
                CircuitMapLine circuitMapLine = (CircuitMapLine)this.addMapLine(protectedMapSelector, abstractProtectedCircuitMapPort, null);
                if (circuitMapLine == null) continue;
                circuitMapLine.setState(n3);
                if (!db.on()) continue;
                db.println(string + " added map line,  lineColor= " + MapGraphicsUtil.getColorString(color));
                continue;
            }
            if (!db.on()) continue;
            db.println("Map port not found for PG port " + iEntityModel);
        }
        if (db.on()) {
            db.println(string + " selector=" + protectedMapSelector + " node=" + iNodeModel.getName());
        }
    }

    @Override
    protected void updateOneSelector() {
        MapSelector mapSelector;
        MapSelector[] mapSelectorArray = this.getSelectors();
        MapSelector mapSelector2 = mapSelector = mapSelectorArray == null && mapSelectorArray.length > 0 ? null : mapSelectorArray[0];
        if (mapSelector == null) {
            if (db.on()) {
                db.println("updateOneSelector(): MapSelector not found");
            }
            return;
        }
        int n = this.getUnprotectedSelectorSide();
        mapSelector.setSide(n);
        mapSelector.updatePositionInNode();
        super.updateOneSelector();
    }

    @Override
    public int getEntityIndex(MapPort mapPort) {
        return super.getEntityIndex(mapPort);
    }

    protected abstract IEntityModel[] getPgPorts(INodeModel var1, int var2) throws AbstractCmsNoSuchEntityException, NoSuchEquipment;

    protected abstract MapPort getUnprotectedPgPort();

    protected abstract int getUnprotectedSelectorSide();

    static {
        db = new SDebug("AbstractProtectedCircuitMapNode");
    }

    class ProtectedMapSelector
    extends MapSelector
    implements IObserver {
        private ArrayList pgPorts;
        private ArrayList pgMapPorts;
        private IYCableModel ycm;

        public ProtectedMapSelector(DetailedMapNode detailedMapNode) {
            super(detailedMapNode);
            this.pgPorts = new ArrayList();
            this.pgMapPorts = new ArrayList();
        }

        public void deleteObserver() {
            if (db.on()) {
                db.println("deleteObserver");
            }
            if (this.ycm != null) {
                this.ycm.deleteObserver((IObserver)this);
            }
            MapLine[] mapLineArray = this.parentNode.getLines();
            for (int i = 0; i < mapLineArray.length; ++i) {
                IMapLineEndpoint iMapLineEndpoint;
                MapLine mapLine = mapLineArray[i];
                IPortModel iPortModel = null;
                if (mapLine instanceof CircuitMapLine) {
                    iMapLineEndpoint = mapLine.getStartPoint();
                    if (!(iMapLineEndpoint instanceof AbstractProtectedCircuitMapPort)) {
                        iMapLineEndpoint = mapLine.getFinishPoint();
                    }
                    if (iMapLineEndpoint instanceof AbstractProtectedCircuitMapPort) {
                        iPortModel = ((AbstractProtectedCircuitMapPort)iMapLineEndpoint).getInternalPort();
                    }
                }
                if (iPortModel == null) continue;
                iMapLineEndpoint = iPortModel.getInterfaceModel();
                iMapLineEndpoint.deleteObserver(this);
            }
        }

        void addPort(MapPort mapPort, IEntityModel iEntityModel, boolean bl) {
            String string = this.stringFromProtectionOp(mapPort, bl);
            int n = string.indexOf(" ");
            if (n < string.length() - 1) {
                this.setLetter(string.charAt(n + 1));
            } else {
                this.setLetter('\u0000');
            }
            this.pgPorts.add(iEntityModel);
            this.pgMapPorts.add(mapPort);
            if (mapPort instanceof AbstractProtectedCircuitMapPort) {
                AbstractProtectedCircuitMapPort abstractProtectedCircuitMapPort = (AbstractProtectedCircuitMapPort)mapPort;
                abstractProtectedCircuitMapPort.setProtectionString(string);
                if (this.ycm == null) {
                    block8: {
                        try {
                            this.ycm = abstractProtectedCircuitMapPort.getYCableOrSplitterModel();
                        }
                        catch (AbstractCmsNoSuchElementException abstractCmsNoSuchElementException) {
                            if (!db.on()) break block8;
                            db.println("Cannot find YCableModel for " + iEntityModel + ": " + abstractCmsNoSuchElementException.getMessage());
                        }
                    }
                    if (this.ycm != null) {
                        this.ycm.addObserver((IObserver)this);
                    }
                }
                IInterfaceModel iInterfaceModel = abstractProtectedCircuitMapPort.getInternalPort().getInterfaceModel();
                iInterfaceModel.addObserver((IObserver)this);
            }
            if (db.on()) {
                db.println("Added PG port (W or P) to selector: " + iEntityModel + ", op = " + string);
            }
        }

        @Override
        public String getToolTipText() {
            return "selector";
        }

        public void update(IObservable iObservable, Object object) {
            this._update(iObservable, object);
        }

        public void update(Observable observable, Object object) {
            this._update(observable, object);
        }

        public void _update(Object object, Object object2) {
            if (db.on()) {
                db.println("Received update from " + object);
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProtectedMapSelector.this.updateMapSelector();
                    ProtectedMapSelector.this.updateMapLines();
                    ProtectedMapSelector.this.updateMapLinks();
                }
            });
        }

        private void updateMapSelector() {
            MapPort[] mapPortArray = this.parentNode.getPorts(true);
            char c = '\u0000';
            for (int i = 0; i < mapPortArray.length; ++i) {
                int n;
                MapPort mapPort = mapPortArray[i];
                if (!(mapPort instanceof AbstractProtectedCircuitMapPort)) continue;
                AbstractProtectedCircuitMapPort abstractProtectedCircuitMapPort = (AbstractProtectedCircuitMapPort)mapPort;
                boolean bl = abstractProtectedCircuitMapPort.isActivePort();
                String string = this.stringFromProtectionOp(mapPort, bl);
                if (c == '\u0000' && (n = string.indexOf(" ")) < string.length() - 1) {
                    c = string.charAt(n + 1);
                }
                abstractProtectedCircuitMapPort.setProtectionString(string);
            }
            this.setLetter(c);
        }

        private void updateMapLines() {
            MapLine[] mapLineArray = this.parentNode.getLines();
            for (int i = 0; i < mapLineArray.length; ++i) {
                MapLine mapLine = mapLineArray[i];
                if (!(mapLine instanceof CircuitMapLine)) continue;
                CircuitMapLine circuitMapLine = (CircuitMapLine)mapLine;
                IMapLineEndpoint iMapLineEndpoint = mapLine.getStartPoint();
                if (!(iMapLineEndpoint instanceof AbstractProtectedCircuitMapPort)) {
                    iMapLineEndpoint = mapLine.getFinishPoint();
                }
                if (!(iMapLineEndpoint instanceof AbstractProtectedCircuitMapPort)) continue;
                this.updateMapLine(circuitMapLine, (AbstractProtectedCircuitMapPort)iMapLineEndpoint);
            }
        }

        private void updateMapLinks() {
            CircuitMap circuitMap = (CircuitMap)this.mtk;
            Collection collection = circuitMap.getLinkUserObjects();
            for (Object e : collection) {
                if (!(e instanceof INetLink)) continue;
                INetLink iNetLink = (INetLink)e;
                if (db.on()) {
                    db.println("Updating link " + iNetLink + " - Is Active = " + circuitMap.isOchTrailTunnelExpandedLinkActive(iNetLink));
                }
                circuitMap.updateLink(iNetLink);
            }
        }

        private void updateMapLine(CircuitMapLine circuitMapLine, AbstractProtectedCircuitMapPort abstractProtectedCircuitMapPort) {
            IEntityModel iEntityModel = abstractProtectedCircuitMapPort.getPort();
            if (iEntityModel != null) {
                boolean bl = abstractProtectedCircuitMapPort.isActivePort();
                boolean bl2 = abstractProtectedCircuitMapPort.isWorkingPort();
                Color color = bl ? NetMapLink.LINK_ACTIVE_COLOR : NetMapLink.LINK_STANDBY_COLOR;
                int n = bl ? 4 : 5;
                circuitMapLine.setState(n);
                this.setSuffixString(abstractProtectedCircuitMapPort, bl, bl2);
                if (db.on()) {
                    db.println("Updated map line to PG port " + iEntityModel + " (isActive = " + bl + "),  lineColor = " + MapGraphicsUtil.getColorString(color));
                }
            }
        }

        private String stringFromProtectionOp(MapPort mapPort, boolean bl) {
            if (mapPort instanceof AbstractProtectedCircuitMapPort) {
                AbstractProtectedCircuitMapPort abstractProtectedCircuitMapPort = (AbstractProtectedCircuitMapPort)mapPort;
                return abstractProtectedCircuitMapPort.getProtectionOpStringValue();
            }
            return "";
        }

        protected void setSuffixString(CircuitMapPort circuitMapPort, boolean bl, boolean bl2) {
            String string = bl2 ? " WRK" : " PRT";
            String string2 = bl ? "/ACT " : "/STDBY ";
            circuitMapPort.setSuffixString(string + string2);
        }
    }
}

