/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NetCSHelpConst;
import cerent.cms.ui.WzDiagDebug;
import cerent.cms.ui.circuits.AbstractCcdAttrsPane;
import cerent.cms.ui.circuits.CircuitCreationDialog;
import cerent.util.CEMC;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.gui.IgnorableDialog;
import cerent.util.gui.NumberTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class CcdSvlanAttrsPane
extends AbstractCcdAttrsPane {
    private static final String SVLAN_PROT_MSG = "For selecting this option, the OCHTrail/PPC ring on which\nthe circuit will be created must have the master node\ndefined and the protection state must be enabled.\nOtherwise the circuit creation will fail.";
    private static final String SVLAN_PROT_TITLE = "Protected SVLAN Circuit Creation";
    private static final String PREF_SVLAN_PROT_VALUE = "ProtSvlanCkt";
    private static final String PREF_SVLAN_PROT_DESCR = "Circuit Creation: Protected SVLAN Circuit";
    private static final int MAX_NUM_SVLANS = 4093;
    private SvlanAttr svlanIDAttr;
    private ProtectionAttr protectionAttr;
    protected GridBagConstraints paneGc;

    public CcdSvlanAttrsPane(CircuitCreationDialog circuitCreationDialog, WzDiagDebug wzDiagDebug, String string) {
        super(circuitCreationDialog, wzDiagDebug, string);
    }

    @Override
    protected void initPane() {
        this.setLayout(new GridBagLayout());
        this.paneGc = new GridBagConstraints();
        this.paneGc.anchor = 18;
        this.paneGc.gridx = 0;
        this.paneGc.gridy = 0;
        this.paneGc.gridwidth = 1;
        this.paneGc.gridheight = 1;
        this.paneGc.weightx = 0.0;
        this.paneGc.weighty = 0.0;
        this.paneGc.fill = 1;
        this.paneGc.insets = new Insets(5, 5, 0, 0);
        this.addComponents();
    }

    protected void addComponents() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(5, 5, 10, 10);
        jPanel.setBorder(BorderFactory.createTitledBorder("Circuit"));
        this.circuitNameAttr = new AbstractCcdAttrsPane.CircuitNameAttr();
        jPanel.add((Component)this.circuitNameAttr.getUI(), gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)new JPanel(), gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.circuitTypeAttr = new AbstractCcdAttrsPane.CircuitTypeAttr(this.getCircuitType());
        jPanel.add((Component)this.circuitTypeAttr.getUI(), gridBagConstraints);
        gridBagConstraints.fill = 0;
        ++gridBagConstraints.gridy;
        this.svlanIDAttr = this.getSVLANAttr();
        jPanel.add((Component)this.svlanIDAttr.getUI(), gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.protectionAttr = new ProtectionAttr();
        jPanel.add((Component)this.protectionAttr.getUI(), gridBagConstraints);
        this.protectionAttr.protectionCB.addActionListener(this);
        this.paneGc.gridheight = 4;
        this.add((Component)jPanel, this.paneGc);
        this.paneGc.gridy = 6;
        this.paneGc.weightx = 1.0;
        this.paneGc.weighty = 1.0;
        this.paneGc.gridheight = 0;
        this.add(Box.createVerticalGlue(), this.paneGc);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (this.protectionAttr != null && object == this.protectionAttr.protectionCB) {
            if (this.protectionAttr.protectionCB.isSelected()) {
                this.protectionAttr.displayIgnorableDialog();
            }
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    protected SvlanAttr getSVLANAttr() {
        return new SvlanAttr();
    }

    @Override
    public void revalidateData() {
        super.revalidateData();
    }

    @Override
    public void validatePage() throws Exception {
        super.validatePage();
        if (this.svlanIDAttr != null) {
            this.getCircuitInfo().setSVLAN(this.svlanIDAttr.getSvlanId());
        }
        if (this.protectionAttr != null) {
            this.getCircuitInfo().setProtected(this.protectionAttr.isProtected());
        }
        this.getCircuitInfo().setTL1Compatible(true);
    }

    @Override
    protected ArrayList<String[]> getAttrPairs() {
        ArrayList arrayList = super.getAttrPairs();
        if (this.svlanIDAttr != null) {
            arrayList.add(this.parseAttr(this.svlanIDAttr));
        }
        if (this.protectionAttr != null) {
            arrayList.add(this.parseAttr(this.protectionAttr));
        }
        return arrayList;
    }

    @Override
    public CSHelpID getHelpID() {
        return NetCSHelpConst.CcdSvlanAttrsPane;
    }

    @Override
    public void dispose() {
        this.svlanIDAttr = null;
        super.dispose();
    }

    @Override
    public String getDiagString() {
        StringBuffer stringBuffer = new StringBuffer(super.getDiagString());
        stringBuffer.append("SVLAN ID:  " + this.svlanIDAttr + "\n");
        return stringBuffer.toString();
    }

    class ProtectionAttr {
        protected JCheckBox protectionCB;
        private JPanel p = new JPanel();

        ProtectionAttr() {
            this.p.setLayout(new BorderLayout());
            this.protectionCB = new JCheckBox("Protection");
            this.p.add(this.protectionCB);
        }

        public JPanel getUI() {
            return this.p;
        }

        boolean isProtected() {
            return this.protectionCB.isSelected();
        }

        public void displayIgnorableDialog() {
            IgnorableDialog.warningDialog((Component)CcdSvlanAttrsPane.this, (String)CcdSvlanAttrsPane.SVLAN_PROT_MSG, (String)CcdSvlanAttrsPane.SVLAN_PROT_TITLE, (String)CcdSvlanAttrsPane.PREF_SVLAN_PROT_VALUE, (String)CcdSvlanAttrsPane.PREF_SVLAN_PROT_DESCR);
        }

        public String toString() {
            if (this.isProtected()) {
                return "Protection: Required";
            }
            return "Protection: Not required";
        }
    }

    class SvlanAttr {
        short svlanId = 0;
        protected JPanel p = new JPanel();
        NumberTextField svlanTF;

        SvlanAttr() {
            this.p.setLayout(new BoxLayout(this.p, 0));
            JLabel jLabel = new JLabel("SVLAN ID: ");
            jLabel.setPreferredSize(new Dimension(70, jLabel.getHeight()));
            this.p.add(jLabel);
            this.svlanTF = new NumberTextField(4);
            this.p.add(this.svlanTF);
            JLabel jLabel2 = new JLabel("  [1-4093]");
            this.p.add(jLabel2);
        }

        public JPanel getUI() {
            return this.p;
        }

        public short getSvlanId() throws Exception {
            boolean bl = false;
            try {
                this.svlanId = Short.parseShort(this.svlanTF.getText());
                if (this.svlanId < 1 || this.svlanId > 4093) {
                    bl = true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                bl = true;
            }
            if (bl) {
                throw new Exception(ErrorMsg.getString((EID)CEMC.EID_SVLAN_OUT_OF_RANGE));
            }
            return this.svlanId;
        }

        public String toString() {
            return "SVLAN ID: " + this.svlanId;
        }
    }
}

