/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.Feature;
import cerent.cms.model.IVlanModel;
import cerent.cms.model.NodeModel;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.IncorrectCircuitState;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.Network;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NetCSHelpConst;
import cerent.cms.ui.NetVlanInfoCellRenderer;
import cerent.cms.ui.WzDiagDebug;
import cerent.cms.ui.circuits.AutorangeInfo;
import cerent.cms.ui.circuits.CircuitColumnRenderer;
import cerent.cms.ui.circuits.CircuitCreationDialog;
import cerent.cms.ui.circuits.WzCcdPane;
import cerent.cms.ui.vlan.VlanCreationDialog;
import cerent.cms.vlan.NetVlanInfo;
import cerent.cms.vlan.NetVlanInfoComparator;
import cerent.cms.vlan.VlanSetManager;
import cerent.util.AnnotatedException;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.NEMC;
import cerent.util.Preferences;
import cerent.util.WID;
import cerent.util.gui.DualListModel;
import cerent.util.gui.UScrollPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class CcdVlanPane
extends WzCcdPane
implements ItemListener,
ListDataListener,
Observer {
    private static final String CIRCUIT_VLAN = "Circuit VLANs";
    private static final String AVAILABLE_VLAN = "Available VLANs";
    private static final String NEW_VLAN = "New VLAN...";
    private static final String DEFAULT_VLAN = "Uses default VLAN if empty";
    private static final String VLAN_REUSE = "Enable Spanning Tree";
    private Preferences prefs = Preferences.instance();
    static final String PREF_PATH = "ctc.circuit.creation";
    private static final String PREF_STP = "stp";
    private JList availList = new JList();
    private JList cktList = new JList();
    private JButton toCktPB = new JButton(">>");
    private JButton fromCktPB = new JButton("<<");
    private DualListModel listsModel = new DualListModel(this.availList, this.cktList, null, null, this.toCktPB, this.fromCktPB, 0);
    private JButton newVlanPB = new JButton("New VLAN...");
    private JCheckBox enableStpCB = new JCheckBox("Enable Spanning Tree");
    private JPanel fillerPanel = new JPanel();
    private NetVlanInfoCellRenderer vlanInfoCellRenderer;
    private static final int LIST_ROW_COUNT = 6;
    private NetVlanInfo[] vlanSet = new NetVlanInfo[0];
    private JPanel srcPanel;
    private JPanel dstPanel;

    @Override
    public String getShortName() {
        return "Selected VLANs";
    }

    public CcdVlanPane(CircuitCreationDialog circuitCreationDialog, WzDiagDebug wzDiagDebug, String string) {
        super(circuitCreationDialog, wzDiagDebug, string);
    }

    @Override
    public void initPane() {
        this.vlanInfoCellRenderer = new NetVlanInfoCellRenderer();
        this.vlanInfoCellRenderer.setHideTopoId(true);
        this.setLayout(new BorderLayout(5, 5));
        this.add((Component)this.createAttrsPanel(), "Center");
        this.enableStpCB.addItemListener(this);
        this.fillerPanel.setLayout(new BorderLayout());
        this.fillerPanel.add((Component)this.enableStpCB, "West");
        this.add((Component)this.fillerPanel, "South");
        this.addListDataListener(this);
        this.reset();
    }

    @Override
    public void enteringPane() {
        if (this.db.on()) {
            this.db.println("enteringPage: adding observer");
        }
        VlanSetManager.instance().addObserver(this);
        super.enteringPane();
    }

    @Override
    public boolean handleBack() {
        try {
            this.getAbstractCktDlg().deleteDestination();
        }
        catch (Exception exception) {
            WzDiagDebug.printStackTrace((Throwable)exception);
            ErrorMsg.displayError((Component)this, (EID)NEMC.EID_DELETE_DESTINATION_FAILED);
        }
        VlanSetManager.instance().deleteObserver(this);
        return super.handleBack();
    }

    @Override
    protected String getNextPaneName() {
        return "Circuit Routing Preferences";
    }

    private JPanel createAttrsPanel() {
        JPanel jPanel;
        JPanel jPanel2 = CcdVlanPane.createHorizontalPanel(null);
        this.srcPanel = jPanel = CcdVlanPane.createVerticalPanel(AVAILABLE_VLAN);
        jPanel.add(this.configureList(this.availList));
        jPanel.add(this.newVlanPB);
        this.newVlanPB.addActionListener(this);
        jPanel2.add(jPanel);
        jPanel = CcdVlanPane.createVerticalPanel(null);
        jPanel.add(Box.createVerticalGlue());
        jPanel.add(this.toCktPB);
        jPanel.add(Box.createVerticalGlue());
        jPanel.add(this.fromCktPB);
        jPanel.add(Box.createVerticalGlue());
        jPanel2.add(jPanel);
        this.dstPanel = jPanel = CcdVlanPane.createVerticalPanel(CIRCUIT_VLAN);
        jPanel.add(this.configureList(this.cktList));
        jPanel.add(new JLabel(DEFAULT_VLAN));
        jPanel2.add(jPanel);
        return jPanel2;
    }

    private void setVlanCount() {
        if (this.srcPanel != null && this.dstPanel != null) {
            String string = "Available VLANs: " + this.listsModel.getSrcContent().size();
            this.srcPanel.setBorder(BorderFactory.createTitledBorder(string));
            string = "Circuit VLANs: " + this.listsModel.getDstContent().size();
            this.dstPanel.setBorder(BorderFactory.createTitledBorder(string));
        }
    }

    private Component configureList(JList jList) {
        jList.setCellRenderer(this.vlanInfoCellRenderer);
        jList.setPrototypeCellValue("Administration (42)");
        jList.setVisibleRowCount(6);
        return new UScrollPane((Component)jList);
    }

    public INetCircuit getCircuit() {
        return this.getAbstractCktDlg().getCircuit();
    }

    public void addListDataListener(ListDataListener listDataListener) {
        this.listsModel.addListDataListener(listDataListener);
    }

    public void removeListDataListener(ListDataListener listDataListener) {
        this.listsModel.removeListDataListener(listDataListener);
    }

    @Override
    public void setEnabled(boolean bl) {
        this.newVlanPB.setEnabled(bl);
        this.listsModel.setEnabled(bl);
        super.setEnabled(bl);
    }

    void reset() {
        if (this.db.on) {
            this.db.println("reset");
        }
        this.listsModel.setContent(null, null);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.newVlanPB) {
            Network network = Network.instance();
            INetElement iNetElement = network.findNetElem(this.getCircuit().getSrcCircuitNode().getNetElement());
            VlanCreationDialog.instance(this, network.getTopoHost(iNetElement.getTopoId()).getName()).show();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.parent != null) {
            if (itemEvent.getStateChange() == 2 && this.prefs.getBoolean(PREF_PATH, PREF_STP, true)) {
                NodeModel nodeModel = (NodeModel)this.getAbstractCktDlg().getSourceNode();
                NodeModel nodeModel2 = (NodeModel)this.getAbstractCktDlg().getDestNode();
                if (!nodeModel.provides(Feature.BACKEND_STP) || !nodeModel2.provides(Feature.BACKEND_STP)) {
                    ErrorMsg.displayError((Component)this, (EID)NEMC.EID_FEATURE_CANT_BE_USED_CKT);
                    this.enableStpCB.setSelected(true);
                } else {
                    ErrorMsg.displayWarning((Component)this, (WID)NEMC.WID_DISABLING_SPANNING_TREE_FOR_CKT);
                }
            }
            this.prefs.setBoolean(PREF_PATH, PREF_STP, this.enableStpCB.isSelected());
        }
    }

    @Override
    public void validatePage() throws Exception {
        if (this.listsModel.getDstContent().size() == 0) {
            this.listsModel.moveItem(this.availList, this.listsModel.getSrcContent().get(0));
        }
        List list = this.listsModel.getDstContent();
        this.vlanSet = list.toArray(new NetVlanInfo[list.size()]);
        try {
            this.getCircuit().assignVlanSet(this.vlanSet);
            if (this.db.on) {
                this.db.println("apply: getCircuit().assignVlanSet() succeeded ");
            }
        }
        catch (Exception exception) {
            throw new AnnotatedException("The VLAN set cannot be assigned.", exception);
        }
        this.getCircuit().createWithStpEnabled(this.enableStpCB.isSelected());
        if (this.db.on()) {
            this.db.println("stpEnabled set to " + this.enableStpCB.isSelected());
        }
    }

    @Override
    protected void handlePostValidate() {
        VlanSetManager.instance().deleteObserver(this);
        AutorangeInfo autorangeInfo = this.getAutorangeInfo();
        if (autorangeInfo != null) {
            autorangeInfo.vlanSet = this.vlanSet;
            autorangeInfo.enableStp = this.enableStpCB.isSelected();
        }
    }

    @Override
    protected JComponent getStatusComponent() {
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        String string = CircuitColumnRenderer.getVlanList(this.vlanSet, true);
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(new String[]{stringTokenizer.nextToken(), ""});
        }
        return CcdVlanPane.getGridPanel(arrayList);
    }

    @Override
    protected String getStatusText() {
        return "\nVLANs: " + CircuitColumnRenderer.getVlanList(this.vlanSet, true) + "\n";
    }

    @Override
    public void revalidateData() {
        if (this.db.on) {
            this.db.println("revalidateData: entry");
        }
        boolean bl = false;
        if (this.listsModel != null) {
            this.setVlanSet(this.listsModel.getDstContent());
        }
        if (this.getCircuit() != null && this.getCircuit().getCircuitType() == 0) {
            this.enableStpCB.setSelected(true);
            this.enableStpCB.setEnabled(false);
        } else if (this.parent == null) {
            this.enableStpCB.setEnabled(false);
            if (this.getCircuit() == null) {
                if (this.db.on()) {
                    this.db.println("Error: ckt is null on revalidateData");
                }
            } else {
                this.enableStpCB.setSelected(this.getCircuit().isStpEnabled());
            }
        } else if (this.getCircuit() != null) {
            NodeModel nodeModel = (NodeModel)this.getAbstractCktDlg().getSourceNode();
            NodeModel nodeModel2 = (NodeModel)this.getAbstractCktDlg().getDestNode();
            try {
                bl = this.getCircuit().mustDisableStp();
            }
            catch (IncorrectCircuitState incorrectCircuitState) {
                WzDiagDebug.printStackTrace((Throwable)incorrectCircuitState);
            }
            if (nodeModel == nodeModel2 && bl) {
                this.enableStpCB.setEnabled(false);
                this.enableStpCB.setSelected(false);
            } else if (!nodeModel.provides(Feature.BACKEND_STP) || !nodeModel2.provides(Feature.BACKEND_STP)) {
                this.enableStpCB.setEnabled(true);
                this.enableStpCB.setSelected(true);
            } else {
                this.enableStpCB.setEnabled(true);
                this.enableStpCB.setSelected(this.prefs.getBoolean(PREF_PATH, PREF_STP, true));
            }
        }
        if (this.parent != null) {
            boolean bl2;
            boolean bl3 = bl2 = this.getAbstractCktDlg().getSourceNode() != this.getAbstractCktDlg().getDestNode();
            if (this.db.on) {
                this.db.println("revalidateData: multiNode = " + bl2);
            }
            this.getAbstractCktDlg().setNextEnabled(true);
        }
    }

    public void setVlanSet(List list) {
        TreeSet treeSet = new TreeSet(new NetVlanInfoComparator());
        TreeSet treeSet2 = new TreeSet(new NetVlanInfoComparator());
        if (this.getCircuit().getSrcCircuitNode() == null) {
            return;
        }
        treeSet.addAll(VlanSetManager.instance().allVlansList(this.getCircuit().getSrcCircuitNode().getNetElement()));
        treeSet2.addAll(list);
        if (this.db.on) {
            this.db.println("setVlanSet: " + treeSet.size() + " total, " + treeSet2.size() + " in circuit");
        }
        ArrayList arrayList = new ArrayList(treeSet);
        this.listsModel.setContentOrderReference(arrayList, arrayList);
        treeSet.removeAll(treeSet2);
        if (this.db.on) {
            this.db.println("setVlanSet: " + treeSet.size() + " not in circuit");
        }
        this.listsModel.setContent(new ArrayList(treeSet), new ArrayList(treeSet2));
        this.setVlanCount();
    }

    @Override
    public void update(Observable observable, Object object) {
        if (observable instanceof VlanSetManager) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (CcdVlanPane.this.db.on()) {
                        CcdVlanPane.this.db.println("received update... revalidateData()");
                    }
                    CcdVlanPane.this.revalidateData();
                }
            });
        }
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.setVlanCount();
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.setVlanCount();
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.setVlanCount();
    }

    @Override
    public CSHelpID getHelpID() {
        return NetCSHelpConst.CcdVlanPane;
    }

    public IVlanModel[] getDstVlans() {
        List list = this.listsModel.getDstContent();
        IVlanModel[] iVlanModelArray = new IVlanModel[list.size()];
        int n = 0;
        for (NetVlanInfo netVlanInfo : list) {
            iVlanModelArray[n++] = netVlanInfo.getVlan();
        }
        return iVlanModelArray;
    }

    @Override
    public void removeListeners() {
        VlanSetManager.instance().deleteObserver(this);
        if (this.listsModel != null) {
            this.removeListDataListener(this);
        }
        if (this.enableStpCB != null) {
            this.enableStpCB.removeItemListener(this);
        }
        if (this.newVlanPB != null) {
            this.newVlanPB.removeActionListener(this);
        }
        super.removeListeners();
    }

    @Override
    public void dispose() {
        this.listsModel = null;
        super.dispose();
    }

    @Override
    public String getDiagString() {
        StringBuffer stringBuffer = new StringBuffer(super.getDiagString());
        stringBuffer.append("Vlan Set: " + this.vlanSet);
        if (this.vlanSet != null) {
            stringBuffer.append("size= " + this.vlanSet.length);
            for (int i = 0; i < this.vlanSet.length; ++i) {
                NetVlanInfo netVlanInfo = this.vlanSet[i];
                IVlanModel iVlanModel = netVlanInfo.getVlan();
                String string = iVlanModel != null ? iVlanModel.getName() : null;
                stringBuffer.append("\tVlan #" + (i + 1) + ": " + this.vlanSet[i] + "\tName= " + string + "\n");
            }
        }
        return stringBuffer.toString();
    }
}

