/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.Feature;
import cerent.cms.model.HoPathDefModel;
import cerent.cms.model.IConnectionModel;
import cerent.cms.model.IConnectionModels;
import cerent.cms.model.IHoConnectionModel;
import cerent.cms.model.IHoPathDefModel;
import cerent.cms.model.ILoConnectionModel;
import cerent.cms.model.ILoDefModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPmStat;
import cerent.cms.model.UpsrSelector;
import cerent.cms.model.circuits.NetCircuitModel;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ui.AbstractPmTableModel;
import cerent.cms.ui.circuits.CedUpsrTableModel;
import cerent.cms.ui.circuits.CircuitMapUtil;
import cerent.util.ILoNum;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CedUpsrPmTableModel
extends AbstractPmTableModel {
    SDebug db = new SDebug("CedUpsrPmTableModel");
    protected static final int SUPPORT_SWCOUNTS = 0;
    protected static final int NO_SUPPORT_SWCOUNTS = 1;
    protected static final int EXCEPTION_IN_SWCOUNTS = 2;
    private INetCircuit circuit;
    private IConnectionModel[] models;
    private boolean[] supported;
    private String[] upsrIndex;
    private int currInterval;
    private int prevInterval;
    private boolean resetTrigger = false;
    private Object[][] statsVal;
    private static final String[] COLUMNS = new String[]{"Node", "Curr", "Prev", "Prev-1", "Prev-2", "Prev-3", "Prev-4", "Prev-5", "Prev-6", "Prev-7", "Prev-8", "Prev-9", "Prev-10", "Prev-11", "Prev-12", "Prev-13", "Prev-14", "Prev-15", "Prev-16", "Prev-17", "Prev-18", "Prev-19", "Prev-20", "Prev-21", "Prev-22", "Prev-23", "Prev-24", "Prev-25", "Prev-26", "Prev-27", "Prev-28", "Prev-29", "Prev-30", "Prev-31"};

    public CedUpsrPmTableModel(NetCircuitModel netCircuitModel) {
        this.setColNames(COLUMNS);
        this.circuit = netCircuitModel.getNetCircuit();
        this.prevInterval = 0;
        this.currInterval = 0;
        this.setIntervalType(0);
        this.rebuildSelectors();
    }

    protected synchronized void rebuildSelectors() {
        int n;
        if (this.db.on()) {
            this.db.println("rebuild selectors!");
        }
        List list = CedUpsrTableModel.getConnectionModels(this.circuit);
        this.models = null;
        this.statsVal = null;
        int n2 = 0;
        ArrayList<IConnectionModel> arrayList = new ArrayList<IConnectionModel>();
        ArrayList<IConnectionModel> arrayList2 = new ArrayList<IConnectionModel>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        for (n = 0; n < list.size(); ++n) {
            IConnectionModel iConnectionModel = (IConnectionModel)list.get(n);
            if (iConnectionModel == null) {
                this.db.println("Index #" + n + " has a null UPSR/SNCP" + " Selector!");
                continue;
            }
            int n3 = this.supportsSwitchCounts(iConnectionModel);
            if (this.db.on()) {
                this.db.println(iConnectionModel + " return code is " + n3);
            }
            if (n3 == 0) {
                ++n2;
                arrayList.add(iConnectionModel);
                arrayList2.add(iConnectionModel);
                arrayList3.add("Only Selector");
                if (!CircuitMapUtil.connectionHasSecondSelector(iConnectionModel)) continue;
                INodeModel iNodeModel = null;
                try {
                    iNodeModel = ((IConnectionModel)list.get(n)).getNodeModel();
                    if (!Feature.provides((INodeModel)iNodeModel, (Feature)Feature.UPSR_REVERSE_SWITCH_COUNTS)) continue;
                    arrayList3.set(arrayList3.size() - 1, "First Selector");
                    arrayList.add(iConnectionModel);
                    arrayList3.add("Second Selector");
                    ++n2;
                }
                catch (Exception exception) {
                    this.db.println("Error with myNMD=" + iNodeModel);
                    SDebug.printStackTrace((Throwable)exception);
                }
                continue;
            }
            if (n3 != 1) continue;
            arrayList.add(iConnectionModel);
            ++n2;
            arrayList3.add("Only Selector");
        }
        if (this.db.on()) {
            this.db.println("rebuilt selectors, newLength=" + n2);
        }
        this.models = new IConnectionModel[n2];
        this.upsrIndex = new String[n2];
        this.supported = new boolean[n2];
        if (this.db.on()) {
            this.db.println(" rowCount=" + this.getRowCount());
        }
        for (n = 0; n < arrayList.size(); ++n) {
            this.models[n] = (IConnectionModel)arrayList.get(n);
            this.upsrIndex[n] = (String)arrayList3.get(n);
            this.supported[n] = arrayList2.contains(this.models[n]);
        }
        this.statsVal = new Object[this.models.length][this.numRegisters];
    }

    private int supportsSwitchCounts(IConnectionModel iConnectionModel) {
        int n = 0;
        if (iConnectionModel != null) {
            try {
                if (iConnectionModel instanceof UpsrSelector) {
                    ((UpsrSelector)iConnectionModel).getSwitchCountStat(0, (short)0);
                } else if (iConnectionModel instanceof IHoConnectionModel) {
                    ((IHoConnectionModel)iConnectionModel).getSwitchCount(0, (short)0);
                } else if (iConnectionModel instanceof ILoConnectionModel) {
                    ((ILoConnectionModel)iConnectionModel).getSwitchCount(0, (short)0);
                } else {
                    if (this.db.on()) {
                        this.db.println("error determining selector type; it is " + iConnectionModel);
                    }
                    n = 2;
                }
            }
            catch (AbstractMethodError abstractMethodError) {
                n = 1;
            }
            catch (Exception exception) {
                this.db.println("Exception in switchCounts, selector=" + iConnectionModel);
                if (this.db.on()) {
                    SDebug.printStackTrace((Throwable)exception);
                }
                n = 2;
            }
        }
        return n;
    }

    private String dumpPathInfo(int n, Object object) {
        IConnectionModels iConnectionModels = this.models[n].getNodeModel().getConnectionModels();
        if (this.models[n] instanceof IHoConnectionModel) {
            IHoPathDefModel iHoPathDefModel = (IHoPathDefModel)object;
            return "getPhysicalHo(): " + HoPathDefModel.physicalHo(iHoPathDefModel);
        }
        if (this.models[n] instanceof ILoConnectionModel) {
            ILoDefModel iLoDefModel = (ILoDefModel)object;
            IHoPathDefModel iHoPathDefModel = iConnectionModels.getHoPathDef(iLoDefModel);
            ILoNum iLoNum = iLoDefModel.getLoNum();
            return "getPhysicalHo(): " + HoPathDefModel.physicalHo(iHoPathDefModel) + " - " + iLoNum.dumpString();
        }
        return "Unknown Model Type: " + this.models[n].getClass();
    }

    @Override
    public void clearStats() {
        for (int i = 0; i < this.models.length; ++i) {
            IConnectionModel iConnectionModel = this.models[i];
            if (this.db.on()) {
                this.db.println("Going to clear stats on NodeModel: " + iConnectionModel.getNodeModel().getName());
                this.db.println("\tinstance of Class: " + iConnectionModel.getClass());
                boolean bl = iConnectionModel instanceof IHoConnectionModel;
                this.db.println("\tconnection type: " + (bl ? ((IHoConnectionModel)iConnectionModel).getConnectionType() : ((ILoConnectionModel)iConnectionModel).getConnectionType()));
                IConnectionModels iConnectionModels = iConnectionModel.getNodeModel().getConnectionModels();
                if (bl) {
                    IHoConnectionModel iHoConnectionModel = (IHoConnectionModel)iConnectionModel;
                    IHoPathDefModel[] iHoPathDefModelArray = iHoConnectionModel.getPaths();
                    this.db.println("\tWorking Path/getPaths[0]: " + CedUpsrTableModel.getPathString(iConnectionModels, iHoPathDefModelArray[0], bl));
                    this.db.println("\tProtect Path/getPaths[1]: " + CedUpsrTableModel.getPathString(iConnectionModels, iHoPathDefModelArray[1], bl));
                    IHoPathDefModel[] iHoPathDefModelArray2 = iHoConnectionModel.getActivePaths();
                    this.db.println("\tActivePath: " + CedUpsrTableModel.getPathString(iConnectionModels, iHoPathDefModelArray2[0], bl));
                }
            }
            if (!this.supported[i]) continue;
            if (iConnectionModel instanceof UpsrSelector) {
                ((UpsrSelector)iConnectionModel).clearSwitchCountStat(this.currInterval);
                continue;
            }
            if (!this.db.on()) continue;
            this.db.println("Can't clear row " + i + " because model " + "supports stats, but not clearing stats.");
        }
    }

    @Override
    public int getRowCount() {
        return this.models.length;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Object getValueAtImpl(int n, int n2) {
        String string;
        Object object;
        block10: {
            block9: {
                object = null;
                if (n2 != 0) break block9;
                IConnectionModel iConnectionModel = this.models[n];
                string = iConnectionModel.getNodeModel().getName();
                if (this.upsrIndex[n].equals("First Selector")) {
                    string = string + " (" + CircuitMapUtil.getSelectorString(iConnectionModel, true, this.db) + ")";
                    break block10;
                } else if (this.upsrIndex[n].equals("Second Selector")) {
                    string = string + " (" + CircuitMapUtil.getSelectorString(iConnectionModel, false, this.db) + ")";
                }
                break block10;
            }
            if (!this.supported[n]) {
                return null;
            }
            int n3 = n2 - 1;
            if (this.statsVal[n][n3] != null) return this.statsVal[n][n3];
            if (this.models[n] instanceof UpsrSelector) {
                this.statsVal[n][n3] = this.upsrIndex[n].equals("Only Selector") || this.upsrIndex[n].equals("First Selector") ? ((UpsrSelector)this.models[n]).getSwitchCountStat(this.currInterval, (short)n3) : ((UpsrSelector)this.models[n]).getReverseSwitchCountStat(this.currInterval, (short)n3);
                return this.statsVal[n][n3];
            } else {
                int n4 = -1;
                if (this.models[n] instanceof IHoConnectionModel) {
                    n4 = ((IHoConnectionModel)this.models[n]).getSwitchCount(this.currInterval, (short)n3);
                } else if (this.models[n] instanceof ILoConnectionModel) {
                    n4 = ((ILoConnectionModel)this.models[n]).getSwitchCount(this.currInterval, (short)n3);
                }
                this.statsVal[n][n3] = new Integer(n4);
            }
            return this.statsVal[n][n3];
        }
        object = string;
        if (this.supported[n]) return object;
        return object;
    }

    @Override
    public long getLongValue(Object object) {
        return ((IPmStat)object).getCnt();
    }

    @Override
    public Object setLongValue(Object object, long l) {
        return ((IPmStat)object).createPmStat((int)l);
    }

    @Override
    public void setIntervalType(int n) {
        this.prevInterval = this.currInterval;
        this.currInterval = n;
    }

    @Override
    public void destroy() {
    }

    @Override
    public void tossData() {
        if (this.statsVal != null) {
            for (int i = 0; i < this.statsVal.length; ++i) {
                for (int j = 0; j < this.numRegisters; ++j) {
                    this.statsVal[i][j] = null;
                }
            }
        } else if (this.db.on()) {
            this.db.println("statsVal[][] is null!");
        }
        this.rebuildSelectors();
        if (this.prevInterval != this.currInterval) {
            if (this.db.on()) {
                this.db.println("Changing interval from " + this.prevInterval + " to " + this.currInterval + ".");
            }
            this.prevInterval = this.currInterval;
            this.resetTrigger = true;
        }
        if (this.resetTrigger) {
            if (this.db.on()) {
                this.db.println("In tossData(), resetting baseline.");
            }
            this.resetBaseline();
            this.resetTrigger = false;
        }
    }

    public void setResetTrigger() {
        this.resetTrigger = true;
    }

    public Map getPartialPmSupportNodes() {
        Integer n;
        if (this.db.on()) {
            this.db.println("asked to get partial pm support nodes.");
        }
        HashMap<INodeModel, Integer> hashMap = new HashMap<INodeModel, Integer>();
        if (this.models != null) {
            for (int i = 0; i < this.models.length; ++i) {
                INodeModel iNodeModel = null;
                if (this.models[i] == null || this.models[i] instanceof UpsrSelector) continue;
                try {
                    iNodeModel = this.models[i].getNodeModel();
                }
                catch (Exception exception) {
                    SDebug.printStackTrace((Throwable)exception);
                }
                if (iNodeModel == null) continue;
                if (hashMap.containsKey(iNodeModel)) {
                    n = (Integer)hashMap.get(iNodeModel);
                    n = new Integer(n + 1);
                } else {
                    n = new Integer(1);
                }
                hashMap.put(iNodeModel, n);
            }
        }
        if (this.db.on()) {
            for (INodeModel iNodeModel : hashMap.keySet()) {
                n = (Integer)hashMap.get(iNodeModel);
                this.db.println(iNodeModel + "\t" + n);
            }
        }
        return hashMap;
    }
}

