/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.ICircuitType;
import cerent.cms.model.INodeModel;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitDropInfo;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.topo.DwdmNetLink;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.LmpDataLinkNetLink;
import cerent.cms.topo.OchTrailTunnelNetLink;
import cerent.cms.topo.SvlanLinksRouteManager;
import cerent.cms.topo.VirtualNetLink;
import cerent.cms.ui.circuits.AbstractCircuitDialog;
import cerent.cms.ui.circuits.AbstractCircuitMap;
import cerent.cms.ui.circuits.CcdCircuitDesignPane;
import cerent.cms.ui.circuits.CircuitMapFactory;
import cerent.util.SDebug;
import com.cisco.ctc.util.map.MapLink;
import com.cisco.ctc.util.map.MapNode;
import java.util.List;
import java.util.Observable;

public class CircuitDesignMap
extends AbstractCircuitMap {
    private static final SDebug db = new SDebug("CircuitDesignMap");
    private CcdCircuitDesignPane circuitDesignPane;
    private AbstractCircuitDialog container;
    private boolean pcaOverride = false;

    CircuitDesignMap(AbstractCircuitDialog abstractCircuitDialog) {
        super(db, 0, CircuitMapFactory.instance());
        this.container = abstractCircuitDialog;
        this.resetMarkers(true);
    }

    public void init(CcdCircuitDesignPane ccdCircuitDesignPane) {
        this.circuitDesignPane = ccdCircuitDesignPane;
    }

    void resetMarkers(boolean bl) {
        this.clearNodeMarkers();
        this.addSourceNodeMarker();
        this.addDestNodeMarker();
        this.jumpToSourceNodeDomain();
        if (bl) {
            this.updateView();
        }
    }

    void resetMarkers(boolean bl, int n) {
        this.clearNodeMarkers();
        this.addSourceNodeMarker();
        if (!this.container.ckt.isOpenEndedVcatCircuit()) {
            this.addDestNodeMarker();
        } else {
            this.addDestNodeMarker(n);
        }
        this.jumpToSourceNodeDomain();
        if (bl) {
            this.updateView();
        }
    }

    void addDestNodeMarker() {
        MapNode mapNode;
        INodeModel iNodeModel = this.container.getDestNode();
        if (iNodeModel != null && (mapNode = this.getMapNode(iNodeModel)) != null) {
            mapNode.addDesc("Dest");
            INetCircuit iNetCircuit = this.getNetCircuit();
            if (iNetCircuit == null) {
                if (this.dbg.on()) {
                    this.dbg.println("get src points - ckt==null");
                }
            } else {
                ICircuitType iCircuitType = iNetCircuit.getCircuitTypeObj();
                if (!iCircuitType.isEthernetCircuitType() && !iCircuitType.isTunnelCircuitType()) {
                    List list = iNetCircuit.getDrops();
                    for (int i = 0; i < list.size(); ++i) {
                        INetCircuitDropInfo iNetCircuitDropInfo = (INetCircuitDropInfo)list.get(i);
                        MapNode mapNode2 = this.getMapNode(iNetCircuitDropInfo.getNodeModel());
                        if (mapNode2 == null) continue;
                        if (i == 1 && !iCircuitType.isSVLANType()) {
                            mapNode2.addDesc("Secondary Dest");
                        }
                        mapNode2.addDesc(this.getPoint(iNetCircuitDropInfo));
                    }
                }
            }
        }
    }

    void addGenericMarker(INodeModel iNodeModel, String string, String string2) {
        MapNode mapNode;
        if (iNodeModel != null && (mapNode = this.getMapNode(iNodeModel)) != null) {
            if (string != null) {
                mapNode.addDesc(string);
            }
            if (string2 != null) {
                mapNode.addDesc(string2);
            }
        }
    }

    @Override
    protected INetCircuit getNetCircuit() {
        return this.container.getCircuit();
    }

    @Override
    protected INodeModel getCktSrcNodeModel() {
        return this.container.getSourceNode();
    }

    @Override
    protected INodeModel getCktDstNodeModel(int n) {
        if (n == 1) {
            return this.container.getDestNode();
        }
        if (n == 2 && this.container.getAltDest() != null) {
            return this.container.getDestNode();
        }
        return null;
    }

    @Override
    protected INetCircuitEnd getDstDropEndpoint(int n) {
        if (n == 1) {
            return this.container.getDest();
        }
        if (n == 2 && this.container.getAltDest() != null) {
            return this.container.getAltDest();
        }
        return null;
    }

    @Override
    public void linkSelected(MapLink mapLink, boolean bl) {
        if (this.circuitDesignPane != null) {
            this.circuitDesignPane.linkSelected(mapLink, bl);
        }
    }

    @Override
    protected void clicked(MapLink mapLink) {
        this.circuitDesignPane.clicked(mapLink);
    }

    public void domainDisplayed(MapNode mapNode) {
        if (this.circuitDesignPane != null) {
            this.circuitDesignPane.domainDisplayed(mapNode);
        }
    }

    @Override
    public void nodeSelected(MapNode mapNode, boolean bl) {
        this.circuitDesignPane.nodeSelected(mapNode, bl);
    }

    public void nodeDoubleClicked(MapNode mapNode) {
    }

    @Override
    public void update(Observable observable, Object object) {
    }

    public void updateReceived(MapNode mapNode, Observable observable, Object object) {
    }

    public void setPcaOverride(boolean bl) {
        this.pcaOverride = bl;
    }

    @Override
    public boolean isLinkAcceptable(INetLink iNetLink) {
        boolean bl = iNetLink.isRoutable();
        boolean bl2 = super.isLinkAcceptable(iNetLink);
        if (bl2 && iNetLink instanceof OchTrailTunnelNetLink) {
            bl2 = this.getNetCircuit().getCircuitTypeObj().isHoCircuitType() && ((OchTrailTunnelNetLink)iNetLink).isLinkOnADMoaB() || this.getNetCircuit().getCircuitTypeObj().isHoVcatCircuitType() && ((OchTrailTunnelNetLink)iNetLink).isLinkOnADMoaB() || this.getNetCircuit().getCircuitTypeObj().isTunnelCircuitType() && ((OchTrailTunnelNetLink)iNetLink).isLinkOnADMoaB() || this.getNetCircuit().getCircuitTypeObj().isSVLANType() && SvlanLinksRouteManager.isUsableForSvlanCkt(iNetLink) || this.getNetCircuit().getCircuitTypeObj().isOchccCircuitType() && !((OchTrailTunnelNetLink)iNetLink).isLinkOnADMoaB() && !SvlanLinksRouteManager.isUsableForSvlanCkt(iNetLink);
        } else if (bl2 && iNetLink instanceof VirtualNetLink) {
            bl2 = this.getNetCircuit().getCircuitTypeObj().isSVLANType() && SvlanLinksRouteManager.isUsableForSvlanCkt(iNetLink) || (this.getNetCircuit().getCircuitTypeObj().isOchncType() || this.getNetCircuit().getCircuitTypeObj().isOchccCircuitType() || this.getNetCircuit().getCircuitTypeObj().isOchTrailTunnelCircuitType()) && !SvlanLinksRouteManager.isUsableForSvlanCkt(iNetLink);
        } else if (bl2 && iNetLink instanceof DwdmNetLink) {
            bl2 = this.getNetCircuit().getCircuitTypeObj().isOchncType() || this.getNetCircuit().getCircuitTypeObj().isOchccCircuitType() || this.getNetCircuit().getCircuitTypeObj().isOchTrailTunnelCircuitType();
        } else if (bl2 && iNetLink instanceof LmpDataLinkNetLink) {
            bl2 = this.getNetCircuit().getCircuitTypeObj().isOchTrailTunnelCircuitType();
        } else if (this.getNetCircuit().getCircuitTypeObj().isOchncType() || this.getNetCircuit().getCircuitTypeObj().isOchccCircuitType() || this.getNetCircuit().getCircuitTypeObj().isOchTrailTunnelCircuitType() || this.getNetCircuit().getCircuitTypeObj().isSVLANType()) {
            bl2 = false;
        }
        if (db.on()) {
            db.println("is link acceptable: " + iNetLink.prettyString());
            db.println("\troutable: " + bl + "\tsuperAcceptable: " + bl2);
        }
        boolean bl3 = false;
        if (this.pcaOverride) {
            boolean bl4 = bl3 = !this.loTopo && !this.pcaTopo && this.notLot(iNetLink) && iNetLink.isPca();
            if (db.on()) {
                db.println("\tpcaOverrideOk: " + bl3);
            }
            return bl && (bl2 || bl3);
        }
        return bl && bl2;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.circuitDesignPane = null;
        this.container = null;
    }

    void addDestNodeMarker(int n) {
        MapNode mapNode;
        INetCircuitEnd iNetCircuitEnd = this.container.getDestList()[n];
        INodeModel iNodeModel = iNetCircuitEnd.getNodeModel();
        if (iNodeModel != null && (mapNode = this.getMapNode(iNodeModel)) != null) {
            mapNode.addDesc("Dest");
            mapNode.addDesc(this.getPoint(iNetCircuitEnd));
            INetCircuit iNetCircuit = this.getNetCircuit();
            if (iNetCircuit == null) {
                if (this.dbg.on()) {
                    this.dbg.println("get src points - ckt==null");
                }
            } else {
                MapNode mapNode2;
                INodeModel iNodeModel2;
                INetCircuitEnd iNetCircuitEnd2;
                ICircuitType iCircuitType = iNetCircuit.getCircuitTypeObj();
                if (!iCircuitType.isEthernetCircuitType() && !iCircuitType.isTunnelCircuitType() && (iNetCircuitEnd2 = this.container.getAltDestList()[n]) != null && (iNodeModel2 = iNetCircuitEnd2.getNodeModel()) != null && (mapNode2 = this.getMapNode(iNodeModel2)) != null) {
                    mapNode2.addDesc("Secondary Dest");
                    mapNode2.addDesc(this.getPoint(iNetCircuitEnd2));
                }
            }
        }
    }
}

