/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.loader.ElementFactoryFinder;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.Feature;
import cerent.cms.model.FramingType;
import cerent.cms.model.ICircuitSize;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IOchccPathDefModel;
import cerent.cms.model.IOchncPathDefModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.ModelAttributeCacheManager;
import cerent.cms.model.ObjNotFound;
import cerent.cms.model.OchPortsHelper;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ui.IEntityCellRenderer;
import cerent.cms.ui.helper.PortHelper;
import cerent.util.HoLoFactory;
import cerent.util.HoLoHelper;
import cerent.util.IAttributeCache;
import cerent.util.IHoNum;
import cerent.util.ILoNum;
import cerent.util.SDebug;
import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;

public class CircuitEndCellRenderer
extends DefaultListCellRenderer {
    private static final ModelAttributeCacheManager attrCaches = ModelAttributeCacheManager.instance();
    private static final IAttributeCache<IModel> attrCache = attrCaches.lookupCache(0).getModelAttributeCache();
    private static final SDebug db = new SDebug("CircuitEndCellRenderer");
    public static final String UNAVAILABLE = "unavailable";

    @Override
    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
        if (object instanceof INetCircuitEnd) {
            this.setText(CircuitEndCellRenderer.asCommaSeparatedString((INetCircuitEnd)object, false));
        }
        return this;
    }

    private static IEntityModel getLoPort(IEntityModel iEntityModel, ILoNum iLoNum, IHoNum iHoNum) {
        IEntityModel iEntityModel2 = iEntityModel;
        boolean bl = iEntityModel instanceof IPortModel;
        if (bl && (iEntityModel.getEqType() == 31 || ((IPortModel)iEntityModel).isOptical())) {
            return iEntityModel2;
        }
        if (iLoNum != null) {
            IPortModel iPortModel = CircuitEndCellRenderer.getDs1(iEntityModel2, iLoNum, iHoNum);
            if (db.on()) {
                db.println("In getLoPort, entityModel is " + iEntityModel);
                db.println("In getLoPort, loNum is " + iLoNum.dumpString());
                db.println("In getLoPort, hoNum is " + iHoNum.prettyString());
                db.println("In getLoPort, port is " + iPortModel);
            }
            if (iPortModel != null) {
                iEntityModel2 = iPortModel;
            }
        }
        return iEntityModel2;
    }

    public static String asCommaSeparatedString(INetCircuitEnd iNetCircuitEnd, boolean bl) {
        IEntityModel iEntityModel;
        StringBuilder stringBuilder = new StringBuilder(64);
        String string = ", ";
        if (iNetCircuitEnd == null) {
            if (db.on()) {
                db.println("asCommaSeparatedString: returning <null circuitend>");
            }
            return UNAVAILABLE;
        }
        if (iNetCircuitEnd.getNodeModel() == null) {
            if (db.on()) {
                db.println("asCommaSeparatedString: returning <null node>");
            }
            return UNAVAILABLE;
        }
        stringBuilder.append(iNetCircuitEnd.getNodeModel().getName());
        stringBuilder.append(", ");
        try {
            iEntityModel = iNetCircuitEnd.getEntityModel();
        }
        catch (ObjNotFound objNotFound) {
            if (db.on()) {
                db.println("asCommaSeparatedString: returning <null entity>");
            }
            stringBuilder.append("unavailable entity");
            return stringBuilder.toString();
        }
        ILoNum iLoNum = iNetCircuitEnd.getLoNum();
        IHoNum iHoNum = iNetCircuitEnd.getHoNum();
        IModuleModel iModuleModel = iEntityModel.getModuleModel();
        boolean bl2 = false;
        if ((iModuleModel.getEqType() == 234 || iModuleModel.getEqType() == 233 || iModuleModel.getEqType() == 157) && iEntityModel.getEqType() == 34) {
            int n = iEntityModel.getSlot();
            stringBuilder.append("slot ");
            stringBuilder.append(n);
            String string2 = iModuleModel.getEqTypeName();
            stringBuilder.append(" (");
            stringBuilder.append(string2);
            stringBuilder.append(")");
            int n2 = CircuitEndCellRenderer.getPortForPath(iEntityModel.getModuleModel(), iEntityModel, iLoNum, iHoNum);
            if (iLoNum != null) {
                stringBuilder.append(string);
                stringBuilder.append("port ");
                if (n2 > 0) {
                    stringBuilder.append(n2);
                }
            }
            if (iHoNum != null) {
                bl2 = true;
                int n3 = n2 % 28 == 0 ? n2 / 28 : n2 / 28 + 1;
                IHoNum iHoNum2 = HoLoFactory.idlSts2HoNum(iNetCircuitEnd.getHoNum().getFramingType(), n3);
                stringBuilder.append(string);
                stringBuilder.append(CircuitEndCellRenderer.getHoString(iEntityModel, iHoNum2));
            }
        } else {
            stringBuilder.append(CircuitEndCellRenderer.getEntityString(CircuitEndCellRenderer.getLoPort(iEntityModel, iLoNum, iHoNum)));
        }
        if (iHoNum != null && !bl2) {
            stringBuilder.append(string);
            stringBuilder.append(CircuitEndCellRenderer.getHoString(iEntityModel, iHoNum));
        }
        if (iLoNum != null) {
            stringBuilder.append(", ");
            stringBuilder.append(CircuitEndCellRenderer.getLoString(iLoNum, string));
        }
        stringBuilder.append(OchPortsHelper.getSideString(iEntityModel, OchPortsHelper.SideStringType.CommaSeparated, attrCache, 0));
        return stringBuilder.toString();
    }

    public static String asSlashSeparatedString(IEntityModel iEntityModel, IHoNum iHoNum, ILoNum iLoNum, int n) {
        return CircuitEndCellRenderer.asSlashSeparatedString(iEntityModel, iHoNum, iLoNum, n, false);
    }

    public static int getPortForPath(IModuleModel iModuleModel, IEntityModel iEntityModel, ILoNum iLoNum, IHoNum iHoNum) {
        int n = 0;
        if (Feature.delegateProvides((INodeModel)iModuleModel.getNodeModel(), (Feature)Feature.C310MA)) {
            int[] nArray;
            IPortModel iPortModel = iModuleModel.getPortModelForPath(iEntityModel, iLoNum, iHoNum);
            if (iPortModel != null && (nArray = iPortModel.getPortNum()) != null && nArray.length == 1) {
                n = nArray[0];
            }
        } else {
            n = iModuleModel.getPortForPath(iLoNum, iHoNum);
        }
        return n;
    }

    public static String asSlashSeparatedString(IEntityModel iEntityModel, IHoNum iHoNum, ILoNum iLoNum, int n, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder(16);
        String string = "/";
        try {
            if (iEntityModel != null) {
                int n2;
                int n3 = iEntityModel.getSlot();
                int n4 = iEntityModel.getEqType();
                boolean bl2 = false;
                INodeModel iNodeModel = iEntityModel.getNodeModel();
                if (Feature.provides((INodeModel)iNodeModel, (Feature)Feature.MULTISHELF) && iNodeModel.isMultishelf()) {
                    n2 = iEntityModel.getShelfId();
                    stringBuilder.append("shelf");
                    stringBuilder.append(n2);
                    stringBuilder.append(string);
                }
                stringBuilder.append('s');
                stringBuilder.append(n3);
                if (bl) {
                    IModuleModel iModuleModel = iEntityModel.getModuleModel();
                    String string2 = iModuleModel.getEqTypeName();
                    stringBuilder.append('(');
                    stringBuilder.append(string2);
                    stringBuilder.append(')');
                }
                if (n4 == 105 || n4 == 144 || n4 == 165 || n4 == 231) {
                    stringBuilder.append(string);
                    stringBuilder.append('p');
                    stringBuilder.append(CircuitEndCellRenderer.getPortString(iEntityModel, false, true));
                    if (n > 0) {
                        stringBuilder.append(string);
                        stringBuilder.append('m');
                        stringBuilder.append(n);
                    }
                    if (iEntityModel.getPayloadType() != 19) {
                        return stringBuilder.toString();
                    }
                } else {
                    if (n4 == 35 || n4 == 36 || n4 == 63) {
                        stringBuilder.append(string);
                        stringBuilder.append('p');
                        stringBuilder.append(CircuitEndCellRenderer.getPortString(iEntityModel, false, true));
                        return stringBuilder.toString();
                    }
                    if (iEntityModel.getModuleModel().getEqType() == 14 || iEntityModel.getModuleModel().getEqType() == 15) {
                        return stringBuilder.toString();
                    }
                    if (iEntityModel instanceof IPortModel) {
                        stringBuilder.append(string);
                        stringBuilder.append('p');
                        n2 = iEntityModel.getEqType();
                        if ((iEntityModel.getModuleModel().getEqType() == 234 || iEntityModel.getModuleModel().getEqType() == 233 || iEntityModel.getModuleModel().getEqType() == 157) && n2 == 34) {
                            int n5;
                            int n6 = CircuitEndCellRenderer.getPortForPath(iEntityModel.getModuleModel(), iEntityModel, iLoNum, iHoNum);
                            stringBuilder.append(CircuitEndCellRenderer.getDs1PortName(iEntityModel, iLoNum, iHoNum));
                            int n7 = n5 = n6 % 28 == 0 ? n6 / 28 : n6 / 28 + 1;
                            if (iHoNum != null) {
                                IHoNum iHoNum2 = HoLoFactory.idlSts2HoNum(iHoNum.getFramingType(), n5);
                                stringBuilder.append(string);
                                stringBuilder.append(CircuitEndCellRenderer.getHoShortString(iEntityModel, iHoNum2));
                                bl2 = true;
                            }
                        } else {
                            stringBuilder.append(CircuitEndCellRenderer.getPortString(CircuitEndCellRenderer.getLoPort(iEntityModel, iLoNum, iHoNum), false, true));
                        }
                    } else {
                        if (db.on()) {
                            db.println("In asSlashSeparatedString, em is " + iEntityModel);
                        }
                        stringBuilder.append(string);
                        stringBuilder.append('p');
                        if (iLoNum != null) {
                            stringBuilder.append(CircuitEndCellRenderer.getDs1PortName(iEntityModel, iLoNum, iHoNum));
                        } else {
                            stringBuilder.append(CircuitEndCellRenderer.getPortString((IEntityModel)CircuitEndCellRenderer.getDs1(iEntityModel, iLoNum, iHoNum), false, true));
                        }
                    }
                }
                if (iHoNum != null && !bl2) {
                    stringBuilder.append(string);
                    stringBuilder.append(CircuitEndCellRenderer.getHoShortString(iEntityModel, iHoNum));
                }
                if (iLoNum != null) {
                    stringBuilder.append(string);
                    stringBuilder.append(CircuitEndCellRenderer.getLoShortString(iLoNum, string));
                }
                stringBuilder.append(OchPortsHelper.getSideString(iEntityModel, OchPortsHelper.SideStringType.SlashSeparated, attrCache, 0));
            } else {
                if (db.on()) {
                    db.println("asSlashSeparatedString: entityModel is null");
                }
                stringBuilder.append(UNAVAILABLE);
            }
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("In asSlashSeparatedString, em is " + iEntityModel);
                SDebug.printStackTrace((Throwable)exception);
            }
            stringBuilder.append(UNAVAILABLE);
        }
        return stringBuilder.toString();
    }

    public static String asSlashSeparatedString(INetCircuitEnd iNetCircuitEnd) {
        return CircuitEndCellRenderer.asSlashSeparatedString(iNetCircuitEnd, null, false);
    }

    public static String asSlashSeparatedString(IOchncPathDefModel iOchncPathDefModel) {
        IEntityModel iEntityModel = null;
        try {
            iEntityModel = iOchncPathDefModel.getNodeModel().getEntityTable().getEntityModelByIndex(iOchncPathDefModel.getPortEntityIdx());
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            return UNAVAILABLE;
        }
        return CircuitEndCellRenderer.asSlashSeparatedString(iEntityModel, null, null, 0, false);
    }

    public static String asSlashSeparatedString(IOchccPathDefModel iOchccPathDefModel) {
        IEntityModel iEntityModel = null;
        try {
            iEntityModel = iOchccPathDefModel.getNodeModel().getEntityTable().getEntityModelByIndex(iOchccPathDefModel.getPortEntityIdx());
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            return UNAVAILABLE;
        }
        return CircuitEndCellRenderer.asSlashSeparatedString(iEntityModel, null, null, 0);
    }

    private static int getMinHoPathWidth(IHoNum iHoNum) {
        return FramingType.getFramingType((int)iHoNum.getFramingType()).getMinimumHoPathWidth();
    }

    private static int getHoOffset(IHoNum iHoNum, ICircuitSize iCircuitSize) {
        return iCircuitSize.size2widthOfHoCircuit() / CircuitEndCellRenderer.getMinHoPathWidth(iHoNum);
    }

    private static IHoNum getLastHoNum(IHoNum iHoNum, int n) {
        return HoLoFactory.addOffset(iHoNum, n - 1);
    }

    private static String getLastHoSuffix(IEntityModel iEntityModel, IHoNum iHoNum, int n) {
        IHoNum iHoNum2 = iEntityModel == null ? iHoNum : CircuitEndCellRenderer.convertToExternalHoNumber(iEntityModel, iHoNum);
        return ".." + CircuitEndCellRenderer.getLastHoNum(iHoNum2, n).getHoNum();
    }

    public static String asSlashSeparatedString(INetCircuitEnd iNetCircuitEnd, ICircuitSize iCircuitSize) {
        return CircuitEndCellRenderer.asSlashSeparatedString(iNetCircuitEnd, iCircuitSize, false);
    }

    public static String asSlashSeparatedString(INetCircuitEnd iNetCircuitEnd, ICircuitSize iCircuitSize, boolean bl) {
        return CircuitEndCellRenderer.asSlashSeparatedString(iNetCircuitEnd, iCircuitSize, bl, true);
    }

    public static String asSlashSeparatedString(INetCircuitEnd iNetCircuitEnd, ICircuitSize iCircuitSize, boolean bl, boolean bl2) {
        try {
            int n;
            IEntityModel iEntityModel = iNetCircuitEnd.getEntityModel();
            IHoNum iHoNum = iNetCircuitEnd.getHoNum();
            ILoNum iLoNum = iNetCircuitEnd.getLoNum();
            int n2 = iNetCircuitEnd.getPathIdentifier();
            String string = CircuitEndCellRenderer.asSlashSeparatedString(iEntityModel, iHoNum, (ILoNum)(bl2 ? iLoNum : null), n2, bl);
            if (iCircuitSize != null && bl2 && iLoNum == null && iHoNum != null && (n = CircuitEndCellRenderer.getHoOffset(iHoNum, iCircuitSize)) > 1) {
                string = string + CircuitEndCellRenderer.getLastHoSuffix(iEntityModel, iHoNum, n);
            }
            return string;
        }
        catch (ObjNotFound objNotFound) {
            if (db.on()) {
                SDebug.printStackTrace((Throwable)objNotFound);
            }
            return UNAVAILABLE;
        }
        catch (Exception exception) {
            if (db.on()) {
                SDebug.printStackTrace((Throwable)exception);
            }
            return UNAVAILABLE;
        }
    }

    public static String getEntityString(IEntityModel iEntityModel) {
        String string = "";
        if (iEntityModel == null) {
            if (CircuitEndCellRenderer.db.on) {
                db.println("getEntityString: returning <null entity>");
            }
            string = UNAVAILABLE;
            return string;
        }
        INodeModel iNodeModel = iEntityModel.getNodeModel();
        if (!Feature.provides((INodeModel)iNodeModel, (Feature)Feature.FTG)) {
            int n = iEntityModel.getSlot();
            int n2 = iEntityModel.getPort();
            return "slot " + n + (n2 == 0 ? "" : ", port " + CircuitEndCellRenderer.getPortString(iEntityModel, false));
        }
        IModuleModel iModuleModel = iEntityModel.getModuleModel();
        IEntityCellRenderer iEntityCellRenderer = ElementFactoryFinder.getElementFactory(iNodeModel).createEntityCellRenderer(iModuleModel);
        string = iEntityCellRenderer.getString((Object)iEntityModel, "shelf ");
        return string;
    }

    public static String getPortString(IEntityModel iEntityModel, boolean bl) {
        return CircuitEndCellRenderer.getPortString(iEntityModel, bl, false);
    }

    public static String getPortString(IEntityModel iEntityModel, boolean bl, boolean bl2) {
        String string = UNAVAILABLE;
        if (iEntityModel != null) {
            INodeModel iNodeModel = iEntityModel.getNodeModel();
            IEntityCellRenderer iEntityCellRenderer = ElementFactoryFinder.getElementFactory(iNodeModel).createEntityCellRenderer(iNodeModel);
            string = iEntityModel.getGenericClass() == 7 ? (iEntityModel.getEqType() == 34 ? PortHelper.getPortNumAndTypeString((IPortModel)((IPortModel)iEntityModel), (boolean)bl2, (boolean)false) : (CircuitEndCellRenderer.hasExpPortNum(iEntityModel) ? iEntityCellRenderer.getPortString(iEntityModel, bl, bl2) : iEntityCellRenderer.getPortString(iEntityModel, bl))) : iEntityCellRenderer.getPortString(iEntityModel, false);
        }
        return string;
    }

    private static boolean hasExpPortNum(IEntityModel iEntityModel) {
        return Feature.provides((INodeModel)iEntityModel.getNodeModel(), (Feature)Feature.EXP_PORT_NUM);
    }

    public static int getMediumType(IEntityModel iEntityModel) {
        INodeModel iNodeModel = iEntityModel.getNodeModel();
        IEntityCellRenderer iEntityCellRenderer = ElementFactoryFinder.getElementFactory(iNodeModel).createEntityCellRenderer(iEntityModel.getModuleModel());
        return iEntityCellRenderer.getMediumType(iEntityModel);
    }

    public static IHoNum convertToExternalHoNumber(IEntityModel iEntityModel, IHoNum iHoNum) {
        if (iHoNum != null) {
            IModuleModel iModuleModel;
            int n = iHoNum.getIdlHoNum();
            if (iEntityModel.getGenericClass() == 7 && (iModuleModel = iEntityModel.getModuleModel()).getEqType() == 47 && !CircuitEndCellRenderer.hasExpPortNum((IEntityModel)iModuleModel)) {
                switch (iEntityModel.getEqType()) {
                    case 34: {
                        n = 1;
                        break;
                    }
                    case 32: {
                        n = iEntityModel.getPort() + 1;
                        break;
                    }
                }
            }
            int n2 = iHoNum.getFramingType();
            iHoNum = HoLoFactory.idlSts2HoNum(n2, n);
        }
        return iHoNum;
    }

    public static IHoNum convertFromExternalHoNumber(IEntityModel iEntityModel, IHoNum iHoNum) {
        IModuleModel iModuleModel = iEntityModel.getModuleModel();
        if (iModuleModel != null && iModuleModel.getEqType() == 47) {
            int n = 0;
            iHoNum = HoLoFactory.createFirstHoNum(n);
        }
        return iHoNum;
    }

    private static String getHoShortString(IEntityModel iEntityModel, IHoNum iHoNum) {
        return CircuitEndCellRenderer.getHoString(iEntityModel, iHoNum, true);
    }

    private static String getHoString(IEntityModel iEntityModel, IHoNum iHoNum) {
        return CircuitEndCellRenderer.getHoString(iEntityModel, iHoNum, false);
    }

    private static String getHoString(IEntityModel iEntityModel, IHoNum iHoNum, boolean bl) {
        String string = "";
        IHoNum iHoNum2 = null;
        if (iEntityModel != null) {
            iHoNum2 = CircuitEndCellRenderer.convertToExternalHoNumber(iEntityModel, iHoNum);
            int n = iHoNum2.getFramingType();
            if (iHoNum2.getFramingType() == 0 && CircuitEndCellRenderer.getMediumType(iEntityModel) == 0) {
                n = 2;
            }
            string = HoLoHelper.getDisplay(iHoNum2, bl, n);
        }
        return string;
    }

    public static String getLoString(ILoNum iLoNum, String string) {
        boolean bl = false;
        return HoLoHelper.getDisplay(iLoNum, string, bl);
    }

    public static String getLoShortString(ILoNum iLoNum, String string) {
        boolean bl = true;
        return HoLoHelper.getDisplay(iLoNum, string, bl);
    }

    public static IPortModel getDs1(IEntityModel iEntityModel, ILoNum iLoNum, IHoNum iHoNum) {
        IPortModel iPortModel = null;
        boolean bl = iEntityModel instanceof IPortModel;
        if (iEntityModel == null || bl && ((IPortModel)iEntityModel).isOptical()) {
            return null;
        }
        IModuleModel iModuleModel = iEntityModel.getModuleModel();
        if (Feature.provides((INodeModel)iModuleModel.getNodeModel(), (Feature)Feature.C310MA)) {
            iPortModel = iModuleModel.getPortModelForPath(iEntityModel, iLoNum, iHoNum);
        } else {
            int n = iEntityModel.getEqType();
            int n2 = iModuleModel.getPortForPath(iLoNum, iHoNum);
            IPortModel[] iPortModelArray = iModuleModel.getDescendantsOfClassType(7).toArray(new IPortModel[0]);
            for (int i = 0; i < iPortModelArray.length; ++i) {
                if (bl && iPortModelArray[i].getEqType() != n || iPortModelArray[i].getPositionInParent() != n2) continue;
                iPortModel = iPortModelArray[i];
                break;
            }
        }
        return iPortModel;
    }

    public static String getDs1PortName(IEntityModel iEntityModel, ILoNum iLoNum, IHoNum iHoNum) {
        String string;
        block5: {
            string = "";
            IPortModel iPortModel = CircuitEndCellRenderer.getDs1(iEntityModel, iLoNum, iHoNum);
            if (iPortModel != null) {
                try {
                    if (iEntityModel.getNodeModel().provides(Feature.EXP_PORT_NUM)) {
                        int[] nArray = iPortModel.getPortNum();
                        string = string + nArray[0] + PortHelper.getFormattedPortAlias((IPortModel)iPortModel);
                    } else {
                        int n = iEntityModel.getModuleModel().getPortForPath(iLoNum, iHoNum);
                        string = string + n + PortHelper.getFormattedPortAlias((IPortModel)iPortModel);
                    }
                }
                catch (Exception exception) {
                    if (!db.on()) break block5;
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
        }
        return string;
    }
}

