/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.INodeModel;
import cerent.cms.model.circuits.SanityCheckException;
import cerent.cms.ncp.CircuitCreatInfo;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitNode;
import cerent.cms.ncp.IncorrectCircuitState;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.ncp.SanityCheckFailed;
import cerent.cms.route.RoutePrefs;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.Network;
import cerent.cms.ui.NodeCellRenderer;
import cerent.cms.ui.WzDialog;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.NEMC;
import cerent.util.SDebug;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class CircuitNodeAdditionDialog
extends JDialog
implements ActionListener {
    private static final SDebug db = new SDebug("CircuitNodeAdditionDialog");
    private static final String OK = "OK";
    private static final String CANCEL = "Cancel";
    private static final int MARGIN = 10;
    public static final String TITLE = "Add Circuit Node";
    private INetCircuit ckt;
    private JButton okButton;
    private JButton cancelButton;
    private JComboBox nodeCB;

    public CircuitNodeAdditionDialog(Component component, INetCircuit iNetCircuit) {
        super(JOptionPane.getFrameForComponent(component), TITLE, true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                CircuitNodeAdditionDialog.this.dispose();
            }
        });
        this.ckt = iNetCircuit;
        this.getContentPane().add((Component)this.getMainPanel(), "Center");
        this.getContentPane().add((Component)this.getButtonPanel(), "South");
        this.pack();
        this.setLocationRelativeTo(JOptionPane.getFrameForComponent(component));
        this.setSize(new Dimension(250, this.getHeight()));
        this.setVisible(true);
    }

    private JPanel getMainPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(1, 10, 10));
        jPanel.add(new JLabel("Node: "));
        this.nodeCB = new JComboBox();
        this.nodeCB.setRenderer(new NodeCellRenderer());
        this.nodeCB.setModel(new DefaultComboBoxModel<Object>(this.getNodeList().toArray()));
        jPanel.add(this.nodeCB);
        return jPanel;
    }

    private List getNodeList() {
        TreeSet<INodeModel> treeSet = new TreeSet<INodeModel>(new NodeComparator());
        if (this.ckt.getCircuitTypeObj().isEthernetCircuitType()) {
            ArrayList arrayList;
            try {
                arrayList = this.ckt.getCircuitNodes();
                arrayList.removeAll(this.ckt.getEtherCircuitNodes());
            }
            catch (IncorrectCircuitState incorrectCircuitState) {
                arrayList = new ArrayList();
            }
            for (INetCircuitNode iNetCircuitNode : arrayList) {
                INodeModel iNodeModel = iNetCircuitNode.getNodeModel();
                if (!iNodeModel.isInited() || iNetCircuitNode.isUpsr()) continue;
                CircuitCreatInfo circuitCreatInfo = new CircuitCreatInfo(this.ckt.getCircuitType(), this.ckt.getCircuitSize(), this.ckt.getCircuitDir());
                if (!NetCircuitManager.instance().canCreateStitchedCircuit(iNodeModel, circuitCreatInfo)) continue;
                treeSet.add(iNodeModel);
            }
        }
        return new ArrayList(treeSet);
    }

    private JPanel getButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 10, 10));
        this.okButton = this.makeActionButton(OK);
        jPanel.add(this.okButton);
        this.cancelButton = this.makeActionButton(CANCEL);
        jPanel.add(this.cancelButton);
        return jPanel;
    }

    private JButton makeActionButton(String string) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(this);
        return jButton;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        try {
            if (object == this.okButton) {
                this.apply();
            }
            this.dispose();
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            if (exception instanceof SanityCheckException) {
                ErrorMsg.displayError(this, NEMC.EID_SANITY_CHECK_FAILED_PARAM_2, ((SanityCheckException)((Object)exception)).getSanityObjects(), WzDialog.closeSentence(exception.getMessage()));
            }
            ErrorMsg.displayError((Component)this, (EID)NEMC.EID_ERROR_ADDING_NODE);
        }
    }

    private void apply() throws Exception {
        int n = ((INodeModel)this.nodeCB.getSelectedItem()).getNodeId();
        INetElement iNetElement = Network.instance().findNetElem(n);
        RoutePrefs routePrefs = new RoutePrefs();
        routePrefs.setPathProt(2);
        routePrefs.setDiversityOption(2);
        this.ckt.routeNetElement(iNetElement, routePrefs);
        if (CircuitNodeAdditionDialog.db.on) {
            db.println("apply: routeNetElement() succeeded");
        }
        try {
            this.ckt.sanityCheck();
            if (CircuitNodeAdditionDialog.db.on) {
                db.println("apply: sanityCheck() succeeded");
            }
            this.ckt.provision();
            if (CircuitNodeAdditionDialog.db.on) {
                db.println("apply: provision() succeeded");
            }
        }
        catch (Exception exception) {
            this.ckt.deleteNetElement(iNetElement);
            if (exception instanceof SanityCheckFailed) {
                throw new SanityCheckException("", "spans are", exception);
            }
            throw exception;
        }
    }

    private class NodeComparator
    implements Comparator {
        private NodeComparator() {
        }

        public int compare(Object object, Object object2) {
            INodeModel iNodeModel = (INodeModel)object;
            INodeModel iNodeModel2 = (INodeModel)object2;
            return iNodeModel.getName().compareTo(iNodeModel2.getName());
        }
    }
}

