/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.ObjNotFound;
import cerent.cms.model.circuits.SanityCheckException;
import cerent.cms.ncp.SanityCheckFailed;
import cerent.cms.ui.WzDiagDebug;
import cerent.cms.ui.circuits.CcdRouteConstraintPane;
import cerent.cms.ui.circuits.CircuitDropCreationDialog;
import cerent.util.gui.CerentDialog;
import java.awt.Component;

public class DropRouteConstraintPane
extends CcdRouteConstraintPane {
    CircuitDropCreationDialog parent;

    public DropRouteConstraintPane(CircuitDropCreationDialog circuitDropCreationDialog, WzDiagDebug wzDiagDebug, String string, boolean bl) {
        super(circuitDropCreationDialog, wzDiagDebug, string, bl);
        this.parent = circuitDropCreationDialog;
    }

    @Override
    protected boolean useDRI() {
        return false;
    }

    @Override
    public void enteringPane() {
        super.enteringPane();
    }

    @Override
    protected void addOrRouteNewCircuit() throws Exception {
        this.parent.addDestination(true);
        if (this.db.on()) {
            this.db.println("addOrRouteNewCircuit: route destination succeeded");
        }
        if (!this.parent.isRrbc()) {
            try {
                this.parent.getCircuit().sanityCheckManualRouting();
                if (this.db.on()) {
                    this.db.println("addOrRouteNewCircuit: sanityCheckManualRouting() succeeded");
                }
            }
            catch (SanityCheckFailed sanityCheckFailed) {
                throw new SanityCheckException("", "drop is", sanityCheckFailed);
            }
        }
    }

    @Override
    public boolean handleBack() {
        boolean bl = true;
        if (this.olm.getSize() > 0 || this.getExcList().size() > 0) {
            bl = CerentDialog.yesNoDialog((Component)this, (String)"Route constraints will be lost.\nAre you sure you want to go BACK?", (String)this.getName());
        }
        if (bl) {
            block9: {
                this.recycle();
                try {
                    if (this.db.on) {
                        this.db.println("constraint handleBack: calling deleteDestination() ->");
                    }
                    this.parent.deleteDestination();
                    if (this.db.on) {
                        this.db.println("constraint handleBack: deleteDestination() successful\n");
                    }
                }
                catch (ObjNotFound objNotFound) {
                    if (this.db.on) {
                        this.db.println("constraint handleBack: no such drop to delete");
                    }
                }
                catch (Exception exception) {
                    if (!this.db.on()) break block9;
                    WzDiagDebug.printStackTrace((Throwable)exception);
                }
            }
            return super.handleBack();
        }
        if (!this.parent.isRrbc()) {
            this.parent.setFinishEnabled(true);
        }
        return false;
    }

    @Override
    protected String getNextPaneName() {
        this.leavingPane();
        return "Route Review and Edit";
    }

    @Override
    public void dispose() {
        this.parent = null;
        super.dispose();
    }

    @Override
    public String getDiagString() {
        StringBuffer stringBuffer = new StringBuffer(super.getDiagString());
        return stringBuffer.toString();
    }
}

