/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.ICircuitSize;
import cerent.cms.model.ICircuitType;
import cerent.cms.model.ILinkModel;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitSpan;
import cerent.cms.ncp.NetVcatCircuit;
import cerent.cms.route.INetLinkSpan;
import cerent.cms.topo.INetLink;
import cerent.cms.ui.circuits.AbstractCircuitMap;
import cerent.cms.ui.network.MapLinkRenderer;
import cerent.util.HoLoComparator;
import cerent.util.IHoNum;
import cerent.util.ILoNum;
import cerent.util.SDebug;
import cerent.util.gui.GridPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;

public abstract class HoLoPane
extends JPanel
implements ActionListener {
    private SDebug dbg;
    private INetLink netLink;
    protected AbstractButton addButton;
    protected AbstractCircuitMap cktMap;
    protected JTextField from;
    protected JTextField to;
    protected ICircuitSize circuitSize;
    protected ICircuitType circuitType;
    protected BoundedGridPanel gridPanel = new BoundedGridPanel(1, 1);
    protected IHoNum firstSpansSrcHoNum = null;
    protected IHoNum firstSpansDstHoNum = null;
    protected ILoNum firstSpansLoNum = null;

    public HoLoPane(SDebug sDebug) {
        this.dbg = sDebug;
        this.Init();
    }

    protected void Init() {
        this.from = new JTextField();
        this.from.setEditable(false);
        this.to = new JTextField();
        this.to.setEditable(false);
        this.gridPanel.addRow("From", this.from);
        this.gridPanel.addRow("To", this.to);
        this.addMoreRows();
        this.add((Component)((Object)this.gridPanel));
    }

    protected abstract void addMoreRows();

    protected abstract void initCB();

    protected abstract JComboBox getHoCB();

    protected abstract void setEnabledControls(boolean var1);

    protected abstract void clearControls();

    protected abstract void enable(INetLink var1, int var2, int var3);

    protected abstract void enable(INetLinkSpan var1);

    protected abstract void selectHoCB(IHoNum var1);

    protected abstract void selectLoCB(ILoNum var1);

    public abstract INetLinkSpan getNetLinkSpan();

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
    }

    public void disablePane() {
        if (this.addButton != null) {
            this.addButton.setEnabled(false);
        }
        this.setEnabledControls(false);
        this.clearControls();
        this.from.setEnabled(false);
        this.to.setEnabled(false);
        this.from.setText("");
        this.to.setText("");
        this.netLink = null;
    }

    public void init(AbstractCircuitMap abstractCircuitMap, AbstractButton abstractButton) {
        this.addButton = abstractButton;
        this.cktMap = abstractCircuitMap;
        this.setEnabledControls(false);
    }

    public void reset() {
        this.addButton = null;
        this.cktMap = null;
        this.netLink = null;
    }

    protected void setNetLink(INetLink iNetLink) {
        this.netLink = iNetLink;
        this.from.setEnabled(true);
        this.to.setEnabled(true);
        ILinkModel iLinkModel = iNetLink.getLinkModel();
        this.from.setText(MapLinkRenderer.getEntityString(iLinkModel.src(), iLinkModel.srcEntityIndex()));
        this.to.setText(MapLinkRenderer.getEntityString(iLinkModel.dst(), iLinkModel.dstEntityIndex()));
    }

    public INetLink getNetLink() {
        return this.netLink;
    }

    protected void setUniqueItem(JComboBox jComboBox, Object object, boolean bl) {
        if (bl) {
            jComboBox.removeActionListener(this);
        }
        jComboBox.removeAllItems();
        jComboBox.addItem(object);
        jComboBox.setEnabled(false);
        if (bl) {
            jComboBox.addActionListener(this);
        }
    }

    protected void filterHoNumbersForVcat(List list) {
        for (INetCircuit iNetCircuit : ((NetVcatCircuit)this.cktMap.getNetCircuit()).getAllMemberCircuits()) {
            INetCircuitSpan iNetCircuitSpan = iNetCircuit.getCircuitSpanFromNetLink(this.netLink);
            if (iNetCircuitSpan == null) continue;
            list.remove(iNetCircuitSpan.getSrcHoNum());
        }
    }

    protected void filterLoNumbersForVcat(List list, IHoNum iHoNum) {
        for (INetCircuit iNetCircuit : ((NetVcatCircuit)this.cktMap.getNetCircuit()).getAllMemberCircuits()) {
            INetCircuitSpan iNetCircuitSpan = iNetCircuit.getCircuitSpanFromNetLink(this.netLink);
            if (iNetCircuitSpan == null) continue;
            if (this.getNetLink().isLOTunnel() || this.getNetLink().isLAP()) {
                list.remove(iNetCircuitSpan.getLoNum());
                if (this.dbg.on()) {
                    this.dbg.println("HoNum-less removal of this LoNum: " + iNetCircuitSpan.getLoNum().prettyString());
                }
            }
            if (!HoLoComparator.instance().isEqual(iNetCircuitSpan.getSrcHoNum(), iHoNum)) continue;
            list.remove(iNetCircuitSpan.getLoNum());
        }
    }

    public class BoundedGridPanel
    extends GridPanel {
        Dimension IDEAL_DIMENSION;

        BoundedGridPanel(int n, int n2) {
            super(n, n2);
            this.IDEAL_DIMENSION = new Dimension(120, 18);
        }

        public void addRow(JComponent jComponent, JComponent jComponent2, int n) {
            jComponent2.setPreferredSize(this.IDEAL_DIMENSION);
            super.addRow(jComponent, jComponent2, n);
        }
    }
}

