/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.Feature;
import cerent.cms.model.IFcmrLineModel;
import cerent.cms.model.IHdGeLineModel;
import cerent.cms.model.IHoPathTraceSupport;
import cerent.cms.model.IInterfaceModel;
import cerent.cms.model.IL2scLineModel;
import cerent.cms.model.ILoPathTraceSupport;
import cerent.cms.model.INodeModel;
import cerent.cms.model.ITdmHoModel;
import cerent.cms.model.ITdmLoModel;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ui.circuits.AbstractPathTrace;
import cerent.cms.ui.circuits.IJTrace;
import cerent.util.SDebug;

public class J1PathTrace
extends AbstractPathTrace
implements IJTrace {
    private static final SDebug db = new SDebug("J1PathTrace");
    private static final String DISABLE_AIS = " Disable AIS and RDI if TIM-P is detected";
    private static final String DISABLE_AIS_600 = " Disable AIS-P if TIM-P is detected";
    public static final String DISABLE_MISMATCH = " Disable AIS on C2 Mismatch?";
    int oldState;
    private IInterfaceModel[] ifModels;
    protected final boolean circuitLevel;
    protected INetCircuit netCircuit;

    public J1PathTrace(IInterfaceModel[] iInterfaceModelArray, INetCircuit iNetCircuit, boolean bl) {
        block3: {
            super(iInterfaceModelArray[0]);
            this.oldState = 0;
            this.ifModels = iInterfaceModelArray;
            this.netCircuit = iNetCircuit;
            this.circuitLevel = bl;
            if (this.pathTraceCleanupSupported) {
                try {
                    this.pathTraceModel = this.isHoCircuitType() ? ((IHoPathTraceSupport)this.ifModels[0]).getHoPathTraceModel() : ((ILoPathTraceSupport)this.ifModels[0]).getLoPathTraceModel();
                }
                catch (Exception exception) {
                    if (!db.on()) break block3;
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
        }
    }

    @Override
    public boolean providesCommonFeature() {
        boolean bl = false;
        if (this.ifModels != null && this.ifModels[0] != null) {
            INodeModel iNodeModel = this.ifModels[0].getNodeModel();
            bl = iNodeModel.provides(Feature.J1_COMMON);
        }
        return bl;
    }

    @Override
    public boolean providesNoAis() {
        boolean bl = false;
        if (this.ifModels != null && this.ifModels[0] != null) {
            for (int i = 0; i < this.ifModels.length; ++i) {
                INodeModel iNodeModel = this.ifModels[i].getNodeModel();
                if (!iNodeModel.provides(Feature.J1_NOAIS)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    @Override
    public boolean providesAutoMode(int n) {
        INodeModel iNodeModel;
        boolean bl = true;
        if (this.ifModels != null && this.ifModels[0] != null && this.ifModels[n] != null && (iNodeModel = this.ifModels[n].getNodeModel()) != null) {
            bl = !Feature.provides((INodeModel)iNodeModel, (Feature)Feature.NO_J1_AUTOMODE);
        }
        return bl;
    }

    @Override
    public String getDisableAisString() {
        if (this.ifModels[0].getNodeModel().getNeType() != null && this.ifModels[0].getNodeModel().getNeType().startsWith("15600")) {
            return DISABLE_AIS_600;
        }
        return DISABLE_AIS;
    }

    public void destroy() {
        if (db.on()) {
            db.println("called destroy");
        }
    }

    @Override
    public int numModels() {
        int n = 0;
        if (this.ifModels != null) {
            n = this.ifModels.length;
        }
        return n;
    }

    @Override
    public String getDisableMismatchString() {
        return DISABLE_MISMATCH;
    }

    public boolean isHoCircuitType() {
        return this.netCircuit.getCircuitTypeObj().isHoCircuitType();
    }

    @Override
    public int getPathTraceMode() throws NoSuchInterface, WrongInterfaceType, InternalCommError, UnsupportedOperation {
        int n = 0;
        if (this.pathTraceCleanupSupported) {
            n = this.pathTraceModel.getPathTraceMode();
        } else if (this.ifModels[0] instanceof ITdmHoModel) {
            n = ((ITdmHoModel)this.ifModels[0]).getHoPathTraceMode();
        } else if (this.ifModels[0] instanceof ITdmLoModel) {
            n = ((ITdmLoModel)this.ifModels[0]).getLoPathTraceMode();
        } else if (this.ifModels[0] instanceof IHdGeLineModel) {
            n = ((IHdGeLineModel)this.ifModels[0]).getPathTraceMode();
        } else if (this.ifModels[0] instanceof IFcmrLineModel) {
            n = ((IFcmrLineModel)this.ifModels[0]).getPathTraceMode();
        } else if (this.ifModels[0] instanceof IL2scLineModel) {
            n = this.isHoCircuitType() ? ((IL2scLineModel)this.ifModels[0]).getPathTraceMode() : ((IL2scLineModel)this.ifModels[0]).getLoPathTraceMode();
        }
        return n;
    }

    @Override
    public int getPayloadMode() throws NoSuchInterface, WrongInterfaceType, InternalCommError, UnsupportedOperation {
        int n = 0;
        if (this.pathTraceCleanupSupported) {
            if (this.ifModels[0] instanceof ITdmHoModel || this.ifModels[0] instanceof ITdmLoModel) {
                n = this.pathTraceModel.getPayloadMode();
            }
        } else if (this.ifModels[0] instanceof ITdmHoModel) {
            n = ((ITdmHoModel)this.ifModels[0]).getHoPayloadMode();
        } else if (this.ifModels[0] instanceof ITdmLoModel) {
            n = ((ITdmLoModel)this.ifModels[0]).getLoPayloadMode();
        }
        if (n == -1) {
            n = 0;
        }
        return n;
    }

    @Override
    public void setPathTraceMode(int n, int n2) throws NoSuchInterface, WrongInterfaceType, InternalCommError, UnsupportedOperation, ProvisionError {
        if (this.pathTraceCleanupSupported) {
            this.pathTraceModel.setPathTraceMode(n2);
        } else if (this.ifModels[0] instanceof ITdmHoModel) {
            ((ITdmHoModel)this.ifModels[0]).setHoPathTraceMode(n2);
        } else if (this.ifModels[0] instanceof ITdmLoModel) {
            ((ITdmLoModel)this.ifModels[0]).setLoPathTraceMode(n2);
        } else if (this.ifModels[0] instanceof IHdGeLineModel) {
            ((IHdGeLineModel)this.ifModels[0]).setPathTraceMode(n2);
        } else if (this.ifModels[0] instanceof IFcmrLineModel) {
            ((IFcmrLineModel)this.ifModels[0]).setPathTraceMode(n2);
        } else if (this.ifModels[0] instanceof IL2scLineModel) {
            if (this.isHoCircuitType()) {
                ((IL2scLineModel)this.ifModels[0]).setPathTraceMode(n2);
            } else {
                ((IL2scLineModel)this.ifModels[0]).setLoPathTraceMode(n2);
            }
        }
    }

    @Override
    public void setPayloadMode(int n, int n2) throws NoSuchInterface, WrongInterfaceType, InternalCommError, UnsupportedOperation {
        if (this.pathTraceCleanupSupported) {
            if (this.ifModels[0] instanceof ITdmHoModel || this.ifModels[0] instanceof ITdmLoModel) {
                this.pathTraceModel.setPayloadMode(n2);
            }
        } else if (this.ifModels[0] instanceof ITdmHoModel) {
            ((ITdmHoModel)this.ifModels[0]).setHoPayloadMode(n2);
        } else if (this.ifModels[0] instanceof ITdmLoModel) {
            ((ITdmLoModel)this.ifModels[0]).setLoPayloadMode(n2);
        }
    }

    @Override
    public byte getCurrentPayloadLabel() throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        byte by = 0;
        if (this.pathTraceCleanupSupported) {
            by = this.pathTraceModel.getCurrentPayloadLabel();
        } else if (this.ifModels[0] instanceof ITdmHoModel) {
            by = ((ITdmHoModel)this.ifModels[0]).getHoTermCurrentPayloadLabel();
        } else if (this.ifModels[0] instanceof ITdmLoModel) {
            by = ((ITdmLoModel)this.ifModels[0]).getLoTermCurrentPayloadLabel();
        } else if (this.ifModels[0] instanceof IHdGeLineModel) {
            by = ((IHdGeLineModel)this.ifModels[0]).getCurrentPayloadLabel();
        } else if (this.ifModels[0] instanceof IFcmrLineModel) {
            by = ((IFcmrLineModel)this.ifModels[0]).getCurrentPayloadLabel();
        } else if (this.ifModels[0] instanceof IL2scLineModel) {
            by = this.isHoCircuitType() ? ((IL2scLineModel)this.ifModels[0]).getCurrentPayloadLabel() : ((IL2scLineModel)this.ifModels[0]).getLoTermCurrentPayloadLabel();
        }
        return by;
    }

    @Override
    public byte getExpectedPayloadLabel() throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        byte by = 0;
        if (this.pathTraceCleanupSupported) {
            if (this.ifModels[0] instanceof ITdmHoModel || this.ifModels[0] instanceof ITdmLoModel) {
                by = this.pathTraceModel.getExpectedPayloadCode();
            }
        } else if (this.ifModels[0] instanceof ITdmHoModel) {
            by = ((ITdmHoModel)this.ifModels[0]).getHoTermExpectedPayloadCode();
        } else if (this.ifModels[0] instanceof ITdmLoModel) {
            by = ((ITdmLoModel)this.ifModels[0]).getLoTermExpectedPayloadCode();
        }
        return by;
    }

    @Override
    public void setSendPathTrace(int n, String string) throws NoSuchInterface, WrongInterfaceType, InternalCommError, UnsupportedOperation {
        if (this.pathTraceCleanupSupported) {
            this.pathTraceModel.setSendPathTrace(string);
        } else if (this.ifModels[0] instanceof ITdmHoModel) {
            ((ITdmHoModel)this.ifModels[0]).setHoTermSendPathTrace(string);
        } else if (this.ifModels[0] instanceof ITdmLoModel) {
            ((ITdmLoModel)this.ifModels[0]).setLoSendPathTrace(string);
        } else if (this.ifModels[0] instanceof IHdGeLineModel) {
            ((IHdGeLineModel)this.ifModels[0]).setSendPathTrace(string);
        } else if (this.ifModels[0] instanceof IFcmrLineModel) {
            ((IFcmrLineModel)this.ifModels[0]).setSendPathTrace(string);
        } else if (this.ifModels[0] instanceof IL2scLineModel) {
            if (this.isHoCircuitType()) {
                ((IL2scLineModel)this.ifModels[0]).setSendPathTrace(string);
            } else {
                ((IL2scLineModel)this.ifModels[0]).setLoSendPathTrace(string);
            }
        }
    }

    @Override
    public char[] getSendPathTrace() {
        char[] cArray = "<unable to retrieve transmit path trace from card>".toCharArray();
        try {
            String string = null;
            if (this.pathTraceCleanupSupported) {
                string = this.pathTraceModel.getSendPathTrace();
            } else if (this.ifModels[0] instanceof ITdmHoModel) {
                string = ((ITdmHoModel)this.ifModels[0]).getHoTermSendPathTrace();
            } else if (this.ifModels[0] instanceof ITdmLoModel) {
                string = ((ITdmLoModel)this.ifModels[0]).getLoSendPathTrace();
            } else if (this.ifModels[0] instanceof IHdGeLineModel) {
                string = ((IHdGeLineModel)this.ifModels[0]).getSendPathTrace();
            } else if (this.ifModels[0] instanceof IFcmrLineModel) {
                string = ((IFcmrLineModel)this.ifModels[0]).getSendPathTrace();
            } else if (this.ifModels[0] instanceof IL2scLineModel) {
                string = this.isHoCircuitType() ? ((IL2scLineModel)this.ifModels[0]).getSendPathTrace() : ((IL2scLineModel)this.ifModels[0]).getLoSendPathTrace();
            }
            if (string != null) {
                cArray = string.toCharArray();
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            cArray = "<unable to retrieve transmit path trace from card>".toCharArray();
        }
        return cArray;
    }

    @Override
    public void setExpectedPathTrace(int n, String string) throws NoSuchInterface, WrongInterfaceType, InternalCommError, UnsupportedOperation {
        if (this.pathTraceCleanupSupported) {
            this.pathTraceModel.setExpectedPathTrace(string);
        } else if (this.ifModels[0] instanceof ITdmHoModel) {
            ((ITdmHoModel)this.ifModels[0]).setHoTermExpectedPathTrace(string);
        } else if (this.ifModels[0] instanceof ITdmLoModel) {
            ((ITdmLoModel)this.ifModels[0]).setLoExpectedPathTrace(string);
        } else if (this.ifModels[0] instanceof IHdGeLineModel) {
            ((IHdGeLineModel)this.ifModels[0]).setExpectedPathTrace(string);
        } else if (this.ifModels[0] instanceof IFcmrLineModel) {
            ((IFcmrLineModel)this.ifModels[0]).setExpectedPathTrace(string);
        } else if (this.ifModels[0] instanceof IL2scLineModel) {
            if (this.isHoCircuitType()) {
                ((IL2scLineModel)this.ifModels[0]).setExpectedPathTrace(string);
            } else {
                ((IL2scLineModel)this.ifModels[0]).setLoExpectedPathTrace(string);
            }
        }
    }

    @Override
    public char[] getExpectedPathTrace() {
        char[] cArray = "<unable to retrieve expected path trace from card>".toCharArray();
        try {
            if (this.pathTraceCleanupSupported) {
                cArray = this.pathTraceModel.getExpectedPathTrace();
            } else if (this.ifModels[0] instanceof ITdmHoModel) {
                cArray = ((ITdmHoModel)this.ifModels[0]).getHoTermExpectedPathTrace();
            } else if (this.ifModels[0] instanceof ITdmLoModel) {
                cArray = ((ITdmLoModel)this.ifModels[0]).getLoExpectedPathTrace();
            } else if (this.ifModels[0] instanceof IHdGeLineModel) {
                cArray = ((IHdGeLineModel)this.ifModels[0]).getExpectedPathTrace();
            } else if (this.ifModels[0] instanceof IFcmrLineModel) {
                cArray = ((IFcmrLineModel)this.ifModels[0]).getExpectedPathTrace();
            } else if (this.ifModels[0] instanceof IL2scLineModel) {
                cArray = this.isHoCircuitType() ? ((IL2scLineModel)this.ifModels[0]).getExpectedPathTrace() : ((IL2scLineModel)this.ifModels[0]).getLoExpectedPathTrace();
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            cArray = "<unable to retrieve expected path trace from card>".toCharArray();
        }
        return cArray;
    }

    @Override
    public char[] getReceivedPathTrace() {
        char[] cArray = "<unable to retrieve received path trace from card>".toCharArray();
        try {
            if (this.pathTraceCleanupSupported) {
                cArray = this.pathTraceModel.getReceivedPathTrace();
            } else if (this.ifModels[0] instanceof ITdmHoModel) {
                cArray = ((ITdmHoModel)this.ifModels[0]).getHoTermReceivedPathTrace();
            } else if (this.ifModels[0] instanceof ITdmLoModel) {
                cArray = ((ITdmLoModel)this.ifModels[0]).getLoReceivedPathTrace();
            } else if (this.ifModels[0] instanceof IHdGeLineModel) {
                cArray = ((IHdGeLineModel)this.ifModels[0]).getReceivedPathTrace();
            } else if (this.ifModels[0] instanceof IFcmrLineModel) {
                cArray = ((IFcmrLineModel)this.ifModels[0]).getReceivedPathTrace();
            } else if (this.ifModels[0] instanceof IL2scLineModel) {
                cArray = this.isHoCircuitType() ? ((IL2scLineModel)this.ifModels[0]).getReceivedPathTrace() : ((IL2scLineModel)this.ifModels[0]).getLoReceivedPathTrace();
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            cArray = "<unable to retrieve received path trace from card>".toCharArray();
        }
        return cArray;
    }

    @Override
    public void setPathTraceFormat(int n, int n2) throws NoSuchInterface, WrongInterfaceType, UnsupportedOperation, ProvisionError {
        if (this.pathTraceCleanupSupported) {
            this.pathTraceModel.setPathTraceFormat(n2);
        } else if (this.ifModels[0] instanceof ITdmHoModel) {
            ((ITdmHoModel)this.ifModels[0]).setHoPathTraceFormat(n2);
        } else if (this.ifModels[0] instanceof ITdmLoModel) {
            ((ITdmLoModel)this.ifModels[0]).setLoPathTraceFormat(n2);
        } else if (this.ifModels[0] instanceof IHdGeLineModel) {
            ((IHdGeLineModel)this.ifModels[0]).setPathTraceFormat(n2);
        } else if (this.ifModels[0] instanceof IFcmrLineModel) {
            try {
                ((IFcmrLineModel)this.ifModels[0]).setPathTraceFormat(n2);
            }
            catch (NoSuchInterface noSuchInterface) {
                db.println("NoSuchInterface caught: " + (Object)((Object)noSuchInterface));
                SDebug.printStackTrace((Throwable)noSuchInterface);
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                db.println("WrongInterfaceType caught: " + (Object)((Object)wrongInterfaceType));
                SDebug.printStackTrace((Throwable)wrongInterfaceType);
            }
            catch (UnsupportedOperation unsupportedOperation) {
                db.println("UnsupportedOperation caught: " + (Object)((Object)unsupportedOperation));
                SDebug.printStackTrace((Throwable)unsupportedOperation);
            }
        } else if (this.ifModels[0] instanceof IL2scLineModel) {
            if (this.isHoCircuitType()) {
                ((IL2scLineModel)this.ifModels[0]).setPathTraceFormat(n2);
            } else {
                ((IL2scLineModel)this.ifModels[0]).setLoPathTraceFormat(n2);
            }
        }
    }

    @Override
    public int getPathTraceFormat() throws NoSuchInterface, WrongInterfaceType, UnsupportedOperation {
        int n = 0;
        if (this.pathTraceCleanupSupported) {
            n = this.pathTraceModel.getPathTraceFormat();
        } else if (this.ifModels[0] instanceof ITdmHoModel) {
            n = ((ITdmHoModel)this.ifModels[0]).getHoPathTraceFormat();
        } else if (this.ifModels[0] instanceof ITdmLoModel) {
            n = ((ITdmLoModel)this.ifModels[0]).getLoPathTraceFormat();
        } else if (this.ifModels[0] instanceof IHdGeLineModel) {
            n = ((IHdGeLineModel)this.ifModels[0]).getPathTraceFormat();
        } else if (this.ifModels[0] instanceof IFcmrLineModel) {
            try {
                n = ((IFcmrLineModel)this.ifModels[0]).getPathTraceFormat();
            }
            catch (NoSuchInterface noSuchInterface) {
                db.println("NoSuchInterface caught: " + (Object)((Object)noSuchInterface));
                SDebug.printStackTrace((Throwable)noSuchInterface);
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                db.println("WrongInterfaceType caught: " + (Object)((Object)wrongInterfaceType));
                SDebug.printStackTrace((Throwable)wrongInterfaceType);
            }
            catch (UnsupportedOperation unsupportedOperation) {
                db.println("UnsupportedOperation caught: " + (Object)((Object)unsupportedOperation));
                SDebug.printStackTrace((Throwable)unsupportedOperation);
            }
        } else if (this.ifModels[0] instanceof IL2scLineModel) {
            n = this.isHoCircuitType() ? ((IL2scLineModel)this.ifModels[0]).getPathTraceFormat() : ((IL2scLineModel)this.ifModels[0]).getLoPathTraceFormat();
        }
        return n;
    }
}

