/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.IEntityModel;
import cerent.cms.model.OchTrailHelper;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.INetCircuitNode;
import cerent.cms.ncp.NetCircuitNode;
import cerent.cms.ncp.OchncCircuit;
import cerent.cms.ui.circuits.CircuitEndCellRenderer;
import cerent.cms.ui.circuits.OchccProtectedCircuitMapPort;
import cerent.cms.ui.network.CircuitMapNode;
import cerent.cms.ui.network.CircuitMapPort;
import cerent.cms.ui.network.CircuitMapPortCookie;
import cerent.util.SDebug;
import com.cisco.ctc.util.map.AbstractInternalPG;
import com.cisco.ctc.util.map.DetailedMapNode;
import com.cisco.ctc.util.map.MapPolygon;
import com.cisco.ctc.util.map.MapPort;
import com.cisco.ctc.util.map.MapTriangle;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;

public class OchTrailInternalPG
extends AbstractInternalPG {
    private static final SDebug db = new SDebug("OchTrailInternalPG");
    private static final double LENGTH = 20.0;
    private static final double LENGTH_HALF = 10.0;
    private static final double HEIGHT = OchTrailInternalPG.getTriangleHeight(20.0, 10.0) - 5.0;
    private static final double BORDER_GAP = 6.0;
    private MapPort otsTx;
    private MapPort otsRx;
    private MapPort ochRx;
    private MapPort ochTx;
    private MapPort trunk;
    private INetCircuitEnd ochRxNce;
    private INetCircuitEnd ochTxNce;
    private INetCircuitEnd trunkNce;
    private IEntityModel trunkEM;
    private IEntityModel ochRxEM;
    private IEntityModel ochTxEM;
    private boolean isOchcc;
    private boolean isProtected;

    private static double getTriangleHeight(double d, double d2) {
        return Math.sqrt(d * d + d2 * d2);
    }

    private static final double avg(double d, double d2) {
        return (d + d2) / 2.0;
    }

    public OchTrailInternalPG(DetailedMapNode detailedMapNode) {
        super(detailedMapNode);
        if (detailedMapNode instanceof CircuitMapNode) {
            INetCircuit iNetCircuit = ((CircuitMapNode)detailedMapNode).getNetCircuit();
            this.isOchcc = iNetCircuit.getCircuitTypeObj().isOchccCircuitType();
        }
    }

    @Override
    protected MapPolygon getShapeObject() {
        MapTriangle mapTriangle = new MapTriangle();
        mapTriangle.setColor(Color.white);
        mapTriangle.setFillOn(true);
        return mapTriangle;
    }

    @Override
    protected MapPort[] getInternalPorts() {
        OchTrailInternalPGCookie ochTrailInternalPGCookie = (OchTrailInternalPGCookie)this.getUserCookie();
        INetCircuit iNetCircuit = ochTrailInternalPGCookie.getCktNode().getCircuit();
        String string = this.ochRxNce != null ? CircuitEndCellRenderer.asSlashSeparatedString(this.ochRxEM, null, null, this.ochRxNce.getPathIdentifier(), false) : "Unknown och";
        CircuitMapPortCookie circuitMapPortCookie = new CircuitMapPortCookie(iNetCircuit, string);
        this.ochRx = new InternalCircuitMapPort(this.getParentNode());
        this.ochRx.init(this.ochRxNce, circuitMapPortCookie);
        string = this.ochTxNce != null ? CircuitEndCellRenderer.asSlashSeparatedString(this.ochTxEM, null, null, this.ochTxNce.getPathIdentifier(), false) : "Unknown och";
        circuitMapPortCookie = new CircuitMapPortCookie(iNetCircuit, string);
        this.ochTx = new InternalCircuitMapPort(this.getParentNode());
        this.ochTx.init(this.ochTxNce, circuitMapPortCookie);
        string = this.trunkNce != null ? CircuitEndCellRenderer.asSlashSeparatedString(this.trunkEM, null, null, this.trunkNce.getPathIdentifier(), false) : "Unknown trunk";
        circuitMapPortCookie = new CircuitMapPortCookie(iNetCircuit, string);
        if (this.isOchcc && !OchTrailHelper.isLineCard(this.trunkEM)) {
            this.trunk = this.isProtected ? new OchccProtectedCircuitMapPort.InternalCircuitMapPort(this, this.getParentNode(), this.trunkEM.getEntityIndex()) : new InternalCircuitMapPort(this.getParentNode());
            this.trunk.init(this.trunkNce, circuitMapPortCookie);
            return new MapPort[]{this.ochRx, this.ochTx, this.trunk};
        }
        return new MapPort[]{this.ochRx, this.ochTx};
    }

    @Override
    protected void graphicallyInit() {
        this.side = 1;
    }

    @Override
    public void updatePositionInNode() {
        if (this.isOchcc) {
            this.updatePositionInNodeForOchcc();
        } else {
            this.updatePositionInNodeForOchnc();
        }
    }

    private void updatePositionInNodeForOchcc() {
        int n;
        if (this.otsTx == null || this.otsRx == null) {
            return;
        }
        int n2 = this.otsTx.getSide();
        if (n2 != (n = this.otsRx.getSide())) {
            db.warning("Side1 and side2 differs: " + n2 + " != " + n + "\nSide1 will be used.");
        }
        this.updateSide(n2);
        if (this.trunk != null) {
            this.trunk.setSide(this.side);
        }
        if (db.on()) {
            db.println("UpdatePositionInNode:\nOTS1: side " + n2 + "\n" + "OTS2: side " + n + "\n" + "PG: side " + this.side);
        }
        double d = 0.0;
        double d2 = 0.0;
        Rectangle2D rectangle2D = this.otsTx.getBounds();
        double d3 = this.otsTx.getCenterX();
        double d4 = rectangle2D.getX();
        double d5 = rectangle2D.getMaxX();
        double d6 = this.otsTx.getCenterY();
        double d7 = rectangle2D.getY();
        double d8 = rectangle2D.getMaxY();
        double d9 = this.otsRx.getCenterX();
        double d10 = this.otsRx.getCenterY();
        Point2D point2D = null;
        Point2D point2D2 = null;
        Point2D point2D3 = null;
        switch (this.side) {
            case 1: {
                d = OchTrailInternalPG.avg(d3, d9);
                d2 = d8 + 6.0;
                if (d3 < d9) {
                    point2D = this.setVertix(1, d - 10.0, d2);
                    point2D2 = this.setVertix(2, d + 10.0, d2);
                } else {
                    point2D = this.setVertix(1, d + 10.0, d2);
                    point2D2 = this.setVertix(2, d - 10.0, d2);
                }
                point2D3 = this.setVertix(3, d, d2 + HEIGHT);
                break;
            }
            case -2: {
                d = d5 + 6.0;
                d2 = OchTrailInternalPG.avg(d6, d10);
                if (d6 < d10) {
                    point2D = this.setVertix(1, d, d2 - 10.0);
                    point2D2 = this.setVertix(2, d, d2 + 10.0);
                } else {
                    point2D = this.setVertix(1, d, d2 + 10.0);
                    point2D2 = this.setVertix(2, d, d2 - 10.0);
                }
                point2D3 = this.setVertix(3, d + HEIGHT, d2);
                break;
            }
            case -1: {
                d = OchTrailInternalPG.avg(d3, d9);
                d2 = d7 - 6.0;
                if (d3 < d9) {
                    point2D = this.setVertix(1, d - 10.0, d2);
                    point2D2 = this.setVertix(2, d + 10.0, d2);
                } else {
                    point2D = this.setVertix(1, d + 10.0, d2);
                    point2D2 = this.setVertix(2, d - 10.0, d2);
                }
                point2D3 = this.setVertix(3, d, d2 - HEIGHT);
                break;
            }
            case 2: {
                d = d4 - 6.0;
                d2 = OchTrailInternalPG.avg(d6, d10);
                if (d6 < d10) {
                    point2D = this.setVertix(1, d, d2 - 10.0);
                    point2D2 = this.setVertix(2, d, d2 + 10.0);
                } else {
                    point2D = this.setVertix(1, d, d2 + 10.0);
                    point2D2 = this.setVertix(2, d, d2 - 10.0);
                }
                point2D3 = this.setVertix(3, d - HEIGHT, d2);
            }
        }
        if (point2D != null && point2D2 != null && point2D3 != null) {
            if (this.shapeObject != null) {
                MapTriangle mapTriangle = (MapTriangle)this.shapeObject;
                Point2D[] point2DArray = new Point2D[]{point2D, point2D2, point2D3};
                mapTriangle.setVertices(point2DArray);
            }
            if (db.on()) {
                db.println("UpdatePositionInNode:\nOTS1: (" + d3 + ", " + d6 + ")\n" + "OTS2: (" + d9 + ", " + d10 + ")\n" + "PG: (" + d + ", " + d2 + ")\n" + "V1: (" + point2D.getX() + ", " + point2D.getY() + ")\n" + "V2: (" + point2D2.getX() + ", " + point2D2.getY() + ")\n" + "V3: (" + point2D3.getX() + ", " + point2D3.getY() + ")\n");
            }
        }
    }

    private void updatePositionInNodeForOchnc() {
        if (this.trunk == null) {
            return;
        }
        int n = this.trunk.getSide();
        this.updateSide(n);
        if (db.on()) {
            db.println("UpdatePositionInNode:\nTrunk: side " + n + "\n" + "PG: side " + this.side);
        }
        double d = 0.0;
        double d2 = 0.0;
        Rectangle2D rectangle2D = this.trunk.getBounds();
        double d3 = this.trunk.getCenterX();
        double d4 = rectangle2D.getX();
        double d5 = rectangle2D.getMaxX();
        double d6 = this.trunk.getCenterY();
        double d7 = rectangle2D.getY();
        double d8 = rectangle2D.getMaxY();
        Point2D point2D = null;
        Point2D point2D2 = null;
        Point2D point2D3 = null;
        switch (this.side) {
            case -1: {
                d = d3;
                d2 = d7;
                point2D = this.setVertix(1, d - 10.0, d2 - HEIGHT);
                point2D2 = this.setVertix(2, d + 10.0, d2 - HEIGHT);
                point2D3 = this.setVertix(3, d, d2);
                break;
            }
            case 1: {
                d = d3;
                d2 = d8;
                point2D = this.setVertix(1, d - 10.0, d2 + HEIGHT);
                point2D2 = this.setVertix(2, d + 10.0, d2 + HEIGHT);
                point2D3 = this.setVertix(3, d, d2);
                break;
            }
            case 2: {
                d = d4;
                d2 = d6;
                point2D = this.setVertix(1, d - HEIGHT, d2 - 10.0);
                point2D2 = this.setVertix(2, d - HEIGHT, d2 + 10.0);
                point2D3 = this.setVertix(3, d, d2);
                break;
            }
            case -2: {
                d = d5;
                d2 = d6;
                point2D = this.setVertix(1, d + HEIGHT, d2 - 10.0);
                point2D2 = this.setVertix(2, d + HEIGHT, d2 + 10.0);
                point2D3 = this.setVertix(3, d, d2);
            }
        }
        if (point2D != null && point2D2 != null && point2D3 != null) {
            if (this.shapeObject != null) {
                MapTriangle mapTriangle = (MapTriangle)this.shapeObject;
                Point2D[] point2DArray = new Point2D[]{point2D, point2D2, point2D3};
                mapTriangle.setVertices(point2DArray);
            }
            if (db.on()) {
                db.println("UpdatePositionInNode:\nTrunk: (" + d3 + ", " + d6 + ")\n" + "PG: (" + d + ", " + d2 + ")\n" + "V1: (" + point2D.getX() + ", " + point2D.getY() + ")\n" + "V2: (" + point2D2.getX() + ", " + point2D2.getY() + ")\n" + "V3: (" + point2D3.getX() + ", " + point2D3.getY() + ")\n");
            }
        }
    }

    private Point2D setVertix(int n, double d, double d2) {
        Point2D.Double double_ = new Point2D.Double();
        switch (n) {
            case 1: {
                double_.setLocation(d, d2);
                this.ochRx.setCenter(d, d2);
                break;
            }
            case 2: {
                double_.setLocation(d, d2);
                this.ochTx.setCenter(d, d2);
                break;
            }
            case 3: {
                double_.setLocation(d, d2);
                if (!this.isOchcc || this.trunk == null) break;
                this.trunk.setCenter(d, d2);
                break;
            }
            default: {
                double_ = null;
                db.warning("Called setVertix with invalid index " + n);
            }
        }
        return double_;
    }

    private void updateSide(int n) {
        this.setSide(n);
        if (this.ochRx != null) {
            this.ochRx.setSide(this.side);
        }
        if (this.ochTx != null) {
            this.ochTx.setSide(this.side);
        }
    }

    @Override
    public void init(Object object, Object object2) throws Exception {
        super.init(object, object2);
        OchTrailInternalPGCookie ochTrailInternalPGCookie = (OchTrailInternalPGCookie)object2;
        IEntityModel iEntityModel = null;
        IEntityModel iEntityModel2 = null;
        INetCircuitNode iNetCircuitNode = ochTrailInternalPGCookie.getCktNode();
        OchncCircuit ochncCircuit = ochTrailInternalPGCookie.getOchncCircuit();
        List list = ochncCircuit.getSrcNetElement().equals(iNetCircuitNode.getNetElement()) ? ochncCircuit.getSrcInternalSpliceLinkEnds() : ochncCircuit.getDstInternalSpliceLinkEnds();
        if (list.size() != 3) {
            throw new Exception("An OCH trail internal protection group with " + list.size() + " OCHNC circuit ports cannot be created.\n" + "Exactly three ports are required.");
        }
        this.trunkNce = (INetCircuitEnd)list.get(0);
        this.trunkEM = this.trunkNce.getEntityModel();
        this.isProtected = OchTrailHelper.isProtected(this.trunkEM);
        this.ochRxNce = (INetCircuitEnd)list.get(1);
        this.ochRxEM = this.ochRxNce.getEntityModel();
        this.ochTxNce = (INetCircuitEnd)list.get(2);
        this.ochTxEM = this.ochTxNce.getEntityModel();
        if (!this.trunkNce.getNetElement().equals(iNetCircuitNode.getNetElement())) {
            list = ochncCircuit.getSrcNetElement().equals(iNetCircuitNode.getNetElement()) ? ochncCircuit.getDstInternalSpliceLinkEnds() : ochncCircuit.getSrcInternalSpliceLinkEnds();
            if (list.size() == 3) {
                this.trunkNce = (INetCircuitEnd)list.get(0);
                this.trunkEM = this.trunkNce.getEntityModel();
                this.isProtected = OchTrailHelper.isProtected(this.trunkEM);
                this.ochRxNce = (INetCircuitEnd)list.get(1);
                this.ochRxEM = this.ochRxNce.getEntityModel();
                this.ochTxNce = (INetCircuitEnd)list.get(2);
                this.ochTxEM = this.ochTxNce.getEntityModel();
            } else {
                throw new Exception("An OCH trail internal protection group with " + list.size() + " OCHNC circuit ports cannot be created.\n" + "Exactly three ports are required.");
            }
        }
        if (db.on()) {
            db.println("Found EM Ports: OCH1 = " + this.ochRxEM + ", OCH2 = " + this.ochTxEM + ", Trunk = " + this.trunkEM);
        }
        this.otsTx = null;
        this.otsRx = null;
        if (ochncCircuit.isSplitterProtectedCircuit()) {
            this.trunk = this.getMapPortFromEM(this.trunkEM);
            if (this.trunk != null) {
                this.setPorts(new MapPort[]{this.trunk});
            }
        } else {
            if (this.ochRxEM != null) {
                iEntityModel = ((NetCircuitNode)iNetCircuitNode).getConnectionPathEnd(2).getEntityModel();
                this.otsTx = this.getMapPortFromEM(iEntityModel);
            }
            if (this.ochTxEM != null) {
                iEntityModel2 = ((NetCircuitNode)iNetCircuitNode).getConnectionPathEnd(1).getEntityModel();
                this.otsRx = this.getMapPortFromEM(iEntityModel2);
            }
            if (db.on()) {
                db.println("Found OTS EMs: OTS1 = " + iEntityModel + ", OTS22 = " + iEntityModel2);
                db.println("Found OTS MapPorts: ots1 = " + this.otsTx + ", OTS2 = " + this.otsRx);
            }
            if (this.otsTx != null && this.otsRx != null) {
                this.setPorts(new MapPort[]{this.otsTx, this.otsRx});
            }
        }
    }

    private MapPort getMapPortFromEM(IEntityModel iEntityModel) {
        int n = iEntityModel.getEntityIndex();
        MapPort[] mapPortArray = this.parentNode.getPorts();
        if (db.on()) {
            db.println("getMapPortFromEM() seeking from " + mapPortArray.length + " ports");
        }
        for (int i = 0; i < mapPortArray.length; ++i) {
            MapPort mapPort = mapPortArray[i];
            if (db.on()) {
                db.println("getMapPortFromEM() checking with " + mapPort);
            }
            if (((CircuitMapNode)this.parentNode).getEntityIndex(mapPort) != n) continue;
            return mapPort;
        }
        return null;
    }

    public class InternalCircuitMapPort
    extends CircuitMapPort {
        private static final double PORTWIDTH = 8.0;
        private static final double PORTHEIGHT = 8.0;

        public InternalCircuitMapPort(DetailedMapNode detailedMapNode) {
            super(detailedMapNode, null);
            this.setInternalPG(OchTrailInternalPG.this);
        }

        @Override
        public void graphicallyInitPort() {
            super.graphicallyInitPort();
            this.setSize(8.0, 8.0);
        }
    }

    static class OchTrailInternalPGCookie {
        private INetCircuitNode cktNode;
        private OchncCircuit ochncCircuit;

        public OchTrailInternalPGCookie(INetCircuitNode iNetCircuitNode) {
            this.cktNode = iNetCircuitNode;
            this.ochncCircuit = (OchncCircuit)iNetCircuitNode.getCircuit();
        }

        public INetCircuitNode getCktNode() {
            return this.cktNode;
        }

        public OchncCircuit getOchncCircuit() {
            return this.ochncCircuit;
        }
    }
}

