/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.Feature;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.IPptData;
import cerent.cms.model.circuits.NetCircuitNodeDataSource;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitNode;
import cerent.cms.ncp.InternalNetLink;
import cerent.cms.ncp.NetCircuitNode;
import cerent.cms.ncp.NetCircuitSpan;
import cerent.cms.ncp.OchncCircuit;
import cerent.cms.ncp.OchncCircuitNode;
import cerent.cms.topo.Network;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.NetworkViewController;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.UiToolkit;
import cerent.cms.ui.ViewName;
import cerent.cms.ui.circuits.CircuitPpt;
import cerent.cms.ui.circuits.PptChartDataModel;
import cerent.cms.ui.circuits.PptChartHighlightListener;
import cerent.cms.ui.circuits.PptFormatter;
import cerent.cms.ui.event.EventPanelController;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.InetUtil;
import cerent.util.KEMC;
import cerent.util.KErrorMsg;
import cerent.util.NEMC;
import cerent.util.gui.BarChart;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.ExtensionFileFilter;
import cerent.util.gui.PersistentFileChooserDialog;
import cerent.util.gui.UScrollPane;
import com.klg.jclass.chart.ChartDataModel;
import ilog.views.chart.IlvChartInteractor;
import ilog.views.chart.IlvDisplayPoint;
import ilog.views.chart.event.ChartInteractionListener;
import ilog.views.chart.interactor.IlvChartHighlightInteractor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.naming.OperationNotSupportedException;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class PptPane
extends AbstractPane {
    private static final String EXPORT_PATH = "ctc";
    private static final String EXPORT_PROP = "export.file.path";
    private static final long serialVersionUID = 1L;
    private static final String TITLE = "Photonic Path Trace";
    private static final String START = "Start";
    private static final String CANCEL = "Cancel";
    private static final String EXPORT = "Export";
    private static final String NOT_AVAIL = " <N/A>";
    private static final String PATH1 = "Path #1";
    private static final String PATH2 = "Path #2";
    private boolean started = false;
    private INetCircuit ckt;
    private CircuitPpt ppt;
    private JTree tree;
    private JButton btnStartCancel;
    private BarChart chart;
    private JButton btnExport;
    private List<IPptData> fwdResult = null;
    private List<IPptData> revResult = null;
    private TreeSelectionListener treeListen = new TreeSelectionListener(){

        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            TreePath treePath = treeSelectionEvent.getPath();
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getParentPath().getLastPathComponent();
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            if (defaultMutableTreeNode2.getLevel() != 2) {
                return;
            }
            PptPane.this.chart.removeMouseListener(PptPane.this.mouseListen);
            if (((TreeNodeInfo)defaultMutableTreeNode2.getUserObject()).isEnabled()) {
                PptPane.this.updateChart(defaultMutableTreeNode.getIndex(defaultMutableTreeNode2), defaultMutableTreeNode.getParent().getIndex(defaultMutableTreeNode) == 1);
                PptPane.this.chart.addMouseListener(PptPane.this.mouseListen);
            } else {
                PptPane.this.chart.setDataSource(null);
            }
        }
    };
    private MouseListener mouseListen = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() != 2) {
                return;
            }
            IlvDisplayPoint ilvDisplayPoint = PptPane.this.highlightListener.getLastPoint();
            if (ilvDisplayPoint == null) {
                return;
            }
            int n = ilvDisplayPoint.getIndex();
            try {
                int n2 = 0;
                IPortModel iPortModel = (IPortModel)PptPane.this.currentNode.getEntityTable().getEntityModelByIndex(PptPane.this.currentDataModel.getPortIds()[n]);
                if (PptPane.this.currentNode.provides(Feature.MULTISHELF) && PptPane.this.currentNode.isMultishelf()) {
                    n2 = iPortModel.getShelfId();
                }
                NetworkViewController.instance().tryJumpView(new ViewName(new int[]{PptPane.this.currentNode.getNodeId(), n2, iPortModel.getSlot()}));
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (db.on) {
                    db.println("AbstractCmsNoSuchEntityException on PptPane.mouseListen");
                }
                return;
            }
        }
    };
    private PptChartDataModel currentDataModel;
    private INodeModel currentNode;
    private PptChartHighlightListener highlightListener;

    public PptPane(TabbedView tabbedView, INetCircuit iNetCircuit) {
        super(TITLE, tabbedView);
        this.ckt = iNetCircuit;
        new EventPanelController(NetworkViewController.instance());
        this.initPane();
    }

    public INetCircuit getCircuit() {
        return this.ckt;
    }

    @Override
    public void enteringPage() throws Exception {
    }

    @Override
    public void leavingPage() throws Exception {
    }

    @Override
    public void refresh() throws Exception {
    }

    public void updateData(List<IPptData> list, List<IPptData> list2) {
        this.fwdResult = list;
        this.revResult = list2;
        this.fillTree();
        this.tree.setEnabled(true);
        this.expandTree();
        this.tree.addTreeSelectionListener(this.treeListen);
        this.tree.setSelectionRow(1);
        this.started = false;
        this.btnStartCancel.setText(START);
        this.btnExport.setEnabled(true);
    }

    private void cancel() {
        if (this.ppt != null) {
            this.ppt.cancel();
        }
        this.started = false;
        this.btnStartCancel.setText(START);
    }

    private void start() {
        this.started = true;
        this.reset();
        this.btnExport.setEnabled(false);
        this.btnStartCancel.setText(CANCEL);
        this.ppt = new CircuitPpt(this, db);
        try {
            this.ppt.start();
        }
        catch (OperationNotSupportedException operationNotSupportedException) {
            operationNotSupportedException.printStackTrace();
        }
    }

    private void reset() {
        this.tree.removeTreeSelectionListener(this.treeListen);
        this.chart.removeMouseListener(this.mouseListen);
        this.tree.setEnabled(false);
        this.tree.setModel(null);
        this.chart.setDataSource(null);
    }

    private void fillTree() {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Object object72;
        List list;
        NetCircuitNodeDataSource netCircuitNodeDataSource = new NetCircuitNodeDataSource(this.ckt);
        ArrayList<OchncCircuitNode> arrayList = new ArrayList<OchncCircuitNode>();
        OchncCircuit ochncCircuit = (OchncCircuit)this.ckt;
        List list2 = ochncCircuit.getCircuitNodeFromNE(ochncCircuit.getSourceNE());
        OchncCircuitNode ochncCircuitNode = null;
        OchncCircuitNode ochncCircuitNode2 = null;
        NetCircuitNode netCircuitNode = (NetCircuitNode)list2.get(0);
        if (netCircuitNode instanceof OchncCircuitNode) {
            ochncCircuitNode = (OchncCircuitNode)netCircuitNode;
        } else {
            list = netCircuitNode.getAllSpansList();
            for (Object object72 : list) {
                object6 = (NetCircuitSpan)object72;
                object5 = ((NetCircuitSpan)object6).getDstNCN();
                if (!(object5 instanceof OchncCircuitNode)) continue;
                ochncCircuitNode = (OchncCircuitNode)object5;
            }
        }
        arrayList.add(ochncCircuitNode);
        list = ochncCircuit.getCircuitNodeFromNE(ochncCircuit.getDstNetElementForOCHNC());
        for (Object object72 : list) {
            if (!(object72 instanceof OchncCircuitNode)) continue;
            ochncCircuitNode2 = (OchncCircuitNode)object72;
            break;
        }
        Object object8 = ochncCircuitNode;
        object72 = null;
        block2: do {
            object6 = ((NetCircuitNode)object8).getAllSpansList();
            object5 = object6.iterator();
            while (object5.hasNext()) {
                object4 = object5.next();
                object3 = (NetCircuitSpan)object4;
                object2 = ((NetCircuitSpan)object3).getLink();
                if (object2 instanceof InternalNetLink || !object2.getSrc().equals(((NetCircuitNode)object8).getNetElement()) || object72 != null && object2.getDst().equals(((NetCircuitNode)object72).getNetElement())) continue;
                List list3 = this.ckt.getCircuitNodeFromNE(object2.getDst());
                for (Object e : list3) {
                    if (!(e instanceof OchncCircuitNode)) continue;
                    object72 = object8;
                    object8 = (OchncCircuitNode)e;
                    arrayList.add((OchncCircuitNode)e);
                    continue block2;
                }
            }
        } while (!object8.equals(ochncCircuitNode2));
        object6 = new DefaultMutableTreeNode("");
        object5 = new DefaultMutableTreeNode();
        object4 = new DefaultMutableTreeNode();
        object3 = ((OchncCircuitNode)arrayList.get(0)).getNodeModel().getName();
        object2 = ((OchncCircuitNode)arrayList.get(arrayList.size() - 1)).getNodeModel().getName();
        for (int i = 0; i < arrayList.size(); ++i) {
            if (this.fwdResult != null) {
                object = ((OchncCircuitNode)arrayList.get(i)).getNodeModel().getName();
                if (this.fwdResult.get(i).getPowerValues().length > 0) {
                    ((DefaultMutableTreeNode)object5).add(new DefaultMutableTreeNode(new TreeNodeInfo((String)object, true, true)));
                } else {
                    ((DefaultMutableTreeNode)object5).add(new DefaultMutableTreeNode(new TreeNodeInfo((String)object + NOT_AVAIL, false, true)));
                }
            }
            if (this.revResult == null) continue;
            object = ((INetCircuitNode)arrayList.get(arrayList.size() - i - 1)).getNodeModel().getName();
            if (this.revResult.get(i).getPowerValues().length > 0) {
                ((DefaultMutableTreeNode)object4).add(new DefaultMutableTreeNode(new TreeNodeInfo((String)object, true, true)));
                continue;
            }
            ((DefaultMutableTreeNode)object4).add(new DefaultMutableTreeNode(new TreeNodeInfo((String)object + NOT_AVAIL, false, true)));
        }
        if (this.fwdResult.get(0).getNodeIp().compareTo((Object)((OchncCircuitNode)arrayList.get(0)).getNodeModel().getIpConfig().getIpAddress()) != 0) {
            List<IPptData> list4 = this.fwdResult;
            this.fwdResult = this.revResult;
            this.revResult = list4;
        }
        String string = this.fwdResult != null && this.fwdResult.size() > 0 ? (String)object3 + " - " + (String)object2 : "Path #1 <N/A>";
        object = this.revResult != null && this.revResult.size() > 0 ? (String)object2 + " - " + (String)object3 : "Path #2 <N/A>";
        ((DefaultMutableTreeNode)object5).setUserObject(new TreeNodeInfo(string, true, false));
        ((DefaultMutableTreeNode)object4).setUserObject(new TreeNodeInfo((String)object, true, false));
        ((DefaultMutableTreeNode)object6).add((MutableTreeNode)object5);
        ((DefaultMutableTreeNode)object6).add((MutableTreeNode)object4);
        this.tree.setModel(new DefaultTreeModel((TreeNode)object6));
        this.expandTree();
    }

    private void expandTree() {
        for (int i = 0; i < this.tree.getRowCount(); ++i) {
            this.tree.expandRow(i);
        }
    }

    private void updateChart(int n, boolean bl) {
        if (!(bl || this.fwdResult != null && this.fwdResult.size() != 0)) {
            return;
        }
        if (bl && (this.revResult == null || this.revResult.size() == 0)) {
            return;
        }
        IPptData iPptData = bl ? this.revResult.get(n) : this.fwdResult.get(n);
        this.currentDataModel = new PptChartDataModel(iPptData, db);
        this.currentNode = Network.instance().findNetElemByIp(InetUtil.makeDottedString(iPptData.getNodeIp())).getNodeModel();
        this.chart.setDataSource((ChartDataModel)this.currentDataModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void export() {
        String[] stringArray = new String[]{"htm", "html"};
        File file = PersistentFileChooserDialog.getFileUseChooser((Component)UiToolkit.instance().getApplicationFrame(), (byte)2, (String)EXPORT_PATH, (String)EXPORT_PROP, (FileFilter)new ExtensionFileFilter(stringArray, "HTML file"));
        if (file != null) {
            if (!file.getName().endsWith(".htm") && !file.getName().endsWith(".html")) {
                file = new File(file.getAbsolutePath() + ".html");
            }
            if (!file.exists() || CerentDialog.yesNoDialog((Component)UiToolkit.instance().getApplicationFrame(), (String)("The file " + file.getAbsolutePath() + " already exists.\nDo you want to replace it?"), (String)"File Export")) {
                BufferedWriter bufferedWriter = null;
                try {
                    bufferedWriter = new BufferedWriter(new FileWriter(file));
                    bufferedWriter.write(new PptFormatter(this.ckt, this.fwdResult, this.revResult, db).htmlFormat());
                }
                catch (IOException iOException) {
                    String string = KErrorMsg.getString((EID)KEMC.EID_FILE_SAVE_EXCEPTION_PARAM_1, (Object)file.getAbsolutePath());
                    CerentDialog.errorDialog((Component)UiToolkit.instance().getApplicationFrame(), (String)string);
                }
                finally {
                    try {
                        if (bufferedWriter != null) {
                            bufferedWriter.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private boolean isCircuitSupported() {
        if (((OchncCircuit)this.ckt).isSplitterProtectedCircuit()) {
            return false;
        }
        Iterator iterator = this.ckt.getCircuitNodes().iterator();
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        while (iterator.hasNext()) {
            INetCircuitNode iNetCircuitNode = (INetCircuitNode)iterator.next();
            if (!(iNetCircuitNode instanceof OchncCircuitNode)) continue;
            OchncCircuitNode ochncCircuitNode = (OchncCircuitNode)iNetCircuitNode;
            Integer n = (Integer)hashMap.get(ochncCircuitNode.getNetElement().getHostName());
            if (n != null) {
                Integer n2 = n;
                Integer n3 = n = Integer.valueOf(n + 1);
            } else {
                n = 1;
            }
            if (n > 1) {
                return false;
            }
            hashMap.put(ochncCircuitNode.getNetElement().getHostName(), n);
        }
        return true;
    }

    private String getUnsupportedCircuitErrorMsg() {
        if (((OchncCircuit)this.ckt).isSplitterProtectedCircuit()) {
            return "Splitter Protected circuits not supported.";
        }
        Iterator iterator = this.ckt.getCircuitNodes().iterator();
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        while (iterator.hasNext()) {
            INetCircuitNode iNetCircuitNode = (INetCircuitNode)iterator.next();
            if (!(iNetCircuitNode instanceof OchncCircuitNode)) continue;
            OchncCircuitNode ochncCircuitNode = (OchncCircuitNode)iNetCircuitNode;
            Integer n = (Integer)hashMap.get(ochncCircuitNode.getNetElement().getHostName());
            if (n != null) {
                Integer n2 = n;
                Integer n3 = n = Integer.valueOf(n + 1);
            } else {
                n = 1;
            }
            if (n > 1) {
                return "Regenerated circuits not supported.";
            }
            hashMap.put(ochncCircuitNode.getNetElement().getHostName(), n);
        }
        return "";
    }

    private void initPane() {
        this.setLayout(new BorderLayout());
        if (!this.isCircuitSupported()) {
            JLabel jLabel = new JLabel();
            jLabel.setText("Unsupported circuit: " + this.getUnsupportedCircuitErrorMsg());
            this.add(jLabel, "North");
        } else {
            this.tree = new JTree();
            this.tree.setSelectionModel(new DefaultTreeSelectionModel(){
                private static final long serialVersionUID = 1L;

                @Override
                public void setSelectionPath(TreePath treePath) {
                    Object object = ((DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject();
                    if (object instanceof TreeNodeInfo && ((TreeNodeInfo)object).isSelectable()) {
                        super.setSelectionPath(treePath);
                    }
                }
            });
            this.tree.getSelectionModel().setSelectionMode(1);
            this.tree.setCellRenderer(new DefaultTreeCellRenderer(){
                private static final long serialVersionUID = 1L;

                @Override
                public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
                    super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
                    Object object2 = ((DefaultMutableTreeNode)object).getUserObject();
                    if (object2 instanceof TreeNodeInfo && !((TreeNodeInfo)object2).isSelectable()) {
                        this.setFont(this.getFont().deriveFont(1));
                    } else {
                        this.setFont(this.getFont().deriveFont(0));
                    }
                    return this;
                }

                @Override
                public Icon getLeafIcon() {
                    return null;
                }

                @Override
                public Icon getOpenIcon() {
                    return null;
                }

                @Override
                public Icon getClosedIcon() {
                    return null;
                }
            });
            this.tree.setRootVisible(false);
            this.tree.setShowsRootHandles(true);
            this.tree.setModel(null);
            this.tree.setEnabled(false);
            UScrollPane uScrollPane = new UScrollPane((Component)this.tree);
            uScrollPane.setPreferredSize(new Dimension(120, 0));
            this.chart = new BarChart(BarChart.BarStyle.SUPERIMP);
            this.chart.setLegendVisible(true);
            this.chart.setAutoLabel(true);
            this.chart.setYaxisTitle("dBm");
            Color color = new Color(187, 187, 240);
            this.chart.setBackground(color);
            IlvChartHighlightInteractor ilvChartHighlightInteractor = new IlvChartHighlightInteractor();
            ilvChartHighlightInteractor.setPickingMode(1);
            this.highlightListener = new PptChartHighlightListener();
            ilvChartHighlightInteractor.addChartInteractionListener((ChartInteractionListener)this.highlightListener);
            this.chart.addInteractor((IlvChartInteractor)ilvChartHighlightInteractor);
            JSplitPane jSplitPane = new JSplitPane(1, (Component)uScrollPane, this.chart.getComponentObj());
            jSplitPane.setDividerSize(2);
            jSplitPane.setBorder(BorderFactory.createEmptyBorder(4, 0, 4, 0));
            this.add(jSplitPane, "Center");
            JPanel jPanel = new JPanel(new FlowLayout(1, 5, 5));
            JPanel jPanel2 = new JPanel(new BorderLayout());
            this.btnStartCancel = new JButton(START);
            this.btnStartCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (PptPane.this.started) {
                        PptPane.this.cancel();
                    } else if (PptPane.this.ckt.getState() != 1 && PptPane.this.ckt.getState() != 5) {
                        ErrorMsg.displayError((Component)((Object)PptPane.this), (EID)NEMC.EID_PPT_FAILURE_WRONG_STATE);
                    } else {
                        PptPane.this.start();
                    }
                }
            });
            this.btnExport = new JButton(EXPORT);
            this.btnExport.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PptPane.this.export();
                }
            });
            this.btnExport.setEnabled(false);
            jPanel2.add((Component)this.btnStartCancel, "West");
            jPanel2.add((Component)this.btnExport, "East");
            jPanel.add(jPanel2);
            this.add(jPanel, "South");
        }
    }

    private static class TreeNodeInfo {
        private boolean enabled;
        private boolean selectable;
        private String label;

        public TreeNodeInfo(String string, boolean bl, boolean bl2) {
            this.label = string;
            this.enabled = bl;
            this.selectable = bl2;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public boolean isSelectable() {
            return this.selectable;
        }

        public String toString() {
            return this.label;
        }
    }
}

