/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.RollValidator;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NetCSHelpConst;
import cerent.cms.ui.WzDiagDebug;
import cerent.cms.ui.WzPane;
import cerent.cms.ui.circuits.RollCreationDialog;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.UComboBox;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class RollAttrsPane
extends WzPane {
    UComboBox rollModeCB;
    UComboBox rollTypeCB;
    JRadioButton firstCktRB;
    JRadioButton secondCktRB;
    ButtonGroup radioButtonGroup;
    private String lastRollType;
    private ButtonModel lastRollFromCkt;
    public static final String ROLL_TYPE_SINGLE = "Single";
    public static final String ROLL_TYPE_DUAL = "Dual";
    public static final String ROLL_MODE_AUTO = "Auto";
    public static final String ROLL_MODE_MANUAL = "Manual";

    public RollAttrsPane(RollCreationDialog rollCreationDialog, WzDiagDebug wzDiagDebug, String string) {
        super(rollCreationDialog, wzDiagDebug, string);
    }

    @Override
    protected void initPane() {
        this.setLayout(new GridLayout(1, 2));
        JPanel jPanel = RollAttrsPane.createVerticalPanel("Roll");
        this.add(jPanel);
        JPanel jPanel2 = RollAttrsPane.createHorizontalPanel(null);
        jPanel2.setAlignmentX(0.0f);
        jPanel2.add(new JLabel("Circuit Roll Mode: "));
        this.rollModeCB = new UComboBox();
        this.rollModeCB.addItem((Object)ROLL_MODE_MANUAL);
        this.rollModeCB.addItem((Object)ROLL_MODE_AUTO);
        jPanel2.add((Component)this.rollModeCB);
        this.rollModeCB.addActionListener((ActionListener)this);
        jPanel.add(jPanel2);
        jPanel.add(Box.createVerticalStrut(5));
        jPanel2 = RollAttrsPane.createHorizontalPanel(null);
        jPanel2.setAlignmentX(0.0f);
        jPanel2.add(new JLabel("Circuit Roll Type: "));
        this.rollTypeCB = new UComboBox();
        this.setRollTypeSelection(((RollCreationDialog)this.parent).rollFromCkt, ((RollCreationDialog)this.parent).rollToCkt);
        this.lastRollType = (String)this.rollTypeCB.getSelectedItem();
        jPanel2.add((Component)this.rollTypeCB);
        this.rollTypeCB.addActionListener((ActionListener)this);
        jPanel.add(jPanel2);
        jPanel.add(Box.createVerticalStrut(5));
        JPanel jPanel3 = RollAttrsPane.createVerticalPanel("Roll From Circuit");
        this.add(jPanel3);
        if (((RollCreationDialog)this.parent).rollToCkt != null) {
            jPanel2 = RollAttrsPane.createHorizontalPanel(null);
            jPanel2.setAlignmentX(0.0f);
            this.firstCktRB = new JRadioButton(((RollCreationDialog)this.parent).rollFromCkt.getCircuitName(), false);
            jPanel2.add(this.firstCktRB);
            jPanel3.add(jPanel2);
            jPanel3.add(Box.createVerticalStrut(5));
            this.firstCktRB.addActionListener(this);
            this.lastRollFromCkt = this.firstCktRB.getModel();
            jPanel2 = RollAttrsPane.createHorizontalPanel(null);
            jPanel2.setAlignmentX(0.0f);
            this.secondCktRB = new JRadioButton(((RollCreationDialog)this.parent).rollToCkt.getCircuitName(), false);
            jPanel2.add(this.secondCktRB);
            jPanel3.add(jPanel2);
            jPanel3.add(Box.createVerticalStrut(5));
            this.secondCktRB.addActionListener(this);
            this.radioButtonGroup = new ButtonGroup();
            this.radioButtonGroup.add(this.firstCktRB);
            this.radioButtonGroup.add(this.secondCktRB);
        } else {
            jPanel3.setVisible(false);
        }
    }

    private void setRollTypeSelection(INetCircuit iNetCircuit, INetCircuit iNetCircuit2) {
        if (iNetCircuit.isMemberOfVcat()) {
            if (iNetCircuit.isOpenEndedVcatCircuit()) {
                this.rollTypeCB.addItem((Object)ROLL_TYPE_DUAL);
                this.rollTypeCB.addItem((Object)ROLL_TYPE_SINGLE);
            } else {
                this.rollTypeCB.addItem((Object)ROLL_TYPE_DUAL);
            }
        } else if (iNetCircuit.getCircuitSpans().size() == 0) {
            this.rollTypeCB.addItem((Object)ROLL_TYPE_SINGLE);
        } else if (iNetCircuit.getCircuitTypeObj().isLoCircuitType() && iNetCircuit.useLAP() != null && (iNetCircuit.getCircuitSpans().size() == 1 || RollValidator.getInstance().allMidNodesInSameBlsr(iNetCircuit))) {
            this.rollTypeCB.addItem((Object)ROLL_TYPE_SINGLE);
        } else if (iNetCircuit.getCircuitTypeObj().isTunnelCircuitType() || iNetCircuit.getCircuitTypeObj().isLAPCircuitType() || iNetCircuit.getCircuitTypeObj().isEthernetCircuitType()) {
            this.rollTypeCB.addItem((Object)ROLL_TYPE_DUAL);
        } else if (((RollCreationDialog)this.parent).isPortGroupingCkt(iNetCircuit) && iNetCircuit2 != null) {
            this.rollTypeCB.addItem((Object)ROLL_TYPE_DUAL);
        } else {
            this.rollTypeCB.addItem((Object)ROLL_TYPE_DUAL);
            this.rollTypeCB.addItem((Object)ROLL_TYPE_SINGLE);
        }
    }

    @Override
    public void revalidateData() {
    }

    @Override
    public void validatePage() throws Exception {
        String string = (String)this.rollTypeCB.getSelectedItem();
        if (string.equals(ROLL_TYPE_SINGLE) && this.rollTypeCB.getItemCount() == 2) {
            this.isOkToPostValidate = CerentDialog.yesNoWarningDialog((Component)this, (String)"Are you sure you want to change the\nsource or destination of this circuit?\n\nIf you only want to reroute the circuit,\nselect the DUAL circuit roll type instead.\n\nIs it OK to continue with the roll creation ?", (String)"Roll Attributes", (int)1);
            if (!this.isOkToPostValidate()) {
                return;
            }
        }
        boolean bl = false;
        if (this.radioButtonGroup != null) {
            ButtonModel buttonModel = this.radioButtonGroup.getSelection();
            if (buttonModel == null) {
                throw new Exception("The roll from circuit is not selected.");
            }
            if (buttonModel != this.lastRollFromCkt) {
                ((RollCreationDialog)this.parent).swapTwoCircuits();
                bl = true;
                this.lastRollFromCkt = buttonModel;
            }
            if (((RollCreationDialog)this.parent).hasMonitorInRollFromCircuit()) {
                throw new Exception("You cannot bridge and roll from the selected circuit because it has a monitor circuit.");
            }
            if (((RollCreationDialog)this.parent).rollToCkt.isMemberOfVcat()) {
                throw new Exception("A VCAT member can only be selected as roll from circuit.");
            }
            if (string.equals(ROLL_TYPE_DUAL) && (((RollCreationDialog)this.parent).rollToCkt.getSources().size() != 1 || ((RollCreationDialog)this.parent).rollToCkt.getDrops().size() != 1)) {
                throw new Exception("A roll to circuit can only have one source and one destination.");
            }
        }
        if (((RollCreationDialog)this.parent).rollFromCkt.isMemberOfVcat() && string.equals(ROLL_TYPE_DUAL) && ((RollCreationDialog)this.parent).rollFromCkt.getCircuitSpans().size() == 0) {
            throw new Exception("A dual roll cannot be performed on a circuit with a source and destination on the same node.");
        }
        if (!string.equals(this.lastRollType)) {
            bl = true;
            this.lastRollType = string;
        }
        if (bl) {
            ((RollCreationDialog)this.parent).resetPanes();
        }
        ((RollCreationDialog)this.parent).rollType = string;
        ((RollCreationDialog)this.parent).guiRollMode = ((String)this.rollModeCB.getSelectedItem()).equals(ROLL_MODE_AUTO) ? 0 : 1;
        if (!((RollCreationDialog)this.parent).rollFromCkt.isBidirectional() && ((RollCreationDialog)this.parent).rollType.equals(ROLL_TYPE_DUAL) && ((RollCreationDialog)this.parent).guiRollMode == 1) {
            throw new Exception("Based on circuit direction and roll type, the circuit roll mode must be AUTO.");
        }
    }

    @Override
    protected JComponent getStatusComponent() {
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        arrayList.add(new String[]{"Ckt Roll Mode:", this.rollModeCB.getSelectedItem().toString()});
        arrayList.add(new String[]{"Ckt Roll Type:", ((RollCreationDialog)this.parent).rollType});
        if (this.radioButtonGroup != null) {
            arrayList.add(new String[]{"Roll From Ckt: ", ((RollCreationDialog)this.parent).rollFromCkt.getCircuitName()});
            arrayList.add(new String[]{"Roll To Ckt: ", ((RollCreationDialog)this.parent).rollToCkt.getCircuitName()});
        } else {
            arrayList.add(new String[]{"Roll From Ckt: ", ((RollCreationDialog)this.parent).rollFromCkt.getCircuitName()});
            arrayList.add(new String[]{"Roll To Ckt: ", ((RollCreationDialog)this.parent).rollFromCkt.getCircuitName()});
        }
        return RollAttrsPane.getGridPanel(arrayList);
    }

    @Override
    protected String getStatusText() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Circuit Roll Mode: ");
        stringBuffer.append(this.rollModeCB.getSelectedItem());
        stringBuffer.append("\nCircuit Roll Type: ");
        stringBuffer.append(((RollCreationDialog)this.parent).rollType);
        if (this.radioButtonGroup != null) {
            stringBuffer.append("\nRoll From Circuit: ");
            stringBuffer.append(((RollCreationDialog)this.parent).rollFromCkt.getCircuitName());
            stringBuffer.append("\nRoll To Circuit: ");
            stringBuffer.append(((RollCreationDialog)this.parent).rollToCkt.getCircuitName());
        } else {
            stringBuffer.append("\nRoll From Circuit: ");
            stringBuffer.append(((RollCreationDialog)this.parent).rollFromCkt.getCircuitName());
            stringBuffer.append("\nRoll To Circuit: ");
            stringBuffer.append(((RollCreationDialog)this.parent).rollFromCkt.getCircuitName());
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.firstCktRB || object == this.secondCktRB) {
            ButtonModel buttonModel = this.radioButtonGroup.getSelection();
            INetCircuit iNetCircuit = ((RollCreationDialog)this.parent).rollFromCkt;
            INetCircuit iNetCircuit2 = ((RollCreationDialog)this.parent).rollToCkt;
            if (buttonModel != this.lastRollFromCkt) {
                iNetCircuit = ((RollCreationDialog)this.parent).rollToCkt;
                iNetCircuit2 = ((RollCreationDialog)this.parent).rollFromCkt;
            }
            Object object2 = this.rollTypeCB.getSelectedItem();
            this.rollTypeCB.removeActionListener((ActionListener)this);
            this.rollTypeCB.removeAllItems();
            this.setRollTypeSelection(iNetCircuit, iNetCircuit2);
            this.rollTypeCB.setSelectedItem(object2);
            this.rollTypeCB.addActionListener((ActionListener)this);
        }
    }

    @Override
    protected String getNextPaneName() {
        return "Pivot/Fixed Point 1";
    }

    @Override
    public CSHelpID getHelpID() {
        return NetCSHelpConst.RollAttrsPane;
    }

    @Override
    public void removeListeners() {
        if (this.rollModeCB != null) {
            this.rollModeCB.removeActionListener((ActionListener)this);
        }
        if (this.rollTypeCB != null) {
            this.rollTypeCB.removeActionListener((ActionListener)this);
        }
        if (this.firstCktRB != null) {
            this.firstCktRB.removeActionListener(this);
        }
        if (this.secondCktRB != null) {
            this.secondCktRB.removeActionListener(this);
        }
        super.removeListeners();
    }

    @Override
    public String getDiagString() {
        StringBuffer stringBuffer = new StringBuffer(super.getDiagString());
        stringBuffer.append("NOTE: Re-arch this class so we can see more variables.\n");
        stringBuffer.append("Last Roll Type: " + this.lastRollType + "\n");
        stringBuffer.append("Last Roll From Ckt: " + this.lastRollFromCkt + "\n");
        return stringBuffer.toString();
    }
}

