/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.circuits;

import cerent.cms.route.INetLinkSpan;
import cerent.cms.route.NetLinkSpan;
import cerent.cms.topo.ServerTrailLink;
import cerent.cms.ui.circuits.AbstractSdhHoLoPane;
import cerent.util.IHoNum;
import cerent.util.ILoNum;
import cerent.util.SDebug;
import cerent.util.SdhAu3LoNum;
import java.awt.event.ActionEvent;
import javax.swing.JComboBox;
import javax.swing.JLabel;

public class SdhAu3HoLoPane
extends AbstractSdhHoLoPane {
    private SDebug dbg;

    public SdhAu3HoLoPane(SDebug sDebug) {
        super(sDebug);
        this.dbg = sDebug;
    }

    @Override
    protected void addMoreRows() {
        this.vc3LB = new JLabel("Source VC3");
        this.vc3CB = new JComboBox();
        this.vc3CB.addActionListener(this);
        this.gridPanel.addRow(this.vc3LB, this.vc3CB);
    }

    @Override
    public void disablePane() {
        this.cleanupControls();
        super.disablePane();
    }

    @Override
    protected void initCB() {
    }

    @Override
    protected JComboBox getHoCB() {
        return this.vc3CB;
    }

    @Override
    protected void selectHoCB(IHoNum iHoNum) {
        this.vc3CB.setSelectedItem(iHoNum);
    }

    @Override
    protected void selectLoCB(ILoNum iLoNum) {
        SdhAu3LoNum sdhAu3LoNum = (SdhAu3LoNum)iLoNum;
        this.tug2CB.setSelectedItem(new Integer(sdhAu3LoNum.getGroupNum()));
        if (sdhAu3LoNum.isVc11Num()) {
            this.vc11_12CB.setSelectedItem(new Integer(sdhAu3LoNum.getVc11()));
        } else if (sdhAu3LoNum.isVc12Num()) {
            this.vc11_12CB.setSelectedItem(new Integer(sdhAu3LoNum.getVc12()));
        }
    }

    protected void cleanupControls() {
        this.vc3CB.removeAllItems();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.getHoCB()) {
            this.addButton.setEnabled(true);
        }
    }

    @Override
    public void enable(INetLinkSpan iNetLinkSpan) {
        this.setEnabledControls(false);
        this.from.setEnabled(false);
        this.addButton.setEnabled(false);
        this.setNetLink(iNetLinkSpan.getLink());
        this.setUniqueItem(this.getHoCB(), iNetLinkSpan.getSrcHoNum(), true);
    }

    @Override
    public INetLinkSpan getNetLinkSpan() {
        NetLinkSpan netLinkSpan = null;
        if (this.getNetLink() != null) {
            IHoNum iHoNum;
            IHoNum iHoNum2;
            ILoNum iLoNum = null;
            if (this.getNetLink().isServerTrail()) {
                iHoNum2 = (IHoNum)this.getHoCB().getSelectedItem();
                iHoNum = ((ServerTrailLink)this.getNetLink()).getDstHo(iHoNum2);
            } else {
                iHoNum = iHoNum2 = (IHoNum)this.getHoCB().getSelectedItem();
            }
            netLinkSpan = new NetLinkSpan(this.getNetLink(), this.cktMap.findReverseLink(this.getNetLink()), iHoNum2, iHoNum, iLoNum);
        }
        return netLinkSpan;
    }

    @Override
    protected void clearControls() {
        this.vc3CB.removeAllItems();
    }

    @Override
    protected void setEnabledControls(boolean bl) {
        this.vc3CB.setEnabled(bl);
    }
}

