/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.download;

import cerent.cms.model.Feature;
import cerent.cms.model.INodeModel;
import cerent.cms.ui.NodeVersionInfo;
import cerent.util.gui.row.AbstractColumnRenderer;
import cerent.util.gui.row.ColumnRenderer;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;

public class SoftMaintColumnRenderer
extends AbstractColumnRenderer {
    private static final int COLUMN_COUNT = 6;
    private static final int NODE = 0;
    private static final int NODE_TYPE = 1;
    private static final int NODE_ALARM_SEVERITY = 2;
    private static final int WORKING_VERSION = 3;
    private static final int PROTECT_VERSION = 4;
    private static final int DOWNLOAD_STATUS = 5;
    private JLabel label = new JLabel();

    public SoftMaintColumnRenderer(String string, int n, boolean bl, int n2) {
        super(string, n, bl, n2);
        this.label.setToolTipText("double click to go to the Node's view");
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        String string = " ";
        JLabel jLabel = this.label;
        NodeVersionInfo nodeVersionInfo = (NodeVersionInfo)object;
        switch (n2) {
            case 0: {
                try {
                    string = string + nodeVersionInfo.getNodeModel().getName();
                }
                catch (Exception exception) {}
                break;
            }
            case 1: {
                string = string + nodeVersionInfo.getNeType();
                if (Feature.provides((INodeModel)nodeVersionInfo.getNodeModel(), (Feature)Feature.PACKAGE_SPLIT) && (nodeVersionInfo.getNeType().equals("15454") || nodeVersionInfo.getNeType().equals("15454SDH"))) {
                    string = string + "-" + nodeVersionInfo.getNodeModel().getPackageTypeStr();
                }
                if (!string.contains("M6") && !string.contains("M2")) break;
                string = "15454-" + nodeVersionInfo.getNeType();
                break;
            }
            case 2: {
                string = string + nodeVersionInfo.getAlarmSeverityString();
                break;
            }
            case 3: {
                string = string + nodeVersionInfo.getWorkingVersion();
                break;
            }
            case 4: {
                string = string + nodeVersionInfo.getProtectVersion();
                break;
            }
            case 5: {
                string = string + nodeVersionInfo.getStatusString();
            }
        }
        this.label.setText(string);
        return jLabel;
    }

    @Override
    public int compareColumn(Object object, Object object2, int n) {
        NodeVersionInfo nodeVersionInfo = (NodeVersionInfo)object;
        NodeVersionInfo nodeVersionInfo2 = (NodeVersionInfo)object2;
        switch (n) {
            case 0: {
                return nodeVersionInfo.getNodeName().compareTo(nodeVersionInfo2.getNodeName());
            }
            case 1: {
                return nodeVersionInfo.getNeType().compareTo(nodeVersionInfo2.getNeType());
            }
            case 2: {
                return nodeVersionInfo.getAlarmSeverityString().compareTo(nodeVersionInfo2.getAlarmSeverityString());
            }
            case 3: {
                return nodeVersionInfo.getWorkingVersion().compareTo(nodeVersionInfo2.getWorkingVersion());
            }
            case 4: {
                return nodeVersionInfo.getProtectVersion().compareTo(nodeVersionInfo2.getProtectVersion());
            }
            case 5: {
                return nodeVersionInfo.getStatusString().compareTo(nodeVersionInfo2.getStatusString());
            }
        }
        return 0;
    }

    static ColumnRenderer[] createTableRenderers() {
        ColumnRenderer[] columnRendererArray = new ColumnRenderer[6];
        for (int i = 0; i < columnRendererArray.length; ++i) {
            columnRendererArray[i] = SoftMaintColumnRenderer.createColumnRenderer(i);
        }
        return columnRendererArray;
    }

    public static ColumnRenderer createColumnRenderer(int n) {
        int n2;
        int n3;
        String string;
        boolean bl = true;
        switch (n) {
            case 0: {
                string = "Node";
                n3 = 140;
                n2 = 2;
                break;
            }
            case 1: {
                string = "Type";
                n3 = 70;
                n2 = 2;
                break;
            }
            case 2: {
                string = "Node Status";
                n3 = 100;
                n2 = 2;
                break;
            }
            case 3: {
                string = "Working Version";
                n3 = 160;
                n2 = 2;
                break;
            }
            case 4: {
                string = "Protect Version";
                n3 = 160;
                n2 = 2;
                break;
            }
            case 5: {
                string = "Download Status";
                n3 = 160;
                n2 = 2;
                break;
            }
            default: {
                string = "???";
                n3 = 20;
                n2 = 2;
            }
        }
        return new SoftMaintColumnRenderer(string, n3, bl, n2);
    }
}

