/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ipodwdm;

import cerent.cms.model.INodeModel;
import cerent.cms.model.ISideModel;
import cerent.cms.model.ISideModels;
import cerent.cms.topo.INetLink;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NetCSHelpConst;
import cerent.cms.ui.NodeCellRenderer;
import cerent.cms.ui.WizardDialog;
import cerent.cms.ui.WizardPane;
import cerent.cms.ui.ipodwdm.LinkCellRenderer;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.IObservable;
import cerent.util.IObserver;
import cerent.util.IPoDWDMUtility;
import cerent.util.KDebug;
import cerent.util.NEMC;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.MultiLineLabelUI;
import cerent.util.gui.UComboBox;
import cerent.util.gui.UScrollPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.LabelUI;

public class SRLGManagementWizard
extends WizardDialog
implements IObserver {
    private static String TITLE = "SRLG Management Wizard";
    private static String SRLG_INTRODUCTION = "SRLG Introduction";
    private static String SRLG_MANAGEMENT = "Manage SRLG";
    private static String[] type = new String[]{"Manage Node SRLG", "Manage Link SRLG"};
    private SRLGManagementPane manageSRLGPane;
    private IPoDWDMUtility dwdmUtil;
    private long uniqueSRLG;
    private String additionalSRLG;
    private String operation;
    private INodeModel nodeModel;
    private INetLink netLink;
    private ISideModel smod;
    private boolean initiated = false;
    private boolean uniqueSRLGDirty = false;
    private boolean additionalSRLGDirty = false;
    private JTextField uniqueSRLGBox;
    private JTextField additionalSRLGBox;
    private UComboBox entityCombo;
    private JList srlgList;
    private DefaultListModel dlm;
    private static final int wizardWidth = 520;
    private static final int wizardHeight = 60;
    private static final int vigWidth = 150;
    private static final int vigHeight = 300;
    protected static final SDebug db = new SDebug("SRLGManagementWizard");

    public SRLGManagementWizard(Frame frame) {
        super(frame, TITLE, true, true);
        this.addStatusPanel(new WizardDialog.StatusPanel("/images/CTC_dialogVignette.gif", new Dimension(150, 300)));
        this.initialize();
        this.init();
        this.setBackEnabled(false);
        this.setSize(new Dimension(670, 360));
        this.setLocationRelativeTo(frame);
        this.setVisible(true);
    }

    private void initialize() {
        try {
            this.dwdmUtil = IPoDWDMUtility.instance();
        }
        catch (Exception exception) {
            ErrorMsg.displayError((Component)this, (EID)NEMC.EID_INITIALIZATION_ERROR);
        }
    }

    private void init() {
        this.addPage(new SRLGIntroductionPane(SRLG_INTRODUCTION));
        this.manageSRLGPane = new SRLGManagementPane(SRLG_MANAGEMENT);
        this.addPage(this.manageSRLGPane);
    }

    public void update(IObservable iObservable, Object object) {
        block3: {
            try {
                if (iObservable instanceof ISideModel || iObservable instanceof INodeModel) {
                    this.updateSRLGData();
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block3;
                db.println("update(): exception" + exception);
            }
        }
    }

    private void addSideObserver(ISideModel iSideModel) {
        this.smod = iSideModel;
        if (!iSideModel.isObserver((IObserver)this)) {
            this.smod.addObserver((IObserver)this);
        }
    }

    private void deleteSideObserver(ISideModel iSideModel) {
        this.smod = iSideModel;
        if (iSideModel.isObserver((IObserver)this)) {
            this.smod.deleteObserver((IObserver)this);
        }
    }

    private synchronized void updateSRLGData() {
        if (this.initiated) {
            if (this.entityCombo.getSelectedItem() instanceof INodeModel) {
                try {
                    INodeModel iNodeModel = (INodeModel)this.entityCombo.getSelectedItem();
                    this.uniqueSRLG = iNodeModel.getUniqueNodeSRLG();
                    this.additionalSRLG = iNodeModel.getAdditionalNodeSRLG();
                    if (this.uniqueSRLGDirty) {
                        this.uniqueSRLGBox.setText(Long.toString(this.uniqueSRLG));
                    }
                    if (this.additionalSRLGDirty) {
                        this.dwdmUtil.updateAdditionalSRLGList(this.dlm, this.additionalSRLG);
                    }
                    this.nodeModel = iNodeModel;
                    this.uniqueSRLGDirty = false;
                    this.additionalSRLGDirty = false;
                    if (!this.nodeModel.isObserver((IObserver)this)) {
                        this.nodeModel.addObserver((IObserver)this);
                    }
                }
                catch (Exception exception) {
                    if (db.on()) {
                        db.println("Error while retriving the node information.");
                        KDebug.printStackTrace((Throwable)exception);
                    }
                    ErrorMsg.displayError((Component)this, (EID)NEMC.EID_UNABLE_TO_RETRIEVE_NODE_INFO);
                }
            } else {
                try {
                    INetLink iNetLink = (INetLink)this.entityCombo.getSelectedItem();
                    INodeModel iNodeModel = iNetLink.getSrc().getNodeModel();
                    int n = this.dwdmUtil.getSrcSideId(iNetLink);
                    ISideModels iSideModels = iNodeModel.getSideModels();
                    this.uniqueSRLG = iSideModels.getUniqueLinkSRLG(n);
                    this.additionalSRLG = iSideModels.getAdditionalLinkSRLG(n);
                    if (this.uniqueSRLGDirty) {
                        this.uniqueSRLGBox.setText(Long.toString(this.uniqueSRLG));
                    }
                    if (this.additionalSRLGDirty) {
                        this.dwdmUtil.updateAdditionalSRLGList(this.dlm, this.additionalSRLG);
                    }
                    this.netLink = iNetLink;
                    this.addSideObserver(iSideModels.getSideById(n));
                }
                catch (Exception exception) {
                    if (db.on()) {
                        db.println("Error while retriving the link information.");
                        KDebug.printStackTrace((Throwable)exception);
                    }
                    ErrorMsg.displayError((Component)this, (EID)NEMC.EID_UNABLE_TO_RETRIEVE_LINK_INFO);
                }
            }
        }
    }

    @Override
    protected void apply() throws Exception {
        boolean bl = false;
        if (this.operation.equals(type[0])) {
            try {
                this.nodeModel.setUniqueNodeSRLG(this.uniqueSRLG);
                this.nodeModel.setAdditionalNodeSRLG(this.additionalSRLG);
                CerentDialog.infoDialog((Component)this, (String)("SRLG value successfully set on the MSTP node\n" + this.nodeModel.getName()), (String)"SRLG Update");
                bl = true;
                this.nodeModel.deleteObserver((IObserver)this);
                if (db.on()) {
                    db.println("SRLG successfully updated on the MSTP node. Going to set on CRS.");
                }
            }
            catch (Exception exception) {
                if (db.on()) {
                    db.println("Error in updating the Node SRLG values.");
                    KDebug.printStackTrace((Throwable)exception);
                }
                if (!bl) {
                    throw new Exception(NEMC.EID_UNKNOWN_ERROR_NODE_LINK_SRLG.getMessage().replace("{0}", this.nodeModel.getName()) + "\n" + exception.getMessage());
                }
                throw new Exception(NEMC.EID_UNKNOWN_ERROR_CRS_SRLG.getMessage().replace("{0}", this.nodeModel.getName()) + "\n" + exception.getMessage());
            }
            this.dwdmUtil.updateCRS(this.nodeModel);
        } else if (this.operation.equals(type[1])) {
            try {
                INodeModel iNodeModel = this.netLink.getSrc().getNodeModel();
                int n = this.dwdmUtil.getSrcSideId(this.netLink);
                ISideModels iSideModels = iNodeModel.getSideModels();
                iSideModels.setUniqueLinkSRLG(n, this.uniqueSRLG);
                iSideModels.setAdditionalLinkSRLG(n, this.additionalSRLG);
                this.deleteSideObserver(iSideModels.getSideById(n));
                iNodeModel = this.netLink.getDst().getNodeModel();
                iSideModels = iNodeModel.getSideModels();
                n = this.dwdmUtil.getDstSideId(this.netLink);
                iSideModels.setUniqueLinkSRLG(n, this.uniqueSRLG);
                iSideModels.setAdditionalLinkSRLG(n, this.additionalSRLG);
                CerentDialog.infoDialog((Component)this, (String)("SRLG value successfully set on the Link \n" + this.dwdmUtil.constructLinkFormat(this.netLink)), (String)"SRLG Update");
                bl = true;
                this.deleteSideObserver(iSideModels.getSideById(n));
                if (db.on()) {
                    db.println("SRLG successfully updated on the Link.");
                }
            }
            catch (Exception exception) {
                if (db.on()) {
                    db.println("Error in updating the SRLG values.");
                    KDebug.printStackTrace((Throwable)exception);
                }
                if (!bl) {
                    throw new Exception(NEMC.EID_UNKNOWN_ERROR_NODE_LINK_SRLG.getMessage().replace("{0}", this.dwdmUtil.constructLinkFormat(this.netLink)) + "\n" + exception.getMessage());
                }
                throw new Exception(NEMC.EID_UNKNOWN_ERROR_CRS_SRLG.getMessage().replace("{0}", this.dwdmUtil.constructLinkFormat(this.netLink)) + "\n" + exception.getMessage());
            }
            this.dwdmUtil.updateCRS(this.netLink);
        }
    }

    @Override
    protected void handleBack(String string) {
        if (string.equals(SRLG_MANAGEMENT)) {
            this.manageSRLGPane.dispose();
        }
        super.handleBack(string);
    }

    private class SRLGIntroductionPane
    extends WizardPane {
        private boolean inited;
        private UComboBox typeCombo;
        private JPanel typePanel;
        private JPanel panel;

        public SRLGIntroductionPane(String string) {
            super(string);
            this.inited = false;
            this.typePanel = new JPanel();
            this.panel = new JPanel();
        }

        @Override
        public void enteringPage() throws Exception {
            if (!this.inited) {
                this.initPane();
                this.inited = true;
            }
        }

        protected void initPane() {
            this.panel.setSize(new Dimension(670, 230));
            this.panel.setLayout(new BorderLayout(15, 15));
            JLabel jLabel = new JLabel("Select Type: ");
            this.typeCombo = new UComboBox((Object[])type);
            String string = "\nThis wizard allows the user to define Groups (SRLGs) for MSTP \nnodes and links.Each risk is identified by an integer number. \nIf several links or nodes share the same number - they are  \nconsidered as a part of the same risk group.";
            String string2 = "\nThe wizard allows the user to perform following operations:\n 1. Update the Unique/Additional SRLG for Node/Link.\n 2. Reset the Unique/Additional SRLG for Node/Link.";
            String string3 = "\nPlease select from the following options:";
            JLabel jLabel2 = new JLabel(string);
            JLabel jLabel3 = new JLabel(string2);
            JLabel jLabel4 = new JLabel(string3);
            jLabel2.setUI((LabelUI)new MultiLineLabelUI());
            this.panel.add((Component)jLabel2, "Center");
            jLabel3.setUI((LabelUI)new MultiLineLabelUI());
            this.panel.add((Component)jLabel3, "South");
            jLabel4.setUI((LabelUI)new MultiLineLabelUI());
            this.typePanel.add(jLabel);
            this.typePanel.add((Component)this.typeCombo);
            this.add(this.panel);
            this.add(jLabel4);
            this.add(new JPanel());
            this.add(this.typePanel);
        }

        @Override
        protected String getStatusText() {
            return "Selected operation:\n" + SRLGManagementWizard.this.operation;
        }

        @Override
        public void refresh() {
        }

        @Override
        public void validatePage() throws Exception {
            SRLGManagementWizard.this.operation = this.typeCombo.getSelectedItem().toString();
            if (SRLGManagementWizard.this.operation.equals(type[0]) && SRLGManagementWizard.this.dwdmUtil.getMSTPNodes().size() == 0) {
                throw new Exception("None of the existing nodes supports SRLG.");
            }
            if (SRLGManagementWizard.this.operation.equals(type[1]) && SRLGManagementWizard.this.dwdmUtil.getLinksForSRLG().size() == 0) {
                throw new Exception("None of the existing links supports SRLG.");
            }
        }

        @Override
        public CSHelpID getHelpID() {
            return NetCSHelpConst.SRLGIntroductionPane;
        }
    }

    private class SRLGManagementPane
    extends WizardPane
    implements ItemListener,
    ActionListener {
        private UScrollPane usp;
        private JButton resetUniqueButton;
        private JButton addButton;
        private JButton deleteButton;
        private JButton resetAdditionalButton;
        private JLabel uLabel;
        private JLabel aLabel;
        private JLabel label;
        private JPanel labelPanel;
        private JPanel textFieldPanel;
        private JPanel buttonsPanel;
        private GridBagLayout bagLayout;

        public SRLGManagementPane(String string) {
            super(string);
        }

        @Override
        public void enteringPage() throws Exception {
            if (!SRLGManagementWizard.this.initiated) {
                this.initPane();
                SRLGManagementWizard.this.initiated = true;
            } else {
                this.removeAll();
                this.initPane();
            }
            SRLGManagementWizard.this.uniqueSRLGDirty = true;
            SRLGManagementWizard.this.additionalSRLGDirty = true;
            SRLGManagementWizard.this.updateSRLGData();
            SRLGManagementWizard.this.setFinishEnabled(true);
        }

        protected void initPane() {
            this.setLayout(new BorderLayout(10, 10));
            this.labelPanel = new JPanel();
            this.textFieldPanel = new JPanel();
            this.buttonsPanel = new JPanel();
            this.bagLayout = new GridBagLayout();
            SRLGManagementWizard.this.uniqueSRLGBox = new JTextField();
            SRLGManagementWizard.this.additionalSRLGBox = new JTextField();
            this.label = new JLabel();
            this.uLabel = new JLabel("Unique SRLG");
            this.aLabel = new JLabel("Additional SRLG");
            this.resetUniqueButton = new JButton("Reset To Default");
            this.resetUniqueButton.addActionListener(this);
            this.resetAdditionalButton = new JButton("Reset To Default");
            this.resetAdditionalButton.addActionListener(this);
            this.addButton = new JButton("Add");
            this.addButton.addActionListener(this);
            this.deleteButton = new JButton("Delete");
            this.deleteButton.addActionListener(this);
            this.deleteButton.setEnabled(false);
            SRLGManagementWizard.this.srlgList = new JList();
            SRLGManagementWizard.this.dlm = new DefaultListModel();
            SRLGManagementWizard.this.srlgList.setModel(SRLGManagementWizard.this.dlm);
            SRLGManagementWizard.this.srlgList.setSelectionMode(0);
            SRLGManagementWizard.this.srlgList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (SRLGManagementWizard.this.dlm.size() != 0) {
                        SRLGManagementPane.this.deleteButton.setEnabled(true);
                    } else {
                        SRLGManagementPane.this.deleteButton.setEnabled(false);
                    }
                }
            });
            this.usp = new UScrollPane((Component)SRLGManagementWizard.this.srlgList);
            if (SRLGManagementWizard.this.operation.equals(type[0])) {
                this.label.setText("Node");
                SRLGManagementWizard.this.entityCombo = new UComboBox(new DefaultComboBoxModel<Object>(SRLGManagementWizard.this.dwdmUtil.getMSTPNodes().toArray()));
                SRLGManagementWizard.this.entityCombo.setRenderer((ListCellRenderer)new NodeCellRenderer());
            } else if (SRLGManagementWizard.this.operation.equals(type[1])) {
                this.label.setText("Link");
                SRLGManagementWizard.this.entityCombo = new UComboBox(new DefaultComboBoxModel<Object>(SRLGManagementWizard.this.dwdmUtil.getLinksForSRLG().toArray()));
                SRLGManagementWizard.this.entityCombo.setRenderer((ListCellRenderer)new LinkCellRenderer());
            }
            SRLGManagementWizard.this.entityCombo.addItemListener((ItemListener)this);
            this.labelPanel.setLayout(new GridLayout(5, 0));
            this.labelPanel.add(this.label);
            this.labelPanel.add(this.uLabel);
            this.labelPanel.add(this.aLabel);
            this.textFieldPanel.setLayout(this.bagLayout);
            SRLGManagementWizard.this.dwdmUtil.addCompConstraint(this.bagLayout, this.textFieldPanel, (Component)SRLGManagementWizard.this.entityCombo, 0, 0, 1, 1, 1, 1, 0, 5, 3, 0, 2);
            SRLGManagementWizard.this.dwdmUtil.addCompConstraint(this.bagLayout, this.textFieldPanel, SRLGManagementWizard.this.uniqueSRLGBox, 0, 1, 1, 1, 1, 1, 0, 12, 5, 0, 2);
            SRLGManagementWizard.this.dwdmUtil.addCompConstraint(this.bagLayout, this.textFieldPanel, SRLGManagementWizard.this.additionalSRLGBox, 0, 2, 1, 1, 1, 1, 0, 12, 5, 0, 2);
            SRLGManagementWizard.this.dwdmUtil.addCompConstraint(this.bagLayout, this.textFieldPanel, (Component)this.usp, 0, 3, 1, 3, 1, 1, 0, 70, 5, 0, 1);
            this.buttonsPanel.setLayout(this.bagLayout);
            SRLGManagementWizard.this.dwdmUtil.addCompConstraint(this.bagLayout, this.buttonsPanel, this.resetUniqueButton, 0, 1, 1, 1, 1, 1, 0, 0, 0, 43, 2);
            SRLGManagementWizard.this.dwdmUtil.addCompConstraint(this.bagLayout, this.buttonsPanel, this.addButton, 0, 2, 1, 1, 1, 1, 0, 0, 0, 0, 2);
            SRLGManagementWizard.this.dwdmUtil.addCompConstraint(this.bagLayout, this.buttonsPanel, this.deleteButton, 0, 3, 1, 1, 1, 1, 0, 0, 0, 0, 2);
            SRLGManagementWizard.this.dwdmUtil.addCompConstraint(this.bagLayout, this.buttonsPanel, this.resetAdditionalButton, 0, 4, 1, 1, 1, 1, 0, 0, 0, 0, 2);
            this.add(this.labelPanel, "West");
            this.add(this.textFieldPanel, "Center");
            this.add(this.buttonsPanel, "East");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource().equals(this.resetUniqueButton)) {
                if (SRLGManagementWizard.this.entityCombo.getSelectedItem() instanceof INodeModel) {
                    INodeModel iNodeModel = (INodeModel)SRLGManagementWizard.this.entityCombo.getSelectedItem();
                    if (ErrorMsg.displayWarningYesNo((Component)((Object)this), (EID)NEMC.WID_RESET_UNIQUE_SRLG, "Reset SRLG", iNodeModel.getName() + "?")) {
                        try {
                            SRLGManagementWizard.this.uniqueSRLGDirty = true;
                            SRLGManagementWizard.this.additionalSRLGDirty = false;
                            iNodeModel.setDefaultUniqueNodeSRLG();
                            CerentDialog.infoDialog((Component)((Object)this), (String)("SRLG value successfully set on the MSTP node " + iNodeModel.getName()), (String)"SRLG Update");
                            SRLGManagementWizard.this.dwdmUtil.updateCRS(iNodeModel);
                        }
                        catch (Exception exception) {
                            if (db.on()) {
                                db.println("SRLG cannot be set.");
                                KDebug.printStackTrace((Throwable)exception);
                            }
                            ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_UNABLE_TO_SET_SRLG, (Object)iNodeModel.getName());
                        }
                    }
                } else {
                    INetLink iNetLink = (INetLink)SRLGManagementWizard.this.entityCombo.getSelectedItem();
                    String string = SRLGManagementWizard.this.dwdmUtil.constructLinkFormat(iNetLink);
                    INodeModel iNodeModel = iNetLink.getSrc().getNodeModel();
                    int n = SRLGManagementWizard.this.dwdmUtil.getSrcSideId(iNetLink);
                    if (ErrorMsg.displayWarningYesNo((Component)((Object)this), (EID)NEMC.WID_RESET_UNIQUE_SRLG, "Reset SRLG", string)) {
                        try {
                            SRLGManagementWizard.this.uniqueSRLGDirty = true;
                            SRLGManagementWizard.this.additionalSRLGDirty = false;
                            iNodeModel.getSideModels().setDefaultUniqueLinkSRLG(n);
                            iNodeModel = iNetLink.getDst().getNodeModel();
                            n = SRLGManagementWizard.this.dwdmUtil.getDstSideId(iNetLink);
                            SRLGManagementWizard.this.uniqueSRLGDirty = true;
                            SRLGManagementWizard.this.additionalSRLGDirty = false;
                            iNodeModel.getSideModels().setDefaultUniqueLinkSRLG(n);
                            SRLGManagementWizard.this.uniqueSRLGBox.setText(Long.toString(iNodeModel.getSideModels().getUniqueLinkSRLG(n)));
                            CerentDialog.infoDialog((Component)((Object)this), (String)("SRLG value successfully set on the Link \n" + SRLGManagementWizard.this.dwdmUtil.constructLinkFormat(SRLGManagementWizard.this.netLink)), (String)"SRLG Update");
                            SRLGManagementWizard.this.dwdmUtil.updateCRS(iNetLink);
                        }
                        catch (Exception exception) {
                            if (db.on()) {
                                db.println("SRLG cannot be set.");
                                KDebug.printStackTrace((Throwable)exception);
                            }
                            ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_UNABLE_TO_SET_SRLG, (Object)string);
                        }
                    }
                }
            } else if (actionEvent.getSource().equals(this.addButton)) {
                String string = SRLGManagementWizard.this.uniqueSRLGBox.getText();
                String string2 = SRLGManagementWizard.this.additionalSRLGBox.getText();
                if (SRLGManagementWizard.this.dwdmUtil.isSRLGValid(string2)) {
                    if (SRLGManagementWizard.this.dwdmUtil.isSRLGInRange(string2)) {
                        if (SRLGManagementWizard.this.dwdmUtil.isSRLGUnique(new String[]{string, string2}, SRLGManagementWizard.this.dlm)) {
                            if (SRLGManagementWizard.this.dwdmUtil.isSRLGCountOk(SRLGManagementWizard.this.dlm)) {
                                SRLGManagementWizard.this.dwdmUtil.addElement(SRLGManagementWizard.this.dlm, string2);
                                SRLGManagementWizard.this.additionalSRLGBox.setText("");
                            } else {
                                SRLGManagementWizard.this.dwdmUtil;
                                ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_MAX_ADDITIONAL_SRLG_LIMIT_REACHED, (Object)20);
                            }
                        } else {
                            ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_DUPLICATE_SRLG);
                        }
                    } else {
                        SRLGManagementWizard.this.dwdmUtil;
                        Long l = 0L;
                        SRLGManagementWizard.this.dwdmUtil;
                        ErrorMsg.displayError((Component)((Object)this), NEMC.EID_SRLG_OUT_OF_RANGE, l, Long.toString(0xFFFFFFFEL));
                    }
                } else {
                    ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_INVALID_SRLG);
                }
            } else if (actionEvent.getSource().equals(this.deleteButton)) {
                if (SRLGManagementWizard.this.srlgList.getSelectedIndex() != -1) {
                    SRLGManagementWizard.this.dlm.remove(SRLGManagementWizard.this.srlgList.getSelectedIndex());
                }
                if (SRLGManagementWizard.this.dlm.size() == 0) {
                    this.deleteButton.setEnabled(false);
                }
            } else if (actionEvent.getSource().equals(this.resetAdditionalButton)) {
                if (SRLGManagementWizard.this.entityCombo.getSelectedItem() instanceof INodeModel) {
                    INodeModel iNodeModel = (INodeModel)SRLGManagementWizard.this.entityCombo.getSelectedItem();
                    if (ErrorMsg.displayWarningYesNo((Component)((Object)this), (EID)NEMC.WID_RESET_ADDITIONAL_SRLG, "Reset SRLG", iNodeModel.getName() + "?")) {
                        try {
                            SRLGManagementWizard.this.additionalSRLGDirty = true;
                            SRLGManagementWizard.this.uniqueSRLGDirty = false;
                            iNodeModel.setDefaultAdditionalNodeSRLG();
                            SRLGManagementWizard.this.dwdmUtil.updateAdditionalSRLGList(SRLGManagementWizard.this.dlm, iNodeModel.getAdditionalNodeSRLG());
                            CerentDialog.infoDialog((Component)((Object)this), (String)("SRLG value successfully set on the MSTP node " + iNodeModel.getName()), (String)"SRLG Update");
                            SRLGManagementWizard.this.dwdmUtil;
                            SRLGManagementWizard.this.additionalSRLG = "";
                            SRLGManagementWizard.this.dwdmUtil.updateCRS(iNodeModel);
                        }
                        catch (Exception exception) {
                            if (db.on()) {
                                db.println("SRLG cannot be set.");
                                KDebug.printStackTrace((Throwable)exception);
                            }
                            ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_UNABLE_TO_SET_SRLG, (Object)iNodeModel.getName());
                        }
                    }
                } else {
                    INetLink iNetLink = (INetLink)SRLGManagementWizard.this.entityCombo.getSelectedItem();
                    String string = SRLGManagementWizard.this.dwdmUtil.constructLinkFormat(iNetLink);
                    INodeModel iNodeModel = iNetLink.getSrc().getNodeModel();
                    int n = SRLGManagementWizard.this.dwdmUtil.getSrcSideId(iNetLink);
                    if (ErrorMsg.displayWarningYesNo((Component)((Object)this), (EID)NEMC.WID_RESET_ADDITIONAL_SRLG, "Reset SRLG", string)) {
                        try {
                            SRLGManagementWizard.this.additionalSRLGDirty = true;
                            SRLGManagementWizard.this.uniqueSRLGDirty = false;
                            iNodeModel.getSideModels().setDefaultAdditionalLinkSRLG(n);
                            iNodeModel = iNetLink.getDst().getNodeModel();
                            n = SRLGManagementWizard.this.dwdmUtil.getDstSideId(iNetLink);
                            SRLGManagementWizard.this.additionalSRLGDirty = true;
                            SRLGManagementWizard.this.uniqueSRLGDirty = false;
                            iNodeModel.getSideModels().setDefaultAdditionalLinkSRLG(n);
                            SRLGManagementWizard.this.dwdmUtil.updateAdditionalSRLGList(SRLGManagementWizard.this.dlm, iNodeModel.getSideModels().getAdditionalLinkSRLG(n));
                            CerentDialog.infoDialog((Component)((Object)this), (String)("SRLG value successfully set on the Link \n" + SRLGManagementWizard.this.dwdmUtil.constructLinkFormat(iNetLink)), (String)"SRLG Update");
                            SRLGManagementWizard.this.dwdmUtil;
                            SRLGManagementWizard.this.additionalSRLG = "";
                            SRLGManagementWizard.this.dwdmUtil.updateCRS(iNetLink);
                        }
                        catch (Exception exception) {
                            if (db.on()) {
                                db.println("SRLG cannot be set.");
                                KDebug.printStackTrace((Throwable)exception);
                            }
                            ErrorMsg.displayError((Component)((Object)this), (EID)NEMC.EID_UNABLE_TO_SET_SRLG, (Object)string);
                        }
                    }
                }
            }
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                SRLGManagementWizard.this.uniqueSRLGDirty = true;
                SRLGManagementWizard.this.additionalSRLGDirty = true;
                SRLGManagementWizard.this.updateSRLGData();
            }
        }

        @Override
        public void refresh() {
        }

        @Override
        public void validatePage() throws Exception {
            try {
                Object object = SRLGManagementWizard.this.entityCombo.getSelectedItem();
                String string = SRLGManagementWizard.this.uniqueSRLGBox.getText().trim();
                if (!SRLGManagementWizard.this.dwdmUtil.isSRLGValid(string)) {
                    throw new Exception(NEMC.EID_INVALID_SRLG.getMessage());
                }
                if (!SRLGManagementWizard.this.dwdmUtil.isSRLGInRange(string)) {
                    String string2 = NEMC.EID_SRLG_OUT_OF_RANGE.getMessage();
                    SRLGManagementWizard.this.dwdmUtil;
                    String string3 = string2.replace("{0}", Long.toString(0L));
                    SRLGManagementWizard.this.dwdmUtil;
                    throw new Exception(string3.replace("{1}", Long.toString(0xFFFFFFFEL)));
                }
                if (!SRLGManagementWizard.this.dwdmUtil.isSRLGUnique(new String[]{string}, SRLGManagementWizard.this.dlm)) {
                    throw new Exception(NEMC.EID_DUPLICATE_SRLG.getMessage());
                }
                SRLGManagementWizard.this.uniqueSRLG = Long.parseLong(SRLGManagementWizard.this.uniqueSRLGBox.getText().trim());
                SRLGManagementWizard.this.additionalSRLG = SRLGManagementWizard.this.dwdmUtil.getAdditionalSRLGString(SRLGManagementWizard.this.dlm);
            }
            catch (Exception exception) {
                if (db.on()) {
                    db.println(exception.getMessage());
                    KDebug.printStackTrace((Throwable)exception);
                }
                throw new Exception(exception.getMessage());
            }
        }

        @Override
        public CSHelpID getHelpID() {
            return NetCSHelpConst.SRLGManagementPane;
        }
    }
}

