/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ipodwdm;

import cerent.cms.model.INodeModel;
import cerent.cms.ncp.NetCircuit;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.ncp.NetCircuitNode;
import cerent.cms.ui.UiToolkit;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.IPoDWDMUtility;
import cerent.util.KDebug;
import cerent.util.NEMC;
import cerent.util.SDebug;
import cerent.util.WID;
import cerent.util.gui.UScrollPane;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class SynchronizeIPoDWDM
extends JFrame
implements ActionListener {
    private static String TITLE_PREFIX = "Synchronize IPoDWDM";
    private IPoDWDMUtility dwdmUtil;
    private static String DOTTED_STRING = "........";
    private INodeModel nodeModel;
    private JButton okButton;
    private JTextArea progressArea;
    private JPanel buttonsPanel;
    protected static final SDebug db = new SDebug("SynchronizeIPoDWDM");

    public SynchronizeIPoDWDM(INodeModel iNodeModel) {
        super(TITLE_PREFIX);
        super.setSize(new Dimension(400, 300));
        this.setLocationRelativeTo(UiToolkit.instance().getApplicationFrame());
        this.setVisible(false);
        this.nodeModel = iNodeModel;
        this.initContentPane();
        this.init();
    }

    protected void initContentPane() {
        this.progressArea = new JTextArea("\n");
        this.buttonsPanel = new JPanel();
        this.progressArea.setEditable(false);
        this.progressArea.setLineWrap(true);
        this.progressArea.setTabSize(5);
        this.okButton = new JButton("OK");
        this.okButton.setPreferredSize(new Dimension(70, 30));
        this.okButton.addActionListener(this);
        this.okButton.setEnabled(false);
        this.buttonsPanel.add((Component)this.okButton, "Center");
        this.add((Component)new UScrollPane((Component)this.progressArea), "Center");
        this.add((Component)this.buttonsPanel, "South");
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.okButton)) {
            super.dispose();
        }
    }

    private void init() {
        try {
            this.dwdmUtil = IPoDWDMUtility.instance();
            List list = NetCircuitManager.instance().getCircuits(this.nodeModel);
            if (list.size() == 0) {
                ErrorMsg.displayWarning((Component)this, (WID)NEMC.WID_NO_CIRCUITS_TO_SYNCHRONIZE);
                super.dispose();
                return;
            }
            this.setVisible(true);
            try {
                boolean bl = this.synchronizeSRLG(list);
                if (!bl) {
                    ErrorMsg.displayWarning((Component)this, (WID)NEMC.WID_UNABLE_TO_SYNCHRONIZE_SRLG);
                }
            }
            catch (Exception exception) {
                ErrorMsg.displayError((Component)this, (EID)NEMC.EID_UNABLE_TO_SYNCHRONIZE_SRLG);
            }
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("Error while initiating some instances.");
                KDebug.printStackTrace((Throwable)exception);
            }
            ErrorMsg.displayError((Component)this, (EID)NEMC.EID_INITIALIZATION_ERROR);
        }
        this.okButton.setEnabled(true);
    }

    private boolean synchronizeSRLG(List list) {
        Iterator iterator = list.iterator();
        NetCircuit netCircuit = null;
        INodeModel iNodeModel = null;
        INodeModel iNodeModel2 = null;
        boolean bl = true;
        this.progressArea.append("Synchronizing SRLG:\n");
        while (iterator.hasNext()) {
            try {
                netCircuit = (NetCircuit)iterator.next();
                List list2 = this.dwdmUtil.getConsolidatedSRLG(netCircuit, 100);
                if (list2.size() == 0) continue;
                iNodeModel = this.dwdmUtil.getSourceCRS(netCircuit);
                iNodeModel2 = this.dwdmUtil.getDestCRS(netCircuit);
                this.progressArea.append("\nSynchronizing circuit: " + netCircuit.getCircuitName() + DOTTED_STRING);
                int n = this.dwdmUtil.getSourceIndex(netCircuit);
                if (!this.dwdmUtil.deleteSRLG(iNodeModel, netCircuit, n)) {
                    this.progressArea.append(" failed\n");
                    this.progressArea.append("\nUnable to delete the SRLG for the CRS node: " + iNodeModel.getName() + "\nSkipping circuit: " + netCircuit.getCircuitName());
                    bl = false;
                    continue;
                }
                if (!this.dwdmUtil.setSRLG(iNodeModel, netCircuit, list2, n)) {
                    this.progressArea.append(" failed\n");
                    this.progressArea.append("\nUnable to set the SRLG for the CRS node: " + iNodeModel.getName() + "\nSkipping circuit: " + netCircuit.getCircuitName());
                    bl = false;
                    continue;
                }
                n = this.dwdmUtil.getDestIndex(netCircuit);
                if (!this.dwdmUtil.deleteSRLG(iNodeModel2, netCircuit, n)) {
                    this.progressArea.append(" failed\n");
                    this.progressArea.append("\nUnable to delete the SRLG for the CRS node: " + iNodeModel2.getName() + "\nSkipping circuit " + netCircuit.getCircuitName());
                    continue;
                }
                if (!this.dwdmUtil.setSRLG(iNodeModel2, netCircuit, list2, n)) {
                    this.progressArea.append(" failed\n");
                    this.progressArea.append("Unable to set the SRLG for the CRS node: " + iNodeModel2.getName() + "\nSkipping circuit " + netCircuit.getCircuitName());
                    bl = false;
                    continue;
                }
                this.progressArea.append(" succeeded\n");
            }
            catch (Exception exception) {
                if (db.on()) {
                    db.println("Error while synchronizing the circuit: " + netCircuit.getCircuitName());
                    KDebug.printStackTrace((Throwable)exception);
                }
                bl = false;
            }
        }
        return bl;
    }

    private boolean synchronizeCoMT(List list) {
        Iterator iterator = list.iterator();
        NetCircuit netCircuit = null;
        INodeModel iNodeModel = null;
        INodeModel iNodeModel2 = null;
        INodeModel iNodeModel3 = null;
        List list2 = null;
        boolean bl = true;
        this.progressArea.append("\n\nSynchronizing CoM:\n");
        block4: while (iterator.hasNext()) {
            try {
                netCircuit = (NetCircuit)iterator.next();
                list2 = this.dwdmUtil.filterDuplicateNodes(netCircuit.getCircuitNodes());
                for (int i = 0; i < list2.size(); ++i) {
                    try {
                        NetCircuitNode netCircuitNode = (NetCircuitNode)list2.get(i);
                        iNodeModel3 = netCircuitNode.getNodeModel();
                        if (!this.dwdmUtil.doesSupportSRLGAndCoMFeature(iNodeModel3) || iNodeModel3.getCoordMaintList() == null) continue;
                        iNodeModel = this.dwdmUtil.getSourceCRS(netCircuit);
                        iNodeModel2 = this.dwdmUtil.getDestCRS(netCircuit);
                        this.progressArea.append("\nSynchronizing circuit: " + netCircuit.getCircuitName() + DOTTED_STRING);
                        int n = this.dwdmUtil.getSourceIndex(netCircuit);
                        if (!this.dwdmUtil.setTransportAdminState(iNodeModel, netCircuit, n, "maintenance")) {
                            this.progressArea.append(" failed\n");
                            this.progressArea.append("\nUnable to set the TAS on the CRS node: " + iNodeModel.getName() + "\nSkipping circuit: " + netCircuit.getCircuitName());
                            bl = false;
                            continue block4;
                        }
                        n = this.dwdmUtil.getDestIndex(netCircuit);
                        if (!this.dwdmUtil.setTransportAdminState(iNodeModel2, netCircuit, n, "maintenance")) {
                            this.progressArea.append(" failed\n");
                            this.progressArea.append("\nUnable to set the TAS on the CRS node: " + iNodeModel.getName() + "\nSkipping circuit: " + netCircuit.getCircuitName());
                            bl = false;
                            continue block4;
                        }
                        this.progressArea.append(" succeeded\n");
                        continue block4;
                    }
                    catch (Exception exception) {
                        if (!db.on()) continue;
                        db.println("Error while synchronizing the circuit: " + netCircuit.getCircuitName());
                        KDebug.printStackTrace((Throwable)exception);
                    }
                }
            }
            catch (Exception exception) {
                if (!db.on()) continue;
                db.println("Error while retrieving the circuit.");
                KDebug.printStackTrace((Throwable)exception);
            }
        }
        return bl;
    }
}

