/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.network;

import cerent.cms.ui.network.IVitalStatsPaneObject;
import cerent.cms.ui.network.LinkClassIconUtil;
import cerent.cms.ui.network.NetMapLink;
import cerent.util.SDebug;
import com.cisco.ctc.util.map.MapDwdmGraph;
import com.cisco.ctc.util.map.MapLink;
import com.cisco.ctc.util.map.MapLinkBundle;
import com.cisco.ctc.util.map.MapToolkit;
import com.cisco.ctc.util.map.Node;
import java.awt.Image;

public class NetLinkBundle
extends MapLinkBundle
implements IVitalStatsPaneObject {
    private static final SDebug db = new SDebug("NetLinkBundle");
    private MapDwdmGraph sideLabel;

    public NetLinkBundle(MapToolkit mapToolkit, Node node, Node node2, String string, int n) {
        super(mapToolkit, node, node2, string, n);
    }

    @Override
    protected void refreshUI() {
        this.sideLabel = null;
        super.refreshUI();
        int n = NetMapLink.getLinkAggregatedState(this.getLinks());
        this.setLineColor(NetMapLink.stateToColor(n));
    }

    @Override
    public String getToolTipText() {
        MapLink[] mapLinkArray = this.getLinks();
        return "Collapsed link: " + mapLinkArray.length + " link" + (mapLinkArray.length > 1 ? "s" : "") + " (" + this.getLinkClass() + ")";
    }

    @Override
    public String getVitalStatsString() {
        StringBuffer stringBuffer = new StringBuffer();
        MapLink[] mapLinkArray = this.getLinks();
        stringBuffer.append("Collapsed link: " + mapLinkArray.length + " link" + (mapLinkArray.length > 1 ? "s\n" : "\n"));
        for (int i = 0; i < mapLinkArray.length; ++i) {
            if (!(mapLinkArray[i] instanceof NetMapLink)) continue;
            stringBuffer.append(((NetMapLink)mapLinkArray[i]).getVitalStatsString());
        }
        return stringBuffer.toString();
    }

    @Override
    protected Image getLinkIcon(String string) {
        return LinkClassIconUtil.getLinkIcon(string);
    }

    @Override
    protected void placeDwdmSide(int n) {
        if (this.getLinkClass().equals("OTS") || this.getLinkClass().equals("PPC")) {
            if (this.sideLabel == null) {
                this.sideLabel = new MapDwdmGraph(this, n);
            } else {
                this.sideLabel.initBundleLink(this, n);
            }
        }
    }
}

