/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.network.raman;

import cerent.cms.model.IEntityModel;
import cerent.cms.model.INodeModel;
import cerent.cms.topo.INetLink;
import cerent.cms.ui.WzDiagDebug;
import cerent.cms.ui.network.MapLinkRenderer;
import cerent.cms.ui.network.raman.RamanAttribute;
import cerent.cms.ui.network.raman.RamanDayZeroDialog;
import cerent.cms.ui.network.raman.RamanDayZeroInfo;
import cerent.cms.ui.network.raman.RamanPathPane;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.NEMC;
import cerent.util.Preferences;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JComponent;

public class RamanDayZeroEndRoutePane
extends RamanPathPane {
    private String nextPage = "Setting Parameters Forward Path";
    private static final String PREF = "ctc.RamanDayZeroEndRoutePane";
    private static final String DIV_LOC = "dl";

    public RamanDayZeroEndRoutePane(RamanDayZeroDialog ramanDayZeroDialog, WzDiagDebug wzDiagDebug, String string, String string2, RamanDayZeroInfo ramanDayZeroInfo) {
        super(ramanDayZeroDialog, wzDiagDebug, string);
        this.info = ramanDayZeroInfo;
    }

    @Override
    public void validatePage() throws Exception {
        if (this.nodesModelOrg.getSize() == 0) {
            ErrorMsg.displayError((Component)this, (EID)NEMC.EID_NO_PATH_SELECTED, (Object)this.info.getStartNode().getNode().getName());
            this.nextPage = null;
        } else {
            this.setStartNode(this.nodesModelOrg.getFirstIncluded());
            this.nextPage = this.info.setMiddleNodes(this.nodesModelOrg.getIncludedLinks());
        }
    }

    private void setStartNode(INetLink iNetLink) {
        if (iNetLink == null) {
            return;
        }
        INodeModel iNodeModel = iNetLink.getSrc().getNodeModel();
        IEntityModel iEntityModel = MapLinkRenderer.getEntity(iNodeModel, iNetLink.getSrcEntityIndex());
        RamanAttribute ramanAttribute = new RamanAttribute(iNodeModel, iEntityModel.getParent());
        this.info.setStartNode(ramanAttribute);
    }

    private void setEndNode(INetLink iNetLink) {
        if (iNetLink == null) {
            return;
        }
        INodeModel iNodeModel = iNetLink.getDst().getNodeModel();
        IEntityModel iEntityModel = MapLinkRenderer.getEntity(iNodeModel, iNetLink.getDstEntityIndex());
        RamanAttribute ramanAttribute = new RamanAttribute(iNodeModel, iEntityModel.getParent());
        this.info.setEndNode(ramanAttribute);
    }

    @Override
    protected String getNextPaneName() {
        return this.nextPage;
    }

    @Override
    protected void initPane() {
        this.info.setStartNode(((RamanDayZeroDialog)this.parent).getNodeList()[0]);
        this.setupPanels();
    }

    @Override
    public void enteringPane() {
        super.enteringPane();
        ((RamanDayZeroDialog)this.parent).nextButtonEnable(!this.goingForward);
        Preferences preferences = Preferences.instance();
        int n = preferences.getInt(PREF, DIV_LOC, 220);
        this.mainSplitPane.setDividerLocation(n);
        this.mainSplitPane.setResizeWeight(0.5);
    }

    @Override
    public JComponent getStatusComponent() {
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        ArrayList<RamanAttribute> arrayList2 = this.info.getAllMiddleNodes();
        arrayList.add(new String[]{"Start Node: ", this.info.getStartNode().getNode().getName()});
        if (arrayList2.size() == 0) {
            arrayList.add(new String[]{"End Node: ", this.info.getEndNode().getNode().getName()});
        } else {
            for (int i = 0; i < arrayList2.size() - 1; ++i) {
                arrayList.add(new String[]{"-> ", arrayList2.get(i).getNode().getName()});
            }
            arrayList.add(new String[]{"End Node: ", arrayList2.get(arrayList2.size() - 1).getNode().getName()});
        }
        return RamanDayZeroEndRoutePane.getGridPanel(arrayList);
    }
}

