/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.network.rpr;

import cerent.cms.model.IRprConstants;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.network.rpr.RprMap;
import cerent.cms.ui.network.rpr.RprTabbedView;
import cerent.util.gui.GridBagPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JLabel;

class RprStatePane
extends AbstractPane
implements IRprConstants {
    private RprMap rprMap;
    private String empty = "     ";
    private JLabel stabilityLB = new JLabel("Ring Stability:  ");
    private JLabel stabilityResult = new JLabel(this.empty);
    private JLabel wrapLB = new JLabel("Protection Mode:  ");
    private JLabel wrapResult = new JLabel(this.empty);
    private JLabel jumboLB = new JLabel("Ring Jumbo Preference:  ");
    private JLabel jumboResult = new JLabel(this.empty);

    public RprStatePane(TabbedView tabbedView) {
        super("RprStatePane", null, tabbedView);
        this.rprMap = ((RprTabbedView)tabbedView).rprMap;
        GridBagPanel gridBagPanel = new GridBagPanel();
        gridBagPanel.anchor(17);
        gridBagPanel.inset(5, 10);
        gridBagPanel.add((Component)this.stabilityLB, 1, 1);
        gridBagPanel.add((Component)this.stabilityResult, 2, 1);
        gridBagPanel.add((Component)this.wrapLB, 1, 2);
        gridBagPanel.add((Component)this.wrapResult, 2, 2);
        gridBagPanel.add((Component)this.jumboLB, 1, 3);
        gridBagPanel.add((Component)this.jumboResult, 2, 3);
        this.setLayout(new BorderLayout());
        this.add(gridBagPanel, "Center");
    }

    @Override
    public void destroy() {
    }

    @Override
    public void enteringPage() {
        this.reload();
    }

    protected void reload() {
        if (this.rprMap.selectedStation != null) {
            String string = this.rprMap.selectedStation.getStability() + " , ";
            string = this.rprMap.selectedStation.isRingClosed() ? string + "Close" : string + "Open";
            this.stabilityResult.setText(string);
            this.wrapResult.setText(this.rprMap.selectedStation.getWrapPreference());
            this.jumboResult.setText(this.rprMap.selectedStation.getRingJumbo());
        } else {
            this.stabilityResult.setText(this.empty);
            this.wrapResult.setText(this.empty);
            this.jumboResult.setText(this.empty);
        }
    }

    @Override
    public void leavingPage() throws Exception {
    }

    @Override
    public void refresh() {
    }
}

