/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ohcircuits;

import cerent.cms.model.INodeModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.ocm.OhCircuit;
import cerent.cms.ocm.OhCircuitManager;
import cerent.cms.topo.INetElement;
import cerent.cms.ui.CSHelpButton;
import cerent.cms.ui.LeavePageException;
import cerent.cms.ui.TablePrintRegionDialog;
import cerent.cms.ui.UiToolkit;
import cerent.cms.ui.ohcircuits.OhCircuitEditTabbedView;
import cerent.cms.ui.ohcircuits.OhCircuitMap;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.NEMC;
import cerent.util.Preferences;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.ComponentPrinter;
import cerent.util.gui.TablePrintPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.print.Printable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class OhCircuitEditDialog
extends TablePrintPane
implements ActionListener,
Observer {
    private static final String APPLICATION_ICON = "/images/icons/CTC_icon.gif";
    private static HashMap allCircuitFrames = new HashMap();
    private static final SDebug db = new SDebug("OhCircuitEditDialog");
    private static final String PREF = "ctc.OhCircuitEditDialog";
    private static final String XPOS = "x";
    private static final String YPOS = "y";
    private static final String WIDTH = "w";
    private static final String HEIGHT = "h";
    private static final Dimension INIT_DIM = new Dimension(800, 600);
    private static final String SPLIT_LOC = "split";
    private static final int INIT_SPLIT_LOC = 300;
    private static OhCircuitEditDialog editDialog;
    private OhCircuit circuit;
    private OhCircuitMap circuitMap;
    private static final String CLOSE = "Close";
    public static final String TITLE = "Edit Overhead Circuit";
    public static final String CHANGE_IP = "IP Tunnel";
    public static final String CHANGE_TRADITIONAL = "Traditional tunnel";
    private static final UiToolkit uiToolkit;
    private JButton mergeButton;
    private JComboBox changeCB;
    private JTextField nameTF;
    private JComboBox pcmCB;
    private boolean nameChanged;
    private boolean pcmChanged;
    private static JPanel mainPanel;
    private static JSplitPane mainSplitPane;
    private boolean disposed = false;
    private boolean deleted = false;
    private OhCircuitEditTabbedView circuitEditTabs;
    private int oldCircuitState = -1;
    private CSHelpButton helpButton;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OhCircuitEditDialog getInstance(OhCircuit ohCircuit) {
        OhCircuitEditDialog ohCircuitEditDialog;
        HashMap hashMap = allCircuitFrames;
        synchronized (hashMap) {
            ohCircuitEditDialog = (OhCircuitEditDialog)allCircuitFrames.get(ohCircuit);
            if (ohCircuitEditDialog != null) {
                return ohCircuitEditDialog;
            }
            ohCircuitEditDialog = new OhCircuitEditDialog(ohCircuit);
            allCircuitFrames.put(ohCircuit, ohCircuitEditDialog);
        }
        try {
            Preferences preferences = Preferences.instance();
            int n = preferences.getInt(PREF, XPOS, -1);
            int n2 = preferences.getInt(PREF, YPOS, 0);
            int n3 = preferences.getInt(PREF, WIDTH, OhCircuitEditDialog.INIT_DIM.width);
            int n4 = preferences.getInt(PREF, HEIGHT, OhCircuitEditDialog.INIT_DIM.height);
            if (n == -1) {
                ohCircuitEditDialog.setSize(new Dimension(n3, n4));
            } else {
                ohCircuitEditDialog.setBounds(n, n2, n3, n4);
            }
        }
        catch (Exception exception) {
            ohCircuitEditDialog.setSize(INIT_DIM);
        }
        ohCircuitEditDialog.setDialogTitle();
        ohCircuitEditDialog.updateSplitPane();
        return ohCircuitEditDialog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeCircuitWindow(OhCircuit ohCircuit) {
        if (ohCircuit != null) {
            HashMap hashMap = allCircuitFrames;
            synchronized (hashMap) {
                OhCircuitEditDialog ohCircuitEditDialog = (OhCircuitEditDialog)allCircuitFrames.get(ohCircuit);
                if (ohCircuitEditDialog != null) {
                    ohCircuitEditDialog.dispose();
                }
            }
        }
    }

    private OhCircuitEditDialog(OhCircuit ohCircuit) {
        super(null, "Overhead Circuit Edit Dialog");
        this.setTable(null);
        this.setDefaultCloseOperation(0);
        this.setCircuit(ohCircuit);
        this.setSize(new Dimension(600, 600));
    }

    private void setCircuit(OhCircuit ohCircuit) {
        this.circuit = ohCircuit;
        this.initContentPane();
        this.setTitle("Edit Overhead Circuit: " + ohCircuit.getCircuitName());
    }

    protected void initContentPane() {
        Container container = this.getContentPane();
        mainPanel = new JPanel(new BorderLayout());
        this.initSubTabs();
        mainPanel.add((Component)this.getButtonPanel(), "South");
        if (this.circuitMap == null) {
            this.circuitMap = new OhCircuitMap(this.circuit);
            this.circuitMap.getGraphWindow().setBorder(BorderFactory.createLoweredBevelBorder());
        } else if (!this.circuit.equals(this.circuitMap.getOhCircuit())) {
            this.circuitMap.setOhCircuit(this.circuit);
        }
        container.add(this.circuitMap.getGraphWindow());
        this.circuitMap.showCircuitObjects();
        this.circuitMap.setViewToCenter();
        mainSplitPane = new JSplitPane(0);
        mainSplitPane.setDividerSize(2);
        mainSplitPane.setTopComponent(this.circuitMap.getGraphWindow());
        mainSplitPane.setBottomComponent(mainPanel);
        container.add((Component)mainSplitPane, "Center");
        this.pack();
        this.circuit.addObserver(this);
    }

    private void initSubTabs() {
        int n = this.circuit.getState();
        if (n == this.oldCircuitState || n == 4) {
            if (db.on()) {
                db.println("Asked to init subtabs, but will not since state  of circuit is still " + n);
            }
            return;
        }
        this.oldCircuitState = n;
        if (db.on()) {
            db.println("initSubTabs... state is " + n);
        }
        if (this.circuitEditTabs != null) {
            mainPanel.remove((Component)((Object)this.circuitEditTabs));
            this.circuitEditTabs.destroy();
        }
        this.circuitEditTabs = new OhCircuitEditTabbedView(this.circuit, this);
        this.circuitEditTabs.showAndCatchException();
        mainPanel.add((Component)((Object)this.circuitEditTabs), "Center");
        this.validate();
    }

    private List getNodeModels(Set set) {
        ArrayList<INodeModel> arrayList = new ArrayList<INodeModel>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            arrayList.add(((INetElement)iterator.next()).getNodeModel());
        }
        return arrayList;
    }

    private JPanel getButtonPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new FlowLayout(1, 5, 5));
        JPanel jPanel3 = new JPanel(new FlowLayout(2, 5, 5));
        if (!this.circuit.getSource().isPortOptical() && this.circuit.getFirstDestination().isPortOptical()) {
            this.mergeButton = this.makeActionButton("Merge");
            jPanel2.add(this.mergeButton);
        }
        this.helpButton = new CSHelpButton(this);
        jPanel3.add(this.helpButton);
        jPanel.add((Component)jPanel2, "Center");
        jPanel.add((Component)jPanel3, "East");
        this.initSubTabs();
        return jPanel;
    }

    private JButton makeActionButton(String string) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(this);
        return jButton;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        String string = actionEvent.getActionCommand();
        if (object == this.mergeButton) {
            this.merge();
        } else if (string.equals(CLOSE)) {
            this.disposeByUser();
        } else if (string.equals(CSHelpButton.getCaption())) {
            this.helpButton.launchHelp(this.circuitEditTabs.getHelpID());
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    public void enableHelp(boolean bl) {
        if (this.helpButton != null) {
            this.helpButton.setEnabled(bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        Cloneable cloneable;
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    OhCircuitEditDialog.this.dispose();
                }
            });
            return;
        }
        if (db.on()) {
            db.println("dispose");
        }
        this.disposed = true;
        if (allCircuitFrames != null) {
            cloneable = allCircuitFrames;
            synchronized (cloneable) {
                allCircuitFrames.remove(this.circuit);
            }
        }
        if (this.circuitEditTabs != null) {
            this.circuitEditTabs.destroy();
            this.circuitEditTabs = null;
        }
        if (this.circuit != null) {
            this.circuit.deleteObserver(this);
            this.circuit = null;
        }
        if (this.circuitMap != null) {
            this.circuitMap.dispose();
            this.circuitMap = null;
        }
        cloneable = this.getBounds();
        Preferences preferences = Preferences.instance();
        preferences.setProperty(PREF, XPOS, Integer.toString(((Rectangle)cloneable).x));
        preferences.setProperty(PREF, YPOS, Integer.toString(((Rectangle)cloneable).y));
        preferences.setProperty(PREF, WIDTH, Integer.toString(((Rectangle)cloneable).width));
        preferences.setProperty(PREF, HEIGHT, Integer.toString(((Rectangle)cloneable).height));
        preferences.setProperty(PREF, SPLIT_LOC, Integer.toString(mainSplitPane.getDividerLocation()));
        this.getContentPane().removeAll();
        this.getRootPane().removeAll();
        this.removeAll();
        super.dispose();
    }

    private void disposeByUser() {
        if (this.circuitEditTabs != null) {
            block5: {
                try {
                    this.circuitEditTabs.setShowing(false);
                }
                catch (LeavePageException leavePageException) {
                    if (db.on()) {
                        db.println("dispose: canceled by user");
                    }
                    return;
                }
                catch (Exception exception) {
                    if (!db.on()) break block5;
                    db.println("exception in dispose");
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
            this.dispose();
        }
    }

    public void merge() {
        String string = "The merged UDC and Orderwire circuits can form termination-to-termination\npaths.\nSuch paths are formed by one termination-to-cross-connection \ncircuit, zero or more cross-connection-to-cross-connection circuits \nand one cross-connection-to-termination circuit, \nconnected by existing links.\nAre you sure you want to continue?";
        if (CerentDialog.yesNoDialog((Component)this, (String)string, (String)"Merge Circuit")) {
            try {
                boolean bl = OhCircuitManager.instance().mergeCircuit(this.circuit);
                CerentDialog.infoDialog((Component)this, (String)(bl ? "The merge succeeded." : "The path to merge cannot be found."), (String)(bl ? "Circuit Merge Succeeded" : "Circuit Merge Failed"));
                if (bl) {
                    this.dispose();
                }
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
                ErrorMsg.displayError((Component)this, (EID)NEMC.EID_ERROR_MERGE_CIRCUITS_PARAM_1, (Object)exception.getMessage());
            }
        }
    }

    @Override
    public void update(Observable observable, Object object) {
        if (db.on()) {
            db.println("update " + observable + ", arg " + object);
        }
        if (object == ModelUpdateType.DELETED) {
            this.deleted = true;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                OhCircuitEditDialog.this.runUpdate();
            }
        });
    }

    private void runUpdate() {
        if (this.circuitEditTabs != null) {
            if (!this.circuitEditTabs.getUpgradeInProgress()) {
                if (!this.disposed) {
                    boolean bl = this.circuit.isCircuitRefValid();
                    if (!this.deleted && bl) {
                        if (db.on()) {
                            db.println("run: circuit still valid and no delete update.");
                            db.println("--- straight from the circuit refresh START");
                            this.circuit.prettyPrint(db);
                            db.println("--- straight from the circuit refresh END");
                        }
                        this.setDialogTitle();
                        this.circuitMap.clearNodeMarkers();
                        this.circuitMap.addNodeMarkers();
                        this.circuitMap.traceCircuit();
                        this.initSubTabs();
                    } else {
                        if (db.on()) {
                            db.println("run: circuit valid? " + bl);
                            db.println("run: circuit deleted? " + this.deleted);
                        }
                        this.dispose();
                    }
                }
            } else if (db.on()) {
                db.println("run: delete update when change in progress");
            }
        } else {
            if (db.on()) {
                db.println("run: delete update when tabbed view alreday disposed");
            }
            this.dispose();
        }
    }

    public void setDialogTitle() {
        String string = "Edit circuit: ";
        string = string + this.circuit.getCircuitName();
        int n = this.circuit.getState();
        if (n != 1) {
            string = string + " (Status: ";
            string = n != 5 ? string + ", Not editable)" : string + ")";
        }
        this.setTitle(string);
    }

    public void updateSplitPane() {
        Preferences preferences = Preferences.instance();
        int n = preferences.getInt(PREF, SPLIT_LOC, 300);
        mainSplitPane.setDividerLocation(n);
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        this.disposeByUser();
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
        if (this.circuitMap != null) {
            // empty if block
        }
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
        if (this.circuitMap != null) {
            // empty if block
        }
    }

    @Override
    protected Printable getPrintableObject() {
        TablePrintRegionDialog tablePrintRegionDialog = new TablePrintRegionDialog(null, "PRINT", true, false, this.getTable());
        tablePrintRegionDialog.pack();
        int n = tablePrintRegionDialog.showDialog();
        if (n == 0) {
            int n2 = tablePrintRegionDialog.getPrintRegionSelection();
            if (n2 == 0) {
                return new ComponentPrinter((Component)this);
            }
            return this.getTableContentPrinter();
        }
        return null;
    }

    static {
        uiToolkit = UiToolkit.instance();
    }
}

