/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.provalarms;

import cerent.cms.model.Feature;
import cerent.cms.model.IAlarmModel;
import cerent.cms.model.IModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.ISetSeverity;
import cerent.cms.model.IStringTag;
import cerent.cms.model.OpenSlotProvisionError;
import cerent.cms.model.SecurityLevel;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.Network;
import cerent.cms.ui.AbstractProvPane;
import cerent.cms.ui.AbstractProvTableModel;
import cerent.cms.ui.UiToolkit;
import cerent.cms.ui.provalarms.ProfileDeletionDialog;
import cerent.cms.ui.provalarms.ProvAlarmable;
import cerent.cms.ui.provalarms.ProvNodeProfile;
import cerent.cms.ui.provalarms.ProvProfileMap;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.NEMC;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.UScrollPane;
import java.awt.Component;
import java.awt.Frame;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class ProvAlarmsTableModel
extends AbstractProvTableModel {
    private int NUMALARMS = 0;
    private ArrayList allProfilesList;
    private ArrayList alarmablesList;
    private Hashtable tooltipTable;
    private ArrayList colDirty;
    protected boolean hideIdenticalRowsFlag;
    protected ArrayList rowMappings;
    private static final SDebug db = new SDebug("ProvAlarmsTableModel");
    public static final int FROM_INTERNAL_PROFILE = 0;
    public static final int FROM_EXTERNAL_PROFILE = 1;
    public static final int PROFILEMAXCAP = 10;
    private static final String PARSE_ERROR_MSG = "An error occurred while parsing the import string. ";
    public static HashSet permProfileSet = new HashSet();
    public static final String DEFAULT_PROFILE_STRING = "Default";
    public static final String INHERITED_PROFILE_STRING = "Inherited";
    private static String[][] convertEntityArray;
    private static String[][] convertAlarmableArray;
    public static ArrayList ignoredAlarmablesList;
    INodeModel[] fullModelArray;
    protected ArrayList nodeInfoList = new ArrayList();

    @Override
    public int getRowCount() {
        return this.numLines;
    }

    @Override
    public int getColumnCount() {
        return this.allProfilesList.size();
    }

    public int getNumAlarms() {
        return this.NUMALARMS;
    }

    protected String getRowName(int n) {
        return this.alarmablesList.get(n).toString();
    }

    protected synchronized int getRowIndex(String string) {
        return Collections.binarySearch(this.alarmablesList, string);
    }

    public Object getRowValue(String string, int n) {
        int n2 = this.getRowIndex(string);
        if (n2 >= 0) {
            return this.rawGetValueAt(n2, n);
        }
        if (db.on()) {
            db.println("getRowValue():Cannot find row with name " + string);
        }
        return null;
    }

    public void setRowValue(Object object, String string, int n) {
        int n2 = this.getRowIndex(string);
        if (n2 >= 0) {
            this.rawSetValueAt(object, n2, n);
        } else if (db.on()) {
            db.println("setRowValue():Cannot find row with name " + string);
        }
    }

    @Override
    public String getColumnName(int n) {
        String string = null;
        if (this.allProfilesList != null) {
            ProvProfileMap provProfileMap = (ProvProfileMap)this.allProfilesList.get(n);
            string = provProfileMap.profileName;
        }
        return string;
    }

    public String getColumnDesc(int n) {
        String string = null;
        if (this.allProfilesList != null) {
            ProvProfileMap provProfileMap = (ProvProfileMap)this.allProfilesList.get(n);
            string = provProfileMap.description;
        }
        return string;
    }

    public boolean columnContainsUnset(int n) {
        if (!this.isColumnAProfile(n)) {
            return false;
        }
        for (int i = 0; i < this.getNumAlarms(); ++i) {
            if (!((Integer)this.rawGetValueAt(i, n)).equals(ISetSeverity.SET_UNSET)) continue;
            return true;
        }
        return false;
    }

    public int columnNameIndex(String string) {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            ProvProfileMap provProfileMap = (ProvProfileMap)this.allProfilesList.get(i);
            if (!provProfileMap.profileName.equals(string)) continue;
            return i;
        }
        return -1;
    }

    public synchronized boolean columnNameExists(String string) {
        for (int i = 1; i < this.allProfilesList.size(); ++i) {
            ProvProfileMap provProfileMap = (ProvProfileMap)this.allProfilesList.get(i);
            if (!provProfileMap.profileName.equals(string)) continue;
            return true;
        }
        return false;
    }

    public void setColumnName(int n, String string) {
        if (n > this.allProfilesList.size() || n < 0) {
            db.println("Invalid column! " + n);
            return;
        }
        ProvProfileMap provProfileMap = (ProvProfileMap)this.allProfilesList.get(n);
        provProfileMap.profileName = string;
        this.fireTableStructureChanged();
    }

    protected boolean valuesAreIdentical(int n) {
        if (this.getColumnCount() < 3) {
            return false;
        }
        Object object = this.rawGetValueAt(n, 1);
        for (int i = 1; i < this.getColumnCount(); ++i) {
            Object object2 = this.rawGetValueAt(n, i);
            if (object2.equals(object)) continue;
            return false;
        }
        return true;
    }

    public boolean isColumnPermanent(int n) {
        return n == 0;
    }

    public boolean isColumnEditable(int n) {
        return this.isCellEditable(0, n);
    }

    public boolean isColumnAProfile(int n) {
        return n > 0;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (n2 == 0) {
            return false;
        }
        return !permProfileSet.contains(this.getColumnName(n2));
    }

    @Override
    public Object getValueAt(int n, int n2) {
        int n3 = this.mapTableRowsToModelRows(n);
        return this.rawGetValueAt(n3, n2);
    }

    public Object rawGetValueAt(int n, int n2) {
        String string = this.getRowName(n);
        if (n2 == 0) {
            return string;
        }
        ProvProfileMap provProfileMap = (ProvProfileMap)this.allProfilesList.get(n2);
        if (provProfileMap.containsKey(string)) {
            ProvAlarmable provAlarmable = (ProvAlarmable)provProfileMap.get(string);
            return provAlarmable.getSeverity();
        }
        return ProvAlarmsTableModel.charToSeverity('U');
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        int n3 = this.mapTableRowsToModelRows(n);
        this.rawSetValueAt(object, n3, n2);
    }

    public void rawSetValueAt(Object object, int n, int n2) {
        if (object == null && db.on()) {
            db.println("Asked to set null at: " + n + "," + n2);
        }
        if (!this.isCellEditable(n, n2) && db.on()) {
            db.println("ProvAlarmModel/set: value not editable at " + n + ", " + n2 + "!");
        }
        try {
            ProvProfileMap provProfileMap = (ProvProfileMap)this.allProfilesList.get(n2);
            ProvAlarmable provAlarmable = (ProvAlarmable)this.alarmablesList.get(n);
            String string = provAlarmable.getObjectName();
            String string2 = provAlarmable.getCondition();
            ProvAlarmable provAlarmable2 = (ProvAlarmable)provProfileMap.get(provAlarmable.toString());
            if (provAlarmable2 != null) {
                provAlarmable2.setSeverity((Integer)object);
            } else {
                ProvAlarmable provAlarmable3 = new ProvAlarmable(string, string2);
                provAlarmable3.setSeverity((Integer)object);
                provProfileMap.put(provAlarmable3.toString(), provAlarmable3);
            }
            if (this.isCellEditable(n, n2)) {
                this.colDirty.set(n2, Boolean.TRUE);
            }
            if (this.hideIdenticalRowsFlag && this.valuesAreIdentical(n)) {
                this.rowMappings.set(n, null);
                this.checkHideRows();
            } else {
                this.rowMappings.set(n, new Integer(n));
            }
            this.fireTableCellUpdated(n, n2);
        }
        catch (ClassCastException classCastException) {
            SDebug.printStackTrace((Throwable)classCastException);
        }
    }

    void forceDirty(int n) {
        this.colDirty.set(n, Boolean.TRUE);
    }

    public static Integer charToSeverity(char c) {
        switch (c) {
            case 'N': {
                return ISetSeverity.SET_NOT_REPORTED;
            }
            case 'A': {
                return ISetSeverity.SET_NOT_ALARMED;
            }
            case 'I': {
                return ISetSeverity.SET_MINOR;
            }
            case 'M': {
                return ISetSeverity.SET_MAJOR;
            }
            case 'C': {
                return ISetSeverity.SET_CRITICAL;
            }
            case 'U': {
                return ISetSeverity.SET_UNSET;
            }
            case 'T': {
                return ISetSeverity.SET_TRANSPARENT;
            }
        }
        return null;
    }

    public static char severityToChar(Integer n) {
        if (n.equals(ISetSeverity.SET_NOT_REPORTED)) {
            return 'N';
        }
        if (n.equals(ISetSeverity.SET_NOT_ALARMED)) {
            return 'A';
        }
        if (n.equals(ISetSeverity.SET_MINOR)) {
            return 'I';
        }
        if (n.equals(ISetSeverity.SET_MAJOR)) {
            return 'M';
        }
        if (n.equals(ISetSeverity.SET_CRITICAL)) {
            return 'C';
        }
        if (n.equals(ISetSeverity.SET_UNSET)) {
            return 'U';
        }
        if (n.equals(ISetSeverity.SET_TRANSPARENT)) {
            return 'T';
        }
        return '?';
    }

    public static String severityToShortString(Integer n) {
        if (n.equals(ISetSeverity.SET_NOT_REPORTED)) {
            return "NR";
        }
        if (n.equals(ISetSeverity.SET_NOT_ALARMED)) {
            return "NA";
        }
        if (n.equals(ISetSeverity.SET_MINOR)) {
            return "MI";
        }
        if (n.equals(ISetSeverity.SET_MAJOR)) {
            return "MJ";
        }
        if (n.equals(ISetSeverity.SET_CRITICAL)) {
            return "CR";
        }
        if (n.equals(ISetSeverity.SET_UNSET)) {
            return "UN";
        }
        if (n.equals(ISetSeverity.SET_TRANSPARENT)) {
            return "TR";
        }
        return "??";
    }

    public static String filterAlarmable(String string, int n) {
        String[] stringArray;
        int n2;
        if (string == null || n < 0 || n > 1) {
            return string;
        }
        String string2 = string;
        string = string.trim();
        string = string.replace('_', '-');
        if (n == 0) {
            for (n2 = 0; n2 < convertEntityArray.length; ++n2) {
                stringArray = convertEntityArray[n2];
                if (!string.equals(stringArray[0])) continue;
                string = stringArray[1];
                break;
            }
        }
        if (n == 1) {
            for (n2 = 0; n2 < convertAlarmableArray.length; ++n2) {
                stringArray = convertAlarmableArray[n2];
                if (!string.equals(stringArray[0])) continue;
                string = stringArray[1];
                break;
            }
        }
        if (db.on() && !string2.equals(string)) {
            db.println("* Nonmatching alarmable part: {" + string2 + "} and {" + string + "}");
        }
        return string;
    }

    public static String[][] readNodeAlarmableList(INodeModel iNodeModel) {
        try {
            IAlarmModel iAlarmModel = iNodeModel.getAlarmModel();
            IStringTag[] iStringTagArray = iAlarmModel.getAlarmableList();
            String[][] stringArray = new String[iStringTagArray.length][2];
            for (int i = 0; i < iStringTagArray.length; ++i) {
                stringArray[i][0] = ProvAlarmsTableModel.filterAlarmable(iStringTagArray[i].getFirst(), 0);
                stringArray[i][1] = ProvAlarmsTableModel.filterAlarmable(iStringTagArray[i].getSecond(), 1);
            }
            return stringArray;
        }
        catch (Exception exception) {
            db.println("ERROR reading alarmableList from " + iNodeModel.getName());
            SDebug.printStackTrace((Throwable)exception);
            return null;
        }
    }

    private Integer[] readNodeDefaultProfile(INodeModel iNodeModel) {
        try {
            IAlarmModel iAlarmModel = iNodeModel.getAlarmModel();
            String string = iAlarmModel.getAlarmSeveritiesFromProfile(DEFAULT_PROFILE_STRING);
            Integer[] integerArray = new Integer[string.length()];
            for (int i = 0; i < string.length(); ++i) {
                integerArray[i] = ProvAlarmsTableModel.charToSeverity(string.charAt(i));
            }
            return integerArray;
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            return null;
        }
    }

    protected synchronized void addNewAlarmablesFromNodes(INodeModel[] iNodeModelArray) {
        int n;
        boolean bl = false;
        if (iNodeModelArray == null) {
            return;
        }
        for (n = 0; n < iNodeModelArray.length; ++n) {
            if (iNodeModelArray[n] == null && iNodeModelArray[n].isInited()) {
                if (!db.on()) continue;
                db.println("Node model at position " + n + " is null!");
                continue;
            }
            String[][] stringArray = ProvAlarmsTableModel.readNodeAlarmableList(iNodeModelArray[n]);
            Integer[] integerArray = this.readNodeDefaultProfile(iNodeModelArray[n]);
            if (stringArray == null || integerArray == null) continue;
            for (int i = 0; i < stringArray.length; ++i) {
                String string;
                int n2;
                String[] stringArray2 = stringArray[i];
                String string2 = stringArray2[0];
                String string3 = stringArray2[1];
                ProvAlarmable provAlarmable = new ProvAlarmable(string2, string3);
                boolean bl2 = false;
                ProvAlarmable provAlarmable2 = null;
                boolean bl3 = true;
                boolean bl4 = false;
                for (n2 = 0; n2 < this.alarmablesList.size(); ++n2) {
                    if (ignoredAlarmablesList.contains(string2) || ignoredAlarmablesList.contains(string3)) {
                        if (db.on()) {
                            db.println("ignore -> " + string2 + ":" + string3);
                        }
                        bl3 = false;
                        bl2 = true;
                        break;
                    }
                    provAlarmable2 = (ProvAlarmable)this.alarmablesList.get(n2);
                    if (provAlarmable2.compareTo(provAlarmable) != 0) continue;
                    bl3 = false;
                    break;
                }
                if (bl3) {
                    Integer n3;
                    block17: {
                        this.alarmablesList.add(provAlarmable);
                        n2 = this.alarmablesList.size() - 1;
                        this.rowMappings.add(new Integer(n2));
                        ++this.NUMALARMS;
                        try {
                            n3 = integerArray[i];
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                            n3 = new Integer(0);
                            if (!db.on()) break block17;
                            SDebug.printStackTrace((Throwable)arrayIndexOutOfBoundsException);
                        }
                    }
                    ProvAlarmable provAlarmable3 = new ProvAlarmable(string2, string3);
                    try {
                        provAlarmable3.setSeverity(n3);
                        if (db.on()) {
                            db.println("new alarmable " + provAlarmable3.getKey() + " -> " + provAlarmable3.getSeverity());
                        }
                    }
                    catch (Exception exception) {
                        SDebug.printStackTrace((Throwable)exception);
                    }
                    for (int j = 1; j < this.getColumnCount(); ++j) {
                        this.rawSetValueAt(ISetSeverity.SET_UNSET, n2, j);
                    }
                    if (this.tooltipTable.containsKey(provAlarmable.getKey())) {
                        this.tooltipTable.remove(provAlarmable.getKey());
                    }
                    this.tooltipTable.put(provAlarmable.getKey(), iNodeModelArray[n].getName());
                    continue;
                }
                if (bl2) continue;
                if (db.on()) {
                    db.println("alarm [" + provAlarmable.getKey() + "] exists, Updating.");
                }
                if ((string = (String)this.tooltipTable.get(provAlarmable.getKey())).indexOf(iNodeModelArray[n].getName()) != -1) continue;
                string = string + " " + iNodeModelArray[n].getName();
                this.tooltipTable.put(provAlarmable.getKey(), string);
            }
        }
        n = this.hideIdenticalRowsFlag ? 1 : 0;
        Collections.sort(this.alarmablesList);
        this.resetRowMappings();
        this.fireTableStructureChanged();
        this.hideIdenticalRowsFlag = n;
        if (this.hideIdenticalRowsFlag) {
            this.hideIdenticalRows();
        }
    }

    protected synchronized void readAlarmColumn(INodeModel[] iNodeModelArray, String string, String string2) {
        ProvProfileMap provProfileMap = new ProvProfileMap();
        provProfileMap.profileName = string != null ? string : "";
        provProfileMap.description = string2 != null ? string2 : "";
        this.allProfilesList.add(provProfileMap);
        this.colDirty.add(Boolean.FALSE);
        this.addNewAlarmablesFromNodes(iNodeModelArray);
    }

    public synchronized void setupNewProfile(String string, String string2, int n) {
        ProvProfileMap provProfileMap = new ProvProfileMap();
        provProfileMap.profileName = string;
        provProfileMap.description = string2;
        this.allProfilesList.add(provProfileMap);
        this.colDirty.add(Boolean.FALSE);
        if (n == 1) {
            for (int i = 0; i < this.alarmablesList.size(); ++i) {
                ProvAlarmable provAlarmable = (ProvAlarmable)this.alarmablesList.get(i);
                ProvAlarmable provAlarmable2 = new ProvAlarmable(provAlarmable.getObjectName(), provAlarmable.getCondition());
                provAlarmable2.setSeverity(ISetSeverity.SET_UNSET);
                provProfileMap.put(provAlarmable2.toString(), provAlarmable2);
            }
        }
    }

    public synchronized void removeProfile(String string) {
        int n = this.columnNameIndex(string);
        if (n == -1) {
            if (db.on()) {
                db.println("!!! Cannot find profile name " + string + " to remove!");
            }
            return;
        }
        ProvProfileMap provProfileMap = (ProvProfileMap)this.allProfilesList.get(n);
        provProfileMap.clear();
        this.allProfilesList.remove(n);
        this.colDirty.remove(n);
    }

    public int copyAllSeverities(String string, String string2) {
        int n = this.columnNameIndex(string);
        int n2 = this.columnNameIndex(string2);
        if (n == -1 || n2 == -1) {
            if (db.on()) {
                db.println("error:cannot find an index for copying");
            }
            return -1;
        }
        ProvProfileMap provProfileMap = (ProvProfileMap)this.allProfilesList.get(n);
        ProvProfileMap provProfileMap2 = (ProvProfileMap)this.allProfilesList.get(n2);
        for (String string3 : provProfileMap.keySet()) {
            ProvAlarmable provAlarmable = (ProvAlarmable)provProfileMap.get(string3);
            ProvAlarmable provAlarmable2 = provAlarmable.copy();
            provProfileMap2.put(string3, provAlarmable2);
        }
        this.colDirty.set(n2, Boolean.TRUE);
        this.fireTableStructureChanged();
        return 1;
    }

    public static ParsedImportString parseAlarmFromImportString(String string) throws Exception {
        int n;
        String string2;
        String string3;
        if (string == null) {
            throw new Exception("An error occurred while parsing the import string.  A null string was encountered.");
        }
        int n2 = string.indexOf(9);
        if (n2 < 0 || n2 + 1 == string.length()) {
            throw new Exception("An error occurred while parsing the import string.  The tab index is " + n2 + ".");
        }
        String string4 = string.substring(0, n2);
        int n3 = string4.indexOf("::");
        if (n3 > -1) {
            String string5 = string4;
            string3 = string4.substring(0, n3);
            string2 = string4.substring(n3 + 2, string4.length());
            string3 = ProvAlarmsTableModel.filterAlarmable(string3, 0);
            string2 = ProvAlarmsTableModel.filterAlarmable(string2, 1);
            if (!string4.equals(string5) && db.on()) {
                db.println("alarmName changed:" + string5 + " -> " + string4);
            }
        } else {
            throw new Exception("An error occurred while parsing the import string.  No delimiter could be found for the alarm " + string4 + ".");
        }
        try {
            n = Integer.parseInt(string.substring(n2 + 1));
        }
        catch (NumberFormatException numberFormatException) {
            throw new Exception("An error occurred while parsing the import string.  The number format is invalid.");
        }
        if (n < 0 || n > 6) {
            throw new Exception("An error occurred while parsing the import string.  The severity of " + n + " is invalid.");
        }
        return new ParsedImportString(string3, string2, n);
    }

    protected int mapTableRowsToModelRows(int n) {
        int n2 = 0;
        for (int i = 0; i < this.getNumAlarms(); ++i) {
            if (this.rowMappings.get(i) == null) continue;
            if (n2 == n) {
                return (Integer)this.rowMappings.get(i);
            }
            ++n2;
        }
        if (db.on()) {
            db.println("Row error on " + n);
        }
        return -1;
    }

    protected void resetRowMappings() {
        this.numLines = this.getNumAlarms();
        this.rowDirty = new boolean[this.numLines];
        for (int i = 0; i < this.numLines; ++i) {
            this.rowMappings.set(i, new Integer(i));
        }
        this.hideIdenticalRowsFlag = false;
        this.fireTableStructureChanged();
    }

    protected void checkHideRows() {
        int n = 0;
        for (int i = 0; i < this.getNumAlarms(); ++i) {
            if (this.rowMappings.get(i) == null) continue;
            ++n;
        }
        this.numLines = n;
        this.rowDirty = new boolean[this.numLines];
        this.fireTableStructureChanged();
    }

    public void hideIdenticalRows() {
        this.hideIdenticalRowsFlag = true;
        for (int i = 0; i < this.getNumAlarms(); ++i) {
            if (this.valuesAreIdentical(i)) {
                this.rowMappings.set(i, null);
                continue;
            }
            this.rowMappings.set(i, new Integer(i));
        }
        this.checkHideRows();
    }

    public void refreshFromColumn(int n) {
        ProvProfileMap provProfileMap = (ProvProfileMap)this.allProfilesList.get(n);
        Iterator iterator = provProfileMap.keySet().iterator();
        ArrayList<String> arrayList = new ArrayList<String>();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            ProvAlarmable provAlarmable = (ProvAlarmable)provProfileMap.get(string);
            if (provAlarmable.getOldSeverity() != null) {
                provAlarmable.setSeverity(provAlarmable.getOldSeverity());
                continue;
            }
            provAlarmable.setSeverity(ProvAlarmsTableModel.charToSeverity('U'));
            arrayList.add(string);
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            provProfileMap.remove(arrayList.get(i));
        }
        this.colDirty.set(n, Boolean.FALSE);
        this.fireTableRowsUpdated(0, this.getNumAlarms() - 1);
    }

    public void applyToColumn(int n) throws Exception {
        if (((Boolean)this.colDirty.get(n)).equals(Boolean.TRUE)) {
            try {
                Object object;
                ArrayList<String> arrayList = new ArrayList<String>();
                ProvProfileMap provProfileMap = (ProvProfileMap)this.allProfilesList.get(n);
                for (String string : provProfileMap.keySet()) {
                    object = ProvAlarmsTableModel.charToSeverity('U');
                    ProvAlarmable provAlarmable = (ProvAlarmable)provProfileMap.get(string);
                    Integer n2 = provAlarmable.getSeverity();
                    if (n2 == null || n2.equals(object)) {
                        arrayList.add(string);
                        continue;
                    }
                    provAlarmable.setOldSeverity(provAlarmable.getSeverity());
                }
                for (int i = 0; i < arrayList.size(); ++i) {
                    object = (String)arrayList.get(i);
                    provProfileMap.remove(object);
                }
                this.colDirty.set(n, Boolean.FALSE);
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    @Override
    public synchronized boolean isDirty() {
        for (int i = 0; i < this.colDirty.size(); ++i) {
            if (!((Boolean)this.colDirty.get(i)).equals(Boolean.TRUE)) continue;
            return true;
        }
        return false;
    }

    public boolean columnIsDirty(int n) {
        return ((Boolean)this.colDirty.get(n)).equals(Boolean.TRUE);
    }

    public void dumpAll() {
        int n;
        for (n = 0; n < this.getColumnCount(); ++n) {
            if (!db.on()) continue;
            db.print(this.getColumnName(n) + "\t");
        }
        if (db.on()) {
            db.println("");
        }
        for (n = 0; n < this.getRowCount(); ++n) {
            for (int i = 0; i < this.getColumnCount(); ++i) {
                Object object = this.getValueAt(n, i);
                if (object instanceof Integer) {
                    ProvProfileMap provProfileMap;
                    if (db.on()) {
                        db.print(object.toString());
                    }
                    if (!(provProfileMap = (ProvProfileMap)this.allProfilesList.get(i)).containsKey(this.getRowName(n)) && db.on()) {
                        db.print("(d)");
                    }
                    if (!db.on()) continue;
                    db.print("\t");
                    continue;
                }
                if (!db.on()) continue;
                db.print(object + "\t");
            }
            if (!db.on()) continue;
            db.println("");
        }
        if (db.on()) {
            db.println("coldirty: " + this.colDirty.size() + ", " + "rowmappings: " + this.rowMappings.size() + ", " + "alarmableslist: " + this.alarmablesList.size());
        }
    }

    public void dumpColumn(int n) {
        if (db.on()) {
            db.println("Displaying values for column " + n + this.getColumnName(n));
        }
        for (int i = 0; i < this.NUMALARMS; ++i) {
            Object object = this.getValueAt(i, n);
            if (!db.on()) continue;
            db.println(object.toString());
        }
    }

    public void applyToModel() {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            if (this.isColumnPermanent(i)) continue;
            try {
                this.applyToColumn(i);
                continue;
            }
            catch (Exception exception) {
                if (db.on()) {
                    db.println("Error on apply, col " + i + 1);
                }
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    @Override
    public void setModels(IModel[] iModelArray) {
        this.cmsModels = iModelArray;
    }

    @Override
    public void refreshFromModel() throws Exception {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            if (this.isColumnPermanent(i)) continue;
            try {
                this.refreshFromColumn(i);
                continue;
            }
            catch (Exception exception) {
                if (db.on()) {
                    db.println("Error on refresh, col " + i + 1);
                }
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        this.fireTableRowsUpdated(0, this.getNumAlarms() - 1);
    }

    public ArrayList getNodeInfoList(SecurityLevel securityLevel) {
        Object object4;
        Object object2;
        Object object3;
        if (db.on()) {
            db.println("----getNodeInfoList: begin()");
        }
        Iterator iterator = Network.instance().getElements().iterator();
        ArrayList<INodeModel> arrayList = new ArrayList<INodeModel>();
        while (iterator.hasNext()) {
            object3 = (INetElement)iterator.next();
            object2 = object3.getNodeModel();
            arrayList.add((INodeModel)object2);
            object4 = object3.getSwVersion();
            this.updateNodeInfoList((INodeModel)object2, securityLevel, (String)object4);
        }
        if (arrayList.size() != this.nodeInfoList.size()) {
            object3 = new ArrayList();
            for (Object object4 : this.nodeInfoList) {
                INodeModel iNodeModel = ((ProvNodeProfile)object4).getNodeModel();
                if (arrayList.contains(iNodeModel)) continue;
                ((ArrayList)object3).add(iNodeModel.getName());
            }
            object2 = ((ArrayList)object3).iterator();
            while (object2.hasNext()) {
                object4 = (String)object2.next();
                this.removeNode((String)object4);
            }
        }
        if (db.on()) {
            db.println("----getNodeInfoList: end()");
        }
        return this.nodeInfoList;
    }

    protected boolean userCanProvisionNode(INodeModel iNodeModel, SecurityLevel securityLevel) {
        boolean bl = AbstractProvPane.isUserAuthorized((IModel)iNodeModel, securityLevel);
        if (db.on()) {
            db.println("Auth for " + iNodeModel.getName() + " is " + bl);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateNodeInfoList(INodeModel iNodeModel, SecurityLevel securityLevel, String string) {
        block25: {
            if (db.on()) {
                db.println("updateNodeInfoList for " + iNodeModel);
            }
            String string2 = null;
            boolean bl = false;
            ProvNodeProfile provNodeProfile = null;
            try {
                if (iNodeModel.isInited()) {
                    ArrayList arrayList = this.nodeInfoList;
                    synchronized (arrayList) {
                        string2 = iNodeModel.getName();
                        provNodeProfile = this.returnNodeInfo(string2);
                    }
                    boolean bl2 = Feature.provides((INodeModel)iNodeModel, (Feature)Feature.PROV_ALM_SEV);
                    if (provNodeProfile != null) {
                        if (!bl2) {
                            this.removeNode(string2);
                            if (db.on()) {
                                db.println(string2 + " has reverted and " + " no longer provides PROV_ALM_SEV: remove from list.");
                            }
                        } else if (!this.userCanProvisionNode(iNodeModel, securityLevel)) {
                            this.removeNode(string2);
                        } else {
                            String string3 = provNodeProfile.getVersionString();
                            if (string3.equals(string)) {
                                if (db.on()) {
                                    db.println(string2 + " in list with " + "matched version " + string + "; don't add.");
                                }
                            } else {
                                if (db.on()) {
                                    db.println(string2 + " in list with " + "unmatched version... old=" + string3 + ", new =" + string + "; load alarmables");
                                }
                                this.addNode(iNodeModel);
                                provNodeProfile.setVersionString(string);
                            }
                        }
                    } else if (bl2 && this.userCanProvisionNode(iNodeModel, securityLevel)) {
                        if (db.on()) {
                            db.println(string2 + " now provides " + "PROV_ALM_SEV; adding to list.");
                        }
                        this.addNode(iNodeModel);
                    } else if (db.on()) {
                        db.println(string2 + " is not PROV_ALM_SEV");
                    }
                    break block25;
                }
                try {
                    string2 = iNodeModel.getName();
                    if (string2 != null) {
                        this.removeNode(string2);
                    }
                }
                catch (Exception exception) {
                    db.finest("Exception in updateNodeInfoList() on " + iNodeModel + ", " + exception);
                }
            }
            catch (Exception exception) {
                if (string2 == null) break block25;
                db.println("Exception in updateNodeInfoList(), removing " + string2 + " " + exception);
                this.removeNode(string2);
            }
        }
    }

    public static String getVersionString(INodeModel iNodeModel) {
        String string = "";
        try {
            Network network = Network.instance();
            Collection collection = network.getElements();
            for (INetElement iNetElement : collection) {
                INodeModel iNodeModel2 = iNetElement.getNodeModel();
                if (iNodeModel2 != iNodeModel) continue;
                string = iNetElement.getSwVersion();
                break;
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
        return string;
    }

    public ArrayList verifyProfilesMatchNode(String string) {
        ProvNodeProfile provNodeProfile = this.returnNodeInfo(string);
        if (provNodeProfile == null) {
            if (db.on()) {
                db.println("Error!  Can't find node named " + string);
            }
            return this.nodeInfoList;
        }
        ArrayList arrayList = provNodeProfile.getProfileList();
        INodeModel iNodeModel = provNodeProfile.getNodeModel();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        if (iNodeModel == null) {
            db.println("ERROR!  Can't find nodemodel for " + string + " in verifyProfilesMatchNode!");
            return this.nodeInfoList;
        }
        try {
            IAlarmModel iAlarmModel = iNodeModel.getAlarmModel();
            IStringTag[] iStringTagArray = iAlarmModel.getAlarmProfileList();
            for (int i = 0; i < iStringTagArray.length; ++i) {
                if (iStringTagArray[i].getFirst() == null) continue;
                arrayList2.add(iStringTagArray[i].getFirst());
            }
        }
        catch (Exception exception) {
            db.println("Error verifying profiles on " + string);
            return this.nodeInfoList;
        }
        if (arrayList == null) {
            if (db.on()) {
                db.println("ERROR!  Null profile list for " + string);
            }
            return this.nodeInfoList;
        }
        boolean bl = true;
        if (arrayList2.size() == arrayList.size()) {
            if (!arrayList.containsAll(arrayList2)) {
                bl = false;
            }
        } else {
            bl = false;
        }
        if (!bl) {
            arrayList.clear();
            for (int i = 0; i < arrayList2.size(); ++i) {
                String string2 = (String)arrayList2.get(i);
                arrayList.add(string2);
            }
        }
        return this.nodeInfoList;
    }

    protected Object[] displayProfileSelectionBox(Component component, String string, String string2, boolean bl, boolean bl2, String string3) {
        JPanel jPanel = new JPanel();
        ArrayList arrayList = null;
        ProvNodeProfile provNodeProfile = this.returnNodeInfo(string);
        if (provNodeProfile == null) {
            if (db.on()) {
                db.println("No node " + string + " in nodeinfolist!");
            }
            return null;
        }
        Serializable serializable = provNodeProfile.getProfileList();
        arrayList = (ArrayList)((ArrayList)serializable).clone();
        if (!bl2) {
            arrayList.removeAll(permProfileSet);
        }
        if (arrayList == null || arrayList.size() == 0) {
            ErrorMsg.displayError(null, (EID)NEMC.EID_NO_PROFILES_PARAM_1, (Object)string);
            return null;
        }
        Collections.sort(arrayList);
        serializable = new JList<Object>(arrayList.toArray());
        if (!bl) {
            ((JList)serializable).setSelectionMode(0);
        }
        UScrollPane uScrollPane = new UScrollPane();
        JLabel jLabel = new JLabel("Available Profiles");
        uScrollPane.getViewport().setView((Component)serializable);
        jPanel.add((Component)uScrollPane, "Center");
        Object[] objectArray = new Object[]{string2, jPanel};
        String string4 = "OK";
        String string5 = "Cancel";
        Object[] objectArray2 = new Object[]{string4, string5};
        JOptionPane jOptionPane = new JOptionPane(objectArray, -1, 0, null, objectArray2, objectArray2[0]);
        ArrayList<Serializable> arrayList2 = new ArrayList<Serializable>();
        arrayList2.add(jOptionPane);
        arrayList2.add(serializable);
        ProfileDeletionDialog profileDeletionDialog = ProfileDeletionDialog.instance(component, true, string3, arrayList2);
        profileDeletionDialog.show();
        Object[] objectArray3 = ((JList)serializable).getSelectedValues();
        if (jOptionPane.getValue().equals(string4) && objectArray3.length > 0) {
            return objectArray3;
        }
        return null;
    }

    public synchronized ProvNodeProfile returnNodeInfo(String string) {
        int n = Collections.binarySearch(this.nodeInfoList, string);
        if (n >= 0) {
            return (ProvNodeProfile)this.nodeInfoList.get(n);
        }
        return null;
    }

    public synchronized INodeModel[] returnNodeModels(SecurityLevel securityLevel) {
        ArrayList<INodeModel> arrayList = new ArrayList<INodeModel>();
        this.getNodeInfoList(securityLevel);
        for (int i = 0; i < this.nodeInfoList.size(); ++i) {
            INodeModel iNodeModel = ((ProvNodeProfile)this.nodeInfoList.get(i)).getNodeModel();
            try {
                if (iNodeModel == null || !iNodeModel.isInited()) continue;
                arrayList.add(iNodeModel);
                continue;
            }
            catch (Exception exception) {
                db.finer("Exception in returnNodeModels(), not adding " + iNodeModel + " " + exception);
            }
        }
        INodeModel[] iNodeModelArray = arrayList.toArray(new INodeModel[arrayList.size()]);
        return iNodeModelArray;
    }

    protected synchronized int removeNodeProfileMapping(String string, String string2) {
        int n = 0;
        boolean bl = false;
        for (int i = 0; i < this.nodeInfoList.size(); ++i) {
            ProvNodeProfile provNodeProfile = (ProvNodeProfile)this.nodeInfoList.get(i);
            String string3 = provNodeProfile.getNodeName();
            if (!string.equals(string3)) continue;
            bl = provNodeProfile.containsProfile(string2);
            if (bl) {
                if (db.on()) {
                    db.println("Remove " + string + ":" + string2);
                }
                boolean bl2 = true;
                ProvNodeProfile provNodeProfile2 = this.returnNodeInfo(string);
                INodeModel iNodeModel = provNodeProfile2.getNodeModel();
                if (iNodeModel != null && iNodeModel.isInited()) {
                    try {
                        iNodeModel.setAlarmProfile(string2, "");
                    }
                    catch (Exception exception) {
                        if (db.on()) {
                            db.println("\tException: " + exception);
                        }
                        SDebug.printStackTrace((Throwable)exception);
                        this.verifyProfilesMatchNode(string);
                        bl2 = false;
                    }
                }
                if (bl2) {
                    if (db.on()) {
                        db.println("\tSuccessful Remove, deleting profile.");
                    }
                    provNodeProfile.deleteProfile(string2);
                    ++n;
                    continue;
                }
                ErrorMsg.displayError(null, NEMC.EID_ERROR_REMOVING_PROFILE_PARAM_2, string2, string3);
                continue;
            }
            ErrorMsg.displayError(null, NEMC.EID_CANNOT_FIND_PROFILE_PARAM_2, string2, string);
        }
        return n;
    }

    protected synchronized void addNodeProfileMapping(Component component, String string, String string2) {
        ProvNodeProfile provNodeProfile = this.returnNodeInfo(string);
        INodeModel iNodeModel = provNodeProfile.getNodeModel();
        if (iNodeModel == null) {
            db.println("The node model for " + string + " is null!");
        }
        boolean bl = false;
        for (int i = 0; i < this.nodeInfoList.size(); ++i) {
            Object[] objectArray;
            int n;
            ProvNodeProfile provNodeProfile2 = (ProvNodeProfile)this.nodeInfoList.get(i);
            String string3 = provNodeProfile2.getNodeName();
            if (!string.equals(string3)) continue;
            bl = provNodeProfile2.containsProfile(string2);
            if (!bl && provNodeProfile2.numberOfProfiles() >= 10) {
                n = 0;
                ErrorMsg.displayWarning(null, (EID)NEMC.WID_PROFILES_FULL_PARAM_2, string, string2);
                objectArray = this.displayProfileSelectionBox(component, string, "Select Profile(s) to Delete:", true, false, "Profile Deletion");
                if (objectArray != null) {
                    for (int j = 0; j < objectArray.length; ++j) {
                        n += this.removeNodeProfileMapping(string, (String)objectArray[j]);
                    }
                    if (n < 0) {
                        return;
                    }
                } else {
                    return;
                }
            }
            if (bl && !CerentDialog.yesNoDialog((Component)this.getFrame(), (String)("The profile " + string2 + " already exists on " + string + ".\n" + "Do you wish to overwrite it?"), (String)"Overwrite Profile?")) {
                return;
            }
            if (db.on()) {
                db.println("Adding " + string + ":" + string2);
            }
            n = this.columnNameIndex(string2);
            objectArray = this.returnNodeInfo(string);
            INodeModel iNodeModel2 = objectArray.getNodeModel();
            boolean bl2 = true;
            try {
                Object object;
                if (iNodeModel2 != null && iNodeModel2.isInited()) {
                    IAlarmModel iAlarmModel = iNodeModel2.getAlarmModel();
                    object = iAlarmModel.getAlarmableList();
                    StringBuffer stringBuffer = new StringBuffer();
                    for (int j = 0; j < ((IStringTag[])object).length; ++j) {
                        Integer n2;
                        String string4 = ProvAlarmsTableModel.filterAlarmable(object[j].getFirst(), 0);
                        String string5 = ProvAlarmsTableModel.filterAlarmable(object[j].getSecond(), 1);
                        ProvAlarmable provAlarmable = new ProvAlarmable(string4, string5);
                        if (ignoredAlarmablesList.contains(string4) || ignoredAlarmablesList.contains(string5)) {
                            if (db.on()) {
                                db.println(string4 + ":" + string5 + " is being ignored " + " and being set to SET_UNSET.");
                            }
                            n2 = ISetSeverity.SET_UNSET;
                        } else {
                            n2 = (Integer)this.getRowValue(provAlarmable.getKey(), n);
                        }
                        if (n2.equals(ISetSeverity.SET_NOT_REPORTED)) {
                            stringBuffer.append('N');
                            continue;
                        }
                        if (n2.equals(ISetSeverity.SET_NOT_ALARMED)) {
                            stringBuffer.append('A');
                            continue;
                        }
                        if (n2.equals(ISetSeverity.SET_MINOR)) {
                            stringBuffer.append('I');
                            continue;
                        }
                        if (n2.equals(ISetSeverity.SET_MAJOR)) {
                            stringBuffer.append('M');
                            continue;
                        }
                        if (n2.equals(ISetSeverity.SET_CRITICAL)) {
                            stringBuffer.append('C');
                            continue;
                        }
                        if (n2.equals(ISetSeverity.SET_UNSET)) {
                            stringBuffer.append('U');
                            continue;
                        }
                        if (!n2.equals(ISetSeverity.SET_TRANSPARENT)) continue;
                        stringBuffer.append('T');
                    }
                    if (stringBuffer.length() != ((IStringTag[])object).length) {
                        if (db.on()) {
                            db.println("different set sizes!");
                        }
                        throw new Exception("The set sizes do not match.");
                    }
                    if (db.on()) {
                        db.println("Will store this combo:\n1. " + string2 + "\n2." + stringBuffer);
                    }
                    iAlarmModel.setAlarmProfile(string2, stringBuffer.toString());
                } else {
                    for (int j = 0; j < this.getNumAlarms(); ++j) {
                        int n3 = (Integer)this.rawGetValueAt(j, n);
                        switch (n3) {
                            case 0: {
                                object = "NR";
                                break;
                            }
                            case 1: {
                                object = "NA";
                                break;
                            }
                            case 2: {
                                object = "MN";
                                break;
                            }
                            case 3: {
                                object = "MJ";
                                break;
                            }
                            case 4: {
                                object = "CR";
                                break;
                            }
                            case 5: {
                                object = "UN";
                                break;
                            }
                            case 6: {
                                object = "TR";
                                break;
                            }
                            default: {
                                object = "!!" + n3;
                            }
                        }
                        if (!db.on()) continue;
                        db.println(string2 + ": Set #" + j + " [" + (String)object + "]");
                    }
                }
            }
            catch (OpenSlotProvisionError openSlotProvisionError) {
                ErrorMsg.displayWarning(null, (EID)NEMC.WID_MODIFY_PROFILE_PARAM_4, string2, string3, string2, string3);
            }
            catch (Exception exception) {
                bl2 = false;
                this.verifyProfilesMatchNode(string);
                ErrorMsg.displayDetailed(null, NEMC.EID_ERROR_ADDING_PROFILE_PARAM_2, string2, string3, exception.getMessage());
            }
            if (!bl2) continue;
            if (bl) {
                provNodeProfile2.deleteProfile(string2);
                provNodeProfile2.addProfile(string2);
                continue;
            }
            provNodeProfile2.addProfile(string2);
        }
    }

    private Frame getFrame() {
        return UiToolkit.instance().getApplicationFrame();
    }

    protected void addNode(INodeModel iNodeModel) {
        INodeModel[] iNodeModelArray = new INodeModel[]{iNodeModel};
        this.readIntoNodeInfo(iNodeModelArray);
        this.addNewAlarmablesFromNodes(iNodeModelArray);
    }

    protected void removeNode(String string) {
        ProvNodeProfile provNodeProfile = this.returnNodeInfo(string);
        if (provNodeProfile != null) {
            this.removeNode(provNodeProfile);
        } else {
            db.println("removeNode(): could not find " + string);
        }
    }

    protected synchronized void removeNode(ProvNodeProfile provNodeProfile) {
        try {
            if (provNodeProfile != null) {
                if (db.on()) {
                    db.println("Removing node " + provNodeProfile.getNodeName());
                }
                provNodeProfile.dispose();
                this.nodeInfoList.remove(provNodeProfile);
            } else if (db.on()) {
                db.println("removeNode(): null dieNodeInfo");
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            SDebug.printStackTrace((Throwable)noSuchElementException);
        }
    }

    protected synchronized void readIntoNodeInfo(INodeModel[] iNodeModelArray) {
        if (iNodeModelArray == null) {
            return;
        }
        boolean bl = false;
        for (int i = 0; i < iNodeModelArray.length; ++i) {
            ProvNodeProfile provNodeProfile;
            INodeModel iNodeModel = iNodeModelArray[i];
            try {
                if (iNodeModel == null || !iNodeModel.isInited()) continue;
                provNodeProfile = new ProvNodeProfile(iNodeModel);
                String string = ProvAlarmsTableModel.getVersionString(iNodeModel);
                if (db.on()) {
                    db.println("setup " + iNodeModel.getName() + " with ver=" + string);
                }
                provNodeProfile.setVersionString(string);
                if (!this.nodeInfoList.contains(provNodeProfile)) {
                    if (db.on()) {
                        db.println("adding " + iNodeModel.getName() + " to nodeInfoList");
                    }
                    IAlarmModel iAlarmModel = iNodeModel.getAlarmModel();
                    IStringTag[] iStringTagArray = iAlarmModel.getAlarmProfileList();
                    for (int j = 0; j < iStringTagArray.length; ++j) {
                        if (iStringTagArray[j].getFirst() == null) continue;
                        provNodeProfile.addProfile(iStringTagArray[j].getFirst());
                    }
                    this.nodeInfoList.add(provNodeProfile);
                    bl = true;
                    continue;
                }
                provNodeProfile = null;
                continue;
            }
            catch (Exception exception) {
                provNodeProfile = null;
            }
        }
        if (bl) {
            Collections.sort(this.nodeInfoList);
        }
    }

    public ProvAlarmsTableModel(boolean bl, INodeModel[] iNodeModelArray) {
        super((IModel[])iNodeModelArray, true, "");
        this.fullModelArray = iNodeModelArray;
        this.alarmablesList = new ArrayList();
        this.colDirty = new ArrayList();
        this.rowMappings = new ArrayList();
        this.tooltipTable = new Hashtable();
        this.allProfilesList = new ArrayList();
    }

    void initAlarmColumn(String string, String string2) {
        ArrayList<INodeModel> arrayList = new ArrayList<INodeModel>();
        if (this.fullModelArray != null) {
            for (int i = 0; i < this.fullModelArray.length; ++i) {
                INodeModel iNodeModel = this.fullModelArray[i];
                try {
                    if (iNodeModel == null || !iNodeModel.isInited()) continue;
                    if (Feature.provides((INodeModel)iNodeModel, (Feature)Feature.PROV_ALM_SEV)) {
                        arrayList.add(iNodeModel);
                        continue;
                    }
                    if (!db.on()) continue;
                    db.println(iNodeModel.getName() + " does not provide PROV_ALM_SEV...");
                    continue;
                }
                catch (Exception exception) {
                    db.finer("Exception in ProvAlarmsTableModel() with provides() on " + iNodeModel + " " + exception);
                }
            }
            INodeModel[] iNodeModelArray = arrayList.toArray(new INodeModel[arrayList.size()]);
            if (iNodeModelArray.length > 0) {
                this.readAlarmColumn(iNodeModelArray, string, string2);
                this.readIntoNodeInfo(iNodeModelArray);
            }
        } else if (db.on()) {
            db.println("could not initAlarmColumn(); model array is empty");
        }
    }

    public String getTooltip(Object object) {
        return this.tooltipTable.get(object).toString();
    }

    public void destroy() {
        this.allProfilesList.clear();
        this.allProfilesList = null;
        this.alarmablesList.clear();
        this.alarmablesList = null;
        if (this.nodeInfoList != null) {
            for (int i = 0; i < this.nodeInfoList.size(); ++i) {
                ProvNodeProfile provNodeProfile = (ProvNodeProfile)this.nodeInfoList.get(i);
                if (provNodeProfile == null) continue;
                provNodeProfile.dispose();
            }
        }
        this.nodeInfoList.clear();
        this.nodeInfoList = null;
        this.colDirty.clear();
        this.colDirty = null;
        this.rowMappings.clear();
        this.rowMappings = null;
        this.disposeDataSource();
    }

    static {
        permProfileSet.add(DEFAULT_PROFILE_STRING);
        permProfileSet.add(INHERITED_PROFILE_STRING);
        permProfileSet.add("None");
        convertEntityArray = new String[][]{{"EC1-12", "EC1"}};
        convertAlarmableArray = new String[][]{{"SWFTDWN", "SFTWDWN"}, {"WTR-RING", "WTR"}, {"WTR-SPAN", "WTR"}, {"PEERMISSM", "PEER-MISM"}, {"EXERCISE-RING", "EXERCISE-RING-REQ"}, {"EXERCISE-SPAN", "EXERCISE-SPAN-REQ"}, {"FE-EXERCISE-RING", "FE-EXERCISING-RING"}, {"FE-EXERCISE-SPAN", "FE-EXERCISING-SPAN"}, {"SECUR-LOGIN", "INTRUSION"}, {"CONTBUS-A", "CONTBUS-IO-A"}, {"CONTBUS-B", "CONTBUS-IO-B"}, {"CTNEQPT-PBACT", "CTNEQPT-PBWORK"}, {"CTNEQPT-PBSTBY", "CTNEQPT-PBPROT"}, {"LOP", "LOP-P"}, {"LPBKDS1FEAC-CMD", "LPBKDS1FE-CMD"}};
        ignoredAlarmablesList = new ArrayList();
        ignoredAlarmablesList.add("???");
    }

    public static class ParsedImportString {
        protected String alarmNameFirst;
        protected String alarmNameSecond;
        protected int alarmSeverity;

        public ParsedImportString(String string, String string2, int n) {
            this.alarmNameFirst = string;
            this.alarmNameSecond = string2;
            this.alarmSeverity = n;
        }

        public String getFirstAlarmPart() {
            return this.alarmNameFirst;
        }

        public String getSecondAlarmPart() {
            return this.alarmNameSecond;
        }

        public String getFullAlarmName() {
            return this.alarmNameFirst + "::" + this.alarmNameSecond;
        }

        public int getSeverity() {
            return this.alarmSeverity;
        }
    }
}

