/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.snmp;

import cerent.cms.model.Attribute;
import cerent.cms.model.SnmpV3EngineContainer;
import cerent.cms.model.SnmpV3PassKey;
import cerent.cms.model.SnmpV3ProxyUser;
import cerent.cms.ui.snmp.SnmpProxyPane;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.NEMC;
import cerent.util.SDebug;
import cerent.util.SnmpUtil;
import cerent.util.gui.SnmpV3RowComboBox;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class Snmpv3UserDetailsPanel
extends JPanel
implements ActionListener,
FocusListener {
    static final int MARGIN = 5;
    static final int MIN_USER_LENGTH = 6;
    static final int MIN_PASSWORD_LENGTH = 8;
    protected SnmpV3RowComboBox nameCB;
    protected JTextField authKeyTF;
    protected JTextField privKeyTF;
    protected JComboBox secLevelCB;
    protected JComboBox authProtocolCB;
    protected JComboBox privProtocolCB;
    private SnmpProxyPane parentPane;
    private boolean isCreate;
    private ArrayList remoteUsers;
    private ArrayList remoteUsersForThisClient;
    private boolean userExists = false;
    private static final SDebug db = new SDebug("Snmpv3UserDetailsPane");

    public Snmpv3UserDetailsPanel(String string, SnmpProxyPane snmpProxyPane, boolean bl) {
        this.parentPane = snmpProxyPane;
        this.isCreate = bl;
        this.remoteUsers = new ArrayList();
        this.remoteUsersForThisClient = new ArrayList();
        this.add((Component)this.createAttrsPanel(string), "Center");
    }

    public void refreshUserList(SnmpV3EngineContainer snmpV3EngineContainer) {
        this.remoteUsers.clear();
        this.remoteUsersForThisClient.clear();
        this.nameCB.removeAllItems();
        if (null != snmpV3EngineContainer) {
            this.remoteUsers = this.parentPane.getSnmpv3RemoteUsers();
            for (int i = 0; i < this.remoteUsers.size(); ++i) {
                SnmpV3ProxyUser snmpV3ProxyUser = (SnmpV3ProxyUser)this.remoteUsers.get(i);
                SnmpV3EngineContainer snmpV3EngineContainer2 = snmpV3ProxyUser.getEngine();
                if (!snmpV3EngineContainer2.equals((Object)snmpV3EngineContainer)) continue;
                this.nameCB.addItem(snmpV3ProxyUser.getuserName());
                this.remoteUsersForThisClient.add(snmpV3ProxyUser);
            }
        }
        this.nameCB.setSelectedIndex(-1);
        this.authProtocolCB.setSelectedIndex(0);
        this.privProtocolCB.setSelectedIndex(0);
    }

    private JPanel createAttrsPanel(String string) {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder(string));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(0, 2, 5, 5));
        jPanel3.add(this.createLabel("User Name:", 70, 20));
        this.nameCB = new SnmpV3RowComboBox();
        jPanel3.add(this.nameCB);
        this.nameCB.setSelectedIndex(-1);
        this.nameCB.setEditable(true);
        this.nameCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                Snmpv3UserDetailsPanel.this.userExists = false;
                String string = (String)Snmpv3UserDetailsPanel.this.nameCB.getSelectedItem();
                for (int i = 0; i < Snmpv3UserDetailsPanel.this.remoteUsersForThisClient.size(); ++i) {
                    SnmpV3ProxyUser snmpV3ProxyUser = (SnmpV3ProxyUser)Snmpv3UserDetailsPanel.this.remoteUsersForThisClient.get(i);
                    String string2 = snmpV3ProxyUser.getuserName();
                    if (!string2.equals(string)) continue;
                    Snmpv3UserDetailsPanel.this.setSelectedItem(snmpV3ProxyUser, false);
                    Snmpv3UserDetailsPanel.this.userExists = true;
                    break;
                }
                if (!Snmpv3UserDetailsPanel.this.userExists) {
                    Snmpv3UserDetailsPanel.this.authProtocolCB.setEnabled(true);
                    Snmpv3UserDetailsPanel.this.privProtocolCB.setEnabled(true);
                    Snmpv3UserDetailsPanel.this.authProtocolCB.setSelectedIndex(0);
                    Snmpv3UserDetailsPanel.this.privProtocolCB.setSelectedIndex(0);
                }
            }
        });
        this.nameCB.addFocusListener(this);
        KeyListener keyListener = new KeyListener(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                Snmpv3UserDetailsPanel.this.userExists = false;
                String string = (String)Snmpv3UserDetailsPanel.this.nameCB.getSelectedItem();
                for (int i = 0; i < Snmpv3UserDetailsPanel.this.remoteUsersForThisClient.size(); ++i) {
                    SnmpV3ProxyUser snmpV3ProxyUser = (SnmpV3ProxyUser)Snmpv3UserDetailsPanel.this.remoteUsersForThisClient.get(i);
                    if (!snmpV3ProxyUser.getuserName().equals(string)) continue;
                    Snmpv3UserDetailsPanel.this.userExists = true;
                    break;
                }
                if (!Snmpv3UserDetailsPanel.this.userExists) {
                    Snmpv3UserDetailsPanel.this.authProtocolCB.setEnabled(true);
                    Snmpv3UserDetailsPanel.this.privProtocolCB.setEnabled(true);
                    Snmpv3UserDetailsPanel.this.authProtocolCB.setSelectedIndex(0);
                    Snmpv3UserDetailsPanel.this.privProtocolCB.setSelectedIndex(0);
                }
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }
        };
        this.nameCB.addKeyListener(keyListener);
        if (this.isCreate) {
            jPanel3.add(this.createLabel("Security Level:", 70, 20));
            this.secLevelCB = new JComboBox<Attribute>(SnmpUtil.securityLevel);
            jPanel3.add(this.secLevelCB);
            this.secLevelCB.removeItemAt(0);
            this.secLevelCB.setSelectedIndex(0);
            this.secLevelCB.addActionListener(this);
        }
        jPanel3.setBorder(BorderFactory.createTitledBorder(""));
        jPanel2.add(jPanel3);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayout(0, 2, 5, 5));
        jPanel4.add(this.createLabel("Protocol:", 70, 20));
        this.authProtocolCB = new JComboBox<Attribute>(SnmpUtil.authProtocol);
        jPanel4.add(this.authProtocolCB);
        this.authProtocolCB.setSelectedIndex(0);
        this.authProtocolCB.addActionListener(this);
        jPanel4.add(this.createLabel("Password:", 70, 20));
        this.authKeyTF = new JPasswordField(20);
        jPanel4.add(this.authKeyTF);
        this.authKeyTF.setEnabled(false);
        jPanel4.setBorder(BorderFactory.createTitledBorder("Authentication"));
        jPanel2.add(jPanel4);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new GridLayout(0, 2, 5, 5));
        jPanel5.add(this.createLabel("Protocol:", 70, 20));
        this.privProtocolCB = new JComboBox<Attribute>(SnmpUtil.privProtocol);
        jPanel5.add(this.privProtocolCB);
        this.privProtocolCB.setSelectedIndex(0);
        this.privProtocolCB.addActionListener(this);
        jPanel5.add(this.createLabel("Password:", 70, 20));
        this.privKeyTF = new JPasswordField(20);
        jPanel5.add(this.privKeyTF);
        this.privKeyTF.setEnabled(false);
        jPanel5.setBorder(BorderFactory.createTitledBorder("Privacy"));
        jPanel2.add(jPanel5);
        jPanel.add(jPanel2);
        this.refreshUserList(null);
        return jPanel;
    }

    public Attribute convertAuthProto(int n) {
        return SnmpUtil.authProtocol[n];
    }

    public Attribute convertPrivProto(int n) {
        return SnmpUtil.privProtocol[n];
    }

    private JLabel createLabel(String string, int n, int n2) {
        JLabel jLabel = new JLabel(string);
        jLabel.setPreferredSize(new Dimension(n, n2));
        return jLabel;
    }

    public String getAuthKey() {
        return this.authKeyTF.getText();
    }

    public String getPrivKey() {
        return this.privKeyTF.getText();
    }

    public String getUserName() {
        if (this.nameCB.getSelectedItem() == null) {
            return "";
        }
        return (String)this.nameCB.getSelectedItem();
    }

    public int getSecurityLevel() {
        int n = ((Attribute)this.secLevelCB.getSelectedItem()).getValue();
        return n;
    }

    public int getAuthProtocol() {
        int n = ((Attribute)this.authProtocolCB.getSelectedItem()).getValue();
        return n;
    }

    public int getPrivProtocol() {
        int n = ((Attribute)this.privProtocolCB.getSelectedItem()).getValue();
        return n;
    }

    public SnmpV3PassKey getAuthPassKey() {
        String string = this.getAuthKey();
        byte[] byArray = new byte[20];
        int n = 0;
        SnmpV3PassKey snmpV3PassKey = new SnmpV3PassKey(byArray, n, string, true);
        return snmpV3PassKey;
    }

    public SnmpV3PassKey getPrivPassKey() {
        String string = this.getPrivKey();
        byte[] byArray = new byte[20];
        int n = 0;
        SnmpV3PassKey snmpV3PassKey = new SnmpV3PassKey(byArray, n, string, true);
        return snmpV3PassKey;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.authProtocolCB) {
            if (this.authProtocolCB.getSelectedIndex() > 0) {
                this.authKeyTF.setEnabled(true);
            } else {
                this.authKeyTF.setEnabled(false);
                this.authKeyTF.setText("");
                this.privProtocolCB.setSelectedIndex(0);
                this.privKeyTF.setEnabled(false);
                this.privKeyTF.setText("");
            }
        } else if (object == this.privProtocolCB) {
            if (this.privProtocolCB.getSelectedIndex() > 0) {
                this.privKeyTF.setEnabled(true);
                if (this.authProtocolCB.getSelectedIndex() == 0) {
                    this.authProtocolCB.setSelectedIndex(1);
                }
                this.authKeyTF.setEnabled(true);
            } else {
                this.privKeyTF.setEnabled(false);
                this.privKeyTF.setText("");
            }
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        Object object = focusEvent.getSource();
        if (object == this.nameCB) {
            this.userExists = false;
            String string = (String)this.nameCB.getSelectedItem();
            for (int i = 0; i < this.remoteUsers.size(); ++i) {
                SnmpV3ProxyUser snmpV3ProxyUser = (SnmpV3ProxyUser)this.remoteUsers.get(i);
                String string2 = snmpV3ProxyUser.getuserName();
                if (!string2.equals(string)) continue;
                this.userExists = true;
                break;
            }
            if (!this.userExists) {
                this.authProtocolCB.setEnabled(true);
                this.privProtocolCB.setEnabled(true);
                this.authProtocolCB.setSelectedIndex(0);
                this.privProtocolCB.setSelectedIndex(0);
            }
        }
    }

    public boolean validateUserAttr() {
        if (this.isCreate && !this.userExists) {
            if (this.getUserName().length() < 6) {
                ErrorMsg.displayError((Component)this, (EID)NEMC.EID_SNMPV3_USERNAME_INVALID);
                return false;
            }
            if (this.authProtocolCB.getSelectedIndex() != 0 && this.getAuthKey().length() < 8) {
                ErrorMsg.displayError((Component)this, (EID)NEMC.EID_SNMPV3_AUTHPWD_INVALID);
                return false;
            }
            if (this.privProtocolCB.getSelectedIndex() != 0 && this.getPrivKey().length() < 8) {
                ErrorMsg.displayError((Component)this, (EID)NEMC.EID_SNMPV3_ENCRYPPWD_INVALID);
                return false;
            }
        }
        return true;
    }

    public boolean validateEditCriteria(SnmpV3ProxyUser snmpV3ProxyUser) {
        boolean bl = true;
        if (this.authProtocolCB.getSelectedIndex() != 0 && this.authProtocolCB.getSelectedIndex() != snmpV3ProxyUser.getauthProtocol()) {
            if (this.getAuthKey().length() < 8) {
                ErrorMsg.displayError((Component)this, (EID)NEMC.EID_SNMPV3_AUTHPWD_INVALID);
                return false;
            }
            if (this.privProtocolCB.getSelectedIndex() != 0 && this.getPrivKey().length() < 8) {
                ErrorMsg.displayError((Component)this, (EID)NEMC.EID_SNMPV3_ENCRYPPWD_INVALID);
                return false;
            }
        }
        if (this.privProtocolCB.getSelectedIndex() != 0 && this.privProtocolCB.getSelectedIndex() != snmpV3ProxyUser.getprivProtocol() && this.getPrivKey().length() < 8) {
            ErrorMsg.displayError((Component)this, (EID)NEMC.EID_SNMPV3_ENCRYPPWD_INVALID);
            return false;
        }
        return bl;
    }

    public boolean checkIfUserReUsed() {
        return this.userExists;
    }

    public void setSelectedItem(SnmpV3ProxyUser snmpV3ProxyUser, boolean bl) {
        if (bl) {
            this.nameCB.setSelectedItem(snmpV3ProxyUser.getuserName());
        }
        this.authKeyTF.setText("");
        this.authProtocolCB.setSelectedItem(this.convertAuthProto(snmpV3ProxyUser.getauthProtocol()));
        this.privKeyTF.setText("");
        this.privProtocolCB.setSelectedItem(this.convertPrivProto(snmpV3ProxyUser.getprivProtocol()));
        this.nameCB.setEnabled(this.isCreate);
        if (this.isCreate) {
            this.authKeyTF.setEnabled(bl);
            this.privKeyTF.setEnabled(bl);
        }
        this.authProtocolCB.setEnabled(bl);
        this.privProtocolCB.setEnabled(bl);
    }
}

