/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.span;

import cerent.cms.model.INodeModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.LinkModel;
import cerent.cms.ui.span.SdEndpointSide;
import cerent.cms.ui.span.SpanUpgradeDialog;
import java.util.ArrayList;
import java.util.List;

abstract class SdEndpointInfo {
    public static final int WORKING_SIDE = 1;
    public static final int PROTECT_SIDE = 2;
    private LinkModel linkModel;
    private boolean isSrc;
    private String nodeName;
    protected SdEndpointSide workingSide;
    protected SdEndpointSide protectSide;

    SdEndpointInfo(LinkModel linkModel, boolean bl) throws Exception {
        this.linkModel = linkModel;
        this.isSrc = bl;
        this.nodeName = this.getNodeModel().getName();
        this.workingSide = this.createEndpointSide(1);
        if (linkModel.protectionType() == 1 || linkModel.protectionType() == 4) {
            this.protectSide = this.createEndpointSide(2);
        }
    }

    protected abstract SdEndpointSide createEndpointSide(int var1) throws Exception;

    public String getNodeName() {
        return this.nodeName;
    }

    public SdEndpointSide getEndpointSide(int n) {
        return n == 1 ? this.workingSide : this.protectSide;
    }

    public String getSlotString(int n) {
        return this.getEndpointSide(n).getSlotString();
    }

    public INodeModel getNodeModel() {
        return this.isSrc ? this.linkModel.src() : this.linkModel.dst();
    }

    public boolean existProtectSide() {
        return this.protectSide != null;
    }

    private int getPortIndex(int n) {
        if (n == 1) {
            return this.isSrc ? this.linkModel.srcEntityIndex() : this.linkModel.dstEntityIndex();
        }
        if (n == 2) {
            if (this.linkModel.protectionType() == 1) {
                return this.isSrc ? this.linkModel.getOnePlusOneSrcProtectCardEntityIndex() : this.linkModel.getOnePlusOneDstProtectCardEntityIndex();
            }
            if (this.linkModel.protectionType() == 4) {
                return this.isSrc ? this.linkModel.get4FBlsrSrcProtectCardEntityIndex() : this.linkModel.get4FBlsrDstProtectCardEntityIndex();
            }
        }
        return -1;
    }

    public IPortModel getPortModel(int n) throws Exception {
        return SpanUpgradeDialog.getPortModel(this.getNodeModel(), this.getPortIndex(n));
    }

    public List getListOfValidUpgradeType() throws Exception {
        if (this.existProtectSide()) {
            ArrayList arrayList = new ArrayList();
            List list = this.workingSide.getListOfValidUpgradeType();
            List list2 = this.protectSide.getListOfValidUpgradeType();
            if (list != null) {
                arrayList.addAll(list);
                arrayList.retainAll(list2);
            }
            return arrayList;
        }
        return this.workingSide.getListOfValidUpgradeType();
    }

    public void changeToNewEquipment(int n) throws Exception {
        this.getEndpointSide(n).changeToNewEquipment();
    }

    public void changeToNewEquipment() throws Exception {
        this.changeToNewEquipment(1);
        if (this.protectSide != null) {
            this.changeToNewEquipment(2);
        }
    }

    public void revertToOldEquipment(int n) throws Exception {
        this.getEndpointSide(n).revertToOldEquipment();
    }

    public void revertToOldEquipment() throws Exception {
        this.revertToOldEquipment(1);
        if (this.protectSide != null) {
            this.revertToOldEquipment(2);
        }
    }

    public void setNewCardType(int n, int n2) throws Exception {
        this.workingSide.newCardType = n;
        this.workingSide.newPortType = n2;
        if (this.protectSide != null) {
            this.protectSide.newCardType = n;
            this.protectSide.newPortType = n2;
        }
    }

    public void setNewPortType(int n) throws Exception {
        this.workingSide.setNewPortType(n);
        if (this.protectSide != null) {
            this.protectSide.setNewPortType(n);
        }
    }

    public boolean isIOCardUpgrade() {
        return this.workingSide.isIOCardUpgrade();
    }

    public boolean isPPMCardUpgarde() {
        return this.workingSide.isPPMCardUpgrade();
    }
}

