/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.span;

import cerent.cms.model.IModuleModel;
import cerent.cms.model.IPortModel;
import cerent.cms.ui.span.SdEndpointInfo;
import cerent.util.SDebug;
import java.util.List;

abstract class SdEndpointSide {
    public static final int UNKNOWN_UPGRADE = 0;
    public static final int NO_UPGRADE = 1;
    public static final int IO_CARD_UPGRADE = 2;
    public static final int PPM_UPGRADE = 3;
    public static final int PORT_RATE_UPGRADE = 4;
    public static final int PPM_CARD_UPGRADE = 5;
    protected static final SDebug db = new SDebug("SdEndpointSide");
    protected SdEndpointInfo parent;
    protected int side;
    protected int slotNo;
    protected int oldPortType;
    protected int newPortType;
    protected int oldCardType;
    protected int newCardType;
    protected int upgradeType;

    SdEndpointSide(SdEndpointInfo sdEndpointInfo, int n) throws Exception {
        this.parent = sdEndpointInfo;
        this.side = n;
        IPortModel iPortModel = this.getPortModel();
        this.slotNo = iPortModel.getSlot();
        this.oldPortType = iPortModel.getEqType();
        this.oldCardType = iPortModel.getParent().getEqType();
    }

    protected IPortModel getPortModel() throws Exception {
        return this.parent.getPortModel(this.side);
    }

    protected IModuleModel getModuleModel() throws Exception {
        return this.getPortModel().getModuleModel();
    }

    protected void setNewPortType(int n) throws Exception {
        this.newPortType = n;
    }

    public String getSlotString() {
        return this.parent.getNodeName() + ", slot " + String.valueOf(this.slotNo);
    }

    public abstract void changeToNewEquipment() throws Exception;

    public abstract void revertToOldEquipment() throws Exception;

    public abstract List getListOfValidUpgradeType() throws Exception;

    public int getNewEquipmentType() {
        switch (this.upgradeType) {
            case 2: 
            case 5: {
                return this.newCardType;
            }
            case 3: 
            case 4: {
                return this.newPortType;
            }
        }
        return -1;
    }

    public int getOldEquipmentType() {
        switch (this.upgradeType) {
            case 2: 
            case 5: {
                return this.oldCardType;
            }
            case 3: 
            case 4: {
                return this.oldPortType;
            }
        }
        return -1;
    }

    public boolean isIOCardUpgrade() {
        return this.upgradeType == 2;
    }

    public boolean needEquipmentChangeInUpgrade() {
        return this.upgradeType != 0 && this.upgradeType != 1;
    }

    public boolean needToChangeCardInUpgrade() {
        return this.upgradeType == 2 || this.upgradeType == 3 || this.upgradeType == 5;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.side == 1 ? "WORKING_SIDE, " : "PROTECT_SIDE, ");
        stringBuffer.append("slotNo=" + this.slotNo + ", ");
        stringBuffer.append("oldPortType=" + this.oldPortType + ", ");
        stringBuffer.append("newPortType=" + this.newPortType + ", ");
        stringBuffer.append("oldCardType=" + this.oldCardType + ", ");
        stringBuffer.append("newCardType=" + this.newCardType + ", ");
        stringBuffer.append("upgradeType=" + this.upgradeType);
        return stringBuffer.toString();
    }

    public boolean isPPMCardUpgrade() {
        return this.upgradeType == 5;
    }
}

