/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.vlan;

import cerent.cms.model.Attribute;
import cerent.cms.model.CTCUserException;
import cerent.cms.model.Feature;
import cerent.cms.model.IBucketSize;
import cerent.cms.model.IModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.INodeModelAndIndex;
import cerent.cms.model.IROSVlanProfile;
import cerent.cms.model.ISVlanProfile;
import cerent.cms.model.ISVlanProfileImportExporter;
import cerent.cms.model.ISVlanProfileModel;
import cerent.cms.model.ISVlanProfileModels;
import cerent.cms.model.NetSecurityModel;
import cerent.cms.model.SVlanProfile;
import cerent.cms.model.SVlanProfileImportExporter;
import cerent.cms.model.SecurityLevel;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.Network;
import cerent.cms.ui.CSHelpButton;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.LeavePageException;
import cerent.cms.ui.NetCSHelpConst;
import cerent.cms.ui.ObserverPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.vlan.DisplayableSVlanProfile;
import cerent.cms.ui.vlan.IModelSelector;
import cerent.cms.ui.vlan.LoadDialog;
import cerent.cms.ui.vlan.ProfileSelector;
import cerent.cms.ui.vlan.ProvMultiSelector;
import cerent.cms.ui.vlan.SVlanProfileRowDataSource;
import cerent.cms.ui.vlan.StoreDialog;
import cerent.util.DetailedLog;
import cerent.util.EnumStrings;
import cerent.util.KDebug;
import cerent.util.NEMC;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.DetailedProgressDialog;
import cerent.util.gui.IDetailedProgressController;
import cerent.util.gui.IDetailedProgressDialog;
import cerent.util.gui.UDialog;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import cerent.util.gui.row.ColumnRenderer;
import cerent.util.gui.row.DefaultColumnEditor;
import cerent.util.gui.row.RowActionListener;
import cerent.util.gui.row.RowDataSource;
import cerent.util.gui.row.SortableRowTableModel;
import com.cisco.ctc.core.ClassLoaderManager;
import com.cisco.ctc.core.IClassLoaderManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Observer;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;
import javax.swing.text.PlainDocument;

public class SVlanProfilePane
extends ObserverPane
implements Observer,
ActionListener,
TableModelListener,
ListSelectionListener {
    private static String[] bucketValues = EnumStrings.getStrings(IBucketSize.class);
    private static Object[] bucketDisplayValues = SVlanProfilePane.createBucketSizeDisplay(bucketValues);
    private static final Color EDITED_BACKGROUND = Color.YELLOW;
    private static JComboBox bucketComboBox = new JComboBox<Object>(bucketDisplayValues);
    private static final int MAX_NAME_LENGTH = 32;
    private static JCheckBox checkBox = new JCheckBox();
    private static JTextField nameTextField = SVlanProfilePane.getLimitedTextField(32);
    private static JFormattedTextField percentFormattedTextField = SVlanProfilePane.getPercentEditor();
    private static JFormattedTextField numberFormattedTextField = SVlanProfilePane.getNumberEditor();
    private static ColumnEditor[] editors = new ColumnEditor[]{new ColumnEditor("Name", 175, 2, false, String.class, new DefaultColumnEditor.AbstractEditableColumnAdapter(){

        @Override
        public Object getColumnData(Object object) {
            DisplayableSVlanProfile displayableSVlanProfile = (DisplayableSVlanProfile)object;
            return displayableSVlanProfile.getName();
        }

        @Override
        public String isValidColumnData(Object object, Object object2) {
            DisplayableSVlanProfile displayableSVlanProfile = (DisplayableSVlanProfile)object;
            return displayableSVlanProfile.checkName((String)object2);
        }

        @Override
        public void setColumnData(Object object, Object object2) {
            DisplayableSVlanProfile displayableSVlanProfile = (DisplayableSVlanProfile)object;
            displayableSVlanProfile.setName((String)object2);
        }

        @Override
        protected Component postProcess(Component component) {
            if (component instanceof JTextField) {
                ((JTextField)component).setHorizontalAlignment(2);
            } else if (component instanceof JLabel) {
                ((JLabel)component).setHorizontalAlignment(2);
            }
            return component;
        }
    }, null, nameTextField){

        @Override
        protected Component postProcess(Component component, Object object, boolean bl, boolean bl2, int n, int n2) {
            DisplayableSVlanProfile displayableSVlanProfile = (DisplayableSVlanProfile)object;
            if (displayableSVlanProfile.wasEdited()) {
                Color color = EDITED_BACKGROUND;
                component.setBackground(color);
                this.setForeground(component, color);
            } else {
                super.postProcess(component, object, bl, bl2, n, n2);
            }
            return component;
        }
    }, new ColumnEditor("Committed Info Rate", 112, 4, true, Short.class, new DefaultColumnEditor.AbstractEditableColumnAdapter(){

        @Override
        public Object getColumnData(Object object) {
            DisplayableSVlanProfile displayableSVlanProfile = (DisplayableSVlanProfile)object;
            return new Short(displayableSVlanProfile.getCommittedInfoRate());
        }

        @Override
        public void setColumnData(Object object, Object object2) {
            DisplayableSVlanProfile displayableSVlanProfile = (DisplayableSVlanProfile)object;
            displayableSVlanProfile.setCommittedInfoRate((Short)object2);
        }
    }, null, percentFormattedTextField), new ColumnEditor("Committed Burst Size", 112, 4, true, String.class, new DefaultColumnEditor.AbstractEditableColumnAdapter(){

        @Override
        public Object getColumnData(Object object) {
            DisplayableSVlanProfile displayableSVlanProfile = (DisplayableSVlanProfile)object;
            return SVlanProfilePane.fromBucketDisplayValues(displayableSVlanProfile.getCommittedBurstSize());
        }

        @Override
        public void setColumnData(Object object, Object object2) {
            DisplayableSVlanProfile displayableSVlanProfile = (DisplayableSVlanProfile)object;
            int n = 0;
            try {
                n = SVlanProfilePane.getIBucketSizeValue((String)object2);
                displayableSVlanProfile.setCommittedBurstSize(n);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException(exception);
            }
        }

        @Override
        protected Component postProcess(Component component) {
            if (component instanceof JComboBox) {
                ((JComboBox)component).setRenderer(new AlignedListCellRenderer(4));
            } else if (component instanceof JLabel) {
                ((JLabel)component).setHorizontalAlignment(4);
            }
            return component;
        }
    }, null, bucketComboBox), new ColumnEditor("Peak Info Rate", 77, 4, true, Short.class, new DefaultColumnEditor.AbstractEditableColumnAdapter(){

        @Override
        public Object getColumnData(Object object) {
            DisplayableSVlanProfile displayableSVlanProfile = (DisplayableSVlanProfile)object;
            return new Short(displayableSVlanProfile.getPeakInfoRate());
        }

        @Override
        public void setColumnData(Object object, Object object2) {
            DisplayableSVlanProfile displayableSVlanProfile = (DisplayableSVlanProfile)object;
            displayableSVlanProfile.setPeakInfoRate((Short)object2);
        }
    }, null, percentFormattedTextField), new ColumnEditor("Peak Burst Size", 84, 4, true, String.class, new DefaultColumnEditor.AbstractEditableColumnAdapter(){

        @Override
        public Object getColumnData(Object object) {
            DisplayableSVlanProfile displayableSVlanProfile = (DisplayableSVlanProfile)object;
            return SVlanProfilePane.fromBucketDisplayValues(displayableSVlanProfile.getPeakBurstSize());
        }

        @Override
        public void setColumnData(Object object, Object object2) {
            DisplayableSVlanProfile displayableSVlanProfile = (DisplayableSVlanProfile)object;
            int n = 0;
            try {
                n = SVlanProfilePane.getIBucketSizeValue((String)object2);
                displayableSVlanProfile.setPeakBurstSize(n);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException(exception);
            }
        }

        @Override
        protected Component postProcess(Component component) {
            if (component instanceof JComboBox) {
                ((JComboBox)component).setRenderer(new AlignedListCellRenderer(4));
            } else if (component instanceof JLabel) {
                ((JLabel)component).setHorizontalAlignment(4);
            }
            return component;
        }
    }, null, bucketComboBox), new ColumnEditor("Link Integrity", 98, 4, true, Boolean.class, new DefaultColumnEditor.AbstractEditableColumnAdapter(){

        @Override
        public Object getColumnData(Object object) {
            if (object instanceof DisplayableSVlanProfile) {
                DisplayableSVlanProfile displayableSVlanProfile = (DisplayableSVlanProfile)object;
                return displayableSVlanProfile.getLinkIntegrity();
            }
            if (object instanceof Boolean) {
                Boolean bl = (Boolean)object;
                return (boolean)bl;
            }
            return false;
        }

        @Override
        public void setColumnData(Object object, Object object2) {
            DisplayableSVlanProfile displayableSVlanProfile = (DisplayableSVlanProfile)object;
            Boolean bl = (Boolean)object2;
            displayableSVlanProfile.setLinkIntegrity(bl);
        }
    }, null, checkBox)};
    private static final String SVLAN_PROFILE_FILE_SUFFIX = "svp";
    private static final String DOTTED_SVLAN_PROFILE_FILE_SUFFIX = ".svp";
    private static final String RESET_ALL_CHOICE = "All";
    private static final String RESET_SELECTED_CHOICE = "Selected Only";
    private static final String RESET_CANCEL_CHOICE = "Cancel";
    private static final Object[] RESET_WITH_SELECTED_CHOICES = new Object[]{"All", "Selected Only", "Cancel"};
    private static final Object[] RESET_CHOICES = new Object[]{"All", "Cancel"};
    private static final int COLUM_MAXWidth = 45;
    private static final int COLUM_MINWidth = 45;
    static Dimension SELECTIONBOX_DIM = new Dimension(200, 150);
    static Dimension BUTTON0_DIM = new Dimension(75, 25);
    static Dimension BUTTON1_DIM = new Dimension(125, 25);
    private static String PREF_SCOPE_VALUE = "warnSvlanProfileScope";
    private static String PREF_SCOPE_DESCR = "Scope Change Will Lose SVLAN Profile Editor Contents";
    private static JMenuItem showSourceItem = new JMenuItem("Show Source(s)");
    private static PopupMenu popupMenu = SVlanProfilePane.initPopupMenu();
    private static final SDebug db = new SDebug("SVlanProfilePane");
    private static ISVlanProfileImportExporter impexp = SVlanProfileImportExporter.instance();
    private SortableRowTableModel srtm;
    private SVlanProfileRowDataSource ds;
    private INodeModel nm = null;
    private boolean isThisGuestPane = false;
    private JPanel bottomPanel;
    private JPanel bottomLeftPanel;
    private JButton loadButton;
    private JButton storeButton;
    private JButton mergeButton;
    private JButton resetButton;
    private JPanel bottomRightPanel;
    private JButton addRowButton;
    private JButton deleteRowButton;
    private JLabel permDelLabel;
    private JCheckBox permDelCB;
    private CSHelpButton helpButton;
    private IClassLoaderManager clm = ClassLoaderManager.instance();

    private static PopupMenu initPopupMenu() {
        PopupMenu popupMenu = new PopupMenu();
        showSourceItem.addActionListener(popupMenu);
        popupMenu.add(showSourceItem);
        return popupMenu;
    }

    private static Object[] createBucketSizeDisplay(String[] stringArray) {
        Object[] objectArray = new Object[stringArray.length - 1];
        for (int i = 1; i < stringArray.length; ++i) {
            objectArray[i - 1] = stringArray[i].substring("BUCKET_SIZE_".length());
        }
        return objectArray;
    }

    private static Object fromBucketDisplayValues(int n) {
        return bucketDisplayValues[n - 1];
    }

    private static NumberFormatter getPercentFormatter() {
        NumberFormat numberFormat = NumberFormat.getIntegerInstance();
        NumberFormatter numberFormatter = new NumberFormatter(numberFormat){

            @Override
            public Object stringToValue(String string) throws ParseException {
                try {
                    return super.stringToValue(string);
                }
                catch (ParseException parseException) {
                    CerentDialog.errorDialog((String)"Percent value must be in the range: 0..100");
                    throw parseException;
                }
            }
        };
        numberFormatter.setFormat(numberFormat);
        numberFormatter.setMinimum(Integer.valueOf(0));
        numberFormatter.setMaximum(Integer.valueOf(100));
        return numberFormatter;
    }

    private static JFormattedTextField getPercentEditor() {
        NumberFormatter numberFormatter = SVlanProfilePane.getPercentFormatter();
        JFormattedTextField jFormattedTextField = new JFormattedTextField();
        jFormattedTextField.setFormatterFactory(new DefaultFormatterFactory(numberFormatter));
        jFormattedTextField.setValue(numberFormatter.getMinimum());
        jFormattedTextField.setHorizontalAlignment(11);
        jFormattedTextField.setFocusLostBehavior(1);
        return jFormattedTextField;
    }

    private static NumberFormatter getNumberFormatter() {
        NumberFormat numberFormat = NumberFormat.getIntegerInstance();
        NumberFormatter numberFormatter = new NumberFormatter(numberFormat);
        return numberFormatter;
    }

    private static JFormattedTextField getNumberEditor() {
        NumberFormatter numberFormatter = SVlanProfilePane.getNumberFormatter();
        JFormattedTextField jFormattedTextField = new JFormattedTextField();
        jFormattedTextField.setFormatterFactory(new DefaultFormatterFactory(numberFormatter));
        jFormattedTextField.setValue(numberFormatter.getMinimum());
        jFormattedTextField.setHorizontalAlignment(11);
        jFormattedTextField.setFocusLostBehavior(3);
        return jFormattedTextField;
    }

    private static JTextField getLimitedTextField(int n) {
        JTextField jTextField = new JTextField();
        jTextField.setDocument(new LimitDocument(32));
        return jTextField;
    }

    private static int getIBucketSizeValue(String string) throws NoSuchFieldException, ExceptionInInitializerError, IllegalArgumentException, IllegalAccessException {
        int n = 0;
        try {
            Field field = IBucketSize.class.getField("BUCKET_SIZE_" + string);
            n = field.getInt(null);
        }
        catch (SecurityException securityException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return n;
    }

    public SVlanProfilePane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
        this.srtm = SVlanProfilePane.getSortableRowTableModel();
        this.ds = (SVlanProfileRowDataSource)this.srtm.getDataSource();
        this.nm = tabbedView.getUiModel().getNodeModel();
        this.initComponents();
    }

    private static SortableRowTableModel getSortableRowTableModel() {
        SVlanProfileRowDataSource sVlanProfileRowDataSource = new SVlanProfileRowDataSource();
        SortableRowTableModel sortableRowTableModel = new SortableRowTableModel((RowDataSource)sVlanProfileRowDataSource, (ColumnRenderer[])editors, sVlanProfileRowDataSource.getRowObjectClass()){

            @Override
            protected boolean doesHandleRowPopups() {
                return true;
            }

            @Override
            protected void handleRowPopup(MouseEvent mouseEvent, int n) {
                if (db.on()) {
                    db.println("handleRowPopup(" + n + ")");
                }
                popupMenu.setRow(n);
                popupMenu.setRowActionListener(this);
                popupMenu.show(this.table, mouseEvent.getX(), mouseEvent.getY());
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent, int n) {
                if (db.on()) {
                    db.println("actionPerformed(" + actionEvent + ", " + n + ")");
                }
                if (actionEvent.getSource() == showSourceItem) {
                    DisplayableSVlanProfile displayableSVlanProfile;
                    if (db.on()) {
                        db.println("show source list request for row: " + n);
                    }
                    if ((displayableSVlanProfile = (DisplayableSVlanProfile)this.getValueAt(n, 0)) == null) {
                        if (db.on()) {
                            db.println("DSP is null at row: " + n);
                        }
                        return;
                    }
                    Set set = displayableSVlanProfile.getCopyOfSources();
                    if (db.on()) {
                        db.print("...for sources: ");
                        for (Object e : set) {
                            db.print(e.toString());
                            db.print(", ");
                        }
                        db.println("");
                    }
                    Object object = new SourcesDialog(null, "Sources(s) for " + displayableSVlanProfile.getName(), true, set);
                    object.show();
                } else {
                    super.actionPerformed(actionEvent, n);
                }
            }
        };
        sVlanProfileRowDataSource.setUnderlyingLock(sortableRowTableModel);
        return sortableRowTableModel;
    }

    private void initComponents() {
        this.setDefaultPrivilegeLevel(SecurityLevel.PROVISIONING);
        this.setLayout(new BorderLayout());
        this.table = new UTable((TableModel)((Object)this.srtm));
        this.table.getSelectionModel().addListSelectionListener(this);
        this.srtm.initTable(this.table);
        this.table.setAutoResizeMode(0);
        UScrollPane uScrollPane = new UScrollPane((Component)this.table);
        this.add((Component)uScrollPane, "Center");
        this.bottomPanel = new JPanel();
        this.bottomPanel.setLayout(new BorderLayout());
        this.bottomLeftPanel = new JPanel();
        this.bottomLeftPanel.setLayout(new FlowLayout(0));
        this.loadButton = new JButton("Load...");
        this.loadButton.addActionListener(this);
        this.storeButton = new JButton("Store...");
        this.storeButton.addActionListener(this);
        this.mergeButton = new JButton("Merge...");
        this.mergeButton.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.add(this.loadButton);
        jPanel.add(this.storeButton);
        jPanel.add(this.mergeButton);
        this.bottomLeftPanel.add(jPanel);
        this.mergeButton.setEnabled(false);
        this.bottomRightPanel = new JPanel();
        this.bottomRightPanel.setLayout(new FlowLayout(2));
        this.addRowButton = new JButton("Add");
        this.addRowButton.addActionListener(this);
        this.enableComponent(this.addRowButton, (IModel)this.nm);
        this.deleteRowButton = new JButton("Delete");
        this.deleteRowButton.addActionListener(this);
        this.resetButton = new JButton("Reset");
        this.resetButton.addActionListener(this);
        this.bottomRightPanel.add(this.addRowButton);
        jPanel = new JPanel();
        jPanel.add(this.deleteRowButton);
        this.permDelLabel = new JLabel("on Node:");
        jPanel.add(this.permDelLabel);
        this.permDelCB = new JCheckBox();
        jPanel.add(this.permDelCB);
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        this.bottomRightPanel.add(jPanel);
        this.bottomRightPanel.add(this.resetButton);
        Dimension dimension = new Dimension(75, 25);
        if (this.getHelpID() != null) {
            this.helpButton = new CSHelpButton(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SVlanProfilePane.this.helpButton.launchHelp(SVlanProfilePane.this.getHelpID());
                }
            });
            this.helpButton.setMinimumSize(dimension);
            this.helpButton.setMaximumSize(dimension);
            this.bottomRightPanel.add(this.helpButton);
        }
        this.bottomPanel.add((Component)this.bottomLeftPanel, "West");
        this.bottomPanel.add((Component)this.bottomRightPanel, "East");
        this.add(this.bottomPanel, "South");
    }

    @Override
    public void leavingPage() throws Exception {
        super.leavingPage();
        this.stopTableCellEditing();
        if (this.ds.wereAnyEdited()) {
            if (this.getLeavingPageOption() == 1) {
                throw new LeavePageException("User vetoed leaving due to cell edits");
            }
            List<DisplayableSVlanProfile> list = this.ds.getAllEditedDisplayableSVlanProfiles();
            this.reset(list);
        }
        this.ds.setPassing(false);
        this.table.getModel().removeTableModelListener(this);
    }

    protected int getLeavingPageOption() {
        boolean bl = CerentDialog.yesNoDialog((Component)((Object)this), (String)"1 or more SVLAN profiles have been created/changed but not stored.\nLeaving this tab will discard these changes.\nIs it OK to continue?", (String)"Changed Profile Not Stored");
        return bl ? 0 : 1;
    }

    private void reauthorizeEditing() {
        INodeModel iNodeModel = this.uiModel.getNodeModel();
        INodeModel iNodeModel2 = iNodeModel.getDelegate();
        if (iNodeModel != null && iNodeModel2 != null && iNodeModel2.isInited()) {
            boolean bl = this.isUserAuthorized(SecurityLevel.PROVISIONING);
            for (ColumnEditor columnEditor : editors) {
                columnEditor.setCellEditable(bl);
            }
        }
    }

    @Override
    public void enteringPage() throws Exception {
        this.reauthorizeEditing();
        this.disableButtons();
        this.table.getModel().addTableModelListener(this);
        boolean bl = this.ds.isDirty();
        this.ds.setPassing(true);
        if (bl) {
            this.ds.forceNeRefresh();
            this.populateFromExistingNodes();
        }
        super.enteringPage();
    }

    @Override
    public void refresh() {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.loadButton) {
            this.loadAction(true);
        } else if (object == this.storeButton) {
            this.storeAction();
            this.disableButtons();
        } else if (object == this.mergeButton) {
            this.mergeAction();
        } else if (object == this.resetButton) {
            this.resetAction();
        } else if (object == this.addRowButton) {
            this.addRowAction();
        } else if (object == this.deleteRowButton) {
            this.deleteRowAction();
            this.disableButtons();
        } else if (db.on()) {
            db.println("SVlanProfilePane : no ActionPerformed command !");
        }
    }

    private void loadAction(boolean bl) {
        boolean bl2;
        if (bl && this.table.getRowCount() > 0 && !(bl2 = CerentDialog.yesNoDialog((Component)((Object)this), (String)"A SVLAN profile already exists.\nLoading a new profile will discard the existing profile.\nIs it OK to continue?", (String)"Changing Profile"))) {
            return;
        }
        ArrayList arrayList = this.getNodeInfoList();
        LoadDialog loadDialog = new LoadDialog(arrayList, (Component)((Object)this)){

            @Override
            public IModelSelector initModelSelectorPanel() {
                ProfileSelector profileSelector = new ProfileSelector(this.fromModelBtn);
                profileSelector.setNetScope(this.nodeInfoList);
                this.gbc.gridx = 0;
                this.gbc.gridy = 1;
                this.gridbag.setConstraints(profileSelector.getPanel(), this.gbc);
                this.readPanel.add(profileSelector.getPanel());
                return profileSelector;
            }
        };
        loadDialog.init("profile", "Profile(s)", "From Node(s) ", "Provisionable SVLAN Profile Files (*.svp)", SVLAN_PROFILE_FILE_SUFFIX, NEMC.EID_INVALID_NODE_SELECTION);
        try {
            if (loadDialog.show()) {
                this.reauthorizeEditing();
                if (loadDialog.isFromModelBtnSelected()) {
                    Collection<IModel> collection = loadDialog.getSelectedModels();
                    this.loadNode(collection, bl);
                } else {
                    this.loadFile(loadDialog.getSelectedFile(), bl);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            db.finest("Exception in doLoadAction() - silent catch " + exception);
        }
        loadDialog.dispose();
    }

    private void loadNode(Collection<IModel> collection, boolean bl) {
        ArrayList arrayList = this.getNodeInfoList();
        boolean bl2 = false;
        DetailedLog detailedLog = new DetailedLog(3, "Some profile was not loaded from the node");
        boolean bl3 = false;
        for (IModel iModel : collection) {
            INodeModel iNodeModel = (INodeModel)iModel;
            String string = iNodeModel.getName();
            if (db.on()) {
                db.println("Loading from node: " + string);
            }
            if (bl && !bl3) {
                this.ds.clear();
                bl3 = true;
            }
            try {
                this.populateFromNode(iNodeModel);
            }
            catch (CTCUserException cTCUserException) {
                bl2 = true;
                DetailedLog detailedLog2 = new DetailedLog(3, "an error occurred while loading the SVLAN profile(s) from " + string, (Exception)((Object)cTCUserException));
                detailedLog.addChild(detailedLog2);
                detailedLog.updateTime();
            }
        }
    }

    private void populateFromExistingNodes() {
        Collection<INodeModel> collection = this.ds.getNeObservers();
        for (INodeModel iNodeModel : collection) {
            try {
                this.populateFromNode(iNodeModel);
            }
            catch (CTCUserException cTCUserException) {
                if (!db.on()) continue;
                db.println("error repopulating from node: " + iNodeModel.getName());
                SDebug.printStackTrace((Throwable)cTCUserException);
            }
        }
    }

    private void populateFromNode(INodeModel iNodeModel) throws CTCUserException {
        ISVlanProfileModels iSVlanProfileModels = iNodeModel.getISVlanProfileModels();
        ArrayList arrayList = new ArrayList();
        iSVlanProfileModels.getSVlanProfileModels(arrayList);
        if (db.on()) {
            db.println("got " + arrayList.size() + " profiles from: " + iNodeModel.getName());
        }
        this.populate(iNodeModel, arrayList);
        this.ds.addNeObserver(iNodeModel);
    }

    private void populate(INodeModel iNodeModel, Collection<? extends ISVlanProfileModel> collection) {
        ArrayList<DisplayableSVlanProfile> arrayList = new ArrayList<DisplayableSVlanProfile>(collection.size());
        for (ISVlanProfileModel iSVlanProfileModel : collection) {
            int n = iSVlanProfileModel.getIndex();
            INodeModelAndIndex iNodeModelAndIndex = new INodeModelAndIndex(iNodeModel, n);
            DisplayableSVlanProfile displayableSVlanProfile = new DisplayableSVlanProfile((ISVlanProfile)new SVlanProfile(n, (IROSVlanProfile)iSVlanProfileModel), iNodeModelAndIndex);
            arrayList.add(displayableSVlanProfile);
        }
        this.ds.addAll(arrayList);
    }

    protected void storeAction() {
        StoreDialog storeDialog;
        block11: {
            List<DisplayableSVlanProfile> list;
            String string;
            int[] nArray;
            boolean bl;
            int n;
            if (db.on()) {
                db.println("store action");
            }
            if ((n = this.table.getSelectedRowCount()) == 0) {
                bl = true;
                int n2 = this.table.getRowCount();
                nArray = new int[n2];
                for (int i = 0; i < n2; ++i) {
                    nArray[i] = i;
                }
            } else {
                bl = false;
                nArray = this.table.getSelectedRows();
            }
            if ((string = this.ds.checkToBeStoredProfiles(list = this.srtm.getValuesAt(nArray, DisplayableSVlanProfile.class))) != null) {
                CerentDialog.errorDialog((Component)((Object)this), (String)string);
                return;
            }
            ArrayList arrayList = this.getNodeInfoList();
            storeDialog = new StoreDialog(arrayList, (Component)((Object)this)){

                @Override
                public IModelSelector initModelSelectorPanel() {
                    ProvMultiSelector provMultiSelector = new ProvMultiSelector(this.toModelBtn, this.selectionBoxDim, this.allOrNoneBtnDim);
                    provMultiSelector.setNetScope(this.nodeInfoList);
                    JPanel jPanel = provMultiSelector.getPanel();
                    this.gbc.gridx = 0;
                    this.gbc.gridy = 1;
                    this.gridbag.setConstraints(jPanel, this.gbc);
                    this.writePanel.add(jPanel);
                    return provMultiSelector;
                }
            };
            storeDialog.init("profiles", "Profile(s)", "To Node(s) ", "Provisionable SVLAN Profile Files (*.svp)", SVLAN_PROFILE_FILE_SUFFIX, false, SELECTIONBOX_DIM, BUTTON1_DIM);
            try {
                if (storeDialog.show()) {
                    if (storeDialog.isToModelBtnSelected()) {
                        Collection<IModel> collection = storeDialog.getSelectedModels();
                        this.storeNode(collection, list);
                    } else {
                        String string2 = storeDialog.getSelectedFile();
                        if (string2 != null && !string2.endsWith(DOTTED_SVLAN_PROFILE_FILE_SUFFIX)) {
                            string2 = string2 + DOTTED_SVLAN_PROFILE_FILE_SUFFIX;
                        }
                        this.storeFile(string2, list);
                    }
                    JOptionPane.showMessageDialog(JOptionPane.getFrameForComponent((Component)((Object)this)), (bl ? "All SVLAN profiles " : "The selected SVLAN profile(s) ") + "have been saved.");
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block11;
                KDebug.printStackTrace((Throwable)exception);
            }
        }
        storeDialog.dispose();
    }

    protected void deleteAction() {
        StoreDialog storeDialog;
        block6: {
            int[] nArray;
            List<DisplayableSVlanProfile> list;
            String string;
            if (db.on()) {
                db.println("doDeleteAction");
            }
            if ((string = this.ds.checkToBeStoredProfiles(list = this.srtm.getValuesAt(nArray = this.table.getSelectedRows(), DisplayableSVlanProfile.class))) != null) {
                CerentDialog.errorDialog((Component)((Object)this), (String)string);
                return;
            }
            ArrayList arrayList = this.getNodeInfoList();
            storeDialog = new StoreDialog(arrayList, (Component)((Object)this)){

                @Override
                public IModelSelector initModelSelectorPanel() {
                    ProvMultiSelector provMultiSelector = new ProvMultiSelector(this.toModelBtn, this.selectionBoxDim, this.allOrNoneBtnDim);
                    provMultiSelector.setNetScope(this.nodeInfoList);
                    JPanel jPanel = provMultiSelector.getPanel();
                    this.gbc.gridx = 0;
                    this.gbc.gridy = 1;
                    this.gridbag.setConstraints(jPanel, this.gbc);
                    this.writePanel.add(jPanel);
                    return provMultiSelector;
                }
            };
            storeDialog.init("profiles", "Profile(s)", "To Node(s) ", "Provisionable SVLAN Profile Files (*.svp)", SVLAN_PROFILE_FILE_SUFFIX, true, SELECTIONBOX_DIM, BUTTON1_DIM);
            try {
                if (storeDialog.show()) {
                    if (storeDialog.isToModelBtnSelected()) {
                        Collection<IModel> collection = storeDialog.getSelectedModels();
                        this.doDeleteNode(collection, list);
                    }
                    JOptionPane.showMessageDialog(JOptionPane.getFrameForComponent((Component)((Object)this)), "The provisioning SVLAN profile has been deleted.");
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block6;
                KDebug.printStackTrace((Throwable)exception);
            }
        }
        storeDialog.dispose();
    }

    private void storeNode(Collection<IModel> collection, Collection<DisplayableSVlanProfile> collection2) throws Exception {
        Collection collection3;
        ISVlanProfileModels iSVlanProfileModels;
        INodeModel iNodeModel;
        ArrayList arrayList = this.getNodeInfoList();
        Collection<ISVlanProfile> collection4 = DisplayableSVlanProfile.getProfiles(collection2);
        if (db.on()) {
            db.println("storeNode(" + collection.size() + ", " + collection4.size() + ")");
            for (DisplayableSVlanProfile object2 : collection2) {
                db.println(" -> " + object2);
            }
        }
        boolean bl = false;
        DetailedLog detailedLog = new DetailedLog(3, "Some profile was not saved to the node");
        Exception exception = null;
        IdentityHashMap<INodeModel, Collection> identityHashMap = new IdentityHashMap<INodeModel, Collection>();
        for (IModel iModel : collection) {
            iNodeModel = (INodeModel)iModel;
            iSVlanProfileModels = iNodeModel.getISVlanProfileModels();
            collection3 = this.clearOrigNameIfModelIsMissing(iSVlanProfileModels, collection4, iNodeModel, collection2);
            identityHashMap.put(iNodeModel, collection3);
        }
        for (DisplayableSVlanProfile displayableSVlanProfile : collection2) {
            displayableSVlanProfile.setWasEdited(false);
        }
        for (IModel iModel : collection) {
            iNodeModel = (INodeModel)iModel;
            try {
                iSVlanProfileModels = iNodeModel.getISVlanProfileModels();
                collection3 = (Collection)identityHashMap.get(iNodeModel);
                iSVlanProfileModels.apply(collection3, detailedLog);
            }
            catch (Exception exception2) {
                if (exception == null) {
                    exception = exception2;
                }
                bl = true;
            }
        }
        if (bl) {
            this.showDetailedLog(detailedLog);
            throw exception != null ? exception : new Exception();
        }
    }

    private Collection<ISVlanProfile> clearOrigNameIfModelIsMissing(ISVlanProfileModels iSVlanProfileModels, Collection<ISVlanProfile> collection, INodeModel iNodeModel, Collection<DisplayableSVlanProfile> collection2) {
        ISVlanProfileModel iSVlanProfileModel;
        INodeModelAndIndex iNodeModelAndIndex;
        DisplayableSVlanProfile displayableSVlanProfile;
        String string;
        Collection<ISVlanProfile> collection3 = collection;
        boolean bl = false;
        for (ISVlanProfile iSVlanProfile : collection) {
            string = iSVlanProfile.getName();
            displayableSVlanProfile = this.find(collection2, string);
            if (displayableSVlanProfile == null || (iNodeModelAndIndex = displayableSVlanProfile.getMatchingNodeSource(iNodeModel)) == null || (iSVlanProfileModel = iSVlanProfileModels.getSVlanProfileModel(iNodeModelAndIndex.index)) != null) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return collection3;
        }
        collection3 = new ArrayList<ISVlanProfile>(collection.size());
        for (ISVlanProfile iSVlanProfile : collection) {
            string = iSVlanProfile.getName();
            displayableSVlanProfile = this.find(collection2, string);
            if (displayableSVlanProfile != null && (iNodeModelAndIndex = displayableSVlanProfile.getMatchingNodeSource(iNodeModel)) != null && (iSVlanProfileModel = iSVlanProfileModels.getSVlanProfileModel(iNodeModelAndIndex.index)) == null) {
                if (db.on()) {
                    db.println("Missing model for node: " + iNodeModel.getName() + " detected for dsp: " + displayableSVlanProfile);
                }
                iSVlanProfile = new SVlanProfile(iSVlanProfile);
                iSVlanProfile.clearOrigName();
            }
            collection3.add(iSVlanProfile);
        }
        return collection3;
    }

    private DisplayableSVlanProfile find(Collection<DisplayableSVlanProfile> collection, String string) {
        DisplayableSVlanProfile displayableSVlanProfile = null;
        for (DisplayableSVlanProfile displayableSVlanProfile2 : collection) {
            if (!displayableSVlanProfile2.getName().equals(string)) continue;
            displayableSVlanProfile = displayableSVlanProfile2;
            break;
        }
        return displayableSVlanProfile;
    }

    private void showDetailedLog(DetailedLog detailedLog) {
        IDetailedProgressController iDetailedProgressController = new IDetailedProgressController(){

            public void start(IDetailedProgressDialog iDetailedProgressDialog) {
            }

            public boolean isCancelSupported() {
                return false;
            }

            public void cancel() {
            }
        };
        DetailedProgressDialog detailedProgressDialog = new DetailedProgressDialog(JOptionPane.getFrameForComponent(this.getParent()), "Error", detailedLog, iDetailedProgressController);
        detailedProgressDialog.setCompleted(true);
        detailedProgressDialog.start();
    }

    private void doDeleteNode(Collection<IModel> collection, Collection<DisplayableSVlanProfile> collection2) throws Exception {
        ArrayList arrayList = this.getNodeInfoList();
        Collection<ISVlanProfile> collection3 = DisplayableSVlanProfile.getProfiles(collection2);
        if (db.on()) {
            db.println("doDeleteNode(" + collection.size() + ", " + collection3.size() + ")");
        }
        boolean bl = false;
        DetailedLog detailedLog = new DetailedLog(3, "The profile was not deleted on the Node");
        for (IModel iModel : collection) {
            INodeModel iNodeModel = (INodeModel)iModel;
            String string = iNodeModel.getName();
            try {
                ISVlanProfileModels iSVlanProfileModels = iNodeModel.getISVlanProfileModels();
                iSVlanProfileModels.delete(collection3);
            }
            catch (Exception exception) {
                bl = true;
                DetailedLog detailedLog2 = new DetailedLog(3, "an error occurred while deleting the SVLAN profile on " + string, exception);
                detailedLog.addChild(detailedLog2);
                detailedLog.updateTime();
            }
        }
        if (bl) {
            IModel iModel;
            IDetailedProgressController iDetailedProgressController = new IDetailedProgressController(){

                public void start(IDetailedProgressDialog iDetailedProgressDialog) {
                }

                public boolean isCancelSupported() {
                    return false;
                }

                public void cancel() {
                }
            };
            iModel = new DetailedProgressDialog(JOptionPane.getFrameForComponent(this.getParent()), "Error", detailedLog, iDetailedProgressController);
            iModel.setCompleted(true);
            iModel.start();
            throw new Exception();
        }
    }

    private void storeFile(String string, Collection<DisplayableSVlanProfile> collection) {
        block7: {
            InetAddress inetAddress;
            if (db.on()) {
                db.println("storeFile(" + string + ", " + collection.size() + " profiles)");
            }
            if (collection == null || collection.size() == 0) {
                return;
            }
            String string2 = "???";
            try {
                inetAddress = InetAddress.getLocalHost();
                string2 = inetAddress.toString();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
            inetAddress = this.clm.getSystemNgrp();
            String string3 = NetSecurityModel.instance().getUserName();
            String string4 = "SVLAN profiles saved by user " + string3 + " for release: " + inetAddress.getFullVersionFormat() + " from machine: " + string2;
            Collection<ISVlanProfile> collection2 = DisplayableSVlanProfile.getProfiles(collection);
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(string);
                impexp.store(collection2, string4, (OutputStream)fileOutputStream);
            }
            catch (IOException iOException) {
                if (!db.on()) break block7;
                SDebug.printStackTrace((Throwable)iOException);
            }
        }
        for (DisplayableSVlanProfile displayableSVlanProfile : collection) {
            if (!displayableSVlanProfile.wasEdited()) continue;
            displayableSVlanProfile.setWasEdited(false);
        }
    }

    protected void mergeAction() {
        this.loadAction(false);
    }

    private Object showResetDialog(Object object, Object[] objectArray) {
        Object object2 = CerentDialog.inputDialog((Component)((Object)this), (String)"Which edited SVLAN profiles are to be reset?", (String)"Resetting of Edited SVLAN Profiles...", (Object[])objectArray, (Object)object);
        return object2;
    }

    protected void resetAction() {
        String string;
        Object[] objectArray;
        if (db.on()) {
            db.println("reset action");
        }
        int[] nArray = this.table.getSelectedRows();
        boolean bl = false;
        List<DisplayableSVlanProfile> list = this.srtm.getValuesAt(nArray, DisplayableSVlanProfile.class);
        for (int i = nArray.length - 1; i >= 0; --i) {
            objectArray = list.get(i);
            if (db.on()) {
                db.println("selected obj: " + this.ds.dump(objectArray));
            }
            if (objectArray.wasEdited()) {
                bl = true;
                continue;
            }
            list.remove(i);
        }
        if (bl) {
            string = RESET_SELECTED_CHOICE;
            objectArray = RESET_WITH_SELECTED_CHOICES;
        } else {
            string = RESET_ALL_CHOICE;
            objectArray = RESET_CHOICES;
        }
        Object object = this.showResetDialog(string, objectArray);
        if (object == RESET_CANCEL_CHOICE || object == null) {
            return;
        }
        if (object == RESET_ALL_CHOICE) {
            list = this.ds.getAllEditedDisplayableSVlanProfiles();
        }
        this.reset(list);
    }

    private void reset(Collection<DisplayableSVlanProfile> collection) {
        Set<DisplayableSVlanProfile> set;
        Object object;
        Object object2;
        HashMap<Object, HashSet<DisplayableSVlanProfile>> hashMap = new HashMap<Object, HashSet<DisplayableSVlanProfile>>();
        ArrayList<DisplayableSVlanProfile> arrayList = new ArrayList<DisplayableSVlanProfile>();
        for (DisplayableSVlanProfile object3 : collection) {
            if (!object3.setWasEdited(false)) {
                if (db.on()) {
                    db.println("NE refreshing of dsp: " + object3 + " failed");
                }
                arrayList.add(object3);
                Object object4 = object3.getFileSources();
                object2 = object4.iterator();
                while (object2.hasNext()) {
                    object = (String)object2.next();
                    set = (Set)hashMap.get(object);
                    if (set == null) {
                        set = new HashSet<DisplayableSVlanProfile>();
                        hashMap.put(object, (HashSet<DisplayableSVlanProfile>)set);
                    }
                    set.add(object3);
                }
                continue;
            }
            if (object3.isDisposed()) continue;
            this.ds.notifyRowChange(object3);
        }
        HashSet hashSet = new HashSet();
        for (Object object4 : hashMap.keySet()) {
            object2 = (Set)hashMap.get(object4);
            object = new LinkedList();
            try {
                set = new FileInputStream((String)object4);
                impexp.load((Collection)object, (InputStream)((Object)set), (String)object4, null);
            }
            catch (IOException iOException) {
                if (!db.on()) continue;
                SDebug.printStackTrace((Throwable)iOException);
                continue;
            }
            Map<DisplayableSVlanProfile, DisplayableSVlanProfile> iOException = this.old2New((Set<DisplayableSVlanProfile>)object2, (List<ISVlanProfile>)object);
            for (DisplayableSVlanProfile displayableSVlanProfile : iOException.keySet()) {
                int n;
                if (hashSet.contains(displayableSVlanProfile) || (n = this.ds.findEqualObject(displayableSVlanProfile)) < 0) continue;
                DisplayableSVlanProfile displayableSVlanProfile2 = iOException.get(displayableSVlanProfile);
                this.ds.setObjectAtRow(n, displayableSVlanProfile2);
                hashSet.add(displayableSVlanProfile);
            }
        }
    }

    private Map<DisplayableSVlanProfile, DisplayableSVlanProfile> old2New(Set<DisplayableSVlanProfile> set, List<ISVlanProfile> list) {
        HashMap<String, DisplayableSVlanProfile> hashMap = new HashMap<String, DisplayableSVlanProfile>();
        for (DisplayableSVlanProfile object : set) {
            hashMap.put(object.getName(), object);
        }
        HashMap hashMap2 = new HashMap();
        for (ISVlanProfile iSVlanProfile : list) {
            String string = iSVlanProfile.getName();
            DisplayableSVlanProfile displayableSVlanProfile = (DisplayableSVlanProfile)hashMap.get(string);
            if (displayableSVlanProfile == null) continue;
            DisplayableSVlanProfile displayableSVlanProfile2 = displayableSVlanProfile.createNewDisplayableSVlanProfile(iSVlanProfile);
            hashMap2.put(displayableSVlanProfile, displayableSVlanProfile2);
        }
        return hashMap2;
    }

    protected void addRowAction() {
        DisplayableSVlanProfile displayableSVlanProfile;
        int[] nArray = this.table.getSelectedRows();
        DisplayableSVlanProfile displayableSVlanProfile2 = null;
        displayableSVlanProfile2 = nArray != null && nArray.length == 1 ? ((displayableSVlanProfile = (DisplayableSVlanProfile)this.srtm.getValueAt(nArray[0], 0)) == null ? this.ds.addNew(1) : this.ds.addNewCopy(displayableSVlanProfile)) : this.ds.addNew(1);
        this.srtm.setSelectedRow(displayableSVlanProfile2);
    }

    protected void deleteRowAction() {
        if (this.permDelCB.isSelected()) {
            this.deleteAction();
        } else {
            int n;
            int[] nArray = this.table.getSelectedRows();
            int n2 = n = nArray == null ? 0 : nArray.length;
            if (db.on() && n > 0) {
                db.println("removing " + n + " rows");
                db.print("...");
                for (Object object : (List<DisplayableSVlanProfile>)nArray) {
                    db.print(Integer.toString((int)object) + ", ");
                }
                db.println("");
            }
            List<DisplayableSVlanProfile> list = this.srtm.getValuesAt(nArray, DisplayableSVlanProfile.class);
            this.ds.deleteNeObservers(list);
            this.srtm.remove(nArray);
        }
    }

    private void disableButtons() {
        if (this.table.getRowCount() == 0) {
            this.storeButton.setEnabled(false);
            this.mergeButton.setEnabled(false);
            this.deleteRowButton.setEnabled(false);
            this.resetButton.setEnabled(false);
            this.permDelLabel.setEnabled(false);
            this.permDelCB.setEnabled(false);
        }
    }

    private void loadFile(String string, boolean bl) {
        DetailedLog detailedLog = new DetailedLog(3, "Some profile was not loaded from the file");
        LinkedList linkedList = new LinkedList();
        boolean bl2 = true;
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            bl2 = impexp.load(linkedList, (InputStream)fileInputStream, string, detailedLog);
        }
        catch (IOException iOException) {
            if (db.on()) {
                db.println("Error while loading SVLAN profiles from file: " + string);
                SDebug.printStackTrace((Throwable)iOException);
            }
            return;
        }
        if (bl) {
            this.ds.clear();
        }
        for (ISVlanProfile iSVlanProfile : linkedList) {
            this.ds.add(iSVlanProfile, string);
        }
        if (!bl2) {
            this.showDetailedLog(detailedLog);
        }
    }

    public ArrayList getNodeInfoList() {
        if (db.on()) {
            db.println("----getNodeInfoList: begin()");
        }
        Iterator iterator = Network.instance().getElements().iterator();
        ArrayList<INodeModel> arrayList = new ArrayList<INodeModel>();
        while (iterator.hasNext()) {
            INetElement iNetElement = (INetElement)iterator.next();
            INodeModel iNodeModel = iNetElement.getNodeModel();
            if (!Feature.provides((INodeModel)iNodeModel, (Feature)Feature.STS_OVER_MSTP_ADM_ENHANCED)) continue;
            arrayList.add(iNodeModel);
        }
        if (db.on()) {
            db.println("----getNodeInfoList: end()");
        }
        return arrayList;
    }

    @Override
    public void dispose() {
        this.srtm.dispose();
        super.dispose();
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        int n;
        if (db.isFinerEnabled()) {
            db.finer("tableChanged(" + tableModelEvent + ")");
        }
        if ((n = this.table.getRowCount()) > 0) {
            int n2;
            this.enableComponent(this.storeButton, (IModel)this.nm);
            this.enableComponent(this.mergeButton, (IModel)this.nm);
            this.enableComponent(this.permDelLabel, (IModel)this.nm);
            this.enableComponent(this.permDelCB, (IModel)this.nm);
            int[] nArray = this.table.getSelectedRows();
            int n3 = n2 = nArray == null ? 0 : nArray.length;
            if (n2 > 0) {
                this.enableComponent(this.deleteRowButton, (IModel)this.nm);
            } else if (this.deleteRowButton.isEnabled()) {
                this.deleteRowButton.setEnabled(false);
            }
            if (this.ds.wereAnyEdited()) {
                if (n2 > 0 && !this.resetButton.isEnabled()) {
                    this.enableComponent(this.resetButton, (IModel)this.nm);
                }
            } else if (this.resetButton.isEnabled()) {
                this.resetButton.setEnabled(false);
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        int n;
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        int[] nArray = this.table.getSelectedRows();
        int n2 = n = nArray == null ? 0 : nArray.length;
        if (n > 0) {
            this.enableComponent(this.deleteRowButton, (IModel)this.nm);
        } else if (this.deleteRowButton.isEnabled()) {
            this.deleteRowButton.setEnabled(false);
        }
        if (this.ds.wereAnyEdited()) {
            if (n > 0 && !this.resetButton.isEnabled()) {
                this.enableComponent(this.resetButton, (IModel)this.nm);
            }
        } else if (this.resetButton.isEnabled()) {
            this.resetButton.setEnabled(false);
        }
    }

    protected Attribute[] getAttributes(String string) {
        return null;
    }

    @Override
    public CSHelpID getHelpID() {
        return NetCSHelpConst.SVlanProfilePane;
    }

    static class AlignedListCellRenderer
    extends DefaultListCellRenderer {
        private int align;

        public AlignedListCellRenderer(int n) {
            this.align = n;
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            jLabel.setHorizontalAlignment(this.align);
            return jLabel;
        }
    }

    private static class ColumnEditor
    extends DefaultColumnEditor {
        private boolean cellEditable = true;

        public ColumnEditor(String string, int n, int n2, boolean bl, Class clazz, DefaultColumnEditor.AbstractEditableColumnAdapter abstractEditableColumnAdapter, Comparator comparator, JComponent jComponent) {
            super(string, n, n2, bl, clazz, abstractEditableColumnAdapter, comparator, jComponent);
        }

        public void setCellEditable(boolean bl) {
            this.cellEditable = bl;
        }

        @Override
        public boolean isCellEditable() {
            return this.cellEditable;
        }

        public ColumnEditor(String string, int n, int n2, boolean bl, Class clazz, DefaultColumnEditor.AbstractEditableColumnAdapter abstractEditableColumnAdapter, Comparator comparator, TableCellEditor tableCellEditor) {
            super(string, n, n2, bl, clazz, abstractEditableColumnAdapter, comparator, tableCellEditor);
        }

        @Override
        protected Component postProcess(Component component, Object object, boolean bl, boolean bl2, int n, int n2) {
            Color color = bl2 ? focusBackgroundColor : (bl ? selectionBackgroundColor : normalBackgroundColor);
            component.setBackground(color);
            this.setForeground(component, color);
            return component;
        }

        protected void setForeground(Component component, Color color) {
            if (color.equals(EDITED_BACKGROUND) || color.equals(normalBackgroundColor)) {
                component.setForeground(normalForegroundColor);
            }
        }
    }

    static class LimitDocument
    extends PlainDocument {
        private int limit;

        public LimitDocument(int n) {
            this.setLimit(n);
        }

        public final int getLimit() {
            return this.limit;
        }

        @Override
        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (n < this.limit) {
                super.insertString(n, string, attributeSet);
            }
        }

        public final void setLimit(int n) {
            this.limit = n;
        }
    }

    static class PopupMenu
    extends JPopupMenu
    implements ActionListener {
        private RowActionListener rlistener;
        private int row = -1;

        public void setRow(int n) {
            this.row = n;
        }

        public int getRow() {
            return this.row;
        }

        public void setRowActionListener(RowActionListener rowActionListener) {
            this.rlistener = rowActionListener;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.rlistener != null) {
                this.rlistener.actionPerformed(actionEvent, this.row);
            }
        }
    }

    static class SourcesDialog
    extends UDialog {
        public SourcesDialog(JFrame jFrame, String string, boolean bl, Set set) {
            super((Frame)jFrame, string, bl, (Object)set);
        }

        protected void initContentPane(JPanel jPanel, Object object) {
            Object object22;
            Set set = (Set)object;
            Object[] objectArray = new Object[set.size()];
            int n = 0;
            for (Object object22 : set) {
                objectArray[n++] = object22;
            }
            JList<Object> jList = new JList<Object>(objectArray);
            object22 = new UScrollPane((Component)jList);
            object22.setPreferredSize(new Dimension(300, 100));
            jPanel.setLayout(new BorderLayout());
            jPanel.add((Component)object22, "Center");
        }
    }
}

