/*
 * Decompiled with CFR 0.152.
 */
package cerent.util;

import cerent.util.IAttributeCache;
import cerent.util.KDebug;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;

public class AttributeCache<E>
implements IAttributeCache<E> {
    protected Map<E, Map<Integer, Object>> objCache;
    protected KDebug db;
    protected String name;

    public AttributeCache() {
        this(new IdentityHashMap());
    }

    public KDebug getDebug() {
        return this.db;
    }

    public void setDebug(KDebug kDebug) {
        this.db = kDebug;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public AttributeCache(Map<E, Map<Integer, Object>> map) {
        if (map == null) {
            throw new IllegalArgumentException("objCache must be non-null");
        }
        this.objCache = map;
    }

    protected Map<Integer, Object> createNewAttrMap(E e) {
        return new HashMap<Integer, Object>();
    }

    public Object cache(E e, int n, Object object) {
        return this.cache(e, n, object, false);
    }

    public Object cache(E e, int n, Object object, boolean bl) {
        Object object2;
        Map<Integer, Object> map = this.objCache.get(e);
        if (map == null) {
            if (this.objCache instanceof ConcurrentMap && !bl) {
                object2 = (ConcurrentMap)this.objCache;
                map = this.createNewAttrMap(e);
                Map<Integer, Object> map2 = object2.putIfAbsent(e, map);
                if (map2 != null) {
                    map = map2;
                }
            } else {
                map = this.createNewAttrMap(e);
                this.objCache.put(e, map);
            }
        }
        object2 = this.rawCache(map, n, object, bl);
        return this.resolveLookup(object2);
    }

    protected Object rawCache(Map<Integer, Object> map, int n, Object object, boolean bl) {
        Object object2 = null;
        if (map instanceof ConcurrentMap) {
            ConcurrentMap concurrentMap = (ConcurrentMap)map;
            object2 = concurrentMap.putIfAbsent(n, object);
        } else {
            object2 = map.put(n, object);
        }
        return object2;
    }

    public Object lookup(E e, int n) {
        Map<Integer, Object> map = this.objCache.get(e);
        Object object = map == null ? null : map.get(n);
        object = this.policyInvalidate(object, map, e, n);
        object = this.resolveLookup(object);
        return object;
    }

    public Object resolveLookup(Object object) {
        return object;
    }

    protected Object policyInvalidate(Object object, Map<Integer, Object> map, E e, int n) {
        return object;
    }

    public Map<Integer, Object> invalidate(E e) {
        return this.objCache.remove(e);
    }

    public Object invalidate(E e, int n) {
        Map<Integer, Object> map = this.objCache.get(e);
        Object object = null;
        if (map != null) {
            object = map.remove(n);
            if (map.size() == 0) {
                this.objCache.remove(e);
            }
        }
        return object;
    }

    public void clear() {
        for (Map<Integer, Object> map : this.objCache.values()) {
            map.clear();
        }
        this.objCache.clear();
    }
}

