/*
 * Decompiled with CFR 0.152.
 */
package cerent.util;

import cerent.cms.topo.NetElement;
import cerent.util.DetailedLog;
import cerent.util.EventBus;
import cerent.util.EventBusServices;
import cerent.util.SDebug;
import cerent.util.job.IJobControl;
import cerent.util.job.JobStatus;
import cerent.version.NetworkVersionMonitor;
import com.cisco.ctc.core.ClassLoaderManager;
import com.cisco.ctc.core.CoreException;
import com.cisco.ctc.core.CoreVersionUtil;
import com.cisco.ctc.core.DownloadArea;
import com.cisco.ctc.core.FutureProofer;
import com.cisco.ctc.core.IAbortable;
import com.cisco.ctc.core.IClassLoaderManager;
import com.cisco.ctc.core.ICoreVersionUtil;
import com.cisco.ctc.core.IDownloadItem;
import com.cisco.ctc.core.IFutureProofer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;

public class CoreSoftwareUpgradeInstaller {
    private static final IClassLoaderManager clm = ClassLoaderManager.instance();
    private static final ICoreVersionUtil cvu = CoreVersionUtil.instance();
    private static final IFutureProofer fp = FutureProofer.instance();
    public static int ABORT = 1;
    public static int CONTINUE = 0;
    private static CoreSoftwareUpgradeInstaller instance;
    private boolean upgradeInProgress = false;
    private boolean communicationsError = false;
    private boolean preferenceError = false;
    private boolean noNodesAvailableError = false;
    private boolean invalidUpgradeError = false;
    private static final SDebug db;

    public static CoreSoftwareUpgradeInstaller instance() {
        if (instance == null) {
            instance = new CoreSoftwareUpgradeInstaller();
        }
        return instance;
    }

    public boolean isUpgradeInProgress() {
        return this.upgradeInProgress;
    }

    private boolean upgradeCtcCoreSoftware(CoreSoftwareUpgradeJob coreSoftwareUpgradeJob) {
        NetworkVersionMonitor.ComparableHolder comparableHolder = new NetworkVersionMonitor.ComparableHolder();
        ArrayList arrayList = NetworkVersionMonitor.instance().getLatestVersionElements(comparableHolder);
        this.communicationsError = false;
        this.preferenceError = false;
        this.noNodesAvailableError = false;
        Object var4_4 = null;
        String string = NetworkVersionMonitor.instance().getLatestVersionAvailable();
        if (!arrayList.isEmpty() && !coreSoftwareUpgradeJob.aborted) {
            String string2 = "The update of the CTC software to R" + string + " is now in progess. To cancel the update,\n" + "select \"Cancel CTC Update\" from the Tools menu.";
            DetailedLog detailedLog = new DetailedLog(1, string2);
            EventBus.instance().notifyEvent((Object)EventBusServices.BG_STATUS_COLLECTOR, (Object)detailedLog);
            this.futureProofUpgrade(coreSoftwareUpgradeJob, arrayList);
            if (this.preferenceError) {
                if (db.on()) {
                    db.println("Preference error encountered during CTC Core SW upgrade.");
                }
                return false;
            }
        }
        if (arrayList.isEmpty()) {
            this.noNodesAvailableError = true;
            return false;
        }
        if (coreSoftwareUpgradeJob.aborted) {
            if (db.on()) {
                db.println("User cancelled CTC Core SW upgrade.");
            }
            return false;
        }
        if (db.on()) {
            db.println("Successful download of all core jar files");
        }
        NetworkVersionMonitor.instance().setLatestVersionUpgraded(comparableHolder.value);
        return true;
    }

    private boolean futureProofUpgrade(CoreSoftwareUpgradeJob coreSoftwareUpgradeJob, ArrayList arrayList) {
        boolean bl;
        block5: {
            Iterator iterator = arrayList.iterator();
            DownloadArea downloadArea = null;
            bl = false;
            while (!bl && iterator.hasNext() && !coreSoftwareUpgradeJob.aborted) {
                NetElement netElement = (NetElement)iterator.next();
                downloadArea = this.setupDownloadArea(downloadArea, netElement);
                bl = this.completeDownloadArea(downloadArea, coreSoftwareUpgradeJob);
            }
            if (!bl || this.preferenceError) {
                try {
                    if (downloadArea != null) {
                        downloadArea.cleanArea();
                    }
                }
                catch (Exception exception) {
                    if (!db.on()) break block5;
                    db.println("Error occurred attempting to clean up the download area after failure.");
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
        }
        return bl && !this.preferenceError;
    }

    private DownloadArea setupDownloadArea(DownloadArea downloadArea, NetElement netElement) {
        DownloadArea downloadArea2;
        block4: {
            downloadArea2 = downloadArea;
            try {
                if (downloadArea2 == null) {
                    String string = netElement.getNodeModel().getSwVersion();
                    downloadArea2 = new DownloadArea(netElement.getHostName(), string);
                } else {
                    downloadArea2.setDownloadVirtualAddr(netElement.getHostName());
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block4;
                db.println("General error occured attempting to perform a future proof upgrade.");
                db.println("Error creating DownloadArea.");
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return downloadArea2;
    }

    private boolean completeDownloadArea(DownloadArea downloadArea, CoreSoftwareUpgradeJob coreSoftwareUpgradeJob) {
        boolean bl;
        block12: {
            try {
                if (downloadArea != null) {
                    downloadArea.completeArea((DownloadArea.Callback)coreSoftwareUpgradeJob);
                }
            }
            catch (CoreException coreException) {
                if (db.on()) {
                    db.println("CoreException caught during core sw upgrade: " + coreException.getMessage());
                    SDebug.printStackTrace((Throwable)coreException);
                }
                this.invalidUpgradeError = true;
            }
            catch (IOException iOException) {
                if (db.on()) {
                    db.println("IOException caught during core sw upgrade.");
                    SDebug.printStackTrace((Throwable)iOException);
                }
                this.communicationsError = true;
            }
            catch (Exception exception) {
                if (!db.on()) break block12;
                db.println("General failure occurred during future proof core sw upgrade.");
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        if (coreSoftwareUpgradeJob.aborted) {
            return false;
        }
        boolean bl2 = bl = downloadArea != null ? downloadArea.isAreaComplete() : false;
        if (bl) {
            try {
                downloadArea.storeDirPreference();
            }
            catch (Exception exception) {
                if (db.on()) {
                    db.println("Error occurred attempting to store the download area preferences.");
                }
                this.preferenceError = true;
            }
        }
        return bl;
    }

    public CoreSoftwareUpgradeJob createCoreSoftwareUpgradeJob() {
        return new CoreSoftwareUpgradeJob();
    }

    static {
        db = new SDebug("CoreSoftwareUpgradeInstaller");
    }

    public class CoreSoftwareUpgradeJob
    implements IJobControl,
    Observer,
    DownloadArea.Callback {
        protected boolean aborted = false;

        public String getName() {
            return "Core Software Upgrade";
        }

        public JobStatus executeJob() {
            String string = NetworkVersionMonitor.instance().getLatestVersionAvailable();
            if (!NetworkVersionMonitor.instance().isLaterVersionAvailable()) {
                DetailedLog detailedLog = new DetailedLog(1, "The CTC software update could not be completed.\nNo later version of the CTC is available.");
                EventBus.instance().notifyEvent((Object)EventBusServices.BG_STATUS_COLLECTOR, (Object)detailedLog);
                return new JobStatus(2, (Object)new Exception("No later version is available."));
            }
            CoreSoftwareUpgradeInstaller.this.upgradeInProgress = true;
            boolean bl = false;
            try {
                bl = CoreSoftwareUpgradeInstaller.this.upgradeCtcCoreSoftware(this);
            }
            catch (Exception exception) {
                if (db.on()) {
                    db;
                    SDebug.printStackTrace((Throwable)exception);
                }
                bl = false;
            }
            CoreSoftwareUpgradeInstaller.this.upgradeInProgress = false;
            return this.determineJobStatus(bl, string);
        }

        public void abortJob() {
            this.aborted = true;
        }

        public int notify(IDownloadItem iDownloadItem) {
            if (this.aborted) {
                return ABORT;
            }
            return CONTINUE;
        }

        private JobStatus determineJobStatus(boolean bl, String string) {
            JobStatus jobStatus = null;
            String string2 = "The CTC software update to R" + string;
            if (bl) {
                jobStatus = new JobStatus(4);
                string2 = string2 + " is now complete. To begin using\n the new version, please restart the CTC.";
            } else if (this.aborted) {
                jobStatus = new JobStatus(3, (Object)new Exception("Cancelled by user."));
                string2 = string2 + " was aborted at the user's request.";
            } else {
                if (CoreSoftwareUpgradeInstaller.this.communicationsError) {
                    jobStatus = new JobStatus(2, (Object)new Exception("A communication error occurred."));
                    string2 = string2 + " could not be completed.\nA communication error occurred during the attempt to update the CTC software.";
                } else if (CoreSoftwareUpgradeInstaller.this.preferenceError) {
                    jobStatus = new JobStatus(2, (Object)new Exception("An error occurred while attempting to save the preferences."));
                    string2 = string2 + " could not be completed.\nAn error occurred while attempting to save the CTC preferences.";
                } else if (CoreSoftwareUpgradeInstaller.this.noNodesAvailableError) {
                    jobStatus = new JobStatus(2, (Object)new Exception("No later version is available."));
                    string2 = string2 + " could not be completed.\nNo nodes with a later version of the CTC were found.\n" + "Connectivity may be unavailable to node(s) with a later version.";
                } else if (CoreSoftwareUpgradeInstaller.this.invalidUpgradeError) {
                    jobStatus = new JobStatus(2, (Object)new Exception("Unable to upgrade to selected version"));
                    string2 = string2 + " could not be completed.\nCTC is unable to update the current version to R" + string + "\ndue to a known incompatibility in the update process between these two versions.";
                } else {
                    jobStatus = new JobStatus(2, (Object)new Exception("A CTC upgrade error occurred."));
                    string2 = string2 + " could not be completed.\nAn error occurred while attempting to update the CTC software";
                }
                CoreSoftwareUpgradeInstaller.this.communicationsError = false;
                CoreSoftwareUpgradeInstaller.this.preferenceError = false;
                CoreSoftwareUpgradeInstaller.this.noNodesAvailableError = false;
                CoreSoftwareUpgradeInstaller.this.invalidUpgradeError = false;
            }
            DetailedLog detailedLog = new DetailedLog(1, string2);
            EventBus.instance().notifyEvent((Object)EventBusServices.BG_STATUS_COLLECTOR, (Object)detailedLog);
            return jobStatus;
        }

        @Override
        public void update(Observable observable, Object object) {
            if (observable instanceof IAbortable) {
                IAbortable iAbortable = (IAbortable)observable;
                iAbortable.setAbort(this.aborted);
                this.aborted = true;
            }
        }
    }
}

