/*
 * Decompiled with CFR 0.152.
 */
package cerent.util;

import cerent.cms.model.INodeModel;
import cerent.cms.topo.NetElement;
import cerent.util.SDebug;

public class ProxyConfigHelper {
    public static final int PROXY_NONE = 0;
    public static final int PROXY_SNE = 1;
    public static final int PROXY_GNE = 2;
    public static final int PROXY_ENE = 3;
    public static final String S_PROXY_NONE = "";
    public static final String S_PROXY_SNE = "[SOCKS]";
    public static final String S_PROXY_GNE = "[GNE]";
    public static final String S_PROXY_ENE = "[ENE]";
    private static SDebug db = new SDebug("ProxyConfigHelper");
    private static String[] PROXY_STATUS = new String[]{"None", "SOCKS proxy", "Firewall", "Craft Access Only"};

    public static String proxyToString(int n) {
        switch (n) {
            case 1: {
                return S_PROXY_SNE;
            }
            case 2: {
                return S_PROXY_GNE;
            }
            case 3: {
                return S_PROXY_ENE;
            }
        }
        return S_PROXY_NONE;
    }

    public static int getProxyConfig(NetElement netElement) {
        int n;
        block4: {
            INodeModel iNodeModel = netElement.getNodeModel();
            n = 0;
            if (null != iNodeModel && iNodeModel.isInited()) {
                try {
                    boolean bl = iNodeModel.getProxyEnable();
                    boolean bl2 = iNodeModel.getFirewallEnable();
                    boolean bl3 = iNodeModel.getCraftAccessOnly();
                    if (bl) {
                        n = bl2 ? (bl3 ? 3 : 2) : 1;
                    }
                }
                catch (Exception exception) {
                    db.println("Caught " + exception + " in getProxyConfig");
                    if (!db.on()) break block4;
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
        }
        return n;
    }

    private ProxyConfigHelper() {
    }
}

