/*
 * Decompiled with CFR 0.152.
 */
package cerent.util;

import cerent.util.AttributeCache;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;

public class TimeBasedAttributeCache<E>
extends AttributeCache<E> {
    protected long maxElapsedTime;

    public TimeBasedAttributeCache(long l) {
        this.maxElapsedTime = l;
    }

    public TimeBasedAttributeCache(Map<E, Map<Integer, Object>> map, long l) {
        super(map);
        this.maxElapsedTime = l;
    }

    @Override
    protected Object rawCache(Map<Integer, Object> map, int n, Object object, boolean bl) {
        Object object2 = null;
        if (map instanceof ConcurrentMap && !bl) {
            ConcurrentMap concurrentMap = (ConcurrentMap)map;
            object2 = concurrentMap.putIfAbsent(n, object instanceof TimestampedValue ? object : new TimestampedValue(object));
        } else {
            object2 = map.put(n, object instanceof TimestampedValue ? object : new TimestampedValue(object));
        }
        return object2;
    }

    @Override
    public Object resolveLookup(Object object) {
        return object instanceof TimestampedValue ? ((TimestampedValue)object).getValue() : object;
    }

    @Override
    protected Object policyInvalidate(Object object, Map<Integer, Object> map, E e, int n) {
        TimestampedValue timestampedValue;
        if (object instanceof TimestampedValue && (timestampedValue = (TimestampedValue)object).isExpired(this.maxElapsedTime) && !this.doExtendTime(timestampedValue, map, e, n)) {
            object = null;
            this.rawCache(map, n, object, true);
        }
        return object;
    }

    public boolean doExtendTime(TimestampedValue timestampedValue, Map<Integer, Object> map, E e, int n) {
        return false;
    }

    protected static class TimestampedValue {
        private long timestamp;
        private Object val;

        public TimestampedValue(Object object) {
            this(object, System.currentTimeMillis());
        }

        public TimestampedValue(Object object, long l) {
            this.val = object;
            this.timestamp = l;
        }

        public Object getValue() {
            return this.val;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public void setTimestamp(long l) {
            this.timestamp = l;
        }

        public void setTimestamp() {
            this.setTimestamp(System.currentTimeMillis());
        }

        public boolean isExpired(long l) {
            return this.isExpired(l, System.currentTimeMillis());
        }

        public boolean isExpired(long l, long l2) {
            if (l < 0L) {
                throw new IllegalArgumentException("max elapsed time must be non-negative");
            }
            return l2 < this.timestamp ? false : l2 - this.timestamp > l;
        }
    }
}

