/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.gui;

import java.awt.Toolkit;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class SnmpV3TagField
extends JTextField {
    private static String lettersString = "_abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTURVWXYZ";
    private static String digitsAndDelemeterString = "0123456789 ,";
    private static int MAX_LENGTH = 32;

    public SnmpV3TagField(int n) {
        super(n);
    }

    public void setMaxLength(int n) {
        MAX_LENGTH = n;
    }

    @Override
    protected Document createDefaultModel() {
        return new LetterOrDigitDocument(this.getColumns());
    }

    static class LetterOrDigitDocument
    extends PlainDocument {
        int documentMaxLength;

        public LetterOrDigitDocument(int n) {
            this.documentMaxLength = n;
        }

        @Override
        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            boolean bl = true;
            if (string != null) {
                if (string.length() + this.getLength() > MAX_LENGTH) {
                    bl = false;
                } else {
                    for (int i = 0; bl && i < string.length(); ++i) {
                        char c = string.charAt(i);
                        if (-1 != lettersString.indexOf(c) || -1 != digitsAndDelemeterString.indexOf(c)) continue;
                        bl = false;
                    }
                }
            }
            if (bl) {
                super.insertString(n, string, attributeSet);
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }
}

