/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.gui;

import cerent.util.CEMC;
import cerent.util.ErrorMsg;
import cerent.util.WID;
import cerent.util.gui.AbstractPropertyEditor;
import cerent.util.gui.BooleanPropertyEditor;
import cerent.util.gui.ProgressDialog;
import cerent.util.gui.ProgressDialogControl;
import cerent.util.gui.ProgressDialogResult;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.WindowHelper;
import cerent.util.job.IJobControl;
import cerent.util.job.IJobGroupListener;
import cerent.util.job.JobController;
import cerent.util.job.JobControllerFactory;
import cerent.util.job.JobGroup;
import cerent.util.job.JobStatus;
import com.cisco.sot.SotSocketFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.InetAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class StringArrayPropertyEditor
extends AbstractPropertyEditor
implements DocumentListener {
    private static final String ADD = "Add";
    private static final String REMOVE = "Remove";
    private JButton addButton = new JButton("Add");
    private JButton removeButton = new JButton("Remove");
    private LabelListModel listModel = new LabelListModel();
    private JList listProperty = new JList(this.listModel);
    private JTextField txtProperty = new JTextField();
    private boolean unique = true;
    private String checkText;
    private int checkPort;
    private int checkTimeout;
    private JButton checkButton;
    private static final int CHECK_THREADS = 5;
    private static final String CK_IMG_PATH = "/images/check_blue.gif";
    private final ImageIcon OK_ICON = new ImageIcon(this.getClass().getResource("/images/check_blue.gif"), "true");
    private static final String ERROR_IMG_PATH = "/images/icons/cancel16.gif";
    private final ImageIcon ERROR_ICON = new ImageIcon(this.getClass().getResource("/images/icons/cancel16.gif"), "true");
    private SotSocketFactory ssf = new SotSocketFactory();
    private BooleanPropertyEditor enableAutoDisc;

    public StringArrayPropertyEditor(String string) {
        this(string, null, 0, 0);
    }

    public StringArrayPropertyEditor(String string, String string2, int n, int n2) {
        this.checkText = string2;
        this.checkPort = n;
        this.checkTimeout = n2;
        JPanel jPanel = this.makeListPane();
        JPanel jPanel2 = this.makeButtonPane();
        this.setLayout(new BorderLayout());
        if (string.length() > 0) {
            this.add((Component)new JLabel(string), "North");
        }
        this.add(jPanel);
        this.add((Component)jPanel2, "East");
        this.listProperty.setCellRenderer(new EntryCellRenderer());
    }

    private JPanel makeEditPane() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.txtProperty.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StringArrayPropertyEditor.this.addButton.doClick(1);
            }
        });
        this.txtProperty.getDocument().addDocumentListener(this);
        jPanel.add((Component)this.txtProperty, "South");
        return jPanel;
    }

    private JPanel makeListPane() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.makeEditPane(), "North");
        this.listProperty.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                StringArrayPropertyEditor.this.removeButton.setEnabled(true);
            }
        });
        jPanel.add((Component)new UScrollPane((Component)this.listProperty));
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 5));
        return jPanel;
    }

    public void setUnique(boolean bl) {
        this.unique = bl;
    }

    private String getEntryAt(int n) {
        return ((JLabel)this.listModel.getElementAt(n)).getText();
    }

    private void addEntry(String string) {
        JLabel jLabel = new JLabel(string);
        if (this.listProperty.getSelectedIndex() != -1) {
            this.listModel.add(this.listProperty.getSelectedIndex(), jLabel);
        } else {
            this.listModel.addElement(jLabel);
        }
        jLabel.setFont(this.listProperty.getFont());
        jLabel.setOpaque(true);
        jLabel.setHorizontalTextPosition(10);
    }

    private String[] getEntries() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.listModel.getSize(); ++i) {
            arrayList.add(this.getEntryAt(i));
        }
        return arrayList.toArray(new String[0]);
    }

    private boolean alreadyInList(String string) {
        for (int i = 0; i < this.listModel.getSize(); ++i) {
            String string2 = this.getEntryAt(i);
            if (!string.equals(string2)) continue;
            return true;
        }
        return false;
    }

    private void checkNes() {
        for (int i = 0; i < this.listModel.getSize(); ++i) {
            JLabel jLabel = (JLabel)this.listModel.getElementAt(i);
            WindowHelper.setLabelIcon((JLabel)jLabel, null);
            jLabel.invalidate();
            jLabel.repaint();
        }
        this.listModel.refresh();
        ProgressDialog.start(this, this.checkText, "Checking Connectivity..", new IpChecker(), 0, 0, true, false);
        this.listModel.refresh();
    }

    private JPanel makeButtonPane() {
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (StringArrayPropertyEditor.this.txtProperty.getText().equals("")) {
                    return;
                }
                if (StringArrayPropertyEditor.this.unique && StringArrayPropertyEditor.this.alreadyInList(StringArrayPropertyEditor.this.txtProperty.getText())) {
                    ErrorMsg.displayWarning((Component)StringArrayPropertyEditor.this.getParent(), (WID)CEMC.WID_DUPLICATE_LIST_ENTRY_PARAM_1, (Object)StringArrayPropertyEditor.this.txtProperty.getText());
                    StringArrayPropertyEditor.this.txtProperty.requestFocus();
                    return;
                }
                StringArrayPropertyEditor.this.addEntry(StringArrayPropertyEditor.this.txtProperty.getText());
                StringArrayPropertyEditor.this.checkButton.setEnabled(true);
                StringArrayPropertyEditor.this.txtProperty.setText("");
                StringArrayPropertyEditor.this.txtProperty.requestFocus();
                StringArrayPropertyEditor.this.setDirty(true);
            }
        });
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = StringArrayPropertyEditor.this.listProperty.getSelectedIndices();
                for (int i = 0; i < nArray.length; ++i) {
                    StringArrayPropertyEditor.this.listModel.removeElementAt(nArray[i] - i);
                }
                if (nArray.length > 0) {
                    StringArrayPropertyEditor.this.removeButton.setEnabled(false);
                    StringArrayPropertyEditor.this.setDirty(true);
                    if (StringArrayPropertyEditor.this.listModel.isEmpty()) {
                        StringArrayPropertyEditor.this.checkButton.setEnabled(false);
                    }
                }
            }
        });
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new GridLayout(0, 1, 5, 10));
        this.addButton.setEnabled(false);
        this.removeButton.setEnabled(false);
        jPanel2.add(this.addButton);
        jPanel2.add(this.removeButton);
        if (this.checkText != null) {
            this.checkButton = new JButton(this.checkText);
            this.checkButton.setEnabled(false);
            jPanel2.add(this.checkButton);
            this.checkButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    StringArrayPropertyEditor.this.checkNes();
                }
            });
        }
        this.enableAutoDisc = new BooleanPropertyEditor("Enable Auto Discovery of DSS");
        jPanel2.add(this.enableAutoDisc);
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 5));
        jPanel.add((Component)jPanel2, "North");
        return jPanel;
    }

    public boolean isAutoDiscoveryEnabled() {
        return this.enableAutoDisc.getBooleanValue();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.toggleAddButton();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.toggleAddButton();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.toggleAddButton();
    }

    private void toggleAddButton() {
        if (this.txtProperty.getText().length() > 0) {
            this.addButton.setEnabled(true);
        } else {
            this.addButton.setEnabled(false);
        }
    }

    public void setVisibleRowCount(int n) {
        this.listProperty.setVisibleRowCount(n);
    }

    @Override
    public Object getValue() {
        return this.getEntries();
    }

    @Override
    public void setValue(Object object) {
        String[] stringArray = (String[])object;
        this.listModel.clear();
        for (int i = 0; i < stringArray.length; ++i) {
            this.addEntry(stringArray[i]);
        }
        this.checkButton.setEnabled(stringArray.length > 0);
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.txtProperty.setEnabled(bl);
        this.listProperty.setEnabled(bl);
        this.addButton.setEnabled(bl);
        this.removeButton.setEnabled(bl);
    }

    public void setAutoDiscoveryFlag(boolean bl) {
        this.enableAutoDisc.setValue(bl);
    }

    private class EntryCellRenderer
    extends DefaultListCellRenderer {
        private EntryCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            JLabel jLabel = (JLabel)object;
            if (bl) {
                jLabel.setBackground(jList.getSelectionBackground());
                jLabel.setForeground(jList.getSelectionForeground());
            } else {
                jLabel.setBackground(jList.getBackground());
                jLabel.setForeground(jList.getForeground());
            }
            jLabel.setBorder(bl2 ? UIManager.getBorder("List.focusCellHighlightBorder") : noFocusBorder);
            return jLabel;
        }
    }

    private class IpChecker
    implements ProgressDialogControl,
    IJobGroupListener {
        private boolean stopRequested = false;
        private JobController jc;
        private JobGroup jg;
        private Observer obs;
        private int done = 0;
        private int total;

        private IpChecker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void executeTask(Observer observer) throws Exception {
            try {
                this.jc = JobControllerFactory.createJC((int)5);
                this.obs = observer;
                Object[] objectArray = StringArrayPropertyEditor.this.listModel.toArray();
                this.total = objectArray.length;
                IJobControl[] iJobControlArray = new IJobControl[this.total];
                for (int i = 0; i < this.total; ++i) {
                    iJobControlArray[i] = new Probe((JLabel)objectArray[i], i);
                }
                this.jg = new JobGroup(iJobControlArray, (IJobGroupListener)this, null);
                this.jc.submitJob(this.jg);
                IpChecker ipChecker = this;
                synchronized (ipChecker) {
                    while (!this.stopRequested) {
                        this.wait();
                    }
                }
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                JobControllerFactory.disposeJC((JobController)this.jc);
            }
        }

        public String getResultString(Exception exception) {
            return "";
        }

        public ProgressDialogResult getResult(Exception exception) {
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() {
            this.stopRequested = true;
            this.jc.abortJob(this.jg);
            IpChecker ipChecker = this;
            synchronized (ipChecker) {
                this.notify();
            }
        }

        public void suspend() {
        }

        public void resume() {
        }

        public boolean stopRequired() {
            return this.stopRequested;
        }

        synchronized Integer getCompletionPercent() {
            ++this.done;
            int n = this.done * 100 / this.total;
            return new Integer(n);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void jobGroupFinished(JobGroup jobGroup) {
            this.stopRequested = true;
            IpChecker ipChecker = this;
            synchronized (ipChecker) {
                this.notify();
            }
        }

        private class Probe
        implements IJobControl {
            private JLabel label;
            private int index;
            private Thread current = null;

            Probe(JLabel jLabel, int n) {
                this.label = jLabel;
                this.index = n;
            }

            public String getName() {
                return "Probing " + this.label.getText();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public JobStatus executeJob() throws Exception {
                Socket socket = null;
                try {
                    InetAddress inetAddress = InetAddress.getByName(this.label.getText());
                    this.current = Thread.currentThread();
                    socket = StringArrayPropertyEditor.this.ssf.createSocket(inetAddress, StringArrayPropertyEditor.this.checkPort, StringArrayPropertyEditor.this.checkTimeout);
                    WindowHelper.setLabelIcon((JLabel)this.label, (Icon)StringArrayPropertyEditor.this.OK_ICON);
                }
                catch (Exception exception) {
                    WindowHelper.setLabelIcon((JLabel)this.label, (Icon)StringArrayPropertyEditor.this.ERROR_ICON);
                }
                finally {
                    this.current = null;
                    if (socket != null) {
                        try {
                            socket.close();
                        }
                        catch (Exception exception) {}
                    }
                }
                this.label.invalidate();
                this.label.repaint();
                StringArrayPropertyEditor.this.listModel.refresh(this.index);
                IpChecker.this.obs.update(null, IpChecker.this.getCompletionPercent());
                return JobStatus.JOB_COMPLETE;
            }

            public void abortJob() {
                if (this.current != null) {
                    try {
                        this.current.interrupt();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private class LabelListModel
    extends DefaultListModel {
        private LabelListModel() {
        }

        public void refresh() {
            this.fireContentsChanged(this, 0, this.getSize() - 1);
            StringArrayPropertyEditor.this.listProperty.revalidate();
            StringArrayPropertyEditor.this.listProperty.repaint();
        }

        public void refresh(int n) {
            this.fireContentsChanged(this, n, n);
            StringArrayPropertyEditor.this.listProperty.revalidate();
            StringArrayPropertyEditor.this.listProperty.repaint();
        }
    }
}

